/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.scatterplot;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.PlotVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.scatterplot.ScatterPlotDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ScatterPlotTableDataModel
extends ScatterPlotDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private ClassificationVariable groupVariable;
    private ClassificationVariable shapeVariable;
    private PlotVariable xVariable;
    private PlotVariable yVariable;
    private PlotVariable y2Variable;
    private Variable colorVariable;
    private Variable sizeVariable;
    private Variable topMarkerLabelVariable;
    private Variable bottomMarkerLabelVariable;
    private Variable sortVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(ScatterPlotTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(ScatterPlotTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.sortVariable = theOtherModel.sortVariable;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.xVariable = theOtherModel.xVariable;
        this.yVariable = theOtherModel.yVariable;
        this.y2Variable = theOtherModel.y2Variable;
        this.colorVariable = theOtherModel.colorVariable;
        this.shapeVariable = theOtherModel.shapeVariable;
        this.sizeVariable = theOtherModel.sizeVariable;
        this.groupVariable = theOtherModel.groupVariable;
        this.topMarkerLabelVariable = theOtherModel.topMarkerLabelVariable;
        this.bottomMarkerLabelVariable = theOtherModel.bottomMarkerLabelVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public ScatterPlotTableDataModel() {
    }

    public ScatterPlotTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSortVariable(Variable newSortVariable) {
        Variable oldVariable = this.sortVariable;
        this.sortVariable = newSortVariable;
        this.firePropertyChange("sortVariable", oldVariable, newSortVariable);
    }

    public Variable getSortVariable() {
        return this.sortVariable;
    }

    public void setColumnVariable(ClassificationVariable newColumnVariable) {
        ClassificationVariable oldVariable = this.getColumnVariable();
        this.columnVariable = newColumnVariable;
        this.firePropertyChange("columnVariable", oldVariable, newColumnVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newRowVariable) {
        ClassificationVariable oldVariable = this.getRowVariable();
        this.rowVariable = newRowVariable;
        this.firePropertyChange("rowVariable", oldVariable, newRowVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setXVariable(PlotVariable newXVariable) {
        PlotVariable oldVariable = this.getXVariable();
        this.xVariable = newXVariable;
        this.firePropertyChange("xVariable", oldVariable, newXVariable);
    }

    public PlotVariable getXVariable() {
        return this.xVariable;
    }

    public void setYVariable(PlotVariable newYVariable) {
        PlotVariable oldVariable = this.getYVariable();
        this.yVariable = newYVariable;
        this.firePropertyChange("yVariable", oldVariable, newYVariable);
    }

    public PlotVariable getYVariable() {
        return this.yVariable;
    }

    public void setY2Variable(PlotVariable newY2Variable) {
        PlotVariable oldVariable = this.getY2Variable();
        this.y2Variable = newY2Variable;
        this.firePropertyChange("y2Variable", oldVariable, newY2Variable);
    }

    public PlotVariable getY2Variable() {
        return this.y2Variable;
    }

    public void setColorVariable(Variable newColorVariable) {
        Variable oldVariable = this.getColorVariable();
        this.colorVariable = newColorVariable;
        newColorVariable = this.getColorVariable();
        this.firePropertyChange("colorVariable", oldVariable, newColorVariable);
    }

    public Variable getColorVariable() {
        return this.colorVariable;
    }

    public void setShapeVariable(ClassificationVariable newShapeVariable) {
        ClassificationVariable oldVariable = this.getShapeVariable();
        this.shapeVariable = newShapeVariable;
        newShapeVariable = this.getShapeVariable();
        this.firePropertyChange("shapeVariable", oldVariable, newShapeVariable);
    }

    public ClassificationVariable getShapeVariable() {
        return this.shapeVariable;
    }

    public void setSizeVariable(Variable newSizeVariable) {
        Variable oldVariable = this.getSizeVariable();
        this.sizeVariable = newSizeVariable;
        newSizeVariable = this.getSizeVariable();
        this.firePropertyChange("sizeVariable", oldVariable, newSizeVariable);
    }

    public Variable getSizeVariable() {
        return this.sizeVariable;
    }

    public void setGroupVariable(ClassificationVariable newGroupVariable) {
        ClassificationVariable oldVariable = this.getGroupVariable();
        this.groupVariable = newGroupVariable;
        newGroupVariable = this.getGroupVariable();
        this.firePropertyChange("groupVariable", oldVariable, newGroupVariable);
    }

    public ClassificationVariable getGroupVariable() {
        return this.groupVariable;
    }

    public void setTopMarkerLabelVariable(Variable newVariable) {
        Variable oldVariable = this.getTopMarkerLabelVariable();
        this.topMarkerLabelVariable = newVariable;
        newVariable = this.getTopMarkerLabelVariable();
        this.firePropertyChange("topMarkerLabelVariable", oldVariable, newVariable);
    }

    public Variable getTopMarkerLabelVariable() {
        return this.topMarkerLabelVariable;
    }

    public void setBottomMarkerLabelVariable(Variable newVariable) {
        Variable oldVariable = this.getBottomMarkerLabelVariable();
        this.bottomMarkerLabelVariable = newVariable;
        newVariable = this.getBottomMarkerLabelVariable();
        this.firePropertyChange("bottomMarkerLabelVariable", oldVariable, newVariable);
    }

    public Variable getBottomMarkerLabelVariable() {
        return this.bottomMarkerLabelVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ScatterPlotTableDataModel arg = (ScatterPlotTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.sortVariable, arg.sortVariable) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.xVariable, arg.xVariable) && Util.Evaluate.isEqual(this.yVariable, arg.yVariable) && Util.Evaluate.isEqual(this.y2Variable, arg.y2Variable) && Util.Evaluate.isEqual(this.groupVariable, arg.groupVariable) && Util.Evaluate.isEqual(this.shapeVariable, arg.shapeVariable) && Util.Evaluate.isEqual(this.sizeVariable, arg.sizeVariable) && Util.Evaluate.isEqual(this.colorVariable, arg.colorVariable) && Util.Evaluate.isEqual(this.topMarkerLabelVariable, arg.topMarkerLabelVariable) && Util.Evaluate.isEqual(this.bottomMarkerLabelVariable, arg.bottomMarkerLabelVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

