/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.scatterplot;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.PlotImageMapInfo;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.scatterplot.RB;
import com.sas.graphics.components.scatterplot.ScatterPlotDataModel;
import com.sas.graphics.components.scatterplot.ScatterPlotModel;
import com.sas.graphics.components.scatterplot.ScatterPlotOLAPDataModel;
import com.sas.graphics.components.scatterplot.ScatterPlotTableDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.PlotImageMapInfo2;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrix;
import com.sas.graphics.util.cell.scatterplot.ScatterPlotMatrixModel;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class ScatterPlot
extends Graph {
    public static final String RB_KEY = "ScatterPlot.";
    private transient ScatterPlotDataModel dataModel;
    private transient ScatterPlotModel scatterPlotModel;
    private final transient ScatterPlotMatrix matrix;
    private final transient ScatterPlotMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    protected MouseListener scrollBarListener;
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            ScatterPlot.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String ANIMATION_IDENTIFICATION = "animationIdentificationVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String X = "xVariable";
    private static final String Y = "yVariable";
    private static final String Y2 = "y2Variable";
    private static final String COLOR = "colorVariable";
    private static final String SHAPE = "shapeVariable";
    private static final String SIZE = "sizeVariable";
    private static final String GROUP = "groupVariable";
    private static final String TOP_MARKER_LABEL = "topMarkerLabelVariable";
    private static final String BOTTOM_MARKER_LABEL = "belowValueVariable";
    private static final String SORT = "sortVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String X_SELECTION = "xselectionVariable";
    private static final String Y_SELECTION = "yselectionVariable";
    private static final String Y2_SELECTION = "y2selectionVariable";
    private static final String SIZE_SELECTION = "sizeselectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public ScatterPlot() {
        this(null, null);
    }

    public ScatterPlot(ScatterPlotDataModel scatterPlotDataModel) {
        this(scatterPlotDataModel, null);
    }

    public ScatterPlot(ScatterPlotDataModel scatterPlotDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new ScatterPlotMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setAnimationIdentificationRole(ANIMATION_IDENTIFICATION);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setXRole(X);
        this.matrixModel.setYRole(Y);
        this.matrixModel.setY2Role(Y2);
        this.matrixModel.setColorRole(COLOR);
        this.matrixModel.setShapeRole(SHAPE);
        this.matrixModel.setSizeRole(SIZE);
        this.matrixModel.setGroupRole(GROUP);
        this.matrixModel.setAboveValueRole(TOP_MARKER_LABEL);
        this.matrixModel.setBelowValueRole(BOTTOM_MARKER_LABEL);
        this.matrixModel.setSortRole(SORT);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setXSelectionRole(X_SELECTION);
        this.matrixModel.setYSelectionRole(Y_SELECTION);
        this.matrixModel.setY2SelectionRole(Y2_SELECTION);
        this.matrixModel.setSizeSelectionRole(SIZE_SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrixModel.setLabelRanges(new Boolean(false));
        this.matrix = new ScatterPlotMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new ScatterPlotModel());
        this.applyGraphStyle(defaultGraphStyle != null ? defaultGraphStyle : this.getDefaultGraphStyle());
        this.dataModelMomento.apply(this.scatterPlotModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimePlotTableData(), Util.getLocale(this), 10475), true, false);
                dataSource.setVariableDefinition(X, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("X")));
                dataSource.setVariableDefinition(Y, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Y")));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (scatterPlotDataModel != null) {
            this.setDataModel(scatterPlotDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        super.setDisplayPolicy(newDisplayPolicy);
        if (newDisplayPolicy == 10002) {
            this.scrollBarInit();
        }
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(ScatterPlotModel newScatterPlotModel) throws IllegalArgumentException {
        super.setGraphModel(newScatterPlotModel);
        ScatterPlotModel oldScatterPlotModel = this.scatterPlotModel;
        this.scatterPlotModel = newScatterPlotModel;
        this.matrixModel.setGraphModel(this.scatterPlotModel);
        this.matrixModel.setScatterPlotModel(this.scatterPlotModel.getScatterPlotModel());
        this.firePropertyChange("graphModel", oldScatterPlotModel, newScatterPlotModel);
    }

    public ScatterPlotModel getGraphModel() {
        return this.scatterPlotModel;
    }

    public void setDataModel(ScatterPlotDataModel newDataModel) {
        ScatterPlotDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public ScatterPlotDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel xAxisModel = this.scatterPlotModel.getXAxisModel();
        AxisModel yAxisModel = this.scatterPlotModel.getYAxisModel();
        AxisModel y2AxisModel = this.scatterPlotModel.getY2AxisModel();
        AxisWallModel axisWallModel = this.scatterPlotModel.getAxisWallModel();
        LegendModel colorLegendModel = this.scatterPlotModel.getColorLegendModel();
        LegendModel shapeLegendModel = this.scatterPlotModel.getShapeLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, xAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, yAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, y2AxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, colorLegendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, shapeLegendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.scatterPlotModel.getColumnAxisModel(), this.scatterPlotModel.getRowAxisModel());
        StrokeLineStyle axisLineStyle = graphStyle.getAxisLineStyle();
        this.scatterPlotModel.getNeedleLineStyle().apply(axisLineStyle);
        TextStyle dataLabelTextStyle = graphStyle.getDataLabelTextStyle();
        Util.Conveyer.applyTextStyle(dataLabelTextStyle, this.scatterPlotModel.getBottomMarkerLabelTextStyle());
        Util.Conveyer.applyTextStyle(dataLabelTextStyle, this.scatterPlotModel.getTopMarkerLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getColumnAxisModel(), this.scatterPlotModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getColorLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getShapeLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getXAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getYAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getY2AxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.scatterPlotModel.getAxisWallModel());
        if (scheme.getAxisLineColor() != null) {
            this.scatterPlotModel.getNeedleLineStyle().setColor(scheme.getAxisLineColor());
        }
        Color vc = scheme.getDataLabelColor();
        Color sc = scheme.getShadowColor();
        AdvancedTextStyle bottomLabel = this.scatterPlotModel.getBottomMarkerLabelTextStyle();
        AdvancedTextStyle topLabel = this.scatterPlotModel.getTopMarkerLabelTextStyle();
        if (vc != null) {
            bottomLabel.setColor(vc);
            topLabel.setColor(vc);
        }
        if (sc != null) {
            topLabel.getShadowStyle().setColor(sc);
            bottomLabel.getShadowStyle().setColor(sc);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public PlotImageMapInfo getImageMapInfo() {
        PlotImageMapInfo2 plotImageMapInfo = null;
        PlotImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (plotImageMapInfo == null) {
                    plotImageMapInfo = new PlotImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                plotImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return plotImageMapInfo;
    }

    @Override
    protected void applyDataModel() {
        DataSource ds;
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.scatterPlotModel);
        this.animationListener.setEventSource(null);
        DataSource sds = this.matrix.getSelectionDataSource();
        if (sds != null) {
            this.matrix.setSelectionDataSource(null);
            sds.setSelectionModel(null);
        }
        if ((ds = this.matrix.getDataSource()) != null) {
            ds.setSelectionModel(null);
        }
        try {
            TableModel tableModel;
            DataSource dataSource = ScatterPlot._newDataSource(this.dataModel, this.scatterPlotModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel), this.getListSelectionListener());
            if (dataSource != null && this.dataModel != null) {
                ScatterPlotTableDataModel tableDataModel;
                if (this.dataModel instanceof ScatterPlotTableDataModel && (tableDataModel = (ScatterPlotTableDataModel)this.dataModel).getSelectionModel() != null) {
                    DataSource selectionDataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getModel(), Util.getFormatLocale(this, this.dataModel), tableDataModel.getSortStrategy()), true, false);
                    selectionDataSource.setSelectionModel(tableDataModel.getSelectionModel(), true);
                    dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                    this.setSelectionVarDef(dataSource, selectionDataSource, ANIMATION_KEY_FRAME);
                    this.setSelectionVarDef(dataSource, selectionDataSource, ANIMATION_IDENTIFICATION);
                    this.setSelectionVarDef(dataSource, selectionDataSource, COLUMN);
                    this.setSelectionVarDef(dataSource, selectionDataSource, ROW);
                    this.setSelectionVarDef(dataSource, selectionDataSource, X);
                    this.setSelectionVarDef(dataSource, selectionDataSource, Y);
                    this.setSelectionVarDef(dataSource, selectionDataSource, Y2);
                    this.setSelectionVarDef(dataSource, selectionDataSource, GROUP);
                    this.setSelectionVarDef(dataSource, selectionDataSource, COLOR);
                    this.setSelectionVarDef(dataSource, selectionDataSource, SIZE);
                    this.setSelectionVarDef(dataSource, selectionDataSource, SHAPE);
                    this.setSelectionVarDef(dataSource, selectionDataSource, TOP_MARKER_LABEL);
                    this.setSelectionVarDef(dataSource, selectionDataSource, BOTTOM_MARKER_LABEL);
                    this.matrix.setSelectionDataSource(selectionDataSource);
                }
                if (this.dataModel.getRulesContext() != null) {
                    String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                    String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{X, Y, Y2}, ruleTargetVariableNameID);
                    this.matrixModel.setRuleTargetIdentifier(columnName);
                }
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof ScatterPlotTableDataModel && (tableModel = ((ScatterPlotTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, ScatterPlotDataModel dataModel, ScatterPlotModel scatterPlotModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (scatterPlotModel.getMissingPolicy()) {
                default: {
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{ANIMATION_KEY_FRAME, COLUMN, ROW, GROUP};
                }
                case 10201: 
            }
            if (removeIfAnyMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
            }
        }
        return dataSource;
    }

    private void setSelectionVarDef(DataSource fromDataSource, DataSource toDataSource, Object role) {
        VariableDefinition vd = fromDataSource.getVariableDefinition(role, 0);
        if (vd != null) {
            try {
                toDataSource.setVariableDefinition(role, vd);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    private static DataSource _newDataSource(ScatterPlotDataModel dataModel, ScatterPlotModel scatterPlotModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        if (dataModel == null) {
            if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof ScatterPlotTableDataModel) {
                dataSource = ScatterPlot._newDataSource((ScatterPlotTableDataModel)dataModel, scatterPlotModel, locale, formatLocale, listSelectionListener);
            } else if (dataModel instanceof ScatterPlotOLAPDataModel) {
                dataSource = ScatterPlot._newDataSource((ScatterPlotOLAPDataModel)dataModel, scatterPlotModel, locale, formatLocale, listSelectionListener);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(ScatterPlotTableDataModel tableDataModel, ScatterPlotModel scatterPlotModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            Variable sv;
            boolean autoY;
            boolean missingDataColumnMessageEnabled;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getModel(), formatLocale, tableDataModel.getSortStrategy()), true, false);
            boolean bl = missingDataColumnMessageEnabled = !scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            if (tableModel instanceof AnimationDirector) {
                AnimationDirector atm = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getKeyFrameVariable()), missingDataColumnMessageEnabled);
                Util.setVariableDefinition(dataSource, ANIMATION_IDENTIFICATION, "animationIdentificationRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, X, "xRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getXVariable(), 16), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, Y, "yRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getYVariable(), 16), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, Y2, "y2Role.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getY2Variable(), 16), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SORT, "sortRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSortVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, GROUP, "groupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getGroupVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, COLOR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SIZE, "sizeRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSizeVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SHAPE, "shapeRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getShapeVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, TOP_MARKER_LABEL, "topMarkerLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getTopMarkerLabelVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, BOTTOM_MARKER_LABEL, "bottomMarkerLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBottomMarkerLabelVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            boolean autoX = dataSource.getVariableDefinition(X) == null;
            boolean bl2 = autoY = dataSource.getVariableDefinition(Y) == null && dataSource.getVariableDefinition(Y2) == null;
            if (autoX || autoY) {
                int[] avoidY;
                int xIndex = autoX ? -1 : tableModel.getColumnCount();
                int yIndex = autoY ? -1 : tableModel.getColumnCount();
                int[] avoidX = autoX ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(X));
                int[] nArray = avoidY = autoY ? null : Util.getColumnIndices(tableModel, dataSource.getVariableDefinition(Y));
                if (xIndex < 0) {
                    int[] nArray2;
                    String xName = com.sas.graphics.components.RB.getStringResource("Graph.", "xRole.txt");
                    xIndex = Util.seekNamedColumn(tableModel, xName, avoidY);
                    if (xIndex >= 0) {
                        int[] nArray3 = new int[1];
                        nArray2 = nArray3;
                        nArray3[0] = xIndex;
                    } else {
                        nArray2 = avoidX = null;
                    }
                }
                if (yIndex < 0) {
                    int[] nArray4;
                    String yName = com.sas.graphics.components.RB.getStringResource("Graph.", "yRole.txt");
                    yIndex = Util.seekNamedColumn(tableModel, yName, avoidX);
                    if (yIndex >= 0) {
                        int[] nArray5 = new int[1];
                        nArray4 = nArray5;
                        nArray5[0] = yIndex;
                    } else {
                        nArray4 = avoidY = null;
                    }
                }
                if (xIndex < 0 && yIndex < 0) {
                    yIndex = Util.seekNumberColumn(tableModel);
                    if (yIndex >= 0) {
                        xIndex = Util.seekNumberColumn(tableModel, new int[]{yIndex});
                        if (xIndex >= 0) {
                            int tmp = yIndex;
                            yIndex = xIndex;
                            xIndex = tmp;
                        } else {
                            int[] nArray6;
                            if (yIndex >= 0) {
                                int[] nArray7 = new int[1];
                                nArray6 = nArray7;
                                nArray7[0] = yIndex;
                            } else {
                                nArray6 = null;
                            }
                            avoidY = nArray6;
                        }
                    }
                } else if (yIndex < 0) {
                    int[] nArray8;
                    yIndex = Util.seekNumberColumn(tableModel, avoidX);
                    if (yIndex >= 0) {
                        int[] nArray9 = new int[1];
                        nArray8 = nArray9;
                        nArray9[0] = yIndex;
                    } else {
                        nArray8 = null;
                    }
                    avoidY = nArray8;
                } else if (xIndex < 0) {
                    int[] nArray10;
                    xIndex = Util.seekNumberColumn(tableModel, avoidY);
                    if (xIndex >= 0) {
                        int[] nArray11 = new int[1];
                        nArray10 = nArray11;
                        nArray11[0] = xIndex;
                    } else {
                        nArray10 = avoidX = null;
                    }
                }
                if (xIndex < 0) {
                    int[] nArray12;
                    xIndex = Util.seekDateColumn(tableModel, avoidY);
                    if (xIndex < 0) {
                        xIndex = Util.seekStringColumn(tableModel, avoidY);
                    }
                    if (xIndex < 0) {
                        xIndex = Util.seekNonNullColumn(tableModel, avoidY);
                    }
                    if (xIndex < 0) {
                        xIndex = Util.seekNonNullColumn(tableModel, null);
                    }
                    if (xIndex < 0) {
                        xIndex = 0;
                    }
                    if (xIndex >= 0) {
                        int[] nArray13 = new int[1];
                        nArray12 = nArray13;
                        nArray13[0] = xIndex;
                    } else {
                        nArray12 = avoidX = null;
                    }
                }
                if (yIndex < 0) {
                    yIndex = Util.seekDateColumn(tableModel, avoidX);
                    if (yIndex < 0) {
                        yIndex = Util.seekStringColumn(tableModel, avoidX);
                    }
                    if (yIndex < 0) {
                        yIndex = Util.seekNonNullColumn(tableModel, avoidX);
                    }
                    if (yIndex < 0) {
                        yIndex = Util.seekNonNullColumn(tableModel);
                    }
                    if (yIndex < 0) {
                        yIndex = 0;
                    }
                }
                if (autoX) {
                    dataSource.setVariableDefinition(X, new VariableDefinition(new Integer(xIndex), null, null, 0));
                }
                if (autoY) {
                    dataSource.setVariableDefinition(Y, new VariableDefinition(new Integer(yIndex), null, null, 0));
                }
            }
            if ((sv = tableDataModel.getSortVariable()) != null) {
                Integer sort = sv instanceof ClassificationVariable ? new Integer(((ClassificationVariable)sv).getSort()) : new Integer(10401);
                VariableDefinition catSortVarDef = sv.getColumnName() != null ? new VariableDefinition(sv.getColumnName(), sv.getFormat(), sv.getInformat(), sv.getLabel(), sort, null, null, null, null, null, null, null, 0) : new VariableDefinition(new Integer(sv.getColumnIndex()), sv.getFormat(), sv.getInformat(), sv.getLabel(), sort, null, null, null, null, null, null, null, 0);
                dataSource.setVariableDefinition(SORT, catSortVarDef);
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("isSelected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = ScatterPlot._applyDataSourceWhereProcessing(dataSource, tableDataModel, scatterPlotModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(ScatterPlotOLAPDataModel olapDataModel, ScatterPlotModel scatterPlotModel, Locale locale, Locale formatLocale, ListSelectionListener listSelectionListener) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    int ii;
                    int y2MeasureCount;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                    dataSource.setSelectionModel(selectionModel, false);
                    String groupHierarchyName = null;
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    ArrayList xMeasures = null;
                    ArrayList yMeasures = null;
                    List y2Measures = null;
                    List sizeMeasures = null;
                    ArrayList measureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getXVariable() != null || olapDataModel.getYVariable() != null || olapDataModel.getY2Variable() != null || olapDataModel.getSizeVariable() != null) {
                        xMeasures = Util.newValidatedList(olapDataModel.getXVariable(), measureNames, gtkOLAPFactory, "xRole.txt", locale);
                        yMeasures = Util.newValidatedList(olapDataModel.getYVariable(), measureNames, gtkOLAPFactory, "yRole.txt", locale);
                        y2Measures = Util.newValidatedList(olapDataModel.getY2Variable(), measureNames, gtkOLAPFactory, "y2Role.txt", locale);
                        sizeMeasures = Util.newValidatedList(olapDataModel.getSizeVariable(), measureNames, gtkOLAPFactory, "sizeRole.txt", locale);
                        if (xMeasures == null || xMeasures.size() < 1 || yMeasures == null || yMeasures.size() < 1) {
                            // empty if block
                        }
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, X, xMeasures, "xRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, Y, yMeasures, "yRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, Y2, y2Measures, "y2Role.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, SIZE, sizeMeasures, "sizeRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, X_SELECTION, xMeasures, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, Y_SELECTION, yMeasures, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, Y2_SELECTION, y2Measures, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, SIZE_SELECTION, sizeMeasures, missingDataColumnMessageEnabled);
                    } else if (measureNames.size() == 1) {
                        yMeasures = measureNames;
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, Y, yMeasures, "yRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, Y_SELECTION, measureNames, missingDataColumnMessageEnabled);
                    } else if (olapDataModel.isPairingEnabled() && measureNames.size() % 2 == 0) {
                        xMeasures = new ArrayList();
                        yMeasures = new ArrayList();
                        for (int i = 0; i < measureNames.size(); i += 2) {
                            xMeasures.add(measureNames.get(i));
                            yMeasures.add(measureNames.get(i + 1));
                        }
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, X, xMeasures, "xRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, Y, yMeasures, "yRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, X_SELECTION, xMeasures, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, Y_SELECTION, yMeasures, missingDataColumnMessageEnabled);
                    } else {
                        xMeasures = new ArrayList();
                        xMeasures.add(measureNames.remove(0));
                        yMeasures = measureNames;
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, X, xMeasures, "xRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, Y, yMeasures, "yRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, X_SELECTION, xMeasures, missingDataColumnMessageEnabled);
                        Util.setOLAPSelections(dataSource, selectionModel, Y_SELECTION, yMeasures, missingDataColumnMessageEnabled);
                    }
                    int xMeasureCount = xMeasures != null ? xMeasures.size() : 0;
                    int yMeasureCount = yMeasures != null ? yMeasures.size() : 0;
                    int n = y2MeasureCount = y2Measures != null ? y2Measures.size() : 0;
                    if (olapDataModel.isGroupEnabled() && yMeasureCount + y2MeasureCount == 1) {
                        if (columnHierarchyNames.size() > 0) {
                            groupHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        } else if (rowHierarchyNames.size() > 0) {
                            groupHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                    }
                    if (xMeasureCount == 0) {
                        String xHierarchyName = null;
                        if (columnHierarchyNames.size() > 0) {
                            xHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        } else if (rowHierarchyNames.size() > 0) {
                            xHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                        if (xHierarchyName == null && groupHierarchyName != null) {
                            xHierarchyName = groupHierarchyName;
                            groupHierarchyName = null;
                        }
                        if (xHierarchyName != null) {
                            ClassificationVariableDefinition x = new ClassificationVariableDefinition(xHierarchyName, null, null, 0);
                            Util.setVariableDefinition(dataSource, X, "xRole.txt", locale, x, missingDataColumnMessageEnabled);
                        } else {
                            throw new Util.ComponentsMessageException("RequiredXDataNotFound.txt", locale);
                        }
                    }
                    if (groupHierarchyName != null) {
                        ClassificationVariableDefinition group = new ClassificationVariableDefinition(groupHierarchyName, null, null, 0);
                        Util.setVariableDefinition(dataSource, GROUP, "groupRole.txt", locale, group, missingDataColumnMessageEnabled);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (int i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            columns = new ClassificationVariableDefinition((String)columnHierarchyNames.get(i), null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (int i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            rows = new ClassificationVariableDefinition((String)rowHierarchyNames.get(i), null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    List allMeasureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], allMeasureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], allMeasureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = ScatterPlot._applyDataSourceWhereProcessing(dataSource, olapDataModel, scatterPlotModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (scatterPlotModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.scatterPlotModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof ScatterPlotTableDataModel) {
            ScatterPlotTableDataModel tm = (ScatterPlotTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof ScatterPlotOLAPDataModel) {
            ScatterPlotOLAPDataModel om = (ScatterPlotOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private void scrollBarInit() {
        this.removeMouseListener(this.scrollBarListener);
        this.scrollBarListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ScatterPlot.this.matrix.getColumnScrollBar() != null) {
                    ScatterPlot.this.matrix.getColumnScrollBar().setVisible(true);
                }
                if (ScatterPlot.this.matrix.getRowScrollBar() != null) {
                    ScatterPlot.this.matrix.getRowScrollBar().setVisible(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Point pt = evt.getPoint();
                Rectangle b = ScatterPlot.this.getBounds();
                if (pt.x >= b.width || pt.x < 0 || pt.y >= b.height || pt.y < 0) {
                    if (!ScatterPlot.this.matrix.isZoomedColumnScrollBar() && ScatterPlot.this.matrix.getColumnScrollBar() != null) {
                        ScatterPlot.this.matrix.getColumnScrollBar().setVisible(false);
                    }
                    if (!ScatterPlot.this.matrix.isZoomedRowScrollBar() && ScatterPlot.this.matrix.getRowScrollBar() != null) {
                        ScatterPlot.this.matrix.getRowScrollBar().setVisible(false);
                    }
                }
            }
        };
        this.addMouseListener(this.scrollBarListener);
    }

    @SASScope
    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(ScatterPlotModel scatterPlotModel) {
            this.apply(scatterPlotModel);
        }

        public void apply(ScatterPlotModel scatterPlotModel) {
            this.customOptions = scatterPlotModel.getCustomOptions() & dataOptions;
            this.missingPolicy = scatterPlotModel.getMissingPolicy();
        }

        public boolean isApplyDataModel(ScatterPlotModel scatterPlotModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != scatterPlotModel.getMissingPolicy();
            }
            return this.customOptions != (scatterPlotModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && super.equals(arg);
        }
    }
}

