/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.riskmapplot;

import com.sas.graphics.components.RB;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.riskmapplot.AbstractRiskMap;
import com.sas.graphics.components.util.Util;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class GridRiskMap
extends AbstractRiskMap {
    private Color[][] color = null;
    private SegmentedRangeModel xSegmentedRangeModel;
    private SegmentedRangeModel ySegmentedRangeModel;
    private BufferedImage image = null;

    public GridRiskMap(SegmentedRangeModel xSegmentedRangeModel, SegmentedRangeModel ySegmentedRangeModel, Color[][] colors) throws IllegalArgumentException {
        if (xSegmentedRangeModel == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeNullRangeNotAllowed.ex.fmt.txt"), (Object)"X-Axis "));
        }
        if (ySegmentedRangeModel == null) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidSegmentedRangeNullRangeNotAllowed.ex.fmt.txt"), (Object)"Y-Axis "));
        }
        if (colors == null) {
            throw new IllegalArgumentException(RB.getStringResource("invalidColorArrayNullNotAllowed.ex.txt"));
        }
        if (xSegmentedRangeModel.getSegmentedRange().length != ySegmentedRangeModel.getSegmentedRange().length) {
            throw new IllegalArgumentException(RB.getStringResource("invalidPositionArrayLengthsNotEqual.ex.txt"));
        }
        if (colors.length != xSegmentedRangeModel.getSegmentedRange().length - 1) {
            throw new IllegalArgumentException(RB.getStringResource("invalidColorArrayLength.ex.txt"));
        }
        for (int i = 0; i < colors.length; ++i) {
            for (int j = 0; j < colors.length; ++j) {
                if (colors[i][j] != null) continue;
                throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidColorArrayNullNotAllowed.ex.txt"), (Object)"colors "));
            }
        }
        Util.Validator.validateSegmentedRange(xSegmentedRangeModel.getSegmentedRange(), "xSegmentedRange");
        Util.Validator.validateSegmentedRange(ySegmentedRangeModel.getSegmentedRange(), "ySegmentedRange");
        this.xSegmentedRangeModel = Util.Copier.copyOf(xSegmentedRangeModel);
        this.ySegmentedRangeModel = Util.Copier.copyOf(ySegmentedRangeModel);
        this.color = colors;
    }

    @Override
    public double[] getXSegmentedRange() {
        return this.xSegmentedRangeModel.getSegmentedRange();
    }

    @Override
    public double[] getYSegmentedRange() {
        return this.ySegmentedRangeModel.getSegmentedRange();
    }

    private BufferedImage typeMagicQuadrant(int imageWidth, int imageHeight, double xDataBegin, double xDataEnd, double yDataBegin, double yDataEnd) {
        int i;
        int i2;
        Graphics2D g = null;
        double[] arrayX = null;
        double[] arrayY = null;
        double tempX = 0.0;
        double tempY = 0.0;
        double prevX = 0.0;
        double prevY = 0.0;
        double xLength = 0.0;
        double yLength = 0.0;
        double xscaleFactor = 0.0;
        double yscaleFactor = 0.0;
        double[] xPos = this.xSegmentedRangeModel.getSegmentedRange();
        double[] yPos = this.ySegmentedRangeModel.getSegmentedRange();
        if (xPos[0] > xPos[xPos.length - 1]) {
            if (xDataEnd > xPos[0]) {
                xPos[0] = xDataEnd;
            }
            if (xDataBegin < xPos[xPos.length - 1]) {
                xPos[xPos.length - 1] = xDataBegin;
            }
        } else {
            xPos[0] = xDataBegin;
            xPos[xPos.length - 1] = xDataEnd;
        }
        if (yPos[0] > yPos[xPos.length - 1]) {
            if (yDataEnd > yPos[0]) {
                yPos[0] = yDataEnd;
            }
            if (yDataBegin < yPos[yPos.length - 1]) {
                yPos[yPos.length - 1] = yDataBegin;
            }
        } else {
            yPos[0] = yDataBegin;
            yPos[yPos.length - 1] = yDataEnd;
        }
        if (xPos[0] > xPos[xPos.length - 1]) {
            xPos = GridRiskMap.getProportion(xDataBegin, xDataEnd, xPos);
        }
        if (yPos[0] > yPos[yPos.length - 1]) {
            yPos = GridRiskMap.getProportion(yDataBegin, yDataEnd, yPos);
        }
        double[] newXArray = new double[xPos.length - 1];
        double[] newYArray = new double[yPos.length - 1];
        Color[][] newColor = new Color[xPos.length - 1][yPos.length - 1];
        arrayX = new double[xPos.length];
        arrayY = new double[yPos.length];
        for (i2 = 0; i2 < xPos.length; ++i2) {
            arrayX[i2] = xPos[i2];
            arrayY[i2] = yPos[i2];
        }
        for (i2 = 0; i2 < xPos.length - 1; ++i2) {
            for (int j = 0; j < yPos.length - 1; ++j) {
                newColor[i2][j] = this.color[i2][j];
            }
        }
        if (xDataBegin == xDataEnd || yDataBegin == yDataEnd) {
            return this.image;
        }
        arrayX = this.getPerfectArray(arrayX, xDataBegin, xDataEnd);
        arrayY = this.getPerfectArray(arrayY, yDataBegin, yDataEnd);
        xLength = arrayX[arrayX.length - 1] - arrayX[0];
        yLength = arrayY[arrayY.length - 1] - arrayY[0];
        xscaleFactor = (double)imageWidth / xLength;
        yscaleFactor = (double)imageHeight / yLength;
        try {
            this.image = new BufferedImage(imageWidth, imageHeight, 2);
        }
        catch (RuntimeException e) {
            this.image = new BufferedImage(imageWidth, imageHeight, 6);
        }
        g = this.image.createGraphics();
        for (i = 0; i <= arrayX.length - 1; ++i) {
            arrayX[i] = arrayX[i] * xscaleFactor;
        }
        for (i = 0; i <= arrayY.length - 1; ++i) {
            arrayY[i] = arrayY[i] * yscaleFactor;
        }
        for (i = 0; i < arrayX.length - 1; ++i) {
            newXArray[i] = arrayX[i + 1] - arrayX[i];
        }
        for (i = 0; i < arrayY.length - 1; ++i) {
            newYArray[i] = arrayY[i + 1] - arrayY[i];
        }
        int row_Color = 0;
        for (int i3 = 0; i3 <= newYArray.length - 1; ++i3) {
            tempY = newYArray[i3];
            prevY += tempY;
            for (int j = 0; j <= newXArray.length - 1; ++j) {
                g.setColor(newColor[row_Color][j]);
                tempX = newXArray[j] + 0.5;
                g.draw(new Rectangle2D.Double(prevX, (double)imageHeight - prevY, tempX, tempY));
                g.fill(new Rectangle2D.Double(prevX, (double)imageHeight - prevY, tempX, tempY));
                prevX += tempX;
            }
            ++row_Color;
            prevX = 0.0;
        }
        return this.image;
    }

    @Override
    public Image createImage(int imageWidth, int imageHeight, double xDataBegin, double xDataEnd, double yDataBegin, double yDataEnd) {
        if (xDataBegin == Double.POSITIVE_INFINITY || xDataEnd == Double.POSITIVE_INFINITY || yDataBegin == Double.POSITIVE_INFINITY || yDataEnd == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (xDataBegin == Double.NEGATIVE_INFINITY || xDataEnd == Double.NEGATIVE_INFINITY || yDataBegin == Double.NEGATIVE_INFINITY || yDataEnd == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        if (imageWidth < 1 || imageHeight < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (Double.isNaN(xDataBegin) || Double.isNaN(yDataBegin) || Double.isNaN(xDataEnd) || Double.isNaN(yDataEnd)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        BufferedImage actualImage = null;
        double[] xPos = this.xSegmentedRangeModel.getSegmentedRange();
        double[] yPos = this.ySegmentedRangeModel.getSegmentedRange();
        if (xPos[0] > xPos[xPos.length - 1]) {
            if (xDataEnd > xPos[0]) {
                xPos[0] = xDataEnd;
            }
            if (xDataBegin > xPos[xPos.length - 1]) {
                xPos[xPos.length - 1] = xDataBegin;
            }
        } else {
            xPos[0] = xDataBegin;
            xPos[xPos.length - 1] = xDataEnd;
        }
        if (yPos[0] > yPos[xPos.length - 1]) {
            if (yDataEnd < yPos[0]) {
                yPos[0] = yDataEnd;
            }
            if (yDataBegin < yPos[yPos.length - 1]) {
                yPos[yPos.length - 1] = yDataBegin;
            }
        } else {
            yPos[0] = yDataBegin;
            yPos[yPos.length - 1] = yDataEnd;
        }
        if (xDataBegin > xPos[xPos.length - 1]) {
            xPos = GridRiskMap.getProportion(xDataBegin, xDataEnd, xPos);
        }
        if (yDataBegin > yPos[xPos.length - 1]) {
            yPos = GridRiskMap.getProportion(yDataBegin, yDataEnd, yPos);
        }
        if (xDataBegin <= xPos[0] && xDataEnd >= xPos[xPos.length - 1] && yDataBegin <= yPos[0] && yDataEnd >= yPos[yPos.length - 1]) {
            actualImage = this.typeMagicQuadrant(imageWidth, imageHeight, xDataBegin, xDataEnd, yDataBegin, yDataEnd);
            return actualImage;
        }
        double xTempDataBegin = xDataBegin;
        double xTempDataEnd = xDataEnd;
        double yTempDataBegin = yDataBegin;
        double yTempDataEnd = yDataEnd;
        if (xDataBegin > xPos[0]) {
            xTempDataBegin = xDataBegin;
        }
        if (xDataEnd < xPos[xPos.length - 1]) {
            xTempDataEnd = xDataEnd;
        }
        if (yDataBegin > yPos[0]) {
            yTempDataBegin = yDataBegin;
        }
        if (yDataEnd < yPos[yPos.length - 1]) {
            yTempDataEnd = yDataEnd;
        }
        double xScaleFactor = 1.0 * (xTempDataEnd - xTempDataBegin) / (1.0 * (xDataEnd - xDataBegin));
        double yScaleFactor = 1.0 * (yTempDataEnd - yTempDataBegin) / (1.0 * (yDataEnd - yDataBegin));
        double widthofBigImage = xScaleFactor * (double)imageWidth;
        double heightofBigImage = yScaleFactor * (double)imageHeight;
        double pixelX = 1.0 * (xDataBegin - xTempDataBegin) / (1.0 * (xTempDataEnd - xTempDataBegin)) * widthofBigImage;
        double pixelY = 1.0 * (yDataBegin - yTempDataBegin) / (1.0 * (yTempDataEnd - yTempDataBegin)) * heightofBigImage;
        BufferedImage bigImage = null;
        bigImage = this.typeMagicQuadrant((int)widthofBigImage, (int)heightofBigImage, xTempDataBegin, xTempDataEnd, yTempDataBegin, yTempDataEnd);
        actualImage = bigImage.getSubimage((int)pixelX, (int)(heightofBigImage - (double)imageHeight - pixelY), imageWidth, imageHeight);
        return actualImage;
    }

    private static double[] getProportion(double DataBegin, double DataEnd, double[] Pos) {
        double temp = DataBegin;
        DataBegin = DataEnd;
        DataEnd = temp;
        double[] dx = new double[Pos.length];
        dx[0] = Pos[Pos.length - 1];
        for (int i = 1; i < dx.length; ++i) {
            dx[i] = dx[0] + Pos[0] - Pos[i];
        }
        Pos = dx;
        return Pos;
    }

    private double[] getPerfectArray(double[] array, double dataBegin, double dataEnd) {
        double[] tempArrayX = new double[array.length];
        if (dataBegin < array[0]) {
            array[0] = dataBegin;
        }
        for (int i = 0; i < array.length; ++i) {
            tempArrayX[i] = array[i] <= dataBegin ? Math.max(array[i], dataBegin) : (array[i] >= dataEnd ? Math.min(array[i], dataEnd) : array[i]);
        }
        if (dataEnd > array[array.length - 1]) {
            tempArrayX[array.length - 1] = dataEnd;
        }
        return tempArrayX;
    }
}

