/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.radarchart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class RadarChartModel
extends GraphModel {
    public static final String RB_KEY = "RadarChartModel.";
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private LegendModel colorLegendModel = new LegendModel();
    private AxisModel axisModel = new AxisModel();
    private double startAngle = 0.0;
    private int radarType = 10903;
    private boolean fillEnabled = true;
    private boolean lineEnabled = false;
    private boolean uniformAxes = true;
    private int missingPolicy = 10200;
    private double sectorWidth = 1.0;
    private boolean drawSectorOnAxis = false;
    private static final int _RADAR_TYPE_ = 10900;
    public static final int RADAR_TYPE_RADIAL = 10900;
    public static final int RADAR_TYPE_SPOKE = 10901;
    public static final int RADAR_TYPE_POLYGON = 10902;
    public static final int RADAR_TYPE_WEDGE = 10903;
    public static final int RADAR_TYPE_SECTOR = 10904;
    public static final int RADAR_TYPE_CHORD = 10905;
    public static final int RADAR_TYPE_CALENDAR = 10906;
    public static final int RADAR_TYPE_CORONA = 10907;
    public static final ConstantCollection RADAR_TYPE = new ConstantCollection(com.sas.graphics.components.radarchart.RB.class, "RadarChartModel.", new ConstantCollection.Element[]{new ConstantCollection.Element(10900, "RADAR_TYPE_RADIAL", "Radial"), new ConstantCollection.Element(10901, "RADAR_TYPE_SPOKE", "Spoke"), new ConstantCollection.Element(10902, "RADAR_TYPE_POLYGON", "Polygon"), new ConstantCollection.Element(10903, "RADAR_TYPE_WEDGE", "Wedge"), new ConstantCollection.Element(10904, "RADAR_TYPE_SECTOR", "Sector"), new ConstantCollection.Element(10905, "RADAR_TYPE_CHORD", "Chord"), new ConstantCollection.Element(10906, "RADAR_TYPE_CALENDAR", "Calendar"), new ConstantCollection.Element(10907, "RADAR_TYPE_CORONA", "Corona")});

    public void apply(RadarChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.startAngle = theOtherModel.startAngle;
        this.radarType = theOtherModel.radarType;
        this.fillEnabled = theOtherModel.fillEnabled;
        this.lineEnabled = theOtherModel.lineEnabled;
        this.uniformAxes = theOtherModel.uniformAxes;
        this.missingPolicy = theOtherModel.missingPolicy;
        this.axisModel.apply(theOtherModel.axisModel);
        this.colorLegendModel.apply(theOtherModel.colorLegendModel);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public RadarChartModel() {
        this.setContainedModel("rowAxisModel", this.rowAxisModel);
        this.setContainedModel("columnAxisModel", this.columnAxisModel);
        this.setContainedModel("axisModel", this.axisModel);
        this.setContainedModel("LegendModel", this.colorLegendModel);
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.rowAxisModel;
        this.rowAxisModel = newAxis;
        this.firePropertyChange("rowAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.columnAxisModel;
        this.columnAxisModel = newAxis;
        this.firePropertyChange("columnAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public void setRadarType(int newRadarType) throws IllegalArgumentException {
        switch (newRadarType) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10900: 
            case 10901: 
            case 10902: 
            case 10903: 
            case 10904: 
            case 10905: 
            case 10906: 
            case 10907: 
        }
        int oldValue = this.radarType;
        this.radarType = newRadarType;
        this.firePropertyChange("radarType", oldValue, newRadarType);
    }

    public int getRadarType() {
        return this.radarType;
    }

    public void setColorLegendModel(LegendModel newModel) throws IllegalArgumentException {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        LegendModel oldValue = this.colorLegendModel;
        this.colorLegendModel = newModel;
        this.firePropertyChange("colorLegendModel", oldValue, newModel);
    }

    public LegendModel getColorLegendModel() {
        return this.colorLegendModel;
    }

    public void setAxisModel(AxisModel newAxisModel) throws IllegalArgumentException {
        if (newAxisModel == null) {
            throw new IllegalArgumentException();
        }
        AxisModel oldValue = this.axisModel;
        this.axisModel = newAxisModel;
        this.firePropertyChange("axisModel", oldValue, newAxisModel);
    }

    public AxisModel getAxisModel() {
        return this.axisModel;
    }

    public void setStartAngle(double newAngle) {
        double oldAngle = this.startAngle;
        this.startAngle = newAngle;
        this.firePropertyChange("startAngle", oldAngle, newAngle);
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setFillEnabled(boolean fill) {
        boolean oldValue = this.fillEnabled;
        this.fillEnabled = fill;
        this.firePropertyChange("fillEnabled", oldValue, fill);
    }

    public boolean isFillEnabled() {
        return this.fillEnabled;
    }

    public void setLineEnabled(boolean line) {
        boolean oldValue = this.lineEnabled;
        this.lineEnabled = line;
        this.firePropertyChange("lineEnabled", oldValue, line);
    }

    public boolean isLineEnabled() {
        return this.lineEnabled;
    }

    public void setUniformAxes(boolean uniform) {
        boolean oldValue = this.uniformAxes;
        this.uniformAxes = uniform;
        this.firePropertyChange("uniformAxes", oldValue, uniform);
    }

    public boolean isUniformAxes() {
        return this.uniformAxes;
    }

    public void setSectorWidth(double newSectorWidth) throws IllegalArgumentException {
        if (!(newSectorWidth > 0.0) || !(newSectorWidth <= 1.0)) {
            throw new IllegalArgumentException(RB.getStringResource("RadarChart.sectorWithInvalid.ex.txt"));
        }
        double oldValue = this.sectorWidth;
        this.sectorWidth = newSectorWidth;
        this.firePropertyChange("sectorWidth", oldValue, this.sectorWidth);
    }

    public double getSectorWidth() {
        return this.sectorWidth;
    }

    public void setMissingPolicy(int newMissingPolicy) {
        GraphConstants.TRI.validate(newMissingPolicy);
        int oldValue = this.missingPolicy;
        this.missingPolicy = newMissingPolicy;
        this.firePropertyChange("missingPolicy", oldValue, this.missingPolicy);
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public void applyWindroseSettings() {
        double inc;
        this.setRadarType(10904);
        this.setDrawSectorOnAxis(true);
        this.axisModel.getMajorTickStyle().getLineStyle().setVisibilityPolicy(10202);
        this.axisModel.getValueTextStyle().setVisible(false);
        double placement = inc = 0.25;
        ReferenceLineModel[] referenceCircleModels = new ReferenceLineModel[4];
        for (int i = 0; i < 4; ++i) {
            referenceCircleModels[i] = new ReferenceLineModel(placement);
            placement += inc;
        }
        this.axisModel.setReferenceLineModels(referenceCircleModels);
    }

    public void applyFlorenceSettings() {
        double inc;
        this.setRadarType(10904);
        this.axisModel.getMajorTickStyle().getLineStyle().setVisibilityPolicy(10202);
        double placement = inc = 0.25;
        ReferenceLineModel[] referenceCircleModels = new ReferenceLineModel[4];
        AdvancedTextStyle textStyle = new AdvancedTextStyle();
        textStyle.setVisible(false);
        for (int i = 0; i < 4; ++i) {
            referenceCircleModels[i] = new ReferenceLineModel(placement);
            referenceCircleModels[i].setTextStyle(textStyle);
            placement += inc;
        }
        this.axisModel.setReferenceLineModels(referenceCircleModels);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        RadarChartModel arg = (RadarChartModel)obj;
        return Util.Evaluate.isEqual(this.radarType, arg.radarType) && Util.Evaluate.isEqual(this.startAngle, arg.startAngle) && Util.Evaluate.isEqual(this.fillEnabled, arg.fillEnabled) && Util.Evaluate.isEqual(this.uniformAxes, arg.uniformAxes) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual(this.colorLegendModel, arg.colorLegendModel) && Util.Evaluate.isEqual(this.axisModel, arg.axisModel) && super.equals(arg);
    }

    public void setDrawSectorOnAxis(boolean newDrawSectorOnAxis) {
        boolean oldValue = this.drawSectorOnAxis;
        this.drawSectorOnAxis = newDrawSectorOnAxis;
        this.firePropertyChange("drawSectorOnAxis", oldValue, newDrawSectorOnAxis);
    }

    public boolean isDrawSectorOnAxis() {
        return this.drawSectorOnAxis;
    }
}

