/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.piechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.piechart.PieChartDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.storage.olap.OLAPDataSetInterface;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

@SASScope(value="ALL")
public class PieChartOLAPDataModel
extends PieChartDataModel {
    private OLAPDataSetInterface model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean subgroupEnabled = false;
    private Variable responseVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(PieChartOLAPDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(PieChartOLAPDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.subgroupEnabled = theOtherModel.subgroupEnabled;
        this.responseVariable = theOtherModel.responseVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PieChartOLAPDataModel arg = (PieChartOLAPDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.subgroupEnabled, arg.subgroupEnabled) && Util.Evaluate.isEqual(this.responseVariable, arg.responseVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public PieChartOLAPDataModel() {
    }

    public PieChartOLAPDataModel(OLAPDataSetInterface newModel) {
        this();
        this.model = newModel;
    }

    public PieChartOLAPDataModel(OLAPDataSetInterface newModel, boolean newSubgroupEnabled) {
        this(newModel);
        this.subgroupEnabled = newSubgroupEnabled;
    }

    public void setSubgroupEnabled(boolean newSubgroupEnabled) {
        boolean oldSubgroupEnabled = this.subgroupEnabled;
        this.subgroupEnabled = newSubgroupEnabled;
        this.firePropertyChange("subgroupEnabled", new Boolean(oldSubgroupEnabled), new Boolean(this.subgroupEnabled));
    }

    public boolean isSubgroupEnabled() {
        return this.subgroupEnabled;
    }

    public void setModel(OLAPDataSetInterface newModel) {
        OLAPDataSetInterface oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setResponseVariable(Variable newVariable) {
        Variable oldVariable = this.responseVariable;
        this.responseVariable = newVariable;
        this.firePropertyChange("responseVariable", oldVariable, newVariable);
    }

    public Variable getResponseVariable() {
        return this.responseVariable;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }
}

