/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.piechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.piechart.OtherThreshold;
import com.sas.graphics.components.piechart.PieChartSubgroupModel;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

@SASScope(value="ALL")
public class PieChartModel
extends GraphModel {
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private LegendModel legendModel = new LegendModel();
    private String[] explodedCategories = new String[0];
    private String[] invisibleCategories = new String[0];
    private double startAngle = 0.0;
    private int sliceOrder = 10400;
    private boolean reverseDirection = false;
    private int dimension = 10100;
    private OtherThreshold otherThreshold = new OtherThreshold(4.0, "percent");
    private Color otherColor = null;
    private String otherSliceLabel = RB.getStringResource("other.txt");
    private int insideSliceLabelContent = 10601;
    private int outsideSliceLabelContent = 10603;
    private AdvancedTextStyle insideSliceLabelTextStyle = new AdvancedTextStyle();
    private AdvancedTextStyle outsideSliceLabelTextStyle = new AdvancedTextStyle();
    private int across = 0;
    private int down = 0;
    private int responseLabelVisiblePolicy = 10200;
    private int donutHoleSize;
    private String donutHoleLabel;
    private AdvancedTextStyle donutHoleLabelTextStyle = new AdvancedTextStyle();
    private AdvancedTextStyle responseLabelTextStyle = new AdvancedTextStyle();
    private PieChartSubgroupModel subgroupLabelModel = new PieChartSubgroupModel();
    private int outsideSliceLabelPlacement = 10200;
    private int insideSliceLabelPlacement = 10200;
    private int missingPolicy = 10200;
    public static final int STACK_SUBGROUP = 0;
    public static final int STACK_RESPONSE = 1;
    private int stackRole = 0;
    private int skin = 10200;

    public void apply(PieChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.outsideSliceLabelContent = theOtherModel.outsideSliceLabelContent;
        this.insideSliceLabelContent = theOtherModel.insideSliceLabelContent;
        this.explodedCategories = theOtherModel.explodedCategories;
        this.invisibleCategories = theOtherModel.invisibleCategories;
        this.startAngle = theOtherModel.startAngle;
        this.sliceOrder = theOtherModel.sliceOrder;
        this.reverseDirection = theOtherModel.reverseDirection;
        this.dimension = theOtherModel.dimension;
        this.otherThreshold = theOtherModel.otherThreshold;
        this.otherColor = theOtherModel.otherColor;
        this.otherSliceLabel = theOtherModel.otherSliceLabel;
        this.across = theOtherModel.across;
        this.down = theOtherModel.down;
        this.responseLabelVisiblePolicy = theOtherModel.responseLabelVisiblePolicy;
        this.missingPolicy = theOtherModel.missingPolicy;
        this.donutHoleSize = theOtherModel.donutHoleSize;
        this.donutHoleLabel = theOtherModel.donutHoleLabel;
        this.outsideSliceLabelPlacement = theOtherModel.outsideSliceLabelPlacement;
        this.insideSliceLabelPlacement = theOtherModel.insideSliceLabelPlacement;
        this.skin = theOtherModel.skin;
        this.legendModel.apply(theOtherModel.legendModel);
        this.insideSliceLabelTextStyle.apply(theOtherModel.insideSliceLabelTextStyle);
        this.outsideSliceLabelTextStyle.apply(theOtherModel.outsideSliceLabelTextStyle);
        this.donutHoleLabelTextStyle.apply(theOtherModel.donutHoleLabelTextStyle);
        this.responseLabelTextStyle.apply(theOtherModel.responseLabelTextStyle);
        this.subgroupLabelModel.apply(theOtherModel.subgroupLabelModel);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.rowAxisModel;
        this.rowAxisModel = newAxis;
        this.firePropertyChange("rowAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.columnAxisModel;
        this.columnAxisModel = newAxis;
        this.firePropertyChange("columnAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public PieChartModel() {
        this.setAntialiasedGraphics(true);
        this.setContainedModel("rowAxisModel", this.rowAxisModel);
        this.setContainedModel("columnAxisModel", this.columnAxisModel);
        this.setContainedModel("insideSliceLabelTextStyle", this.insideSliceLabelTextStyle);
        this.setContainedModel("outsideSliceLabelTextStyle", this.outsideSliceLabelTextStyle);
        this.setContainedModel("LegendModel", this.legendModel);
        this.setContainedModel("donutHoleLabelTextStyle", this.donutHoleLabelTextStyle);
        this.setContainedModel("responseLabelTextStyle", this.responseLabelTextStyle);
        this.setContainedModel("subgroupLabelModel", this.subgroupLabelModel);
    }

    public void setLegendModel(LegendModel newModel) throws IllegalArgumentException {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        LegendModel oldValue = this.legendModel;
        this.legendModel = newModel;
        this.firePropertyChange("legendModel", oldValue, newModel);
    }

    public LegendModel getLegendModel() {
        return this.legendModel;
    }

    public void setInsideSliceLabelContent(int newSliceLabel) {
        switch (newSliceLabel) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10200: 
            case 10601: 
            case 10602: 
            case 10603: 
            case 10608: 
            case 10609: 
            case 10610: 
            case 10611: 
            case 10612: 
        }
        int oldSliceLabel = this.insideSliceLabelContent;
        this.insideSliceLabelContent = newSliceLabel;
        this.firePropertyChange("insideSliceLabelContent", oldSliceLabel, newSliceLabel);
    }

    public int getInsideSliceLabelContent() {
        return this.insideSliceLabelContent;
    }

    public void setOutsideSliceLabelContent(int newSliceLabel) {
        switch (newSliceLabel) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10200: 
            case 10601: 
            case 10602: 
            case 10603: 
            case 10608: 
            case 10609: 
            case 10610: 
            case 10611: 
            case 10612: 
        }
        int oldSliceLabel = this.outsideSliceLabelContent;
        this.outsideSliceLabelContent = newSliceLabel;
        this.firePropertyChange("outsideSliceLabelContent", oldSliceLabel, newSliceLabel);
    }

    public int getOutsideSliceLabelContent() {
        return this.outsideSliceLabelContent;
    }

    public void setInsideSliceLabelTextStyle(AdvancedTextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldStyle = this.insideSliceLabelTextStyle;
        this.insideSliceLabelTextStyle = newStyle;
        this.firePropertyChange("insideSliceLabelTextStyle", oldStyle, newStyle);
    }

    public AdvancedTextStyle getInsideSliceLabelTextStyle() {
        return this.insideSliceLabelTextStyle;
    }

    public void setOutsideSliceLabelTextStyle(AdvancedTextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldStyle = this.outsideSliceLabelTextStyle;
        this.outsideSliceLabelTextStyle = newStyle;
        this.firePropertyChange("outsideSliceLabelTextStyle", oldStyle, newStyle);
    }

    public AdvancedTextStyle getOutsideSliceLabelTextStyle() {
        return this.outsideSliceLabelTextStyle;
    }

    public void setExplodedCategories(String[] newCategories) {
        String[] oldCategories = this.explodedCategories;
        this.explodedCategories = newCategories;
        this.firePropertyChange("explodedCategories", oldCategories, newCategories);
    }

    public String[] getExplodedCategories() {
        return this.explodedCategories;
    }

    public void setInvisibleCategories(String[] newCategories) {
        String[] oldCategories = this.invisibleCategories;
        this.invisibleCategories = newCategories;
        this.firePropertyChange("invisibleCategories", oldCategories, newCategories);
    }

    public String[] getInvisibleCategories() {
        return this.invisibleCategories;
    }

    public void setStartAngle(double newAngle) {
        double oldAngle = this.startAngle;
        this.startAngle = newAngle;
        this.firePropertyChange("startAngle", oldAngle, newAngle);
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setSliceOrder(int newOrder) {
        switch (newOrder) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10400: 
            case 10401: 
            case 10402: 
        }
        int oldOrder = this.sliceOrder;
        this.sliceOrder = newOrder;
        this.firePropertyChange("sliceOrder", oldOrder, newOrder);
    }

    public int getSliceOrder() {
        return this.sliceOrder;
    }

    public void setReverseDirection(boolean newDir) {
        boolean oldDir = this.reverseDirection;
        this.reverseDirection = newDir;
        this.firePropertyChange("reverseDirection", oldDir, newDir);
    }

    public boolean isReverseDirection() {
        return this.reverseDirection;
    }

    public void setResponseLabelVisiblePolicy(int newLabel) {
        switch (newLabel) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10200: 
            case 10201: 
            case 10202: 
        }
        int oldLabel = this.responseLabelVisiblePolicy;
        this.responseLabelVisiblePolicy = newLabel;
        this.firePropertyChange("responseLabelVisiblePolicy", oldLabel, newLabel);
    }

    public int getResponseLabelVisiblePolicy() {
        return this.responseLabelVisiblePolicy;
    }

    public void setOtherThreshold(OtherThreshold newThreshold) {
        if (newThreshold == null) {
            throw new IllegalArgumentException();
        }
        OtherThreshold oldThreshold = this.otherThreshold;
        this.otherThreshold = newThreshold;
        this.firePropertyChange("otherThreshold", (Object)oldThreshold, (Object)newThreshold);
    }

    public OtherThreshold getOtherThreshold() {
        return this.otherThreshold;
    }

    public void setOtherColor(Color newColor) {
        Color oldColor = this.otherColor;
        this.otherColor = newColor;
        this.firePropertyChange("otherColor", oldColor, newColor);
    }

    public Color getOtherColor() {
        return this.otherColor;
    }

    public void setOtherSliceLabel(String newSliceLabel) {
        String oldSliceLabel = this.otherSliceLabel;
        this.otherSliceLabel = newSliceLabel;
        this.firePropertyChange("otherSliceLabel", oldSliceLabel, newSliceLabel);
    }

    public String getOtherSliceLabel() {
        return this.otherSliceLabel;
    }

    public void setAcross(int newAcross) {
        int oldAcross = this.across;
        this.across = newAcross;
        this.firePropertyChange("across", oldAcross, newAcross);
    }

    public int getAcross() {
        return this.across;
    }

    public void setDown(int newDown) {
        int oldDown = this.down;
        this.down = newDown;
        this.firePropertyChange("down", oldDown, newDown);
    }

    public int getDown() {
        return this.down;
    }

    public void setDonutHoleSize(int newSize) {
        int oldSize = this.donutHoleSize;
        this.donutHoleSize = newSize;
        this.firePropertyChange("donutHoleSize", oldSize, newSize);
    }

    public int getDonutHoleSize() {
        return this.donutHoleSize;
    }

    public void setDonutHoleLabel(String newLabel) {
        String oldLabel = this.donutHoleLabel;
        this.donutHoleLabel = newLabel;
        this.firePropertyChange("donutHoleLabel", oldLabel, newLabel);
    }

    public String getDonutHoleLabel() {
        return this.donutHoleLabel;
    }

    public void setDonutHoleLabelTextStyle(AdvancedTextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldStyle = this.donutHoleLabelTextStyle;
        this.donutHoleLabelTextStyle = newStyle;
        this.firePropertyChange("donutHoleLabelTextStyle", oldStyle, newStyle);
    }

    public AdvancedTextStyle getDonutHoleLabelTextStyle() {
        return this.donutHoleLabelTextStyle;
    }

    public void setResponseLabelTextStyle(AdvancedTextStyle newStyle) throws IllegalArgumentException {
        if (newStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        AdvancedTextStyle oldStyle = this.responseLabelTextStyle;
        this.responseLabelTextStyle = newStyle;
        this.firePropertyChange("responseLabelTextStyle", oldStyle, newStyle);
    }

    public AdvancedTextStyle getResponseLabelTextStyle() {
        return this.responseLabelTextStyle;
    }

    public void setSubgroupLabelModel(PieChartSubgroupModel newModel) {
        PieChartSubgroupModel oldModel = this.subgroupLabelModel;
        this.subgroupLabelModel = newModel;
        this.firePropertyChange("subgroupValueTextStyle", oldModel, newModel);
    }

    public PieChartSubgroupModel getSubgroupLabelModel() {
        return this.subgroupLabelModel;
    }

    public void setInsideSliceLabelPlacement(int newPos) {
        switch (newPos) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10200: 
            case 11310: 
        }
        int oldPos = this.insideSliceLabelPlacement;
        this.insideSliceLabelPlacement = newPos;
        this.firePropertyChange("insideSliceLabelPlacement", oldPos, newPos);
    }

    public int getInsideSliceLabelPlacement() {
        return this.insideSliceLabelPlacement;
    }

    public void setOutsideSliceLabelPlacement(int newPos) {
        switch (newPos) {
            default: {
                throw new IllegalArgumentException();
            }
            case 10200: 
            case 11309: 
        }
        int oldPos = this.outsideSliceLabelPlacement;
        this.outsideSliceLabelPlacement = newPos;
        this.firePropertyChange("outsideSliceLabelPlacement", oldPos, newPos);
    }

    public int getOutsideSliceLabelPlacement() {
        return this.outsideSliceLabelPlacement;
    }

    public void setDimension(int newDimension) throws IllegalArgumentException {
        switch (newDimension) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10100: 
            case 10101: 
        }
        int oldValue = this.dimension;
        this.dimension = newDimension;
        this.firePropertyChange("dimension", oldValue, newDimension);
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setMissingPolicy(int newMissingPolicy) {
        GraphConstants.TRI.validate(newMissingPolicy);
        int oldValue = this.missingPolicy;
        this.missingPolicy = newMissingPolicy;
        this.firePropertyChange("missingPolicy", oldValue, this.missingPolicy);
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setStackRole(int newStackRole) {
        int oldValue = this.stackRole;
        this.stackRole = newStackRole;
        this.firePropertyChange("stackRole", oldValue, this.stackRole);
    }

    public int getStackRole() {
        return this.stackRole;
    }

    public void setSkin(int newSkin) throws IllegalArgumentException {
        GraphConstants.SKIN.validate(newSkin);
        int oldValue = this.skin;
        this.skin = newSkin;
        this.firePropertyChange("skin", oldValue, newSkin);
    }

    public int getSkin() {
        return this.skin;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PieChartModel arg = (PieChartModel)obj;
        return Util.Evaluate.isEqual(this.sliceOrder, arg.sliceOrder) && Util.Evaluate.isEqual(this.reverseDirection, arg.reverseDirection) && Util.Evaluate.isEqual(this.dimension, arg.dimension) && Util.Evaluate.isEqual(this.across, arg.across) && Util.Evaluate.isEqual(this.down, arg.down) && Util.Evaluate.isEqual(this.donutHoleSize, arg.donutHoleSize) && Util.Evaluate.isEqual(this.insideSliceLabelContent, arg.insideSliceLabelContent) && Util.Evaluate.isEqual(this.insideSliceLabelPlacement, arg.insideSliceLabelPlacement) && Util.Evaluate.isEqual(this.outsideSliceLabelContent, arg.outsideSliceLabelContent) && Util.Evaluate.isEqual(this.outsideSliceLabelPlacement, arg.outsideSliceLabelPlacement) && Util.Evaluate.isEqual(this.responseLabelVisiblePolicy, arg.responseLabelVisiblePolicy) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.startAngle, arg.startAngle) && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual(this.legendModel, arg.legendModel) && Util.Evaluate.isEqual(this.subgroupLabelModel, arg.subgroupLabelModel) && Util.Evaluate.isEqual(this.otherColor, arg.otherColor) && Util.Evaluate.isEqual(this.otherSliceLabel, arg.otherSliceLabel) && Util.Evaluate.isEqual((Object)this.otherThreshold, (Object)arg.otherThreshold) && Util.Evaluate.isEqual(this.insideSliceLabelTextStyle, arg.insideSliceLabelTextStyle) && Util.Evaluate.isEqual(this.outsideSliceLabelTextStyle, arg.outsideSliceLabelTextStyle) && Util.Evaluate.isEqual(this.donutHoleLabel, arg.donutHoleLabel) && Util.Evaluate.isEqual(this.donutHoleLabelTextStyle, arg.donutHoleLabelTextStyle) && Util.Evaluate.isEqual(this.responseLabelTextStyle, arg.responseLabelTextStyle) && Util.Evaluate.isEqual(this.explodedCategories, arg.explodedCategories) && Util.Evaluate.isEqual(this.invisibleCategories, arg.invisibleCategories) && Util.Evaluate.isEqual(this.skin, arg.skin) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

