/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.piechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.piechart.UnitInfo;
import com.sas.measures.Measure;
import com.sas.measures.RB;
import com.sas.text.Message;

@SASScope(value="ALL")
public class OtherThreshold
extends Measure {
    private static final int PERCENT = 0;
    private static final int SLICES = 1;
    private static final UnitInfo[] UnitInfo = new UnitInfo[]{new UnitInfo("percent", 0, 1.0, "percent"), new UnitInfo("slices", 1, 1.0, "slices")};
    private int unit_index;

    public OtherThreshold(double magnitude, String unit) {
        super(magnitude, (Object)unit);
    }

    public OtherThreshold(String text) {
        super(text);
    }

    public OtherThreshold(double pct) {
        super(pct, (Object)"percent");
    }

    public double getMagnitude(Object unit) {
        int du_index = this.parseUnit(unit);
        if (du_index == -1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"invalidUnit.ex.txt"), (Object)unit));
        }
        return this.internalGetMagnitude(UnitInfo[this.unit_index], UnitInfo[du_index], this.magnitude);
    }

    public Object getUnit() {
        return OtherThreshold.UnitInfo[this.unit_index].name;
    }

    public String getUnitName() {
        return OtherThreshold.UnitInfo[this.unit_index].longName;
    }

    protected void initializeUnit(Object unit) {
        this.unit_index = this.parseUnit(unit);
        if (this.unit_index == -1) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource((String)"invalidUnit.ex.txt"), (Object)unit));
        }
    }

    public boolean validateUnit(String unit) {
        return this.parseUnit(unit) != -1;
    }

    private int parseUnit(Object unit) {
        int index;
        for (index = 0; index < UnitInfo.length; ++index) {
            if (!OtherThreshold.UnitInfo[index].name.equals(unit)) continue;
            return index;
        }
        for (index = 0; index < UnitInfo.length; ++index) {
            if (!OtherThreshold.UnitInfo[index].longName.equals(unit)) continue;
            return index;
        }
        return -1;
    }

    private double internalGetMagnitude(UnitInfo srcInfo, UnitInfo dstInfo, double magnitude) {
        return magnitude * (dstInfo.normf / srcInfo.normf);
    }
}

