/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pathanalysischart;

import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.pathanalysischart.CompositeTableDataModel;
import com.sas.graphics.components.pathanalysischart.PathAnalysisChartDataModel;
import com.sas.graphics.components.pathanalysischart.PathTableDataModel;
import com.sas.graphics.components.pathanalysischart.VolumeTableDataModel;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class PathAnalysisChartTableDataModel
extends PathAnalysisChartDataModel {
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private Variable nodeVar;
    private Variable[] tipVars;
    private Variable[] auxVars;
    private Vector nodeDisplayItems = new Vector();
    private VolumeTableDataModel volumeModel;
    private PathTableDataModel pathModel;
    private CompositeTableDataModel compositeModel;
    private TableModel dataTable;
    private static final String defaultNodeColumnName = "nodeName";
    private static final TextStyle notVisible = new TextStyle();

    public static TextStyle getInvisibleTextStyle() {
        return notVisible;
    }

    public void setModel(TableModel newData) {
        TableModel oldData = this.dataTable;
        this.dataTable = newData;
        this.firePropertyChange("model", oldData, newData);
    }

    public TableModel getModel() {
        return this.dataTable;
    }

    public void createNodeDataFromVolumeData() {
        if (this.volumeModel == null || this.volumeModel.getModel() == null) {
            throw new IllegalArgumentException(PathAnalysisChartTableDataModel.nls("noVolumeData"));
        }
        String colName = defaultNodeColumnName;
        if (this.nodeVar != null && this.nodeVar.getColumnName() != null) {
            colName = this.nodeVar.getColumnName();
        } else {
            this.setNodeVariable(new Variable(colName));
        }
        TableModel volData = this.volumeModel.getModel();
        Vector<String> allNodeNames = new Vector<String>();
        Variable fromVar = this.volumeModel.getSourceNodeVariable();
        Variable toVar = this.volumeModel.getDestinationNodeVariable();
        int fromCol = PathAnalysisChartTableDataModel.findColumnIndex(fromVar, volData);
        int toCol = PathAnalysisChartTableDataModel.findColumnIndex(toVar, volData);
        for (int i = 0; i < volData.getRowCount(); ++i) {
            String name = (String)volData.getValueAt(i, fromCol);
            if (!allNodeNames.contains(name)) {
                allNodeNames.add(name);
            }
            if (allNodeNames.contains(name = (String)volData.getValueAt(i, toCol))) continue;
            allNodeNames.add(name);
        }
        allNodeNames.remove("_OUTSIDE_");
        DefaultTableModel t = new DefaultTableModel();
        t.addColumn((Object)colName, allNodeNames);
        this.setModel(t);
    }

    public void setVolumeTableDataModel(VolumeTableDataModel newModel) {
        VolumeTableDataModel oldModel = this.volumeModel;
        this.volumeModel = newModel;
        this.firePropertyChange("volumeTableDataModel", oldModel, newModel);
    }

    public VolumeTableDataModel getVolumeTableDataModel() {
        return this.volumeModel;
    }

    public void setPathTableDataModel(PathTableDataModel newModel) {
        PathTableDataModel oldModel = this.pathModel;
        this.pathModel = newModel;
        this.firePropertyChange("pathTableDataModel", oldModel, newModel);
    }

    public PathTableDataModel getPathTableDataModel() {
        return this.pathModel;
    }

    public void setCompositeTableDataModel(CompositeTableDataModel newModel) {
        CompositeTableDataModel oldModel = this.compositeModel;
        this.compositeModel = newModel;
        this.firePropertyChange("compositeTableDataModel", oldModel, newModel);
    }

    public CompositeTableDataModel getCompositeTableDataModel() {
        return this.compositeModel;
    }

    public void setNodeVariable(Variable newVar) {
        PathAnalysisChartTableDataModel._validateVariable(newVar, null);
        Variable oldVar = this.nodeVar;
        this.nodeVar = newVar;
        this.firePropertyChange("nodeVariable", oldVar, newVar);
        this.nodeDisplayItems.add(new NodeDisplayItem(newVar, 11302, 11308, 11304, -1, notVisible, null));
    }

    public Variable getNodeVariable() {
        return this.nodeVar;
    }

    public void setDataTipVariable(Variable[] newVars) {
        if (newVars != null && newVars.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] oldVars = this.tipVars;
        this.tipVars = newVars;
        this.firePropertyChange("dataTipVariable", oldVars, newVars);
    }

    public Variable[] getDataTipVariable() {
        return this.tipVars;
    }

    public void setAuxilliaryVariable(Variable[] newVars) {
        if (newVars != null && newVars.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] oldVars = this.auxVars;
        this.auxVars = newVars;
        this.firePropertyChange("auxilliaryVariables", oldVars, newVars);
    }

    public Variable[] getAuxilliaryVariable() {
        return this.auxVars;
    }

    public NodeDisplayItem addNodeLabelVariable(Variable newVar, int location1, int location2, int location3, int row, TextStyle labelStyle, TextStyle dataStyle) {
        PathAnalysisChartTableDataModel._validateVariable(newVar, null);
        NodeDisplayItem m = new NodeDisplayItem(newVar, location1, location2, location3, row, labelStyle, dataStyle);
        this.nodeDisplayItems.add(m);
        this.firePropertyChange("nodeLabelVariable", null, newVar);
        return m;
    }

    public void removeNodeLabelVariable(Variable oldVar) {
        PathAnalysisChartTableDataModel._validateVariable(oldVar, null);
        int removed = 0;
        for (int i = 0; i < this.nodeDisplayItems.size(); ++i) {
            NodeDisplayItem ni = (NodeDisplayItem)this.nodeDisplayItems.get(i);
            Variable v = ni.getVariable();
            if (!v.equals(oldVar)) continue;
            this.nodeDisplayItems.remove(i);
            ++removed;
        }
        if (removed > 0) {
            this.firePropertyChange("NodeLabelVariable", oldVar, null);
        }
    }

    public Vector getNodeLabelDisplayInfo(Variable var) {
        PathAnalysisChartTableDataModel._validateVariable(var, null);
        Vector<NodeDisplayItem> vec = new Vector<NodeDisplayItem>();
        for (int i = 0; i < this.nodeDisplayItems.size(); ++i) {
            NodeDisplayItem ni = (NodeDisplayItem)this.nodeDisplayItems.get(i);
            if (!var.equals(ni.getVariable())) continue;
            vec.add(ni);
        }
        return vec;
    }

    public Vector getNodeLabelDisplayInfo(int p1, int p2, int p3, int row) {
        Vector<NodeDisplayItem> items = new Vector<NodeDisplayItem>();
        int nrows = -1;
        if (row < 0 && row != Integer.MIN_VALUE) {
            nrows = this.getNodeLabelDisplayAreaRowCount(p1, p2);
            row = nrows + row;
        }
        for (int i = 0; i < this.nodeDisplayItems.size(); ++i) {
            NodeDisplayItem ni = (NodeDisplayItem)this.nodeDisplayItems.get(i);
            int[] location = ni.getLocation();
            if (p1 != Integer.MIN_VALUE && p1 != location[0] || p2 != Integer.MIN_VALUE && p2 != location[1] || p3 != Integer.MIN_VALUE && p3 != location[2]) continue;
            int ni_row = location[3];
            if (row != Integer.MIN_VALUE && row != ni_row && ni_row < 0 && ni_row != Integer.MIN_VALUE) {
                if (nrows < 0) {
                    nrows = this.getNodeLabelDisplayAreaRowCount(p1, p2);
                }
                ni_row = nrows + ni_row;
            }
            if (row != Integer.MIN_VALUE && row != ni_row) continue;
            items.add(ni);
        }
        return items;
    }

    private int getNodeLabelDisplayAreaRowCount(int p1, int p2) {
        int maxRow = -1;
        for (int i = 0; i < this.nodeDisplayItems.size(); ++i) {
            NodeDisplayItem ni = (NodeDisplayItem)this.nodeDisplayItems.get(i);
            int[] location = ni.getLocation();
            if (p1 != Integer.MIN_VALUE && p1 != location[0] || p2 != Integer.MIN_VALUE && p2 != location[1]) continue;
            int loc3 = location[3];
            if (loc3 < 0) {
                loc3 = -loc3 - 1;
            }
            if (loc3 <= maxRow) continue;
            maxRow = loc3;
        }
        return maxRow + 1;
    }

    private static int findColumnIndex(Variable var, TableModel tm) {
        if (var == null) {
            return -1;
        }
        int colnum = var.getColumnIndex();
        return colnum != -1 ? colnum : PathAnalysisChartTableDataModel.findColumnIndex(var.getColumnName(), tm);
    }

    private static int findColumnIndex(String colname, TableModel tm) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            if (!tm.getColumnName(i).equals(colname)) continue;
            return i;
        }
        return -1;
    }

    private static void _validateVariable(Variable var, String msg) throws IllegalArgumentException {
        if (msg == null) {
            msg = PathAnalysisChartTableDataModel.nls("nonNullVars");
        }
        PathAnalysisChartTableDataModel._validateNonNull(var, msg);
    }

    private static void _validateNonNull(Object obj, String msg) throws IllegalArgumentException {
        if (msg == null) {
            msg = RB.getStringResource("nullInvalid.ex.txt");
        }
        if (obj == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    private static String nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    static {
        notVisible.setVisible(false);
    }

    public class NodeDisplayItem {
        private Variable var;
        private TextStyle labelStyle;
        private TextStyle dataStyle;
        private int[] loc;

        NodeDisplayItem(Variable v, int loc1, int loc2, int loc3, int row, TextStyle ls, TextStyle ds) {
            if (loc1 != 11301 && loc1 != 11302 || loc2 != 11308 && loc2 != 11307 || loc3 != 11304 && loc3 != 11305 && loc3 != 11306) {
                throw new IllegalArgumentException(PathAnalysisChartTableDataModel.nls("badLocation"));
            }
            this.var = v;
            this.loc = new int[]{loc1, loc2, loc3, row};
            this.labelStyle = ls;
            this.dataStyle = ds;
        }

        public Variable getVariable() {
            return this.var;
        }

        public TextStyle getLabelStyle() {
            return this.labelStyle;
        }

        public TextStyle getDataStyle() {
            return this.dataStyle;
        }

        public int[] getLocation() {
            return this.loc;
        }
    }
}

