/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.pathanalysischart;

import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.util.cell.pathanalysischart.PathAnalysisChartCell;
import com.sas.text.Message;
import java.util.Vector;

public class PathAnalysisChartModel
extends GraphModel {
    private static final String PAC_RB_KEY = "PathAnalysisChart.";
    private static final String PAC_RB_EXT = ".txt";
    private boolean showingTables = true;
    private String typeLabel;
    private Vector typeNames = new Vector();
    private Vector expandedComposites = new Vector();
    private TextStyle nodeTextStyle;

    public void setShowingTables(boolean newShow) {
        boolean oldShow = this.showingTables;
        this.showingTables = newShow;
        this.firePropertyChange("showingTables", oldShow, newShow);
    }

    public boolean isShowingTables() {
        return this.showingTables;
    }

    public void setExpandedComposites(String[] newNames) {
        Vector oldV = this.expandedComposites;
        Vector<String> newV = new Vector<String>();
        for (int i = 0; i < newNames.length; ++i) {
            newV.add(newNames[i]);
        }
        if (!oldV.equals(newV)) {
            this.expandedComposites = newV;
            this.firePropertyChange("expandedComposites", oldV, newV);
        }
    }

    public String[] getExpandedComposites() {
        return this.expandedComposites.toArray(PathAnalysisChartCell.STRING_ARRAY);
    }

    public void expandComposite(String newName) {
        if (this.expandedComposites.contains(newName)) {
            return;
        }
        this.expandedComposites.add(newName);
        this.firePropertyChange("expandedComposite", null, newName);
    }

    public void collapseComposite(String oldName) {
        if (!this.expandedComposites.contains(oldName)) {
            return;
        }
        this.expandedComposites.remove(oldName);
        this.firePropertyChange("expandedComposite", oldName, null);
    }

    public void setTypeLabel(String newLabel) {
        String oldLabel = this.typeLabel;
        this.typeLabel = newLabel;
        this.firePropertyChange("typeLabel", oldLabel, newLabel);
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public void setNodeTextStyle(TextStyle newTextStyle) {
        if (newTextStyle.equals(this.nodeTextStyle)) {
            return;
        }
        TextStyle oldTextStyle = this.nodeTextStyle;
        this.nodeTextStyle = newTextStyle;
        this.firePropertyChange("nodeTextStyle", oldTextStyle, newTextStyle);
    }

    public TextStyle getNodeTextStyle() {
        return this.nodeTextStyle;
    }

    public void setTypeNames(String[] newNames) {
        Vector oldV = this.typeNames;
        Vector<String> newV = new Vector<String>();
        for (int i = 0; i < newNames.length; ++i) {
            newV.add(newNames[i]);
        }
        if (!oldV.equals(newV)) {
            this.typeNames = newV;
            this.firePropertyChange("typeNameList", oldV, newV);
        }
    }

    public void addTypeName(String newName) {
        if (this.typeNames.contains(newName)) {
            throw new IllegalArgumentException(PathAnalysisChartModel.nls("typeExists", newName));
        }
        Vector oldV = (Vector)this.typeNames.clone();
        Vector newV = this.typeNames;
        newV.add(newName);
        this.firePropertyChange("typeNameList", oldV, newV);
    }

    public void removeTypeName(String oldName) {
        if (!this.typeNames.contains(oldName)) {
            throw new IllegalArgumentException(PathAnalysisChartModel.nls("typeMissing", oldName));
        }
        Vector oldV = (Vector)this.typeNames.clone();
        Vector newV = this.typeNames;
        newV.remove(oldName);
        this.firePropertyChange("typeNameList", oldV, newV);
    }

    public boolean containsTypeName(String name) {
        return this.typeNames.contains(name);
    }

    public int getTypeNameCount() {
        return this.typeNames.size();
    }

    public String getTypeName(int n) {
        if (n < 0 || n >= this.typeNames.size()) {
            throw new IllegalArgumentException(PathAnalysisChartModel.nls("typeListBadIndex", "" + this.typeNames.size(), "" + n));
        }
        return (String)this.typeNames.get(n);
    }

    public String[] getTypeNames() {
        return this.typeNames.toArray(PathAnalysisChartCell.STRING_ARRAY);
    }

    private static String nls(String key) {
        return RB.getStringResource(PAC_RB_KEY, key + PAC_RB_EXT);
    }

    private static String nls(String key, String p0) {
        return Message.format((String)PathAnalysisChartModel.nls(key), (Object)p0);
    }

    private static String nls(String key, String p0, String p1) {
        return Message.format((String)PathAnalysisChartModel.nls(key), (Object)p0, (Object)p1);
    }
}

