/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.mapchart;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.mapchart.MapChartDataModel;
import com.sas.graphics.components.mapchart.RB;
import com.sas.graphics.components.mapchart.SpatialDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class MapChartTableDataModel
extends MapChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean statisticEnabled = true;
    private ClassificationVariable IDVariable;
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private AnalysisVariable colorVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void apply(MapChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(MapChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.statisticEnabled = theOtherModel.statisticEnabled;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.colorVariable = theOtherModel.colorVariable;
        this.IDVariable = theOtherModel.IDVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public MapChartTableDataModel() {
    }

    public MapChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public MapChartTableDataModel(TableModel newModel, SpatialDataModel spatialDataModel) {
        this(newModel);
        this.setSpatialDataModel(spatialDataModel);
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setStatisticEnabled(boolean newStatisticEnabled) {
        boolean oldValue = this.statisticEnabled;
        this.statisticEnabled = newStatisticEnabled;
        this.firePropertyChange("statisticEnabled", oldValue, newStatisticEnabled);
    }

    public boolean isStatisticEnabled() {
        return this.statisticEnabled;
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public ClassificationVariable getIdentificationVariable() {
        return this.IDVariable;
    }

    public void setIdentificationVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.IDVariable;
        this.IDVariable = newVariable;
        newVariable = this.getIdentificationVariable();
        this.firePropertyChange("IDVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getColorVariable() {
        return this.colorVariable;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.columnVariable;
        this.columnVariable = newVariable;
        newVariable = this.getColumnVariable();
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.rowVariable;
        this.rowVariable = newVariable;
        newVariable = this.getRowVariable();
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public void setColorVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.colorVariable;
        this.colorVariable = newVariable;
        newVariable = this.getColorVariable();
        this.firePropertyChange("colorVariable", oldVariable, newVariable);
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MapChartTableDataModel arg = (MapChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.statisticEnabled, arg.statisticEnabled) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.IDVariable, arg.IDVariable) && Util.Evaluate.isEqual(this.colorVariable, arg.colorVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

