/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.mapchart;

import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphMatrixAxisModel;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.mapchart.RB;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

public class MapChartModel
extends GraphModel {
    private GraphMatrixAxisModel rowAxisModel = new GraphMatrixAxisModel();
    private GraphMatrixAxisModel columnAxisModel = new GraphMatrixAxisModel();
    private LegendModel legendModel = new LegendModel();
    private int dimension = 10100;
    private int across = 0;
    private int down = 0;
    private int missingPolicy = 10200;
    private int emptyPolicy = 10202;
    private FillStyle emptyFillStyle = new FillStyle(Color.LIGHT_GRAY);
    private LineStyle emptyOutlineStyle = new LineStyle();
    private int categorizationType = 10200;
    private int categorizationNum = 0;

    public void apply(MapChartModel theOtherModel) {
        if (theOtherModel == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherModel);
        this.dimension = theOtherModel.dimension;
        this.across = theOtherModel.across;
        this.down = theOtherModel.down;
        this.missingPolicy = theOtherModel.missingPolicy;
        this.emptyPolicy = theOtherModel.emptyPolicy;
        this.categorizationType = theOtherModel.categorizationType;
        this.categorizationNum = theOtherModel.categorizationNum;
        this.rowAxisModel.apply(theOtherModel.rowAxisModel);
        this.columnAxisModel.apply(theOtherModel.columnAxisModel);
        this.legendModel.apply(theOtherModel.legendModel);
        this.emptyFillStyle.apply(theOtherModel.emptyFillStyle);
        this.emptyOutlineStyle.apply(theOtherModel.emptyOutlineStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setRowAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.rowAxisModel;
        this.rowAxisModel = newAxis;
        this.firePropertyChange("rowAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getRowAxisModel() {
        return this.rowAxisModel;
    }

    public void setColumnAxisModel(GraphMatrixAxisModel newAxis) throws IllegalArgumentException {
        if (newAxis == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        GraphMatrixAxisModel oldValue = this.columnAxisModel;
        this.columnAxisModel = newAxis;
        this.firePropertyChange("columnAxisModel", oldValue, newAxis);
    }

    public GraphMatrixAxisModel getColumnAxisModel() {
        return this.columnAxisModel;
    }

    public MapChartModel() {
        this.emptyFillStyle.setVisible(false);
        this.setContainedModel("rowAxisModel", this.rowAxisModel);
        this.setContainedModel("columnAxisModel", this.columnAxisModel);
        this.setContainedModel("emptyFillStyle", this.emptyFillStyle);
        this.setContainedModel("emptyOutlineStyle", this.emptyOutlineStyle);
        this.setContainedModel("LegendModel", this.legendModel);
    }

    public void setLegendModel(LegendModel newModel) throws IllegalArgumentException {
        if (newModel == null) {
            throw new IllegalArgumentException();
        }
        LegendModel oldValue = this.legendModel;
        this.legendModel = newModel;
        this.firePropertyChange("legendModel", oldValue, newModel);
    }

    public LegendModel getLegendModel() {
        return this.legendModel;
    }

    public void setEmptyFillStyle(FillStyle newFillStyle) {
        FillStyle oldFillStyle = this.emptyFillStyle;
        this.emptyFillStyle = newFillStyle;
        this.firePropertyChange("emptyFillStyle", oldFillStyle, newFillStyle);
    }

    public FillStyle getEmptyFillStyle() {
        return this.emptyFillStyle;
    }

    public LineStyle getEmptyOutlineLineStyle() {
        return this.emptyOutlineStyle;
    }

    public void setEmptyOutlineLineStyle(LineStyle emptyOutlineStyle) {
        LineStyle oldStyle = this.emptyOutlineStyle;
        this.emptyOutlineStyle = emptyOutlineStyle;
        this.firePropertyChange("emptyOutlineStyle", oldStyle, emptyOutlineStyle);
    }

    public void setAcross(int newAcross) {
        int oldAcross = this.across;
        this.across = newAcross;
        this.firePropertyChange("across", oldAcross, newAcross);
    }

    public int getAcross() {
        return this.across;
    }

    public void setDown(int newDown) {
        int oldDown = this.down;
        this.down = newDown;
        this.firePropertyChange("down", oldDown, newDown);
    }

    public int getDown() {
        return this.down;
    }

    public void setMissingPolicy(int newMissingPolicy) {
        GraphConstants.TRI.validate(newMissingPolicy);
        int oldValue = this.missingPolicy;
        this.missingPolicy = newMissingPolicy;
        this.firePropertyChange("missingPolicy", oldValue, this.missingPolicy);
    }

    public int getMissingPolicy() {
        return this.missingPolicy;
    }

    public void setEmptyPolicy(int newEmptyPolicy) {
        GraphConstants.TRI.validate(newEmptyPolicy);
        int oldValue = this.emptyPolicy;
        this.emptyPolicy = newEmptyPolicy;
        this.firePropertyChange("emptyPolicy", oldValue, this.emptyPolicy);
    }

    public int getEmptyPolicy() {
        return this.emptyPolicy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MapChartModel arg = (MapChartModel)obj;
        return this.dimension == arg.dimension && this.across == arg.across && this.down == arg.down && this.missingPolicy == arg.missingPolicy && this.emptyPolicy == arg.emptyPolicy && Util.Evaluate.isEqual(this.rowAxisModel, arg.rowAxisModel) && Util.Evaluate.isEqual(this.columnAxisModel, arg.columnAxisModel) && Util.Evaluate.isEqual(this.legendModel, arg.legendModel) && Util.Evaluate.isEqual(this.emptyFillStyle, arg.emptyFillStyle) && Util.Evaluate.isEqual(this.emptyOutlineStyle, arg.emptyOutlineStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

