/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.kpichart;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.kpichart.KPIChartDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class KPIChartTableDataModel
extends KPIChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private ClassificationVariable columnVariable;
    private ClassificationVariable rowVariable;
    private AnalysisVariable actualVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void apply(KPIChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(KPIChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.actualVariable = theOtherModel.actualVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public KPIChartTableDataModel() {
    }

    public KPIChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, this.model);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.columnVariable;
        this.columnVariable = newVariable;
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.rowVariable;
        this.rowVariable = newVariable;
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setActualVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.actualVariable;
        this.actualVariable = newVariable;
        this.firePropertyChange("actualVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getActualVariable() {
        return this.actualVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        KPIChartTableDataModel arg = (KPIChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.actualVariable, arg.actualVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

