/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.kpichart;

import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.SegmentedRangeModel;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

public class KPIChartSegmentedRangeColorModel
extends ModelBase {
    SegmentedRangeModel segmentedRangeModel;
    Color[] segmentColors;
    Color[] activeSegmentColors;

    public KPIChartSegmentedRangeColorModel(SegmentedRangeModel segmentedRangeModel, Color[] segmentColors, Color[] activeSegmentColors) {
        if (segmentedRangeModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (segmentColors == null) {
            int numColors = segmentedRangeModel.getSegmentedRange().length - 1;
            Color neutralColor = new Color(178, 178, 178);
            Color redColor = new Color(208, 105, 89);
            Color orangeColor = new Color(225, 160, 93);
            Color yellowColor = new Color(241, 220, 99);
            Color yellowGreenColor = new Color(189, 205, 95);
            Color greenColor = new Color(132, 175, 91);
            segmentColors = new Color[numColors];
            if (numColors == 2) {
                segmentColors = new Color[]{redColor, greenColor};
            } else if (numColors == 3) {
                segmentColors = new Color[]{redColor, yellowColor, greenColor};
            } else if (numColors == 4) {
                segmentColors = new Color[]{redColor, orangeColor, yellowGreenColor, greenColor};
            } else if (numColors == 5) {
                segmentColors = new Color[]{redColor, orangeColor, yellowColor, yellowGreenColor, greenColor};
            } else {
                for (int i = 0; i < numColors; ++i) {
                    segmentColors[i] = neutralColor;
                }
            }
        }
        for (int i = 0; i < segmentColors.length; ++i) {
            if (segmentColors[i] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        this.segmentedRangeModel = segmentedRangeModel;
        this.setContainedModel("segmentedRangeModel", segmentedRangeModel);
        this.segmentColors = Util.Copier.copyOf(segmentColors);
        if (activeSegmentColors != null && this.segmentColors.length == activeSegmentColors.length) {
            this.activeSegmentColors = Util.Copier.copyOf(activeSegmentColors);
        }
    }

    public KPIChartSegmentedRangeColorModel(SegmentedRangeModel segmentedRangeModel, Color[] segmentColors) throws IllegalArgumentException {
        this(segmentedRangeModel, segmentColors, null);
    }

    public KPIChartSegmentedRangeColorModel(SegmentedRangeModel segmentedRangeModel) {
        this(segmentedRangeModel, null, null);
    }

    public void setActiveSegmentColors(Color[] activeSegmentColors) {
        Color[] oldActiveSegmentColors = this.activeSegmentColors;
        this.activeSegmentColors = Util.Copier.copyOf(activeSegmentColors);
        this.firePropertyChange("activeSegmentColors", oldActiveSegmentColors, this.activeSegmentColors);
    }

    public Color[] getActiveSegmentColors() {
        return Util.Copier.copyOf(this.activeSegmentColors);
    }

    public void setSegmentColors(Color[] segmentColors) {
        if (segmentColors == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        for (int i = 0; i < segmentColors.length; ++i) {
            if (segmentColors[i] != null) continue;
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        Color[] oldSegmentColors = this.segmentColors;
        this.segmentColors = Util.Copier.copyOf(segmentColors);
        this.firePropertyChange("segmentColors", oldSegmentColors, this.segmentColors);
    }

    public Color[] getSegmentColors() {
        return Util.Copier.copyOf(this.segmentColors);
    }

    public void setSegmentedRangeModel(SegmentedRangeModel segmentedRangeModel) {
        if (segmentedRangeModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        SegmentedRangeModel oldSegmentedRangeModel = this.segmentedRangeModel;
        this.segmentedRangeModel = segmentedRangeModel;
        this.firePropertyChange("segmentedRangeModel", oldSegmentedRangeModel, this.segmentedRangeModel);
    }

    public SegmentedRangeModel getSegmentedRangeModel() {
        return this.segmentedRangeModel;
    }

    public void apply(KPIChartSegmentedRangeColorModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.segmentedRangeModel.apply(theOtherObject.segmentedRangeModel);
        this.enablePropertyChange();
        this.segmentColors = theOtherObject.getSegmentColors();
        this.activeSegmentColors = theOtherObject.getActiveSegmentColors();
        this.firePropertyChange("", null, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        KPIChartSegmentedRangeColorModel arg = (KPIChartSegmentedRangeColorModel)obj;
        return Util.Evaluate.isEqual(this.segmentedRangeModel, arg.segmentedRangeModel) && Util.Evaluate.isEqual(this.segmentColors, arg.segmentColors) && Util.Evaluate.isEqual(this.activeSegmentColors, arg.activeSegmentColors) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

