/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.ganttchart;

import com.sas.MissingValues;
import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.CompoundTimeAxisModel;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.ProbeEvent;
import com.sas.graphics.components.ProbeListener;
import com.sas.graphics.components.TableAxisColumn;
import com.sas.graphics.components.TableAxisModel;
import com.sas.graphics.components.TableAxisZone;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.TimeLength;
import com.sas.graphics.components.TreeIconModel;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.VariableList;
import com.sas.graphics.components.ganttchart.GanttChartAnnotationTableDataModel;
import com.sas.graphics.components.ganttchart.GanttChartDataModel;
import com.sas.graphics.components.ganttchart.GanttChartModel;
import com.sas.graphics.components.ganttchart.GanttChartTableDataModel;
import com.sas.graphics.components.ganttchart.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.PrintSupport;
import com.sas.graphics.util.cell.CompoundTimeAxisCell;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.LegendCell;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.ganttchart.GanttChartCell;
import com.sas.graphics.util.cell.ganttchart.GanttChartMatrix;
import com.sas.graphics.util.cell.ganttchart.GanttChartMatrixModel;
import com.sas.graphics.util.cell.ganttchart.GanttTableDataModel;
import com.sas.graphics.util.cell.ganttchart.GanttTableModel;
import com.sas.graphics.util.cell.ganttchart.GanttTreeTable;
import com.sas.measures.MeasureInterface;
import com.sas.swing.visuals.treetable.TreeTableHeader;
import com.sas.swing.visuals.treetable.TreeTableModel;
import com.sas.swing.visuals.treetable.TreeTableRow;
import com.sas.text.SASFormat;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;

@SASScope(value="ALL")
public class GanttChart
extends Graph {
    public static final String RB_KEY = "GanttChart.";
    private transient GanttChartModel ganttChartModel;
    private transient GanttChartDataModel dataModel;
    private transient GanttChartMatrix matrix;
    private transient GanttChartMatrixModel matrixModel;
    private transient HashMap rowDataHashMap = new HashMap();
    private transient HashMap taskTreeTableRowHashMap = new HashMap();
    private transient TableModel localTableModel = null;
    private static final int _DATEAXIS_TYPE_UNKNOWN_ = 10000;
    private static final int _DATEAXIS_TYPE_SASTIME_ = 10100;
    private static final int _DATEAXIS_TYPE_SASDATE_ = 10200;
    private static final int _DATEAXIS_TYPE_SASDATETIME_ = 10300;
    private transient int dateAxisType = 10000;
    private static final String TASK_VAR = "TaskVariable";
    private static final String DESCRIPTION_VAR = "DescriptionVariable";
    private static final String SUCC_VAR = "SuccessorVariable";
    private static final String EARLY_START_VAR = "earlyStartVariable";
    private static final String EARLY_FINISH_VAR = "earlyFinishVariable";
    private static final String LATE_START_VAR = "lateStartVariable";
    private static final String LATE_FINISH_VAR = "lateFinishVariable";
    private static final String RESOURCE_START_VAR = "resourceStartVariable";
    private static final String RESOURCE_FINISH_VAR = "resourceFinishVariable";
    private static final String ACTUAL_START_VAR = "actualStartVariable";
    private static final String ACTUAL_FINISH_VAR = "actualFinishVariable";
    private static final String CUSTOM1_START_VAR = "custom1StartVariable";
    private static final String CUSTOM1_FINISH_VAR = "custom1FinishVariable";
    private static final String CUSTOM2_START_VAR = "custom2StartVariable";
    private static final String CUSTOM2_FINISH_VAR = "custom2FinishVariable";
    private static final String BASELINE_START_VAR = "baselineStartVariable";
    private static final String BASELINE_FINISH_VAR = "baselineFinishVariable";
    private static final String DURATION_VAR = "durationVariable";
    private static final String TARGET_VAR = "targetVariable";
    private static final String COLOR_VAR = "colorVariable";
    private static final String PARENT_VAR = "parentVariable";
    private static final String SUPPLEMENTARY_VAR = "supplementaryVariable";
    private static final String DATA_TIP_VAR = "datatipVariable";
    private static final String AUXILIARY_VAR = "auxiliaryVariable";
    private static final String SELECTION_VAR = "selectionVariable";
    private static final String CALENDAR_VAR = "calendarVariable";
    private static final String MARKER_TASK_VAR = "markerTaskVariable";
    private static final String MARKER_LOCATION_VAR = "markerLocationVariable";
    private static final String MARKER_POSITION_VAR = "markerPositionVariable";
    private static final String MARKER_SYMBOL_VAR = "markerSymbolVariable";
    private static final String MARKER_TEXT_VAR = "markerTextVariable";
    private static final String MARKER_SYMBOLCOLOR_VAR = "markerSymbolColorVariable";
    private static final String MARKER_TEXTCOLOR_VAR = "markerTextColorVariable";
    private static final String MARKER_TEXTJUSTIFICATION_VAR = "markerTextJustificationVariable";
    private static final String REPLACE_WITH_CHILDREN_VAR = "replaceWithChildrenVariable";
    private static final String STYLE_BY_VAR = "styleByVariable";
    private static final String DRAW_BAR_VAR = "drawBarVariable";
    private static final String ANNO_TASK_VAR = "annoTaskVariable";
    private static final String ANNO_LOCATION_VAR = "annoLocationVariable";
    private static final String ANNO_POSITION_VAR = "annoPositionVariable";
    private static final String ANNO_SYMBOL_VAR = "annoSymbolVariable";
    private static final String ANNO_TEXT_VAR = "annoTextVariable";
    private static final String ANNO_SYMBOLCOLOR_VAR = "annoSymbolColorVariable";
    private static final String ANNO_TEXTCOLOR_VAR = "annoTextColorVariable";
    private static final String ANNO_TEXTJUSTIFICATION_VAR = "annoTextJustificationVariable";
    private static final String BREAKTIME_START_VAR = "breakTimeStartVariable";
    private static final String BREAKTIME_FINISH_VAR = "breakTimeFinishVariable";
    private static final String BREAKTIME_CALENDAR_VAR = "breakTimeCalendarVariable";
    private static final String BREAKTIME_DURATION_VAR = "breakTimeDurationVariable";
    private int dataTipVarsCount = 0;
    private int auxiliaryVarsCount = 0;
    private ArrayList columnOrder;
    private String[] columnNames = null;
    private DataSource dataSource = null;
    private ArrayList tableVariableList;
    private int levels = 0;
    private int parentIdx = -1;
    private int taskIdx = -1;
    private boolean treeHierarchyEnabledMemo = true;
    private TableAxisZone[] zonesMemo = null;
    private TableAxisColumn[] columnsMemo = null;
    private TableModelListener tableChangePropagation;
    private TableModel currentAnnoModel = null;
    private MyProbeListener myProbeListener = null;
    private TimeLength preferredVisibleTimeLengthMemo = null;
    private PrintSupport printModel;
    private boolean bgImageBrowseOptionToBeDisabled = false;
    private boolean logoImageBrowseOptionToBeDisabled = false;
    int count = 0;
    private GanttTableDataModel internalTableDataModel;
    boolean messagePrinted = false;
    private ActionListener linkListeners;
    private ActionListener linkListenerTunnel = new ActionListenerTunnel();
    boolean useAlternatePrintDialog = false;

    public GanttChart() {
        this(null, null);
    }

    public GanttChart(GanttChartDataModel newGanttChartDataModel) {
        this(newGanttChartDataModel, null);
    }

    public GanttChart(GanttChartDataModel newGanttChartDataModel, GraphStyle newGraphStyle) {
        this.matrixModel = new GanttChartMatrixModel();
        this.matrixModel.setTaskRole(TASK_VAR);
        this.matrixModel.setDescriptionRole(DESCRIPTION_VAR);
        this.matrixModel.setSuccessorRole(SUCC_VAR);
        this.matrixModel.setEarlyStartRole(EARLY_START_VAR);
        this.matrixModel.setEarlyFinishRole(EARLY_FINISH_VAR);
        this.matrixModel.setLateStartRole(LATE_START_VAR);
        this.matrixModel.setLateFinishRole(LATE_FINISH_VAR);
        this.matrixModel.setResourceStartRole(RESOURCE_START_VAR);
        this.matrixModel.setResourceFinishRole(RESOURCE_FINISH_VAR);
        this.matrixModel.setActualStartRole(ACTUAL_START_VAR);
        this.matrixModel.setActualFinishRole(ACTUAL_FINISH_VAR);
        this.matrixModel.setCustom1StartRole(CUSTOM1_START_VAR);
        this.matrixModel.setCustom1FinishRole(CUSTOM1_FINISH_VAR);
        this.matrixModel.setCustom2StartRole(CUSTOM2_START_VAR);
        this.matrixModel.setCustom2FinishRole(CUSTOM2_FINISH_VAR);
        this.matrixModel.setBaselineStartRole(BASELINE_START_VAR);
        this.matrixModel.setBaselineFinishRole(BASELINE_FINISH_VAR);
        this.matrixModel.setDurationRole(DURATION_VAR);
        this.matrixModel.setTargetRole(TARGET_VAR);
        this.matrixModel.setColorRole(COLOR_VAR);
        this.matrixModel.setParentRole(PARENT_VAR);
        this.matrixModel.setDataTipRole(DATA_TIP_VAR);
        this.matrixModel.setAuxiliaryRole(AUXILIARY_VAR);
        this.matrixModel.setSelectionRole(SELECTION_VAR);
        this.matrixModel.setMarkerTaskRole(MARKER_TASK_VAR);
        this.matrixModel.setMarkerLocationRole(MARKER_LOCATION_VAR);
        this.matrixModel.setMarkerPositionRole(MARKER_POSITION_VAR);
        this.matrixModel.setMarkerSymbolRole(MARKER_SYMBOL_VAR);
        this.matrixModel.setMarkerTextRole(MARKER_TEXT_VAR);
        this.matrixModel.setMarkerSymbolColorRole(MARKER_SYMBOLCOLOR_VAR);
        this.matrixModel.setMarkerTextColorRole(MARKER_TEXTCOLOR_VAR);
        this.matrixModel.setMarkerTextJustificationRole(MARKER_TEXTJUSTIFICATION_VAR);
        this.matrixModel.setReplaceWithChildrenRole(REPLACE_WITH_CHILDREN_VAR);
        this.matrixModel.setStyleByRole(STYLE_BY_VAR);
        this.matrixModel.setDrawBarRole(DRAW_BAR_VAR);
        this.matrixModel.setCalendarRole(CALENDAR_VAR);
        this.matrixModel.setAnnoTaskRole(ANNO_TASK_VAR);
        this.matrixModel.setAnnoLocationRole(ANNO_LOCATION_VAR);
        this.matrixModel.setAnnoPositionRole(ANNO_POSITION_VAR);
        this.matrixModel.setAnnoSymbolRole(ANNO_SYMBOL_VAR);
        this.matrixModel.setAnnoTextRole(ANNO_TEXT_VAR);
        this.matrixModel.setAnnoSymbolColorRole(ANNO_SYMBOLCOLOR_VAR);
        this.matrixModel.setAnnoTextColorRole(ANNO_TEXTCOLOR_VAR);
        this.matrixModel.setAnnoTextJustificationRole(ANNO_TEXTJUSTIFICATION_VAR);
        this.matrixModel.setBreaktimeStartRole(BREAKTIME_START_VAR);
        this.matrixModel.setBreaktimeFinishRole(BREAKTIME_FINISH_VAR);
        this.matrixModel.setBreaktimeCalendarRole(BREAKTIME_CALENDAR_VAR);
        this.matrixModel.setBreaktimeDurationRole(BREAKTIME_DURATION_VAR);
        this.matrixModel.setMouseEventListenerRecasterFactory(new Util.Events.MouseEventListenerRecasterFactory(this));
        this.matrix = new GanttChartMatrix(this.getChannel());
        this.matrix.setModel(this.matrixModel);
        this.setGraphModel(new GanttChartModel());
        this.applyGraphStyle(newGraphStyle);
        if (this.designTime) {
            String informat;
            String format = informat = "DATE7.";
            DataSource designDataSource = new DataSource(new TableModelVariableFactory(new SampleGanttChartTableModel(), Util.getLocale(this), 10475), true, false);
            designDataSource.setVariableDefinition(TASK_VAR, VariableDefinition.Factory.newVariableDefinition(new Variable("Id")));
            designDataSource.setVariableDefinition(EARLY_START_VAR, VariableDefinition.Factory.newVariableDefinition(new Variable("EarlyStart", format, informat, "Early Start")));
            designDataSource.setVariableDefinition(EARLY_FINISH_VAR, VariableDefinition.Factory.newVariableDefinition(new Variable("EarlyFinish", format, informat, "Early Finish")));
            designDataSource.setVariableDefinition(LATE_START_VAR, VariableDefinition.Factory.newVariableDefinition(new Variable("LateStart", format, informat, "Late Start")));
            designDataSource.setVariableDefinition(LATE_FINISH_VAR, VariableDefinition.Factory.newVariableDefinition(new Variable("LateFinish", format, informat, "Late Finish")));
            designDataSource.setVariableDefinition(SUCC_VAR, VariableDefinition.Factory.newVariableDefinition(new VariableList(new String[]{"SUCC1", "SUCC2", "SUCC3"})));
            this.matrix.setDataSource(designDataSource);
        }
        if (newGanttChartDataModel != null) {
            this.setDataModel(newGanttChartDataModel);
        }
        this.setGraph(this.matrix);
        this.tableChangePropagation = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                GanttChart.this._updateDataModel(e);
            }
        };
    }

    public Collection getTreeExpansionState() {
        return this.matrix.getTreeExpansionState();
    }

    public void setTreeExpansionState(Collection expansionState) {
        if (expansionState != null) {
            this.matrix.setTreeExpansionState(expansionState);
        }
    }

    public void setSortEnabled(boolean sortEnable) {
        this.matrix.setSortEnable(sortEnable);
    }

    public boolean isSortEnabled() {
        return this.matrix.isSortEnabled();
    }

    public String[] getLegendCategoryValues() {
        return this.matrix.getLegendCategoryValues();
    }

    public Color[] getLegendCategoryColors() {
        return this.matrix.getLegendCategoryColors();
    }

    public void setRowSelectionColor(Color newColor) {
        this.matrix.setRowSelectionColor(newColor);
    }

    public Color getRowSelectionColor() {
        return this.matrix.getRowSelectionColor();
    }

    public void setRowSelectionFont(Font newFont) {
        this.matrix.setRowSelectionFont(newFont);
    }

    public void setFontForegroundColor(Color newFontColor) {
        this.matrix.setFontForegroundColor(newFontColor);
    }

    public void setGraphModel(GanttChartModel newGanttChartModel) throws IllegalArgumentException {
        super.setGraphModel(newGanttChartModel);
        GanttChartModel oldGanttChartModel = this.ganttChartModel;
        this.ganttChartModel = newGanttChartModel;
        this.matrixModel.setGanttChartModel(this.ganttChartModel);
        this.firePropertyChange("graphModel", oldGanttChartModel, this.ganttChartModel);
    }

    public GanttChartModel getGraphModel() {
        return this.ganttChartModel;
    }

    public void setDataModel(GanttChartDataModel newDataModel) {
        GanttChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public GanttChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        switch (newDisplayPolicy) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "unsupportedDisplayPolicy.txt"));
            }
            case 10001: 
            case 10002: 
            case 10200: 
        }
        super.setDisplayPolicy(newDisplayPolicy);
    }

    @Override
    public int getDisplayPolicy() {
        return super.getDisplayPolicy();
    }

    @Override
    protected void applyGraphModel() {
        int ii;
        ModelBase[] current;
        super.applyGraphModel();
        boolean rereadData = false;
        if (this.treeHierarchyEnabledMemo != this.ganttChartModel.getTableAxisModel().getHierarchyModel().isEnabled()) {
            rereadData = true;
        }
        if (!rereadData && this.columnsMemo != null && this.ganttChartModel.getTableAxisModel().getColumns() != null) {
            if (this.columnsMemo.length != this.ganttChartModel.getTableAxisModel().getColumns().length) {
                rereadData = true;
            } else {
                current = this.ganttChartModel.getTableAxisModel().getColumns();
                for (ii = 0; ii < this.columnsMemo.length && !rereadData; ++ii) {
                    if (this.columnsMemo[ii].getVariable() != null && ((TableAxisColumn)current[ii]).getVariable() != null && !this.columnsMemo[ii].getVariable().equals(((TableAxisColumn)current[ii]).getVariable())) {
                        rereadData = true;
                        continue;
                    }
                    if (this.columnsMemo[ii].getSort() != ((TableAxisColumn)current[ii]).getSort()) {
                        rereadData = true;
                        continue;
                    }
                    if (this.columnsMemo[ii].getSortIndex() != ((TableAxisColumn)current[ii]).getSortIndex()) {
                        rereadData = true;
                        continue;
                    }
                    if (!this.columnsMemo[ii].getWidth().equals((MeasureInterface)((TableAxisColumn)current[ii]).getWidth())) {
                        rereadData = true;
                        continue;
                    }
                    if (this.columnsMemo[ii].isVisible() == ((TableAxisColumn)current[ii]).isVisible()) continue;
                    rereadData = true;
                }
            }
        }
        if (!rereadData && this.zonesMemo != null && this.ganttChartModel.getTableAxisModel().getZones() != null) {
            if (this.zonesMemo.length != this.ganttChartModel.getTableAxisModel().getZones().length) {
                rereadData = true;
            } else {
                current = this.ganttChartModel.getTableAxisModel().getZones();
                for (ii = 0; ii < this.zonesMemo.length && !rereadData; ++ii) {
                    if (current[ii] == null && this.zonesMemo[ii] != null || current[ii] != null && this.zonesMemo[ii] == null) {
                        rereadData = true;
                    }
                    if (current[ii] == null || this.zonesMemo[ii] == null) continue;
                    if (this.zonesMemo[ii].getVariable() != null && ((TableAxisZone)current[ii]).getVariable() != null && !this.zonesMemo[ii].getVariable().equals(((TableAxisZone)current[ii]).getVariable())) {
                        rereadData = true;
                        continue;
                    }
                    if (this.zonesMemo[ii].getTreeLevel() == ((TableAxisZone)current[ii]).getTreeLevel()) continue;
                    rereadData = true;
                }
            }
        } else if (this.zonesMemo == null && this.ganttChartModel.getTableAxisModel().getZones() != null || this.zonesMemo != null && this.ganttChartModel.getTableAxisModel().getZones() == null) {
            rereadData = true;
        }
        if (!this.designTime && this.matrix.getDataSource() != null && rereadData) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        if (this.dataModel instanceof GanttChartTableDataModel) {
            Locale formatLocale = Util.getFormatLocale(this, this.dataModel);
            int sortStrategy = this.dataModel.getSortStrategy();
            GanttChartTableDataModel tableDataModel = (GanttChartTableDataModel)this.dataModel;
            TableModel tableModel = tableDataModel.getModel();
            if (tableModel != null && tableModel.getColumnCount() > 0) {
                if (this.internalTableDataModel == null) {
                    this.internalTableDataModel = new GanttTableDataModel();
                } else {
                    this.internalTableDataModel.reset();
                }
                this.internalTableDataModel.apply(tableDataModel);
                DataSource annoDataSource = null;
                if (tableDataModel.getAnnotationTableDataModel() != null && tableDataModel.getAnnotationTableDataModel().getModel() != null) {
                    annoDataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getAnnotationTableDataModel().getModel(), formatLocale, sortStrategy), false, false);
                    this.matrix.setAnnoDataSource(annoDataSource);
                }
                DataSource breaktimeDataSource = null;
                if (tableDataModel.getBreakTimeTableDataModel() != null && tableDataModel.getBreakTimeTableDataModel().getModel() != null) {
                    breaktimeDataSource = new DataSource(new TableModelVariableFactory(tableDataModel.getBreakTimeTableDataModel().getModel(), formatLocale, sortStrategy), false, false);
                    this.matrix.setBreaktimeDataSource(breaktimeDataSource);
                }
                TableAxisColumn[] columns = this.ganttChartModel.getTableAxisModel().getColumns();
                Variable[] suppVars = null;
                if (columns != null && columns.length > 0) {
                    this.columnOrder = new ArrayList();
                    ArrayList<Variable> supplementaryVars = new ArrayList<Variable>();
                    Variable var = null;
                    for (int ii = 0; ii < columns.length; ++ii) {
                        var = columns[ii].getVariable();
                        if (this._isDefined(var, this.internalTableDataModel, annoDataSource) || var.getColumnName() == null && var.getColumnIndex() < 0) continue;
                        supplementaryVars.add(var);
                    }
                    if (supplementaryVars.size() > 0) {
                        suppVars = supplementaryVars.toArray(new Variable[0]);
                        this.internalTableDataModel.setSupplementaryVariable(new VariableList(suppVars));
                    }
                }
                this.dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, sortStrategy), false, false);
                this._addVariables(this.dataSource, annoDataSource, breaktimeDataSource, this.internalTableDataModel);
                this.columnOrder = this._createColumnOrder();
                com.sas.graphics.util.gtk.Variable taskVd = this.dataSource.getVariable(TASK_VAR, 0);
                com.sas.graphics.util.gtk.Variable esVd = this.dataSource.getVariable(EARLY_START_VAR, 0);
                com.sas.graphics.util.gtk.Variable[] succVd = this.dataSource.getVariable(SUCC_VAR);
                if (taskVd == null) {
                    return;
                }
                if (esVd == null) {
                    return;
                }
                ArrayList succVars = new ArrayList();
                this.matrix.setDataSource(this.dataSource);
                this.matrix.setTableDataModel(this.internalTableDataModel);
                tableModel = this._asGanttTableModel(taskVd, esVd, succVd, this.columnOrder, succVars, suppVars);
                if (succVars.size() > 1) {
                    String[] succColNames = new String[succVars.size()];
                    for (int ii = 0; ii < succVars.size(); ++ii) {
                        succColNames[ii] = new String((String)succVars.get(ii));
                    }
                    this.internalTableDataModel.setModel(tableModel);
                    this.internalTableDataModel.setSuccessorVariable(new VariableList(succColNames));
                }
                this.dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, sortStrategy), false, false);
                this._addVariables(this.dataSource, annoDataSource, breaktimeDataSource, this.internalTableDataModel);
                this.matrix.setDataSource(this.dataSource);
                taskVd = this.dataSource.getVariable(TASK_VAR, 0);
                if (taskVd == null) {
                    return;
                }
                this.levels = 0;
                com.sas.graphics.util.gtk.Variable parentVd = this.dataSource.getVariable(PARENT_VAR, 0);
                if (parentVd != null && taskVd != null) {
                    TableAxisModel tam = null;
                    if (this.ganttChartModel != null) {
                        tam = this.ganttChartModel.getTableAxisModel();
                    }
                    TreeTableRow root = null;
                    this.columnNames = this._getColumnNames(tableModel, parentVd, taskVd);
                    if (this.parentIdx != -1 && this.taskIdx != -1) {
                        String rootText = null;
                        rootText = tam != null && tableDataModel.getRoot() != null ? tableDataModel.getRoot() : new String("Project Summary");
                        root = this._constructTreeTableData(tableModel, this.parentIdx, this.taskIdx, rootText, this.ganttChartModel.getTableAxisModel());
                    }
                    if (root != null) {
                        Object[] rowData;
                        if (tam != null && tableDataModel.getRoot() == null && (rowData = root.getTableRow()) != null && rowData.length > this.taskIdx) {
                            String rootTaskName = (String)rowData[this.taskIdx];
                            tableDataModel.setRoot(rootTaskName);
                        }
                        tableModel = new TreeTableModel(root, this.columnNames);
                        this.levels = root.getDepth() + 1;
                        this.dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, sortStrategy), false, false);
                        this._addVariables(this.dataSource, annoDataSource, breaktimeDataSource, this.internalTableDataModel);
                        this.matrix.setDataSource(this.dataSource);
                        taskVd = this.dataSource.getVariable(TASK_VAR, 0);
                        if (taskVd == null) {
                            return;
                        }
                    }
                }
                tableModel.addTableModelListener(this.tableChangePropagation);
                this.treeHierarchyEnabledMemo = this.ganttChartModel.getTableAxisModel().getHierarchyModel().isEnabled();
                if (this.ganttChartModel.getTableAxisModel().getColumns() != null && this.ganttChartModel.getTableAxisModel().getColumns().length > 0) {
                    TableAxisColumn[] cols = this.ganttChartModel.getTableAxisModel().getColumns();
                    this.columnsMemo = new TableAxisColumn[cols.length];
                    for (int ii = 0; ii < cols.length; ++ii) {
                        this.columnsMemo[ii] = new TableAxisColumn(new Variable(cols[ii].getVariable()));
                        this.columnsMemo[ii].apply(cols[ii]);
                    }
                }
                this.zonesMemo = this.ganttChartModel.getTableAxisModel().getZones();
                if (this.ganttChartModel.getTableAxisModel().getZones() != null && this.ganttChartModel.getTableAxisModel().getZones().length > 0) {
                    TableAxisZone[] zones = this.ganttChartModel.getTableAxisModel().getZones();
                    this.zonesMemo = new TableAxisZone[zones.length];
                    for (int ii = 0; ii < zones.length; ++ii) {
                        if (zones[ii] != null) {
                            if (zones[ii].getTreeLevel() > 0) {
                                this.zonesMemo[ii] = new TableAxisZone(zones[ii].getTreeLevel());
                                continue;
                            }
                            this.zonesMemo[ii] = new TableAxisZone(new Variable(zones[ii].getVariable()));
                            continue;
                        }
                        this.zonesMemo[ii] = null;
                    }
                }
            }
        } else {
            this.matrix.setDataSource(null);
            this.internalTableDataModel = null;
        }
    }

    public int convertRowIndexToModel(int viewRowIndex) {
        int internalRow = viewRowIndex;
        if (internalRow < 0) {
            return -1;
        }
        TableModel internalModel = (TableModel)this.dataSource.getModel();
        int internalLastCol = internalModel.getColumnCount() - 1;
        if (internalRow > internalModel.getRowCount() - 1) {
            return -1;
        }
        Integer ii = (Integer)internalModel.getValueAt(internalRow, internalLastCol);
        int externalRow = ii;
        return externalRow;
    }

    public int convertRowIndexToView(int modelRowIndex) {
        int externalRow = modelRowIndex;
        TableModel internalModel = (TableModel)this.dataSource.getModel();
        int internalLastCol = internalModel.getColumnCount() - 1;
        for (int internalRow = 0; internalRow < internalModel.getRowCount(); ++internalRow) {
            Integer ii = (Integer)internalModel.getValueAt(internalRow, internalLastCol);
            if (externalRow != ii) continue;
            return internalRow;
        }
        return -1;
    }

    private TableModel _asGanttTableModel(com.sas.graphics.util.gtk.Variable taskVar, com.sas.graphics.util.gtk.Variable esVar, com.sas.graphics.util.gtk.Variable[] succVar, ArrayList roleOrder, ArrayList succAdd, Variable[] suppVar) {
        ArrayList<com.sas.graphics.util.gtk.Variable> gtkVariableArrayList = new ArrayList<com.sas.graphics.util.gtk.Variable>();
        this.matrix.clearComponentVariableArrayList();
        com.sas.graphics.util.gtk.Variable[] var = null;
        int succIdx = -1;
        int varIdx = -1;
        for (int ii = 0; ii < roleOrder.size(); ++ii) {
            if (roleOrder.get(ii) == null || (var = this.dataSource.getVariable(roleOrder.get(ii))) == null) continue;
            for (int jj = 0; jj < var.length; ++jj) {
                gtkVariableArrayList.add(var[jj]);
                if (roleOrder.get(ii).toString().compareTo(SUPPLEMENTARY_VAR) == 0 && suppVar != null && suppVar.length > jj) {
                    this.matrix.addToComponentVariableArrayList(roleOrder.get(ii), suppVar[jj]);
                } else {
                    this.matrix.addToComponentVariableArrayList(roleOrder.get(ii), null);
                }
                if (succVar == null || succVar.length != 1) continue;
                ++varIdx;
                if (roleOrder.get(ii).toString().compareTo(SUCC_VAR) != 0) continue;
                succIdx = varIdx;
            }
        }
        this.tableVariableList = gtkVariableArrayList;
        return new GanttTableModel(gtkVariableArrayList, taskVar, esVar, succVar, succIdx, succAdd);
    }

    void _updateDataModel() {
        this._updateDataModel(null);
    }

    void _updateDataModel(TableModelEvent e) {
        TreeIconModel tim;
        if (e == null || e.getType() != 0) {
            return;
        }
        int internalR = e.getFirstRow();
        int internalC = e.getColumn();
        if (internalC < 0) {
            return;
        }
        TableAxisModel tam = this.ganttChartModel.getTableAxisModel();
        TableModel internalModel = (TableModel)this.dataSource.getModel();
        int internalTaskIdx = this.taskIdx;
        int internalParentIdx = this.parentIdx;
        Object newValue = internalModel.getValueAt(internalR, internalC);
        if (this._isMissing(newValue)) {
            newValue = MissingValues.Dot;
        }
        int internalLastCol = internalModel.getColumnCount() - 1;
        Integer ii = (Integer)internalModel.getValueAt(internalR, internalLastCol);
        int externalR = ii;
        com.sas.graphics.util.gtk.Variable cv = (com.sas.graphics.util.gtk.Variable)this.tableVariableList.get(internalC);
        String colName = cv.getColumnName();
        GanttChartTableDataModel gctdm = (GanttChartTableDataModel)this.dataModel;
        TableModel externalModel = gctdm.getModel();
        int externalC = -1;
        for (int j = 0; j < externalModel.getColumnCount(); ++j) {
            String nj = externalModel.getColumnName(j);
            if (!nj.equals(colName)) continue;
            externalC = j;
            break;
        }
        if (externalC == -1) {
            Thread.dumpStack();
            return;
        }
        int externalParentIdx = -1;
        int externalTaskIdx = -1;
        if (internalC == internalTaskIdx || internalC == internalParentIdx) {
            cv = (com.sas.graphics.util.gtk.Variable)this.tableVariableList.get(internalParentIdx);
            String parentColName = cv.getColumnName();
            cv = (com.sas.graphics.util.gtk.Variable)this.tableVariableList.get(internalTaskIdx);
            String taskColName = cv.getColumnName();
            int j1 = externalModel.getColumnCount();
            for (int j = 0; j < j1 && (externalParentIdx == -1 || externalTaskIdx == -1); ++j) {
                String nj = externalModel.getColumnName(j);
                if (nj.equals(parentColName)) {
                    externalParentIdx = j;
                }
                if (!nj.equals(taskColName)) continue;
                externalTaskIdx = j;
            }
        }
        Object oldValue = externalModel.getValueAt(externalR, externalC);
        cv = (com.sas.graphics.util.gtk.Variable)this.tableVariableList.get(internalC);
        if (oldValue instanceof String && newValue instanceof Double && cv != null && cv.getFormatter() != null) {
            newValue = cv.getFormatter().format(newValue);
        }
        if (this._isMissing(oldValue) && this._isMissing(newValue)) {
            return;
        }
        if (oldValue.equals(newValue)) {
            return;
        }
        if (internalC == internalTaskIdx && this.blank(newValue)) {
            internalModel.setValueAt(oldValue, internalR, internalC);
            return;
        }
        if (internalC == internalParentIdx && this.blank(oldValue) != this.blank(newValue)) {
            internalModel.setValueAt(oldValue, internalR, internalC);
            return;
        }
        if (internalC == internalParentIdx && externalTaskIdx != -1) {
            boolean found = false;
            int i1 = externalModel.getRowCount();
            for (int i = 0; i < i1; ++i) {
                if (!externalModel.getValueAt(i, externalTaskIdx).equals(newValue)) continue;
                found = true;
                break;
            }
            if (!found) {
                internalModel.setValueAt(oldValue, internalR, internalC);
                return;
            }
        }
        if (internalC == internalTaskIdx && externalTaskIdx != -1) {
            int i1 = externalModel.getRowCount();
            for (int i = 0; i < i1; ++i) {
                if (!externalModel.getValueAt(i, externalTaskIdx).equals(newValue)) continue;
                internalModel.setValueAt(oldValue, internalR, internalC);
                return;
            }
        }
        externalModel.setValueAt(newValue, externalR, externalC);
        if (internalC == internalTaskIdx && gctdm.getRoot().equals(oldValue)) {
            gctdm.setRoot((String)newValue);
        }
        if (internalC == internalTaskIdx && (tim = tam.getHierarchyModel().getTreeIconModel(oldValue)) != null) {
            TreeIconModel newTim = new TreeIconModel(tim.getOpenIcon(), tim.getClosedIcon(), tim.getLeafIcon());
            tam.getHierarchyModel().putTreeIconModel(newValue, newTim);
            tam.getHierarchyModel().removeTreeIconModel(oldValue);
        }
        if (internalC == internalTaskIdx) {
            int i1 = externalModel.getRowCount();
            for (int i = 0; i < i1; ++i) {
                if (!externalModel.getValueAt(i, externalTaskIdx).equals(oldValue)) continue;
                externalModel.setValueAt(newValue, i, externalTaskIdx);
            }
        }
        if (internalC == internalTaskIdx && externalParentIdx != -1) {
            int i1 = externalModel.getRowCount();
            for (int i = 0; i < i1; ++i) {
                if (!externalModel.getValueAt(i, externalParentIdx).equals(oldValue)) continue;
                externalModel.setValueAt(newValue, i, externalParentIdx);
            }
        }
    }

    private boolean blank(Object x) {
        return x == null || x.toString().trim().length() == 0;
    }

    private boolean _isMissing(Object x) {
        return x == null || x instanceof Double && ((Double)x).isNaN() || x instanceof Float && ((Float)x).isNaN() || x instanceof MissingValues;
    }

    public void setHandCursorEnabled(boolean hand) {
        if (hand) {
            this.myProbeListener = new MyProbeListener();
            this.addProbeListener(this.myProbeListener);
        } else if (this.myProbeListener != null) {
            this.removeProbeListener(this.myProbeListener);
        }
    }

    private boolean _isDefined(Variable var, GanttTableDataModel tdm, DataSource annoDataSource) {
        if (var == tdm.getTaskVariable()) {
            return true;
        }
        if (var == tdm.getActualFinishVariable()) {
            return true;
        }
        if (var == tdm.getActualStartVariable()) {
            return true;
        }
        if (var == tdm.getBaselineFinishVariable()) {
            return true;
        }
        if (var == tdm.getBaselineStartVariable()) {
            return true;
        }
        if (var == tdm.getColorVariable()) {
            return true;
        }
        if (var == tdm.getDescriptionVariable()) {
            return true;
        }
        if (var == tdm.getDurationVariable()) {
            return true;
        }
        if (var == tdm.getEarlyFinishVariable()) {
            return true;
        }
        if (var == tdm.getEarlyStartVariable()) {
            return true;
        }
        if (var == tdm.getLateFinishVariable()) {
            return true;
        }
        if (var == tdm.getLateStartVariable()) {
            return true;
        }
        if (var == tdm.getParentVariable()) {
            return true;
        }
        if (var == tdm.getResourceFinishVariable()) {
            return true;
        }
        if (var == tdm.getResourceStartVariable()) {
            return true;
        }
        if (var == tdm.getCustom1StartVariable()) {
            return true;
        }
        if (var == tdm.getCustom1FinshVariable()) {
            return true;
        }
        if (var == tdm.getCustom2StartVariable()) {
            return true;
        }
        if (var == tdm.getCustom2FinshVariable()) {
            return true;
        }
        if (var == tdm.getTargetVariable()) {
            return true;
        }
        if (var == tdm.getSuccessorVariable()) {
            return true;
        }
        if (var == tdm.getReplaceWithChildrenVariable()) {
            return true;
        }
        if (var == tdm.getStyleByVariable()) {
            return true;
        }
        if (var == tdm.getDrawBarVariable()) {
            return true;
        }
        if (var == tdm.getCalendarVariable()) {
            return true;
        }
        if (tdm.getAnnotationTableDataModel() != null) {
            GanttChartAnnotationTableDataModel atdm = tdm.getAnnotationTableDataModel();
            if (annoDataSource == null) {
                if (var == atdm.getLabelColorVariable()) {
                    return true;
                }
                if (var == atdm.getLabelVariable()) {
                    return true;
                }
                if (var == atdm.getLocationVariable()) {
                    return true;
                }
                if (var == atdm.getPositionVariable()) {
                    return true;
                }
                if (var == atdm.getSymbolColorVariable()) {
                    return true;
                }
                if (var == atdm.getSymbolVariable()) {
                    return true;
                }
                if (var == atdm.getTaskVariable()) {
                    return true;
                }
            } else {
                if (atdm.getTaskVariable() != null && (var == atdm.getTaskVariable() || var.getColumnName().equalsIgnoreCase(atdm.getTaskVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getLocationVariable() != null && (var == atdm.getLocationVariable() || var.getColumnName().equalsIgnoreCase(atdm.getLocationVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getPositionVariable() != null && (var == atdm.getPositionVariable() || var.getColumnName().equalsIgnoreCase(atdm.getPositionVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getSymbolVariable() != null && (var == atdm.getSymbolVariable() || var.getColumnName().equalsIgnoreCase(atdm.getSymbolVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getLabelVariable() != null && (var == atdm.getLabelVariable() || var.getColumnName().equalsIgnoreCase(atdm.getLabelVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getSymbolColorVariable() != null && (var == atdm.getSymbolColorVariable() || var.getColumnName().equalsIgnoreCase(atdm.getSymbolColorVariable().getColumnName()))) {
                    return true;
                }
                if (atdm.getLabelColorVariable() != null && (var == atdm.getLabelColorVariable() || var.getColumnName().equalsIgnoreCase(atdm.getLabelColorVariable().getColumnName()))) {
                    return true;
                }
            }
        }
        return false;
    }

    private void _addVariables(DataSource ganttDataSource, DataSource annoDataSource, DataSource breaktimeDataSource, GanttTableDataModel tableDataModel) {
        Variable[] auxiliaryVars;
        Variable[] dataTipVars;
        Locale locale = Util.getLocale(this);
        boolean missingDataColumnMessageEnabled = !this.ganttChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
        Util.setVariableDefinition(ganttDataSource, EARLY_START_VAR, "earlyStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getEarlyStartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, EARLY_FINISH_VAR, "earlyFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getEarlyFinishVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, LATE_START_VAR, "lateStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getLateStartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, LATE_FINISH_VAR, "lateFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getLateFinishVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, RESOURCE_START_VAR, "resourceStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResourceStartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, RESOURCE_FINISH_VAR, "resourceFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getResourceFinishVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, ACTUAL_START_VAR, "actualStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getActualStartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, ACTUAL_FINISH_VAR, "actualFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getActualFinishVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, CUSTOM1_START_VAR, "custom1StartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCustom1StartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, CUSTOM1_FINISH_VAR, "custom1FinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCustom1FinshVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, CUSTOM2_START_VAR, "custom2StartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCustom2StartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, CUSTOM2_FINISH_VAR, "custom2FinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCustom2FinshVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, BASELINE_START_VAR, "baselineStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBaselineStartVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, BASELINE_FINISH_VAR, "baselineFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBaselineFinishVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, TASK_VAR, "taskRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getTaskVariable(), 4), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, DESCRIPTION_VAR, "descriptionRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDescriptionVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, DURATION_VAR, "durationRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDurationVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, TARGET_VAR, "targetRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getTargetVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, SUCC_VAR, "succRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSuccessorVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, COLOR_VAR, "colorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColorVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, PARENT_VAR, "parentRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getParentVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, SUPPLEMENTARY_VAR, null, null, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSupplementaryVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, REPLACE_WITH_CHILDREN_VAR, "replaceWithChildrenRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getReplaceWithChildrenVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, DRAW_BAR_VAR, "drawBarRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDrawBarVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, CALENDAR_VAR, "calendarRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCalendarVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, STYLE_BY_VAR, "styleByRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getStyleByVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_TASK_VAR, "markerTaskRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTaskVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_LOCATION_VAR, "markerLocationRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationLocationVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_POSITION_VAR, "markerPositionRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationPositionVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_SYMBOL_VAR, "markerSymbolRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationSymbolVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_TEXT_VAR, "markerTextRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationLabelVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_SYMBOLCOLOR_VAR, "markerSymbolColorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationSymbolColorVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_TEXTCOLOR_VAR, "markerTextColorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationLabelColorVariable()), missingDataColumnMessageEnabled);
        Util.setVariableDefinition(ganttDataSource, MARKER_TEXTJUSTIFICATION_VAR, "markerTextJustRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationLabelJustificationVariable()), missingDataColumnMessageEnabled);
        if (tableDataModel.getSelectionModel() != null) {
            ganttDataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
            SelectionVariableDefinition selectionVariableDefinition = new SelectionVariableDefinition(tableDataModel.getSelectionModel(), null, 0);
            Util.setVariableDefinition(ganttDataSource, SELECTION_VAR, null, null, selectionVariableDefinition, missingDataColumnMessageEnabled);
        }
        if ((dataTipVars = tableDataModel.getDataTipVariables()) != null && dataTipVars.length > 0) {
            this.dataTipVarsCount = 0;
            for (int ii = 0; ii < dataTipVars.length; ++ii) {
                if (dataTipVars[ii] == null) continue;
                Util.setVariableDefinition(ganttDataSource, DATA_TIP_VAR + this.dataTipVarsCount++, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(dataTipVars[ii]), missingDataColumnMessageEnabled);
            }
        }
        if ((auxiliaryVars = tableDataModel.getAuxiliaryVariables()) != null && auxiliaryVars.length > 0) {
            this.auxiliaryVarsCount = 0;
            for (int ii = 0; ii < auxiliaryVars.length; ++ii) {
                if (auxiliaryVars[ii] == null) continue;
                Util.setVariableDefinition(ganttDataSource, AUXILIARY_VAR + this.auxiliaryVarsCount++, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(auxiliaryVars[ii]), missingDataColumnMessageEnabled);
            }
        }
        if (annoDataSource != null && tableDataModel.getAnnotationTableDataModel() != null) {
            Util.setVariableDefinition(annoDataSource, ANNO_TASK_VAR, "annoTaskRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getTaskVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_LOCATION_VAR, "annoLocationRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getLocationVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_POSITION_VAR, "annoPositionRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getPositionVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_SYMBOL_VAR, "annoSymbolRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getSymbolVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_TEXT_VAR, "annoTextRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getLabelVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_SYMBOLCOLOR_VAR, "annoSymbolColorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getSymbolColorVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_TEXTCOLOR_VAR, "annoTextColorRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getLabelColorVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(annoDataSource, ANNO_TEXTJUSTIFICATION_VAR, "annoTextJustRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAnnotationTableDataModel().getLabelJustificationVariable()), missingDataColumnMessageEnabled);
        }
        if (breaktimeDataSource != null && tableDataModel.getBreakTimeTableDataModel() != null) {
            Util.setVariableDefinition(breaktimeDataSource, BREAKTIME_START_VAR, "breaktimeStartRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBreakTimeTableDataModel().getStartVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(breaktimeDataSource, BREAKTIME_FINISH_VAR, "breaktimeFinishRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBreakTimeTableDataModel().getFinishVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(breaktimeDataSource, BREAKTIME_CALENDAR_VAR, "breaktimeCalendarRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBreakTimeTableDataModel().getCalendarVariable()), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(breaktimeDataSource, BREAKTIME_DURATION_VAR, "breaktimeDurationRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBreakTimeTableDataModel().getDurationVariable()), missingDataColumnMessageEnabled);
        }
    }

    private TreeTableRow _constructTreeTableData(TableModel tableModel, int parentColumnIdx, int taskColumnIdx, String rootText, TableAxisModel tam) {
        TreeTableRow rootRow = null;
        if (parentColumnIdx != -1 && taskColumnIdx != -1) {
            int ii;
            TreeTableRow taskRow = null;
            this.localTableModel = tableModel;
            int nrow = this.localTableModel.getRowCount();
            int ncol = this.localTableModel.getColumnCount();
            String parent = null;
            String task = null;
            TreeTableRow treeTableRow = null;
            this.rowDataHashMap = new HashMap();
            for (int ii2 = 0; ii2 < nrow; ++ii2) {
                Object[] rowData = new Object[ncol];
                for (int jj = 0; jj < ncol; ++jj) {
                    rowData[jj] = this.localTableModel.getValueAt(ii2, jj);
                }
                task = this._getStringValueAt(ii2, taskColumnIdx);
                if (task == null) continue;
                this.rowDataHashMap.put(task, rowData);
            }
            Class<?> parentClass = this.localTableModel.getColumnClass(parentColumnIdx);
            this.taskTreeTableRowHashMap = new HashMap();
            for (ii = 0; ii < nrow; ++ii) {
                task = this._getStringValueAt(ii, taskColumnIdx);
                parent = this._getStringValueAt(ii, parentColumnIdx);
                if (task == null || parent == null) continue;
                treeTableRow = this._createTreeTableRow(task, tam);
                if (treeTableRow != null) {
                    this.taskTreeTableRowHashMap.put(task, treeTableRow);
                }
                if (parentClass == String.class) {
                    if (parent.compareTo("") != 0 || task.compareToIgnoreCase(rootText) != 0) continue;
                    rootRow = treeTableRow;
                    continue;
                }
                if (parentClass != Double.class && parentClass != Integer.class || parent.compareTo("Dot") != 0 || task.compareToIgnoreCase(rootText) != 0) continue;
                rootRow = treeTableRow;
            }
            if (rootRow != null) {
                for (ii = 0; ii < nrow; ++ii) {
                    TreeTableRow parentRow;
                    task = this._getStringValueAt(ii, taskColumnIdx);
                    if (task == null || (taskRow = (TreeTableRow)this.taskTreeTableRowHashMap.get(task)) == null || (parentRow = (TreeTableRow)this.taskTreeTableRowHashMap.get(parent = this._getStringValueAt(ii, parentColumnIdx))) == null) continue;
                    parentRow.add((MutableTreeNode)taskRow);
                }
            }
        }
        return rootRow;
    }

    private String _getStringValueAt(int row, int idx) {
        if (this.localTableModel == null) {
            return null;
        }
        try {
            Object value = null;
            value = this.localTableModel.getValueAt(row, idx);
            if (value != null) {
                return value.toString().trim();
            }
        }
        catch (Exception ex) {
            return null;
        }
        return null;
    }

    private TreeTableRow _createTreeTableRow(String task, TableAxisModel tam) {
        TreeTableRow row = new TreeTableRow((Object[])this.rowDataHashMap.get(task));
        TreeIconModel tim = tam.getHierarchyModel().getTreeIconModel(task);
        if (tim != null) {
            Icon icon = tim.getOpenIcon();
            if (icon != null) {
                row.setOpenIcon(icon);
            }
            if ((icon = tim.getClosedIcon()) != null) {
                row.setClosedIcon(icon);
            }
            if ((icon = tim.getLeafIcon()) != null) {
                row.setLeafIcon(icon);
            }
        }
        return row;
    }

    public int getDataLevelCount() {
        return this.levels;
    }

    private String[] _getColumnNames(TableModel tableModel, com.sas.graphics.util.gtk.Variable parentVd, com.sas.graphics.util.gtk.Variable taskVd) {
        String[] names = new String[tableModel.getColumnCount()];
        boolean foundParentVar = false;
        boolean foundTaskVar = false;
        if (parentVd != null) {
            for (int ii = 0; ii < tableModel.getColumnCount(); ++ii) {
                names[ii] = tableModel.getColumnName(ii);
                if (!foundParentVar && tableModel.getColumnName(ii).compareTo(parentVd.getColumnName()) == 0) {
                    foundParentVar = true;
                    this.parentIdx = ii;
                }
                if (foundTaskVar || tableModel.getColumnName(ii).compareTo(taskVd.getColumnName()) != 0) continue;
                foundTaskVar = true;
                this.taskIdx = ii;
            }
        }
        return names;
    }

    private ArrayList _createColumnOrder() {
        String role;
        int ii;
        ArrayList<String> roleArray = new ArrayList<String>();
        roleArray.add(DESCRIPTION_VAR);
        roleArray.add(TASK_VAR);
        roleArray.add(DURATION_VAR);
        roleArray.add(EARLY_START_VAR);
        roleArray.add(EARLY_FINISH_VAR);
        roleArray.add(LATE_START_VAR);
        roleArray.add(LATE_FINISH_VAR);
        roleArray.add(BASELINE_START_VAR);
        roleArray.add(BASELINE_FINISH_VAR);
        roleArray.add(ACTUAL_START_VAR);
        roleArray.add(ACTUAL_FINISH_VAR);
        roleArray.add(CUSTOM1_START_VAR);
        roleArray.add(CUSTOM1_FINISH_VAR);
        roleArray.add(CUSTOM2_START_VAR);
        roleArray.add(CUSTOM2_FINISH_VAR);
        roleArray.add(RESOURCE_START_VAR);
        roleArray.add(RESOURCE_FINISH_VAR);
        roleArray.add(TARGET_VAR);
        roleArray.add(COLOR_VAR);
        roleArray.add(PARENT_VAR);
        roleArray.add(CALENDAR_VAR);
        roleArray.add(SUPPLEMENTARY_VAR);
        for (ii = 0; ii < this.dataTipVarsCount; ++ii) {
            role = DATA_TIP_VAR + ii;
            roleArray.add(role);
        }
        for (ii = 0; ii < this.auxiliaryVarsCount; ++ii) {
            role = AUXILIARY_VAR + ii;
            roleArray.add(role);
        }
        roleArray.add(REPLACE_WITH_CHILDREN_VAR);
        roleArray.add(STYLE_BY_VAR);
        roleArray.add(DRAW_BAR_VAR);
        roleArray.add(MARKER_TASK_VAR);
        roleArray.add(MARKER_LOCATION_VAR);
        roleArray.add(MARKER_POSITION_VAR);
        roleArray.add(MARKER_SYMBOL_VAR);
        roleArray.add(MARKER_TEXT_VAR);
        roleArray.add(MARKER_SYMBOLCOLOR_VAR);
        roleArray.add(MARKER_TEXTCOLOR_VAR);
        roleArray.add(MARKER_TEXTJUSTIFICATION_VAR);
        roleArray.add(ANNO_TASK_VAR);
        roleArray.add(ANNO_LOCATION_VAR);
        roleArray.add(ANNO_POSITION_VAR);
        roleArray.add(ANNO_SYMBOL_VAR);
        roleArray.add(ANNO_TEXT_VAR);
        roleArray.add(ANNO_SYMBOLCOLOR_VAR);
        roleArray.add(ANNO_TEXTCOLOR_VAR);
        roleArray.add(ANNO_TEXTJUSTIFICATION_VAR);
        roleArray.add(SUCC_VAR);
        return roleArray;
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        TableAxisModel tableAxisModel = this.ganttChartModel.getTableAxisModel();
        AxisWallModel axisWallModel = this.ganttChartModel.getAxisWallModel();
        CompoundTimeAxisModel compoundTimeAxisModel = this.ganttChartModel.getDateAxisModel();
        LegendModel legendModel = this.ganttChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, tableAxisModel);
        tableAxisModel.setLabelTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getValueTextStyle(), tableAxisModel.getLabelTextStyle()));
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, compoundTimeAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        this.ganttChartModel.setAnnotationLabelTextStyle(Util.Conveyer.applyTextStyle_ReplaceAsNeeded(graphStyle.getDataLabelTextStyle(), this.ganttChartModel.getAnnotationLabelTextStyle()));
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        Color headerBackgroundColor;
        if (scheme == null) {
            this.useAlternatePrintDialog = true;
        }
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.ganttChartModel.getLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.ganttChartModel.getAxisWallModel());
        GanttChart._applyColorScheme(scheme, this.ganttChartModel.getDateAxisModel());
        Color[] c = new Color[]{scheme.getWallColor()};
        this.ganttChartModel.getTableAxisModel().getValueCellStyle().setBackgroundColors(c);
        Color headerOutlineColor = scheme.getColumnRowAxisLabelCellFrameColor();
        if (headerOutlineColor == null) {
            headerOutlineColor = scheme.getFrameColor();
        }
        if (headerOutlineColor != null) {
            this.ganttChartModel.getTableAxisModel().getLabelCellStyle().getFrameLineStyle().setColor(headerOutlineColor);
            this.ganttChartModel.getTableAxisModel().getValueCellStyle().getFrameLineStyle().setColor(headerOutlineColor);
            this.ganttChartModel.getDateAxisModel().getValueCellStyle().getFrameLineStyle().setColor(headerOutlineColor);
        }
        if ((headerBackgroundColor = scheme.getRowAxisLabelCellBackgroundColor()) == null) {
            headerBackgroundColor = scheme.getLegendBackgroundColor();
        }
        if (headerBackgroundColor != null) {
            Color[] clr = new Color[]{headerBackgroundColor};
            this.ganttChartModel.getTableAxisModel().getLabelCellStyle().setBackgroundColors(clr);
            this.ganttChartModel.getDateAxisModel().getValueCellStyle().setBackgroundColors(clr);
        }
        this.ganttChartModel.getTableAxisModel().getValueTextStyle().setColor(scheme.getValueColor());
        this.ganttChartModel.getTableAxisModel().getLabelTextStyle().setColor(scheme.getValueColor());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @SASScope
    public boolean isDateAxisSASTime() {
        if (this.dateAxisType == 10000) {
            SASFormat sasFormat = this._getSASFormat();
            if (sasFormat != null && sasFormat.isTimeFormat()) {
                this.dateAxisType = 10100;
                return true;
            }
        } else if (this.dateAxisType == 10100) {
            return true;
        }
        return false;
    }

    @SASScope
    public boolean isDateAxisSASDate() {
        if (this.dateAxisType == 10000) {
            SASFormat sasFormat = this._getSASFormat();
            if (sasFormat != null && sasFormat.isDateFormat()) {
                this.dateAxisType = 10200;
                return true;
            }
        } else if (this.dateAxisType == 10200) {
            return true;
        }
        return false;
    }

    @SASScope
    public boolean isDateAxisSASDateTime() {
        if (this.dateAxisType == 10000) {
            SASFormat sasFormat = this._getSASFormat();
            if (sasFormat != null && sasFormat.isDateTimeFormat()) {
                this.dateAxisType = 10300;
                return true;
            }
        } else if (this.dateAxisType == 10300) {
            return true;
        }
        return false;
    }

    private SASFormat _getSASFormat() {
        if (this.dataSource == null) {
            return null;
        }
        com.sas.graphics.util.gtk.Variable var = null;
        var = this.dataSource.getVariable(EARLY_START_VAR, 0);
        if (var != null || (var = this.dataSource.getVariable(EARLY_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(LATE_START_VAR, 0)) != null || (var = this.dataSource.getVariable(LATE_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(RESOURCE_START_VAR, 0)) != null || (var = this.dataSource.getVariable(RESOURCE_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(ACTUAL_START_VAR, 0)) != null || (var = this.dataSource.getVariable(ACTUAL_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(CUSTOM1_START_VAR, 0)) != null || (var = this.dataSource.getVariable(CUSTOM1_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(CUSTOM2_START_VAR, 0)) != null || (var = this.dataSource.getVariable(CUSTOM2_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(BASELINE_START_VAR, 0)) != null || (var = this.dataSource.getVariable(BASELINE_FINISH_VAR, 0)) != null || (var = this.dataSource.getVariable(TARGET_VAR, 0)) != null) {
            // empty if block
        }
        if (var != null && var.getSASFormatName() != null) {
            return SASFormat.getInstance((String)var.getSASFormatName());
        }
        return null;
    }

    private static final void _applyColorScheme(ColorScheme scheme, CompoundTimeAxisModel axisModel) {
        Color bg;
        Color vc = scheme.getValueColor();
        Color sc = scheme.getShadowColor();
        Color gc = scheme.getGridLineColor();
        Color oc = scheme.getColumnRowAxisValueCellFrameColor();
        if (oc == null) {
            oc = scheme.getFrameColor();
        }
        if ((bg = scheme.getRowAxisLabelCellBackgroundColor()) == null) {
            bg = scheme.getLegendBackgroundColor();
        }
        TextStyle ts = axisModel.getTimePeriodModel1().getTextStyle();
        if (vc != null) {
            ts.setColor(vc);
        }
        if (sc != null) {
            ts.getShadowStyle().setColor(sc);
        }
        ts = axisModel.getTimePeriodModel2().getTextStyle();
        if (vc != null) {
            ts.setColor(vc);
        }
        if (sc != null) {
            ts.getShadowStyle().setColor(sc);
        }
        ts = axisModel.getTimePeriodModel3().getTextStyle();
        if (vc != null) {
            ts.setColor(vc);
        }
        if (sc != null) {
            ts.getShadowStyle().setColor(sc);
        }
        if (gc != null) {
            axisModel.getGridLineStyle().setColor(gc);
        }
        if (oc != null) {
            axisModel.getValueCellStyle().getFrameLineStyle().setColor(oc);
        }
        if (bg != null) {
            Color[] c = new Color[]{bg};
            axisModel.getValueCellStyle().setBackgroundColors(c);
        }
    }

    @Override
    protected void selectionChanged() {
        this.repaint();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        TableModel annoModel = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof GanttChartTableDataModel) {
            GanttChartTableDataModel tm = (GanttChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
            if (tm.getAnnotationTableDataModel() != null) {
                annoModel = tm.getAnnotationTableDataModel().getModel();
            }
        }
        this.updateDataModelListeners(model, selectionModel);
        this.updateAnnoModelListener(annoModel);
        if (this.matrixModel != null) {
            this.matrixModel.setDateAxisScrollModel(null);
            this.matrixModel.setTaskAxisScrollModel(null);
            this.matrixModel.setTableColumnScrollModel(null);
        }
    }

    private void updateAnnoModelListener(TableModel newAnnoModel) {
        if (this.currentAnnoModel != newAnnoModel) {
            if (this.currentAnnoModel != null) {
                this.currentAnnoModel.removeTableModelListener(this.getTableModelListener());
            }
            if (newAnnoModel != null) {
                newAnnoModel.addTableModelListener(this.getTableModelListener());
            }
            this.currentAnnoModel = newAnnoModel;
        }
    }

    @Override
    protected void doPropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        super.doPropertyChange(propertyName, oldProperty, newProperty);
        if (this.ganttChartModel != null) {
            Boolean reInitialize = Boolean.FALSE;
            CompoundTimeAxisModel ctam = this.ganttChartModel.getDateAxisModel();
            if (this.preferredVisibleTimeLengthMemo == null || !this.preferredVisibleTimeLengthMemo.equals(ctam.getPreferredVisibleTimeLength())) {
                this.preferredVisibleTimeLengthMemo = ctam.getPreferredVisibleTimeLength();
                reInitialize = Boolean.TRUE;
            }
            if (reInitialize == Boolean.TRUE) {
                this.matrixModel.setInitializeDateAxisScrollModel(Boolean.TRUE);
            }
        }
    }

    public synchronized void addLinkListener(ActionListener l) {
        this.linkListeners = AWTEventMulticaster.add(this.linkListeners, l);
    }

    public synchronized void removeLinkListener(ActionListener l) {
        this.linkListeners = AWTEventMulticaster.remove(this.linkListeners, l);
    }

    @Override
    protected void setGraph(JComponent newGraph) {
        JComponent graph = this.getGraph();
        if (newGraph != graph) {
            if (graph instanceof GanttChartMatrix) {
                ((GanttChartMatrix)graph).removeLinkListener(this.linkListenerTunnel);
            }
            super.setGraph(newGraph);
            if (newGraph instanceof GanttChartMatrix) {
                ((GanttChartMatrix)newGraph).addLinkListener(this.linkListenerTunnel);
            }
        }
    }

    public void print(PrintSupport p) {
        this.fillPrintModel(p);
        this.printModel.print();
    }

    public void print() {
        this.fillPrintModel(null);
        this.printModel.setPageNumber(1);
        this.printModel.print();
        this.printModel.setPageNumber(1);
    }

    public void setPrintSupport(PrintSupport ps) {
        this.fillPrintModel(ps);
    }

    public PrintSupport getPrintSupport() {
        this.fillPrintModel(null);
        return this.printModel;
    }

    public void printSetup() {
        this.fillPrintModel(null);
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        this.printModel.setupDialog(f);
    }

    public Window printPreview() {
        this.fillPrintModel(null);
        Frame f = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        Window w = this.printModel.previewHiddenDialog(f);
        new Thread(new WindowDisplayer(w)).start();
        while (!w.isVisible()) {
        }
        w.paint(w.getGraphics());
        return w;
    }

    private void fillPrintModel(PrintSupport ps) {
        if (this.printModel != null && ps == null) {
            Component c = this.printModel.getComponent();
            if (c instanceof Printable) {
                ((Printable)c).refresh();
            }
        } else {
            if (ps == null) {
                ps = new PrintSupport();
                ps.setMargins(36, 36, 36, 36);
                ps.setLandscapeMode();
                ps.setNumberingPages(true);
            }
            this.printModel = ps;
            if (this.useAlternatePrintDialog) {
                try {
                    this.printModel.setScale(null);
                }
                catch (NullPointerException c) {
                    // empty catch block
                }
            }
            Printable p = new Printable(this);
            this.printModel.setComponent((Component)p);
            this.printModel.setSetupDialogTab((PrintSupport.SetupDialogTabInterface)new PrintSetupTab(p));
        }
    }

    @Override
    public void paintBackground(Graphics g, Rectangle bounds, Insets insets) {
        super.paintBackground(g, bounds, insets);
    }

    private static int lim(int min, int x, int max) {
        return x < min ? min : (x > max ? max : x);
    }

    private static final double min(double a, double b) {
        return a < b ? a : b;
    }

    public void setBgImageBrowseOptionToBeDisabled(boolean b) {
        this.bgImageBrowseOptionToBeDisabled = b;
    }

    public void setLogoImageBrowseOptionToBeDisabled(boolean b) {
        this.logoImageBrowseOptionToBeDisabled = b;
    }

    public boolean isBgCheckBoxToBeDisabled() {
        return this.bgImageBrowseOptionToBeDisabled;
    }

    public boolean isLogoCheckBoxToBeDisabled() {
        return this.logoImageBrowseOptionToBeDisabled;
    }

    public boolean isBgAndLogoDropDownOptionToBeDisabled() {
        return this.bgImageBrowseOptionToBeDisabled && this.logoImageBrowseOptionToBeDisabled;
    }

    public LinkedHashMap getLegendValuesHashMap() {
        LegendModel lm = this.ganttChartModel.getLegendModel();
        return lm.getLegendValuesIndexMap();
    }

    @SASScope
    public class PrintSetupTab
    extends JPanel
    implements PrintSupport.SetupDialogTabInterface {
        public static final String RB_KEY = "PrintSetupTab.";
        JCheckBox showHeaderCbx;
        JCheckBox showTimeAxisCbx;
        JCheckBox showFooterCbx;
        JCheckBox showLegendCbx;
        Printable ganttPrintable;

        public PrintSetupTab(Printable p) {
            this.ganttPrintable = p;
            this.createTabPanel();
            this.readModel();
        }

        protected void createTabPanel() {
            this.setBorder(new EmptyBorder(15, 10, 10, 10));
            this.setLayout(new BorderLayout(5, 5));
            JPanel showHeaderPanel = new JPanel(new BorderLayout(5, 5));
            this.showHeaderCbx = new JCheckBox(RB.getStringResource(RB_KEY, "ShowHeader.txt"));
            showHeaderPanel.add((Component)this.showHeaderCbx, "West");
            showHeaderPanel.setBorder(new EmptyBorder(0, 7, 0, 7));
            JPanel showTimeAxisPanel = new JPanel(new BorderLayout(5, 5));
            this.showTimeAxisCbx = new JCheckBox(RB.getStringResource(RB_KEY, "ShowTimeAxis.txt"));
            showTimeAxisPanel.add((Component)this.showTimeAxisCbx, "West");
            showTimeAxisPanel.setBorder(new EmptyBorder(0, 7, 0, 7));
            JPanel showFooterPanel = new JPanel(new BorderLayout(5, 5));
            this.showFooterCbx = new JCheckBox(RB.getStringResource(RB_KEY, "ShowFooter.txt"));
            showFooterPanel.add((Component)this.showFooterCbx, "West");
            showFooterPanel.setBorder(new EmptyBorder(0, 7, 0, 7));
            JPanel showLegendPanel = new JPanel(new BorderLayout(5, 5));
            this.showLegendCbx = new JCheckBox(RB.getStringResource(RB_KEY, "ShowLegend.txt"));
            showLegendPanel.add((Component)this.showLegendCbx, "West");
            showLegendPanel.setBorder(new EmptyBorder(0, 7, 0, 7));
            JPanel topPanel = new JPanel(new GridLayout(0, 1, 2, 2));
            topPanel.add(showHeaderPanel);
            topPanel.add(showTimeAxisPanel);
            topPanel.add(showFooterPanel);
            topPanel.add(showLegendPanel);
            this.add((Component)topPanel, "North");
        }

        public JComponent getTabContents() {
            return this;
        }

        public String getTabName() {
            return RB.getStringResource(RB_KEY, "Display.txt");
        }

        public void readModel() {
            this.showHeaderCbx.setSelected(this.ganttPrintable.getHeaderOnEveryPage());
            this.showTimeAxisCbx.setSelected(this.ganttPrintable.getTimeAxisOnEveryPage());
            this.showFooterCbx.setSelected(this.ganttPrintable.getFooterOnEveryPage());
            this.showLegendCbx.setSelected(this.ganttPrintable.getLegendOnEveryPage());
        }

        public void writeModel() {
            this.ganttPrintable.setHeaderOnEveryPage(this.showHeaderCbx.isSelected());
            this.ganttPrintable.setTimeAxisOnEveryPage(this.showTimeAxisCbx.isSelected());
            this.ganttPrintable.setFooterOnEveryPage(this.showFooterCbx.isSelected());
            this.ganttPrintable.setLegendOnEveryPage(this.showLegendCbx.isSelected());
            this.ganttPrintable.refresh();
        }

        public void close() {
        }

        @SASScope
        class HorizontalSeparator
        extends JComponent {
            private Dimension prefSize;

            public HorizontalSeparator() {
                this.setOpaque(true);
                this.prefSize = new Dimension(1, new JLabel((String)"W").getPreferredSize().height);
            }

            @Override
            public Dimension getPreferredSize() {
                return this.prefSize;
            }

            @Override
            public void paint(Graphics g) {
                Dimension size = this.getSize();
                int width = size.width;
                int midY = size.height / 2;
                Color bgColor = this.getBackground();
                g.setColor(bgColor.brighter());
                g.drawLine(0, midY + 1, width - 1, midY + 1);
                g.setColor(bgColor.darker());
                g.drawLine(1, midY, width, midY);
            }
        }
    }

    @SASScope
    private class Printable
    extends JComponent {
        private static final int sideMargin = 0;
        private static final int vgap = 20;
        private GanttChart chart;
        private JComponent gch;
        private JComponent gc;
        private JComponent tth;
        private JComponent tt;
        private JComponent header;
        private JComponent footer;
        private JComponent legend;
        private int pw;
        private int ph;
        private int aw;
        private int ah;
        private int cw;
        private int ch;
        private int hw;
        private int hh;
        private int fw;
        private int fh;
        private int lw;
        private int lh;
        private int totalWidth;
        private int totalHeight;
        private int bgWidth;
        private int bgHeight;
        private boolean printHeaderOnEveryPage = false;
        private boolean printTimeAxisOnEveryPage = false;
        private boolean printFooterOnEveryPage = false;
        private boolean printLegendOnEveryPage = false;

        public Printable(GanttChart c) {
            this.chart = c;
            this.computeSizes(this.chart);
        }

        public void setHeaderOnEveryPage(boolean b) {
            this.printHeaderOnEveryPage = b;
        }

        public void setTimeAxisOnEveryPage(boolean b) {
            this.printTimeAxisOnEveryPage = b;
        }

        public void setFooterOnEveryPage(boolean b) {
            this.printFooterOnEveryPage = b;
        }

        public void setLegendOnEveryPage(boolean b) {
            this.printLegendOnEveryPage = b;
        }

        public boolean getHeaderOnEveryPage() {
            return this.printHeaderOnEveryPage;
        }

        public boolean getTimeAxisOnEveryPage() {
            return this.printTimeAxisOnEveryPage;
        }

        public boolean getFooterOnEveryPage() {
            return this.printFooterOnEveryPage;
        }

        public boolean getLegendOnEveryPage() {
            return this.printLegendOnEveryPage;
        }

        @Override
        public void paint(Graphics g) {
            int pnY;
            int pnX;
            this.computeSizes(this.chart);
            int[] npXY = GanttChart.this.printModel.getComputedFitToPages();
            int npX = npXY[0];
            int npY = npXY[1];
            int pn = GanttChart.this.printModel.getCurrentPrintingPageNumber() - 1;
            if (GanttChart.this.printModel.isPageOrderHorizontal()) {
                pnX = pn % npX;
                pnY = pn / npX;
            } else {
                pnX = pn / npY;
                pnY = pn % npY;
            }
            int pY0 = pnY * this.ph;
            int pX0 = pnX * this.pw;
            int pX1 = pX0 + this.pw;
            int eph = this.ph;
            if (this.printHeaderOnEveryPage) {
                eph -= this.hh;
            }
            if (this.printTimeAxisOnEveryPage) {
                eph -= this.ah;
            }
            if (this.printLegendOnEveryPage) {
                eph -= this.lh;
            }
            if (this.printFooterOnEveryPage) {
                eph -= this.fh;
            }
            PlacementContext context = new PlacementContext(pnY * eph, eph, pX0, pY0, this.pw, this.ph, this.totalWidth, this.totalHeight);
            ElementPlacement gcPl = null;
            ElementPlacement gchPl = null;
            ElementPlacement ttPl = null;
            ElementPlacement tthPl = null;
            ElementPlacement headerPl = null;
            ElementPlacement footerPl = null;
            ElementPlacement legendPl = null;
            headerPl = new ElementPlacement(context, this.header, 20, this.printHeaderOnEveryPage);
            if (this.gc == null) {
                int height = context.spaceOnPreviousPages + context.spaceOnCurrentPage - (this.printLegendOnEveryPage ? 0 : this.lh) - (this.printFooterOnEveryPage ? 0 : this.fh);
                gcPl = new ElementPlacement(context, height, false);
            } else if (this.gc.getWidth() > 0 && this.gc.getHeight() > 0) {
                gchPl = new ElementPlacement(context, this.gch, 0, this.printTimeAxisOnEveryPage);
                gcPl = new ElementPlacement(context, this.gc, 0, false);
                tthPl = new ElementPlacement(gchPl, this.tth);
                ttPl = new ElementPlacement(gcPl, this.tt);
                ttPl.x = 0;
                tthPl.x = 0;
                gchPl.x = gcPl.x = ttPl.x + ttPl.w;
                ttPl.bgx = tthPl.bgx = pX0;
                ttPl.bgw = tthPl.bgw = GanttChart.lim(0, gcPl.x - pX0, this.pw);
                gcPl.bgx = gchPl.bgx = GanttChart.lim(pX0, gcPl.x, pX1);
                gcPl.bgw = gchPl.bgw = pX1 - gcPl.bgx;
            } else {
                tthPl = new ElementPlacement(context, this.tth, 0, false);
                ttPl = new ElementPlacement(context, this.tt, 0, false);
                ttPl.x = 0;
                tthPl.x = 0;
            }
            legendPl = new ElementPlacement(context, this.legend, 20, this.printLegendOnEveryPage);
            footerPl = new ElementPlacement(context, this.footer, 20, this.printFooterOnEveryPage);
            this.paintElement("treetable_header", tthPl, g);
            this.paintElement("ganttchart_header", gchPl, g);
            boolean opt = false;
            if (this.gc != null) {
                GanttChartCell gcc = (GanttChartCell)this.gc;
                opt = gcc.isRenderingOptimized();
                gcc.setRenderingOptimized(false);
                this.paintElement("treetable", ttPl, g);
                this.paintElement("ganttchart", gcPl, g);
                gcc.setRenderingOptimized(opt);
            } else {
                this.paintElement("ganttchart filler", gcPl, g);
            }
            this.paintElement("header", headerPl, g);
            this.paintElement("legend", legendPl, g);
            this.paintElement("footer", footerPl, g);
        }

        private void paintElement(String jname, ElementPlacement ep, Graphics g) {
            if (ep == null) {
                return;
            }
            this.paintElement(jname, ep.element, g, ep.x, ep.y, ep.w, ep.h, ep.l, ep.r, ep.clipy0, ep.clipy1, ep.bgx, ep.bgy, ep.bgw, ep.bgh);
        }

        private synchronized void paintElement(String jname, JComponent j, Graphics g, int x, int y, int w, int h, int l, int r, int clipy0, int clipy1, int bgx, int bgy, int bgw, int bgh) {
            if (bgy + bgh > clipy1) {
                bgh = clipy1 - bgy;
            }
            if (bgy < clipy0) {
                int d = clipy0 - bgy;
                bgy += d;
                bgh -= d;
            }
            if (bgw > 0 && bgh > 0) {
                this.paintBackground(g, bgx, bgy, bgw, bgh);
            }
            if (h == 0 || w == 0 || y + h < clipy0 || y > clipy1 || clipy1 <= clipy0) {
                return;
            }
            Rectangle clip = g.getClipBounds();
            g.setClip(x, clipy0, l + w, clipy1 - clipy0);
            boolean db = j.isDoubleBuffered();
            j.setDoubleBuffered(false);
            g.translate(x, y);
            j.paint(g);
            g.translate(-x, -y);
            j.setDoubleBuffered(db);
            g.setClip(clip);
        }

        private void paintBackground(Graphics g, int bgx, int bgy, int bgw, int bgh) {
            if (bgw > 0 && bgh > 0) {
                Rectangle clip = g.getClipBounds();
                g.setClip(bgx, bgy, bgw, bgh);
                Rectangle bgBounds = new Rectangle(this.bgWidth, this.bgHeight);
                GanttChart.this.paintBackground(g, bgBounds, new Insets(0, 0, 0, 0));
                g.setClip(clip);
            }
        }

        public void refresh() {
            this.computeSizes(this.chart);
        }

        private void computeSizes(GanttChart c) {
            int npX;
            int prefWidth;
            this.tt = this.findSubcomponent(c, GanttTreeTable.class);
            this.tth = this.findSubcomponent(c, TreeTableHeader.class);
            this.gc = this.findSubcomponent(c, GanttChartCell.class);
            this.gch = this.findSubcomponent(c, CompoundTimeAxisCell.class);
            this.header = this.unwrapComponent(GanttChart.this.titleContainer);
            this.legend = this.unwrapComponent(this.findSubcomponent(c, LegendCell.class));
            this.footer = this.unwrapComponent(GanttChart.this.footnoteContainer);
            if (this.gc == null) {
                this.legend = null;
                this.gch = null;
                this.tth = null;
                this.tt = null;
            }
            int n = this.aw = this.tt != null ? this.tt.getWidth() : 0;
            this.ah = this.tth != null ? this.tth.getHeight() : (this.gch != null ? this.gch.getHeight() : 0);
            int n2 = this.cw = this.gc != null ? this.gc.getWidth() : 0;
            this.ch = this.tt != null ? this.tt.getHeight() : (this.gc != null ? this.gc.getHeight() : 0);
            this.hw = this.header != null ? this.header.getWidth() : 0;
            int n3 = this.hh = this.header != null ? this.header.getHeight() : 0;
            if (this.hh > 0) {
                this.hh += 20;
            } else {
                this.header = null;
                this.hw = 0;
            }
            this.fw = this.footer != null ? this.footer.getWidth() : 0;
            int n4 = this.fh = this.footer != null ? this.footer.getHeight() : 0;
            if (this.fh > 0) {
                this.fh += 20;
            } else {
                this.footer = null;
                this.fw = 0;
            }
            this.lw = this.legend != null ? this.legend.getWidth() : 0;
            int n5 = this.lh = this.legend != null ? this.legend.getHeight() : 0;
            if (this.lh > 0) {
                this.lh += 20;
            } else {
                this.legend = null;
                this.lw = 0;
            }
            if (this.header != null && this.header instanceof LabelComponent && (prefWidth = (int)((LabelComponent)this.header).getPreferredSize().getWidth()) < this.hw) {
                this.hw = prefWidth;
            }
            if (this.footer != null && this.footer instanceof LabelComponent && (prefWidth = (int)((LabelComponent)this.footer).getPreferredSize().getWidth()) < this.fw) {
                this.fw = prefWidth;
            }
            if (this.legend != null && this.legend instanceof LabelComponent && (prefWidth = (int)((LabelComponent)this.legend).getPreferredSize().getWidth()) < this.lw) {
                this.lw = prefWidth;
            }
            if (this.aw > 0 && this.tth != null && this.tth.getWidth() > this.aw) {
                this.tth.setSize(this.aw, this.tth.getHeight());
            }
            this.totalWidth = this.aw + this.cw + 0;
            if (this.totalWidth < this.hw + 0 && !this.printHeaderOnEveryPage) {
                this.totalWidth = this.hw + 0;
            }
            if (this.totalWidth < this.lw + 0 && !this.printLegendOnEveryPage) {
                this.totalWidth = this.lw + 0;
            }
            if (this.totalWidth < this.fw + 0 && !this.printFooterOnEveryPage) {
                this.totalWidth = this.fw + 0;
            }
            this.totalHeight = this.ch;
            int perPageHeight = 0;
            if (this.printHeaderOnEveryPage) {
                perPageHeight += this.hh;
            } else {
                this.totalHeight += this.hh;
            }
            if (this.printTimeAxisOnEveryPage) {
                perPageHeight += this.ah;
            } else {
                this.totalHeight += this.ah;
            }
            if (this.printLegendOnEveryPage) {
                perPageHeight += this.lh;
            } else {
                this.totalHeight += this.lh;
            }
            if (this.printFooterOnEveryPage) {
                perPageHeight += this.fh;
            } else {
                this.totalHeight += this.fh;
            }
            Insets margins = GanttChart.this.printModel.getMargins();
            PageFormat f = GanttChart.this.printModel.getPageFormat();
            this.pw = (int)f.getWidth() - (margins.left + margins.right);
            this.ph = (int)f.getHeight() - (margins.top + margins.bottom);
            if (GanttChart.this.printModel.isFitToPageEnabled()) {
                int[] fnp = GanttChart.this.printModel.getFitToPages();
                npX = fnp[0];
                int npY = fnp[1];
                if (npY == 0) {
                    double q1 = (double)this.totalHeight * 1.0 / (double)this.ph;
                    double q2 = 1.0 - (double)perPageHeight * 1.0 / (double)this.ph;
                    int lo = (int)Math.ceil((q1 - 0.5) / q2);
                    npY = lo + 1;
                }
                if (npX == 0) {
                    npX = (this.totalWidth + this.pw / 2) / this.pw;
                }
                double scaleX = 1.0;
                double scaleY = 1.0;
                boolean fillSinglePage = GanttChart.this.printModel.isFillSinglePage();
                if (npY == -1 && npX == -1 || npY == 1 && npX == 1 && !fillSinglePage) {
                    npY = 1;
                    npX = 1;
                    this.totalHeight += perPageHeight;
                    scaleY = 1.0 * (double)this.ph / (double)this.totalHeight;
                    if (scaleY > 1.0) {
                        scaleY = 1.0;
                    }
                    if ((scaleX = 1.0 * (double)this.pw / (double)this.totalWidth) > 1.0) {
                        scaleX = 1.0;
                    }
                    scaleX = scaleY = GanttChart.min(scaleX, scaleY);
                } else if (npY == -1) {
                    scaleX = 1.0 * (double)npX * (double)this.pw / (double)this.totalWidth;
                    if (scaleX > 1.0 && npX == 1 && !GanttChart.this.printModel.isFillSinglePage()) {
                        scaleX = 1.0;
                    }
                    scaleY = scaleX;
                    double q1 = (double)this.totalHeight / ((double)this.ph / scaleY);
                    double q2 = 1.0 - (double)perPageHeight / ((double)this.ph / scaleY);
                    npY = (int)Math.ceil(q1 / q2);
                    this.totalHeight += npY * perPageHeight;
                } else if (npX == -1) {
                    this.totalHeight += npY * perPageHeight;
                    scaleY = 1.0 * (double)npY * (double)this.ph / (double)this.totalHeight;
                    if (scaleY > 1.0 && npY == 1 && !GanttChart.this.printModel.isFillSinglePage()) {
                        scaleY = 1.0;
                    }
                    scaleX = scaleY;
                    npX = (int)(((double)this.totalWidth * scaleX + (double)this.pw - 1.0) / (double)this.pw);
                } else {
                    boolean invalidScaleY;
                    this.totalHeight += npY * perPageHeight;
                    scaleX = 1.0 * (double)npX * (double)this.pw / (double)this.totalWidth;
                    scaleY = 1.0 * (double)npY * (double)this.ph / (double)this.totalHeight;
                    boolean invalidScaleX = scaleX > 1.0 && npX == 1 && !fillSinglePage;
                    boolean bl = invalidScaleY = scaleY > 1.0 && npY == 1 && !fillSinglePage;
                    if (npY != 1 || npX != 1 || !fillSinglePage) {
                        if (scaleX > scaleY || invalidScaleX) {
                            scaleX = scaleY;
                        } else if (scaleY > scaleX || invalidScaleY) {
                            scaleY = scaleX;
                        }
                    }
                }
                this.pw = (int)((double)this.pw / scaleX);
                this.ph = (int)((double)this.ph / scaleY);
            } else {
                int lo;
                double[] scale = GanttChart.this.printModel.getScale();
                this.pw = (int)((double)this.pw / scale[0]);
                this.ph = (int)((double)this.ph / scale[1]);
                double q1 = (double)this.totalHeight * 1.0 / (double)this.ph;
                double q2 = 1.0 - (double)perPageHeight * 1.0 / (double)this.ph;
                int npY = lo = (int)Math.ceil(q1 / q2);
                npX = (this.totalWidth + this.pw - 1) / this.pw;
                if (npY >= 0) {
                    this.totalHeight += npY * perPageHeight;
                }
            }
            if (this.ph <= perPageHeight || this.ch == 0) {
                this.totalWidth = this.bgWidth = this.pw;
                this.totalHeight = this.bgHeight = this.ph;
                return;
            }
            this.bgWidth = this.totalWidth;
            this.bgHeight = this.totalHeight;
            if (this.printHeaderOnEveryPage && this.hh > 0 || this.printLegendOnEveryPage && this.lh > 0 || this.printFooterOnEveryPage && this.fh > 0) {
                this.bgWidth = npX * this.pw;
            }
        }

        private JComponent unwrapComponent(JComponent jc0) {
            JComponent jc1;
            for (jc1 = jc0; jc1 != null && jc1.getComponentCount() == 1 && jc1.getComponent(0) instanceof JComponent; jc1 = (JComponent)jc1.getComponent(0)) {
            }
            return jc1;
        }

        private JComponent findSubcomponent(Container p, Class cc) {
            int i1 = p.getComponentCount();
            for (int i = 0; i < i1; ++i) {
                JComponent jc;
                Component c = p.getComponent(i);
                if (c.getClass().equals(cc)) {
                    return (JComponent)c;
                }
                if (!(c instanceof Container) || (jc = this.findSubcomponent((Container)c, cc)) == null) continue;
                return jc;
            }
            return null;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.totalWidth, this.totalHeight);
        }

        @Override
        public Rectangle getBounds() {
            return new Rectangle(0, 0, this.totalWidth, this.totalHeight);
        }

        @SASScope
        private class ElementPlacement {
            PlacementContext context;
            JComponent element;
            public int x;
            public int y;
            public int w;
            public int h;
            public int f;
            public int l;
            public int r;
            public int clipy0;
            public int clipy1;
            public int bgx;
            public int bgy;
            public int bgw;
            public int bgh;

            public ElementPlacement(PlacementContext p, JComponent e, int vgap, boolean b) {
                this.context = p;
                this.element = e;
                this.f = e != null ? vgap : 0;
                this.doPlacement(b);
            }

            public ElementPlacement(ElementPlacement that, JComponent e) {
                this(that);
                this.element = e;
                this.w = e != null ? e.getWidth() : 0;
                this.h = e != null ? e.getHeight() : 0;
            }

            public ElementPlacement(ElementPlacement that) {
                this.context = that.context;
                this.element = that.element;
                this.x = that.x;
                this.y = that.y;
                this.w = that.w;
                this.h = that.h;
                this.f = that.f;
                this.l = that.l;
                this.r = that.r;
                this.clipy0 = that.clipy0;
                this.clipy1 = that.clipy1;
                this.bgx = that.bgx;
                this.bgy = that.bgy;
                this.bgw = that.bgw;
                this.bgh = that.bgh;
            }

            public ElementPlacement(PlacementContext p, int vgap, boolean b) {
                this.context = p;
                this.element = null;
                this.f = vgap;
                this.doPlacement(b);
            }

            public String toString() {
                String ee = ",element=null";
                if (this.element != null) {
                    Dimension s = this.element.getSize();
                    Dimension p = this.element.getPreferredSize();
                    ee = ",element=" + this.element.getClass().getName() + ",element.size=(" + s.getWidth() + "," + s.getHeight() + "),element.preferredSize=(" + p.getWidth() + "," + p.getHeight() + ")";
                }
                return "ElementPlacement{context=" + this.context.toString() + ee + ",x=" + this.x + ",y=" + this.y + ",w=" + this.w + ",h=" + this.h + ",f=" + this.f + ",l=" + this.l + ",r=" + this.r + ",clipy0=" + this.clipy0 + ",clipy1=" + this.clipy1 + ",bgx=" + this.bgx + ",bgy=" + this.bgy + ",bgw=" + this.bgw + ",bgh=" + this.bgh + "}";
            }

            private void doPlacement(boolean everyPage) {
                this.r = 0;
                this.l = 0;
                this.h = 0;
                this.w = 0;
                if (this.element != null) {
                    this.w = this.element.getWidth();
                    this.h = this.element.getHeight();
                    int w2 = (int)this.element.getPreferredSize().getWidth();
                    int padding = this.w - w2;
                    if (this.element instanceof LabelComponent && padding > 0) {
                        LabelComponent c = (LabelComponent)this.element;
                        switch (c.getTextStyle().getJustification()) {
                            case 3: 
                            case 4: 
                            case 11: {
                                this.l = padding;
                                break;
                            }
                            default: {
                                this.l = this.r = padding / 2;
                                break;
                            }
                            case 2: 
                            case 7: 
                            case 10: {
                                this.r = padding;
                            }
                        }
                        this.w = w2;
                    }
                }
                int eh = this.h + this.f;
                int eh0 = 0;
                int eh1 = 0;
                if (everyPage) {
                    this.x = this.context.px + (this.context.pw - this.w) / 2 - this.l;
                    this.y = this.context.filled;
                    eh1 = eh;
                } else {
                    this.x = (this.context.imageWidth - this.w) / 2 - this.l;
                    if (this.context.spaceOnCurrentPage <= 0 || eh <= 0) {
                        eh1 = 0;
                        eh0 = 0;
                        this.element = null;
                    } else if (this.context.spaceOnPreviousPages >= eh) {
                        eh0 = eh;
                        eh1 = 0;
                        this.element = null;
                    } else if (this.context.spaceOnPreviousPages > 0) {
                        eh0 = this.context.spaceOnPreviousPages;
                        eh1 = eh - eh0;
                        this.y = this.context.filled - eh0;
                    } else {
                        eh0 = 0;
                        eh1 = eh;
                        this.y = this.context.filled;
                    }
                    this.context.spaceOnPreviousPages -= eh0;
                    if (eh1 > this.context.spaceOnCurrentPage) {
                        eh1 = this.context.spaceOnCurrentPage;
                    }
                    this.context.spaceOnCurrentPage -= eh1;
                }
                this.clipy0 = this.context.filled;
                this.context.filled += eh1;
                this.clipy1 = this.context.filled;
                this.bgx = this.context.px;
                this.bgw = this.context.pw;
                this.bgy = this.clipy0;
                this.bgh = this.clipy1 - this.clipy0;
            }
        }

        @SASScope
        private class PlacementContext {
            public int spaceOnPreviousPages;
            public int spaceOnCurrentPage;
            public int px;
            public int py;
            public int pw;
            public int ph;
            public int filled;
            public int imageWidth;
            public int imageHeight;

            public PlacementContext(int pps, int cps, int px, int py, int pw, int ph, int iw, int ih) {
                this.spaceOnPreviousPages = pps;
                this.spaceOnCurrentPage = cps;
                this.px = px;
                this.py = py;
                this.pw = pw;
                this.ph = ph;
                this.filled = py;
                this.imageWidth = iw;
                this.imageHeight = ih;
            }

            public String toString() {
                return "PlacementContext{previousPageSpace=" + this.spaceOnPreviousPages + ",currentPageSpace=" + this.spaceOnCurrentPage + ",px=" + this.px + ",py=" + this.py + ",pw=" + this.pw + ",ph=" + this.ph + ",filled=" + this.filled + ",imageWidth=" + this.imageWidth + ",imageHeight=" + this.imageHeight + "}";
            }
        }
    }

    @SASScope
    class WindowDisplayer
    implements Runnable {
        Window w;

        WindowDisplayer(Window w) {
            this.w = w;
        }

        @Override
        public void run() {
            this.w.setVisible(true);
        }
    }

    @SASScope
    private class ActionListenerTunnel
    implements ActionListener {
        private ActionListenerTunnel() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (GanttChart.this.linkListeners != null) {
                GanttChart.this.linkListeners.actionPerformed(e);
            }
        }
    }

    @SASScope
    private static class SampleGanttChartTableModel
    extends DefaultTableModel {
        private static Class[] columnClass = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, String.class, String.class};
        private static String[] columnNames = new String[]{"Id", "EarlyStart", "EarlyFinish", "LateStart", "LateFinish", "SUCC1", "SUCC2", "SUCC3"};

        public SampleGanttChartTableModel() {
            Object[][] data = new Object[][]{{"Approve Plan", "02DEC91", "06DEC91", "02DEC91", "06DEC91", "Drawing", "Anal. Market", "Write Specs"}, {"Anal. Market", "06DEC91", "10DEC91", "06DEC91", "10DEC91", "Mkt. Strat.", null, null}, {"Drawing", "07DEC91", "17DEC91", "07DEC91", "17DEC91", "Prototype", null, null}, {"Write Specs", "08DEC91", "13DEC91", "08DEC91", "13DEC91", "Prototype", null, null}, {"Mkt. Strat.", "11DEC91", "22DEC91", "11DEC91", "22DEC91", "Test Market", "Marketing", null}, {"Prototype", "18DEC91", "05JAN92", "18DEC91", "05JAN92", "Materials", "Facility", null}, {"Materials", "06JAN92", "15JAN92", "06JAN92", "15JAN92", "Init. Prod.", null, null}, {"Facility", "06JAN92", "15JAN92", "06JAN92", "15JAN92", "Init. Prod.", null, null}, {"Init. Prod.", "16JAN92", "25JAN92", "16JAN92", "25JAN92", "Test Market", "Marketing", "Evaluate"}, {"Evaluate", "26JAN92", "04FEB92", "31JAN92", "09FEB92", "Changes", null, null}, {"Test Market", "26JAN92", "09FEB92", "26JAN92", "09FEB92", "Changes", null, null}, {"Marketing", "26JAN92", "26JAN92", "15FEB92", "15FEB92", null, null, null}, {"Changes", "10FEB92", "14FEB92", "10FEB92", "14FEB92", "Production", null, null}, {"Production", "15FEB92", "15FEB92", "15FEB92", "15FEB92", null, null, null}};
            this.setDataVector(data, columnNames);
        }

        public Class getColumnClass(int column) {
            return columnClass[column];
        }
    }

    @SASScope
    private class MyProbeListener
    implements ProbeListener {
        private MyProbeListener() {
        }

        @Override
        public void probeUpdate(ProbeEvent e) {
            if (e.getID() == 1) {
                GanttChart.this.setCursor(Cursor.getPredefinedCursor(0));
            } else if (e.getID() == 0) {
                GanttChart.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }
    }
}

