/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.barlinechart;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.barlinechart.BarLineChartDataModel;
import com.sas.graphics.components.util.Util;
import com.sas.storage.olap.OLAPDataSetInterface;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;

@SASScope(value="ALL")
public class BarLineChartOLAPDataModel
extends BarLineChartDataModel {
    private OLAPDataSetInterface model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private boolean subgroupEnabled = true;
    private Variable barResponseVariable;
    private Variable barResponse2Variable;
    private Variable lineResponseVariable;
    private Variable lineResponse2Variable;
    private Variable styleByVariable;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public void apply(BarLineChartOLAPDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(BarLineChartOLAPDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.subgroupEnabled = theOtherModel.subgroupEnabled;
        this.barResponseVariable = theOtherModel.barResponseVariable;
        this.barResponse2Variable = theOtherModel.barResponse2Variable;
        this.lineResponseVariable = theOtherModel.lineResponseVariable;
        this.lineResponse2Variable = theOtherModel.lineResponse2Variable;
        this.styleByVariable = theOtherModel.styleByVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BarLineChartOLAPDataModel arg = (BarLineChartOLAPDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.subgroupEnabled, arg.subgroupEnabled) && Util.Evaluate.isEqual(this.barResponseVariable, arg.barResponseVariable) && Util.Evaluate.isEqual(this.barResponse2Variable, arg.barResponse2Variable) && Util.Evaluate.isEqual(this.lineResponseVariable, arg.lineResponseVariable) && Util.Evaluate.isEqual(this.lineResponse2Variable, arg.lineResponse2Variable) && Util.Evaluate.isEqual(this.styleByVariable, arg.styleByVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public BarLineChartOLAPDataModel() {
    }

    public BarLineChartOLAPDataModel(OLAPDataSetInterface newModel) {
        this();
        this.model = newModel;
    }

    public BarLineChartOLAPDataModel(OLAPDataSetInterface newModel, boolean newSubgroupEnabled) {
        this(newModel);
        this.subgroupEnabled = newSubgroupEnabled;
    }

    public void setModel(OLAPDataSetInterface newModel) {
        OLAPDataSetInterface oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public OLAPDataSetInterface getModel() {
        return this.model;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, this.selectionModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSubgroupEnabled(boolean newSubgroupEnabled) {
        boolean oldSubgroupEnabled = this.subgroupEnabled;
        this.subgroupEnabled = newSubgroupEnabled;
        this.firePropertyChange("subgroupEnabled", new Boolean(oldSubgroupEnabled), new Boolean(this.subgroupEnabled));
    }

    public boolean isSubgroupEnabled() {
        return this.subgroupEnabled;
    }

    public void setBarResponseVariable(Variable newVariable) {
        Variable oldVariable = this.barResponseVariable;
        this.barResponseVariable = newVariable;
        this.firePropertyChange("barResponseVariable", oldVariable, newVariable);
    }

    public Variable getBarResponseVariable() {
        return this.barResponseVariable;
    }

    public void setBarResponse2Variable(Variable newVariable) {
        Variable oldVariable = this.barResponse2Variable;
        this.barResponse2Variable = newVariable;
        this.firePropertyChange("barResponse2Variable", oldVariable, newVariable);
    }

    public Variable getBarResponse2Variable() {
        return this.barResponse2Variable;
    }

    public void setLineResponseVariable(Variable newVariable) {
        Variable oldVariable = this.lineResponseVariable;
        this.lineResponseVariable = newVariable;
        this.firePropertyChange("lineResponseVariable", oldVariable, newVariable);
    }

    public Variable getLineResponseVariable() {
        return this.lineResponseVariable;
    }

    public void setLineResponse2Variable(Variable newVariable) {
        Variable oldVariable = this.lineResponse2Variable;
        this.lineResponse2Variable = newVariable;
        this.firePropertyChange("lineResponse2Variable", oldVariable, newVariable);
    }

    public Variable getLineResponse2Variable() {
        return this.lineResponse2Variable;
    }

    public void setStyleByVariable(Variable newVariable) {
        Variable oldVariable = this.styleByVariable;
        this.styleByVariable = newVariable;
        this.firePropertyChange("styleByVariable", oldVariable, newVariable);
    }

    public Variable getStyleByVariable() {
        return this.styleByVariable;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }
}

