/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.barlinechart;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.AxisModel;
import com.sas.graphics.components.AxisWallModel;
import com.sas.graphics.components.ChartImageMapInfo;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.Graph;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphOLAPDataSet;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.LegendModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.barlinechart.BarLineChartDataModel;
import com.sas.graphics.components.barlinechart.BarLineChartModel;
import com.sas.graphics.components.barlinechart.BarLineChartOLAPDataModel;
import com.sas.graphics.components.barlinechart.BarLineChartTableDataModel;
import com.sas.graphics.components.barlinechart.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.cell.AnalysisVariableDefinition;
import com.sas.graphics.util.cell.ChartImageMapInfo2;
import com.sas.graphics.util.cell.ClassificationVariableDefinition;
import com.sas.graphics.util.cell.DataSource;
import com.sas.graphics.util.cell.FreqVariableDefinition;
import com.sas.graphics.util.cell.OLAPVariableFactory;
import com.sas.graphics.util.cell.RPFUtil;
import com.sas.graphics.util.cell.SelectionVariableDefinition;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.Util;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrix;
import com.sas.graphics.util.cell.barlinechart.BarLineChartMatrixModel;
import com.sas.rpf.ContextInterface;
import com.sas.storage.olap.OLAPDataSetInterface;
import com.sas.storage.olap.OLAPException;
import com.sas.storage.olap.ResultSetMetadataInterface;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public class BarLineChart
extends Graph {
    public static final String RB_KEY = "BarLineChart.";
    private transient BarLineChartModel barLineChartModel;
    private transient BarLineChartDataModel dataModel;
    private final transient BarLineChartMatrix matrix;
    private final transient BarLineChartMatrixModel matrixModel;
    private final transient DataModelMomento dataModelMomento = new DataModelMomento();
    protected MouseListener scrollBarListener;
    private final transient Util.AnimationDirectorListener animationListener = new Util.AnimationDirectorListener(){

        @Override
        public void doSetAnimationFrame(AnimationPosition animationPosition) {
            BarLineChart.this.setAnimationFrame(animationPosition);
        }
    };
    private static final String ANIMATION_KEY_FRAME = "animationKeyFrameVariable";
    private static final String COLUMN = "columnVariable";
    private static final String ROW = "rowVariable";
    private static final String CATEGORY = "categoryVariable";
    private static final String CATEGORY_SORT = "categorySortVariable";
    private static final String STYLE_BY = "styleByVariable";
    private static final String SUBGROUP = "subgroupVariable";
    private static final String BAR_RESPONSE = "barResponseVariable";
    private static final String BAR_RESPONSE2 = "barResponse2Variable";
    private static final String LINE_RESPONSE = "lineResponseVariable";
    private static final String LINE_RESPONSE2 = "lineResponse2Variable";
    private static final String OUTSIDE_BAR_LABEL = "outsideBarLabelVariable";
    private static final String INSIDE_BAR_LABEL = "insideBarLabelVariable";
    private static final String OUTSIDE_MARKER_LABEL = "outsideMarkerLabelVariable";
    private static final String SELECTION = "selectionVariable";
    private static final String BAR_SELECTION = "barSelectionVariable";
    private static final String BAR2_SELECTION = "bar2SelectionVariable";
    private static final String LINE_SELECTION = "lineSelectionVariable";
    private static final String LINE2_SELECTION = "line2SelectionVariable";
    private static final String DATA_TIP = "datatipVariable";
    private static final String AUXILIARY = "auxiliaryVariable";

    public BarLineChart() {
        this(null, null);
    }

    public BarLineChart(BarLineChartDataModel barLineChartDataModel) {
        this(barLineChartDataModel, null);
    }

    public BarLineChart(BarLineChartDataModel barLineChartDataModel, GraphStyle defaultGraphStyle) {
        this.matrixModel = new BarLineChartMatrixModel();
        this.matrixModel.setAnimationKeyFrameRole(ANIMATION_KEY_FRAME);
        this.matrixModel.setColumnRole(COLUMN);
        this.matrixModel.setRowRole(ROW);
        this.matrixModel.setCategoryRole(CATEGORY);
        this.matrixModel.setCategorySortRole(CATEGORY_SORT);
        this.matrixModel.setStyleByRole(STYLE_BY);
        this.matrixModel.setSubgroupRole(SUBGROUP);
        this.matrixModel.setBarRole(BAR_RESPONSE);
        this.matrixModel.setBar2Role(BAR_RESPONSE2);
        this.matrixModel.setLineRole(LINE_RESPONSE);
        this.matrixModel.setLine2Role(LINE_RESPONSE2);
        this.matrixModel.setOutsideBarLabelRole(OUTSIDE_BAR_LABEL);
        this.matrixModel.setInsideBarLabelRole(INSIDE_BAR_LABEL);
        this.matrixModel.setOutsideMarkerLabelRole(OUTSIDE_MARKER_LABEL);
        this.matrixModel.setSelectionRole(SELECTION);
        this.matrixModel.setBarSelectionRole(BAR_SELECTION);
        this.matrixModel.setBar2SelectionRole(BAR2_SELECTION);
        this.matrixModel.setLineSelectionRole(LINE_SELECTION);
        this.matrixModel.setLine2SelectionRole(LINE2_SELECTION);
        this.matrixModel.setDataTipRole(DATA_TIP);
        this.matrixModel.setAuxiliaryRole(AUXILIARY);
        this.matrix = new BarLineChartMatrix(this.matrixModel, this.getChannel());
        this.setGraphModel(new BarLineChartModel());
        this.applyGraphStyle(defaultGraphStyle != null ? defaultGraphStyle : this.getDefaultGraphStyle());
        this.dataModelMomento.apply(this.barLineChartModel);
        if (this.designTime) {
            try {
                DataSource dataSource = new DataSource(new TableModelVariableFactory(new Util.DesignTimeChartTableData(), Util.getLocale(this), 10475), true, true);
                dataSource.setVariableDefinition(CATEGORY, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable("Category"), 2));
                dataSource.setVariableDefinition(BAR_RESPONSE, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response"), 1));
                dataSource.setVariableDefinition(LINE_RESPONSE2, VariableDefinition.Factory.newVariableDefinition(new AnalysisVariable("Response"), 1));
                this.matrix.setDataSource(dataSource);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        if (barLineChartDataModel != null) {
            this.setDataModel(barLineChartDataModel);
        }
        this.setGraph(this.matrix);
    }

    private void setAnimationFrame(AnimationPosition animationPosition) {
        this.matrix.setAnimationFrame(animationPosition);
        super.setPaintContext(true, animationPosition);
    }

    public void setAnimationEnabled(boolean enabled) {
        this.animationListener.setListeningEnabled(enabled);
    }

    public boolean isAnimationEnabled() {
        return this.animationListener.isListeningEnabled();
    }

    @Override
    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        super.setDisplayPolicy(newDisplayPolicy);
        if (newDisplayPolicy == 10002) {
            this.scrollBarInit();
        }
    }

    @Override
    public void prepareToPaint() {
        this.matrix.prepareToPaint();
    }

    @Override
    public void setAutoRepaintEnabled(boolean b) {
        this.matrix.setAutoRepaintEnabled(b);
    }

    @Override
    public boolean isAutoRepaintEnabled() {
        return this.matrix.isAutoRepaintEnabled();
    }

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.shortDescription = RB.getStringResource(RB_KEY, "shortDescription.txt");
        return ebi;
    }

    @Override
    public void setLocale(Locale locale) {
        this.matrix.setLocale(locale);
        super.setLocale(locale);
    }

    public void setGraphModel(BarLineChartModel newBarLineChartModel) throws IllegalArgumentException {
        super.setGraphModel(newBarLineChartModel);
        BarLineChartModel oldBarLineChartModel = this.barLineChartModel;
        this.barLineChartModel = newBarLineChartModel;
        this.matrixModel.setGraphModel(this.barLineChartModel);
        this.matrixModel.setBarLineChartModel(this.barLineChartModel.getBarLineChartModel());
        this.firePropertyChange("graphModel", oldBarLineChartModel, this.barLineChartModel);
    }

    public BarLineChartModel getGraphModel() {
        return this.barLineChartModel;
    }

    public void setDataModel(BarLineChartDataModel newDataModel) {
        BarLineChartDataModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        this.firePropertyChange("dataModel", oldDataModel, this.dataModel);
    }

    public BarLineChartDataModel getDataModel() {
        return this.dataModel;
    }

    @Override
    protected void applyDataModel() {
        if (this.matrix == null) {
            return;
        }
        this.dataModelMomento.apply(this.barLineChartModel);
        this.animationListener.setEventSource(null);
        try {
            TableModel tableModel;
            DataSource dataSource = BarLineChart._newDataSource(this.dataModel, this.barLineChartModel, Util.getLocale(this), Util.getFormatLocale(this, this.dataModel));
            if (this.dataModel != null && this.dataModel.getRulesContext() != null) {
                String ruleTargetVariableNameID = RPFUtil.applyExceptionHighlighting(dataSource, (ContextInterface)this.dataModel.getRulesContext());
                String columnName = RPFUtil.containsRuleTargetVariableNameID(dataSource, new String[]{BAR_RESPONSE, BAR_RESPONSE2, LINE_RESPONSE, LINE_RESPONSE2}, ruleTargetVariableNameID);
                this.matrixModel.setRuleTargetIdentifier(columnName);
            }
            this.matrix.setDataSource(dataSource);
            if (this.dataModel instanceof BarLineChartTableDataModel && (tableModel = ((BarLineChartTableDataModel)this.dataModel).getModel()) instanceof AnimationDirector) {
                this.animationListener.setEventSource((AnimationDirector)((Object)tableModel));
            }
        }
        catch (Util.ComponentsMessageException e) {
            this.matrix.setDataSource(null, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            this.matrix.setDataSource(null);
            throw e;
        }
    }

    private static DataSource _applyDataSourceWhereProcessing(DataSource dataSource, BarLineChartDataModel dataModel, BarLineChartModel barLineChartModel) {
        if (dataSource != null && dataSource.isOLAPData()) {
            return dataSource;
        }
        if (dataSource != null) {
            Object[] removeIfAnyMissing = null;
            switch (barLineChartModel.getMissingPolicy()) {
                default: {
                    removeIfAnyMissing = new Object[]{CATEGORY};
                    break;
                }
                case 10202: {
                    removeIfAnyMissing = new Object[]{ANIMATION_KEY_FRAME, COLUMN, ROW, CATEGORY, SUBGROUP};
                }
                case 10201: 
            }
            Object[] removeIfAllMissing = null;
            if (!(dataSource.getVariableDefinition(BAR_RESPONSE, 0) instanceof FreqVariableDefinition) && !barLineChartModel.isMissingResponseEnabled()) {
                removeIfAllMissing = new Object[]{BAR_RESPONSE, BAR_RESPONSE2, LINE_RESPONSE, LINE_RESPONSE2};
            }
            if (removeIfAnyMissing != null || removeIfAllMissing != null) {
                dataSource = dataSource.newDataSourceWhere(null);
                dataSource.removeObservationsWhereAnyMissing(removeIfAnyMissing);
                dataSource.removeObservationsWhereAllMissing(removeIfAllMissing);
            }
        }
        return dataSource;
    }

    private static DataSource _newDataSource(BarLineChartDataModel dataModel, BarLineChartModel barLineChartModel, Locale locale, Locale formatLocale) {
        if (dataModel == null) {
            if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullDataModel.txt", locale);
            }
        } else {
            DataSource dataSource = null;
            if (dataModel instanceof BarLineChartTableDataModel) {
                dataSource = BarLineChart._newDataSource((BarLineChartTableDataModel)dataModel, barLineChartModel, locale, formatLocale);
            } else if (dataModel instanceof BarLineChartOLAPDataModel) {
                dataSource = BarLineChart._newDataSource((BarLineChartOLAPDataModel)dataModel, barLineChartModel, locale, formatLocale);
            }
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(BarLineChartTableDataModel tableDataModel, BarLineChartModel barLineChartModel, Locale locale, Locale formatLocale) {
        TableModel tableModel = tableDataModel.getModel();
        if (tableModel == null) {
            if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("nullModel.txt", locale);
            }
        } else if (tableModel.getColumnCount() == 0 || tableModel.getRowCount() == 0) {
            if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
            }
        } else {
            Integer statistic;
            Integer sort;
            Variable catSortVariable;
            boolean missingDataColumnMessageEnabled;
            DataSource dataSource = new DataSource(new TableModelVariableFactory(tableModel, formatLocale, tableDataModel.getSortStrategy()), true, tableDataModel.isStatisticEnabled());
            boolean bl = missingDataColumnMessageEnabled = !barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
            if (tableModel instanceof AnimationDirector) {
                AnimationDirector atm = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, ANIMATION_KEY_FRAME, "animationKeyFrameRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(atm.getKeyFrameVariable()), missingDataColumnMessageEnabled);
            }
            Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getColumnVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getRowVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getCategoryVariable(), 2), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getSubgroupVariable(), 10), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, BAR_RESPONSE, "barResponseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBarResponseVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, BAR_RESPONSE2, "barResponse2Role.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getBarResponse2Variable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, LINE_RESPONSE, "lineResponseRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getLineResponseVariable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, LINE_RESPONSE2, "lineResponse2Role.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getLineResponse2Variable(), 1), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, DATA_TIP, "dataTipRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getDataTipVariable(), 4), missingDataColumnMessageEnabled);
            Util.setVariableDefinition(dataSource, AUXILIARY, "auxiliaryRoles.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getAuxiliaryVariable(), 4), missingDataColumnMessageEnabled);
            if (dataSource.getVariableDefinition(CATEGORY) == null && tableModel instanceof AnimationDirector) {
                AnimationDirector animationDirector = (AnimationDirector)((Object)tableModel);
                Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(animationDirector.getIdentificationVariable(), 2), missingDataColumnMessageEnabled);
            }
            AnalysisVariable[] brva = new AnalysisVariable[]{tableDataModel.getBarResponseVariable(), tableDataModel.getBarResponse2Variable()};
            AnalysisVariable olv = null;
            switch (barLineChartModel.getOutsideBarLabelContent()) {
                case 10200: {
                    Util.setVariableDefinition(dataSource, OUTSIDE_BAR_LABEL, "outsideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getOutsideBarLabelVariable(), 4), missingDataColumnMessageEnabled);
                    break;
                }
                case 10614: {
                    olv = Util.newAnalysisVaraible(brva, 10506);
                    break;
                }
                case 10615: {
                    olv = Util.newAnalysisVaraible(brva, 10501);
                    break;
                }
                case 10608: {
                    olv = Util.newAnalysisVaraible(brva, 10507);
                }
            }
            if (olv != null) {
                Util.setVariableDefinition(dataSource, OUTSIDE_BAR_LABEL, null, null, VariableDefinition.Factory.newVariableDefinition(olv, 0), missingDataColumnMessageEnabled);
            }
            AnalysisVariable ilv = null;
            switch (barLineChartModel.getInsideBarLabelContent()) {
                case 10200: {
                    Util.setVariableDefinition(dataSource, INSIDE_BAR_LABEL, "insideBarLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getInsideBarLabelVariable(), 6), missingDataColumnMessageEnabled);
                    break;
                }
                case 10614: {
                    ilv = Util.newAnalysisVaraible(brva, 10506);
                    break;
                }
                case 10615: {
                    ilv = Util.newAnalysisVaraible(brva, 10501);
                    break;
                }
                case 10608: {
                    ilv = Util.newAnalysisVaraible(brva, 10507);
                }
            }
            if (ilv != null) {
                Util.setVariableDefinition(dataSource, INSIDE_BAR_LABEL, null, null, VariableDefinition.Factory.newVariableDefinition(ilv, 2), missingDataColumnMessageEnabled);
            }
            AnalysisVariable[] lrva = new AnalysisVariable[]{tableDataModel.getLineResponseVariable(), tableDataModel.getLineResponse2Variable()};
            AnalysisVariable tmv = null;
            switch (barLineChartModel.getOutsideMarkerLabelContent()) {
                case 10200: {
                    Util.setVariableDefinition(dataSource, OUTSIDE_MARKER_LABEL, "outsideMarkerLabelRole.txt", locale, VariableDefinition.Factory.newVariableDefinition(tableDataModel.getOutsideMarkerLabelVariable(), 4), missingDataColumnMessageEnabled);
                    break;
                }
                case 10614: {
                    tmv = Util.newAnalysisVaraible(lrva, 10506);
                    break;
                }
                case 10615: {
                    tmv = Util.newAnalysisVaraible(lrva, 10501);
                    break;
                }
                case 10608: {
                    tmv = Util.newAnalysisVaraible(lrva, 10507);
                }
            }
            if (tmv != null) {
                Util.setVariableDefinition(dataSource, OUTSIDE_MARKER_LABEL, null, null, VariableDefinition.Factory.newVariableDefinition(tmv, 0), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(CATEGORY) == null) {
                int index = -1;
                index = Util.seekStringColumn(tableModel);
                if (index < 0) {
                    index = Util.seekDateColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNumberColumn(tableModel);
                }
                if (index < 0) {
                    index = Util.seekNonNullColumn(tableModel);
                }
                if (index < 0) {
                    index = 0;
                }
                Util.setVariableDefinition(dataSource, CATEGORY, null, null, VariableDefinition.Factory.newVariableDefinition(new ClassificationVariable(index), 2), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(BAR_RESPONSE) == null && dataSource.getVariableDefinition(LINE_RESPONSE) == null && dataSource.getVariableDefinition(BAR_RESPONSE2) == null && dataSource.getVariableDefinition(LINE_RESPONSE2) == null) {
                if (!tableDataModel.isStatisticEnabled()) {
                    throw new Util.ComponentsMessageException("RequiredResponseDataNotFound.txt", locale);
                }
                Util.setVariableDefinition(dataSource, BAR_RESPONSE, "barResponseRole.txt", locale, new FreqVariableDefinition(), missingDataColumnMessageEnabled);
            }
            if (dataSource.getVariableDefinition(ANIMATION_KEY_FRAME) == null && (catSortVariable = tableDataModel.getCategorySortVariable()) != null) {
                Integer n = catSortVariable instanceof ClassificationVariable ? new Integer(((ClassificationVariable)catSortVariable).getSort()) : (sort = tableDataModel.getCategoryVariable() != null ? new Integer(tableDataModel.getCategoryVariable().getSort()) : new Integer(10401));
                statistic = catSortVariable instanceof AnalysisVariable ? new Integer(((AnalysisVariable)catSortVariable).getStatistic()) : (catSortVariable instanceof ClassificationVariable ? null : new Integer(10506));
                AnalysisVariableDefinition catSortVarDef = catSortVariable.getColumnName() != null ? new AnalysisVariableDefinition(catSortVariable.getColumnName(), catSortVariable.getFormat(), catSortVariable.getInformat(), catSortVariable.getLabel(), sort, statistic, null, null, null, null, null, null, null, 0) : new AnalysisVariableDefinition(new Integer(catSortVariable.getColumnIndex()), catSortVariable.getFormat(), catSortVariable.getInformat(), catSortVariable.getLabel(), sort, statistic, null, null, null, null, null, null, null, 0);
                Util.setVariableDefinition(dataSource, CATEGORY_SORT, "categorySortRole.txt", locale, catSortVarDef, missingDataColumnMessageEnabled);
            }
            if (tableDataModel.getSubgroupVariable() != null) {
                Util.setLegendVariable(dataSource, STYLE_BY, SUBGROUP);
            } else {
                Variable styleByVariable = tableDataModel.getStyleByVariable();
                if (styleByVariable != null) {
                    sort = new Integer(10401);
                    Integer n = statistic = styleByVariable instanceof AnalysisVariable ? new Integer(((AnalysisVariable)styleByVariable).getStatistic()) : new Integer(10500);
                    AnalysisVariableDefinition styleByVarDef = styleByVariable.getColumnName() != null ? new AnalysisVariableDefinition(styleByVariable.getColumnName(), styleByVariable.getFormat(), styleByVariable.getInformat(), styleByVariable.getLabel(), sort, statistic, styleByVariable.getCategorizationModel(), styleByVariable.getSegmentedRangeStyle(), null, null, null, null, null, null, null, styleByVariable instanceof ClassificationVariable ? 2 : 0) : new AnalysisVariableDefinition(new Integer(styleByVariable.getColumnIndex()), styleByVariable.getFormat(), styleByVariable.getInformat(), styleByVariable.getLabel(), sort, statistic, styleByVariable.getCategorizationModel(), styleByVariable.getSegmentedRangeStyle(), null, null, null, null, null, null, null, styleByVariable instanceof ClassificationVariable ? 2 : 0);
                    Util.setVariableDefinition(dataSource, STYLE_BY, "styleByRole.txt", locale, styleByVarDef, missingDataColumnMessageEnabled);
                }
            }
            if (tableDataModel.getSelectionModel() != null) {
                dataSource.setSelectionModel(tableDataModel.getSelectionModel(), false);
                SelectionVariableDefinition selections = new SelectionVariableDefinition("selected", tableDataModel.getSelectionModel(), null, 0);
                Util.setVariableDefinition(dataSource, SELECTION, null, null, selections, missingDataColumnMessageEnabled);
            }
            dataSource = BarLineChart._applyDataSourceWhereProcessing(dataSource, tableDataModel, barLineChartModel);
            return dataSource;
        }
        return null;
    }

    private static DataSource _newDataSource(BarLineChartOLAPDataModel olapDataModel, BarLineChartModel barLineChartModel, Locale locale, Locale formatLocale) {
        OLAPDataSetInterface olapDataSetInterface = olapDataModel.getModel();
        try {
            if (olapDataSetInterface == null) {
                if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("nullModel.txt", locale);
                }
            } else if (olapDataSetInterface.getCellCount() == 0L) {
                if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED)) {
                    throw new Util.ComponentsMessageException("zeroDataValues.txt", locale);
                }
            } else {
                if (System.getProperty("com.sas.graph.tuple.limit") != null && olapDataSetInterface.getCellCount() > (long)new Integer(System.getProperty("com.sas.graph.tuple.limit")).intValue()) {
                    throw new Util.ComponentsMessageException(com.sas.graphics.util.cell.RB.getStringResource("Matrix.InsufficientDisplaySpace.ex.txt", locale));
                }
                com.sas.graphics.util.gtk.OLAPVariableFactory gtkOLAPFactory = (com.sas.graphics.util.gtk.OLAPVariableFactory)GraphOLAPDataSet.getGraphInfo(olapDataSetInterface);
                ResultSetMetadataInterface resultSetMetadataInterface = gtkOLAPFactory.getResultSetMetadata();
                if (resultSetMetadataInterface != null) {
                    int ii;
                    int i;
                    int lineMeasure2Count;
                    DataSource dataSource = new DataSource(new OLAPVariableFactory(olapDataSetInterface, gtkOLAPFactory, formatLocale, olapDataModel.getSortStrategy()), true, false);
                    boolean missingDataColumnMessageEnabled = !barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_MISSING_DATA_COLUMN_MESSAGE_DISABLED);
                    String categoryHierarchyName = null;
                    String subgroupHierarchyName = null;
                    List columnHierarchyNames = gtkOLAPFactory.getHeirarchyNames(0);
                    List rowHierarchyNames = gtkOLAPFactory.getHeirarchyNames(1);
                    ArrayList barMeasureNames = gtkOLAPFactory.getMeasureNames();
                    List barMeasure2Names = null;
                    List lineMeasureNames = null;
                    List lineMeasure2Names = null;
                    List styleByNames = null;
                    if (olapDataModel.getBarResponseVariable() != null || olapDataModel.getBarResponse2Variable() != null || olapDataModel.getLineResponseVariable() != null || olapDataModel.getLineResponse2Variable() != null) {
                        ArrayList names = barMeasureNames;
                        barMeasureNames = Util.newValidatedList(olapDataModel.getBarResponseVariable(), names, gtkOLAPFactory, "barResponseRole.txt", locale);
                        barMeasure2Names = Util.newValidatedList(olapDataModel.getBarResponse2Variable(), names, gtkOLAPFactory, "barResponse2Role.txt", locale);
                        lineMeasureNames = Util.newValidatedList(olapDataModel.getLineResponseVariable(), names, gtkOLAPFactory, "lineResponseRole.txt", locale);
                        lineMeasure2Names = Util.newValidatedList(olapDataModel.getLineResponse2Variable(), names, gtkOLAPFactory, "lineResponse2Role.txt", locale);
                    } else if (barMeasureNames.size() > 1) {
                        lineMeasureNames = barMeasureNames;
                        barMeasureNames = new ArrayList();
                        barMeasureNames.add(lineMeasureNames.remove(lineMeasureNames.size() - 1));
                    }
                    int barMeasureCount = barMeasureNames != null ? barMeasureNames.size() : 0;
                    int barMeasure2Count = barMeasure2Names != null ? barMeasure2Names.size() : 0;
                    int lineMeasureCount = lineMeasureNames != null ? lineMeasureNames.size() : 0;
                    int n = lineMeasure2Count = lineMeasure2Names != null ? lineMeasure2Names.size() : 0;
                    if (olapDataModel.isSubgroupEnabled() && barMeasureCount + barMeasure2Count + lineMeasureCount + lineMeasure2Count == 1) {
                        if (columnHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                        } else if (rowHierarchyNames.size() > 0) {
                            subgroupHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                        }
                    }
                    if (subgroupHierarchyName == null && olapDataModel.getStyleByVariable() != null) {
                        styleByNames = Util.newValidatedList(olapDataModel.getStyleByVariable(), gtkOLAPFactory.getMeasureNames(), gtkOLAPFactory, "styleByRole.txt", locale);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)columnHierarchyNames.remove(columnHierarchyNames.size() - 1);
                    } else if (rowHierarchyNames.size() > 0) {
                        categoryHierarchyName = (String)rowHierarchyNames.remove(rowHierarchyNames.size() - 1);
                    }
                    if (categoryHierarchyName == null && subgroupHierarchyName != null) {
                        categoryHierarchyName = subgroupHierarchyName;
                        subgroupHierarchyName = null;
                    }
                    if (categoryHierarchyName == null) {
                        throw new Util.ComponentsMessageException("RequiredCategoryDataNotFound.txt", locale);
                    }
                    ClassificationVariableDefinition category = new ClassificationVariableDefinition(categoryHierarchyName, null, null, 0);
                    Util.setVariableDefinition(dataSource, CATEGORY, "categoryRole.txt", locale, category, missingDataColumnMessageEnabled);
                    if (subgroupHierarchyName != null) {
                        ClassificationVariableDefinition subgroup = new ClassificationVariableDefinition(subgroupHierarchyName, null, null, 0);
                        Util.setVariableDefinition(dataSource, SUBGROUP, "subgroupRole.txt", locale, subgroup, missingDataColumnMessageEnabled);
                        Util.setLegendVariable(dataSource, STYLE_BY, SUBGROUP);
                    } else if (styleByNames != null) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, STYLE_BY, styleByNames, "styleByRole.txt", locale, missingDataColumnMessageEnabled);
                    }
                    if (columnHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition columns = null;
                        for (i = columnHierarchyNames.size() - 1; i >= 0; --i) {
                            columns = new ClassificationVariableDefinition((String)columnHierarchyNames.get(i), null, columns, 0);
                        }
                        Util.setVariableDefinition(dataSource, COLUMN, "columnRole.txt", locale, columns, missingDataColumnMessageEnabled);
                    }
                    if (rowHierarchyNames.size() > 0) {
                        ClassificationVariableDefinition rows = null;
                        for (i = rowHierarchyNames.size() - 1; i >= 0; --i) {
                            rows = new ClassificationVariableDefinition((String)rowHierarchyNames.get(i), null, rows, 0);
                        }
                        Util.setVariableDefinition(dataSource, ROW, "rowRole.txt", locale, rows, missingDataColumnMessageEnabled);
                    }
                    if (barMeasureCount + barMeasure2Count + lineMeasureCount + lineMeasure2Count > 0) {
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, BAR_RESPONSE, barMeasureNames, "barResponseRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, BAR_RESPONSE2, barMeasure2Names, "barResponse2Role.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, LINE_RESPONSE, lineMeasureNames, "lineResponseRole.txt", locale, missingDataColumnMessageEnabled);
                        Util.setOLAPMeasures(dataSource, gtkOLAPFactory, LINE_RESPONSE2, lineMeasure2Names, "lineResponse2Role.txt", locale, missingDataColumnMessageEnabled);
                        if (olapDataModel.getSelectionModel() != null) {
                            ListSelectionModel selectionModel = olapDataModel.getSelectionModel();
                            dataSource.setSelectionModel(selectionModel, false);
                            Util.setOLAPSelections(dataSource, selectionModel, BAR_SELECTION, barMeasureNames, missingDataColumnMessageEnabled);
                            Util.setOLAPSelections(dataSource, selectionModel, BAR2_SELECTION, barMeasure2Names, missingDataColumnMessageEnabled);
                            Util.setOLAPSelections(dataSource, selectionModel, LINE_SELECTION, lineMeasureNames, missingDataColumnMessageEnabled);
                            Util.setOLAPSelections(dataSource, selectionModel, LINE2_SELECTION, lineMeasure2Names, missingDataColumnMessageEnabled);
                        }
                    }
                    List measureNames = gtkOLAPFactory.getMeasureNames();
                    if (olapDataModel.getDataTipVariable() != null) {
                        Variable[] dataTipVariable = olapDataModel.getDataTipVariable();
                        for (ii = 0; ii < dataTipVariable.length; ++ii) {
                            List dataTipNames = Util.newValidatedList(dataTipVariable[ii], measureNames, gtkOLAPFactory, "dataTipRoles.txt", locale);
                            if (dataTipNames == null || dataTipNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, DATA_TIP + ii, dataTipNames, "dataTipRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    if (olapDataModel.getAuxiliaryVariable() != null) {
                        Variable[] auxiliaryVariable = olapDataModel.getAuxiliaryVariable();
                        for (ii = 0; ii < auxiliaryVariable.length; ++ii) {
                            List auxiliaryNames = Util.newValidatedList(auxiliaryVariable[ii], measureNames, gtkOLAPFactory, "auxiliaryRoles.txt", locale);
                            if (auxiliaryNames == null || auxiliaryNames.size() <= 0) continue;
                            Util.setOLAPMeasures(dataSource, gtkOLAPFactory, AUXILIARY + ii, auxiliaryNames, "auxiliaryRoles.txt", locale, missingDataColumnMessageEnabled);
                        }
                    }
                    dataSource = BarLineChart._applyDataSourceWhereProcessing(dataSource, olapDataModel, barLineChartModel);
                    return dataSource;
                }
            }
        }
        catch (OLAPException e) {
            if (barLineChartModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_OLPA_EXCEPTION_MESSAGE_ENABLED)) {
                throw new Util.ComponentsMessageException("olapExceptionEncounteredZeroDataValues.txt", locale);
            }
            System.err.println(e.getLocalizedMessage());
            System.err.println(e.getStackTrace());
        }
        return null;
    }

    @Override
    protected void applyGraphModel() {
        super.applyGraphModel();
        if (!this.designTime && this.dataModelMomento.isApplyDataModel(this.barLineChartModel, this.matrix.getDataSource())) {
            this.applyDataModel();
        } else {
            this.matrix.reconstruct();
        }
    }

    public ChartImageMapInfo getImageMapInfo() {
        ChartImageMapInfo2 chartImageMapInfo = null;
        ChartImageMapInfo2[] matrixImageMapInfos = this.matrix.getImageMapInfo();
        if (matrixImageMapInfos != null) {
            for (int ii = 0; ii < matrixImageMapInfos.length; ++ii) {
                if (matrixImageMapInfos[ii] == null) continue;
                matrixImageMapInfos[ii].translate(this);
                if (chartImageMapInfo == null) {
                    chartImageMapInfo = new ChartImageMapInfo2(matrixImageMapInfos[ii]);
                    continue;
                }
                chartImageMapInfo.add(matrixImageMapInfos[ii]);
            }
        }
        return chartImageMapInfo;
    }

    @Override
    public void applyColorScheme(ColorScheme scheme) {
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyColorScheme(scheme);
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getColumnAxisModel(), this.barLineChartModel.getRowAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getLegendModel());
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getCategoryAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getResponseAxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getResponse2AxisModel());
        Util.Conveyer.applyColorScheme(scheme, this.barLineChartModel.getAxisWallModel());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.barLineChartModel.getInsideBarLabelTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.barLineChartModel.getOutsideBarLabelTextStyle());
        Util.Conveyer.applyColorSchemeToValueText(scheme, this.barLineChartModel.getOutsideMarkerLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    public void applyGraphStyle(GraphStyle graphStyle) {
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        super.applyGraphStyle(graphStyle);
        AxisModel categoryAxisModel = this.barLineChartModel.getCategoryAxisModel();
        AxisModel responseAxisModel = this.barLineChartModel.getResponseAxisModel();
        AxisModel response2AxisModel = this.barLineChartModel.getResponse2AxisModel();
        AxisWallModel axisWallModel = this.barLineChartModel.getAxisWallModel();
        LegendModel legendModel = this.barLineChartModel.getLegendModel();
        Util.Conveyer.applyGraphStyle(graphStyle, categoryAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, responseAxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, response2AxisModel);
        Util.Conveyer.applyGraphStyle(graphStyle, axisWallModel);
        Util.Conveyer.applyGraphStyle(graphStyle, legendModel);
        Util.Conveyer.applyGraphStyle(graphStyle, this.barLineChartModel.getColumnAxisModel(), this.barLineChartModel.getRowAxisModel());
        StrokeLineStyle baseLineStyle = this.barLineChartModel.getResponseAxisBaselineModel().getLineStyle();
        if (baseLineStyle != null) {
            baseLineStyle.apply(graphStyle.getAxisLineStyle());
        }
        if ((baseLineStyle = this.barLineChartModel.getResponse2AxisBaselineModel().getLineStyle()) != null) {
            baseLineStyle.apply(graphStyle.getAxisLineStyle());
        }
        this.barLineChartModel.getAxisWallModel().getWallFillStyle().apply(graphStyle.getWallFillStyle());
        this.barLineChartModel.getAxisWallModel().getFloorFillStyle().apply(graphStyle.getFloorFillStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.barLineChartModel.getOutsideBarLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.barLineChartModel.getInsideBarLabelTextStyle());
        Util.Conveyer.applyTextStyle(graphStyle.getDataLabelTextStyle(), this.barLineChartModel.getOutsideMarkerLabelTextStyle());
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    @Override
    protected void selectionChanged() {
        this.matrix.refresh();
    }

    @Override
    protected void updateDataModelListeners() {
        TableModel model = null;
        ListSelectionModel selectionModel = null;
        if (this.dataModel instanceof BarLineChartTableDataModel) {
            BarLineChartTableDataModel tm = (BarLineChartTableDataModel)this.dataModel;
            model = tm.getModel();
            selectionModel = tm.getSelectionModel();
        } else if (this.dataModel instanceof BarLineChartOLAPDataModel) {
            BarLineChartOLAPDataModel om = (BarLineChartOLAPDataModel)this.dataModel;
            model = om.getModel();
            selectionModel = om.getSelectionModel();
        }
        this.updateDataModelListeners(model, selectionModel);
    }

    private void scrollBarInit() {
        this.removeMouseListener(this.scrollBarListener);
        this.scrollBarListener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (BarLineChart.this.matrix.getColumnScrollBar() != null) {
                    BarLineChart.this.matrix.getColumnScrollBar().setVisible(true);
                }
                if (BarLineChart.this.matrix.getRowScrollBar() != null) {
                    BarLineChart.this.matrix.getRowScrollBar().setVisible(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Point pt = evt.getPoint();
                Rectangle b = BarLineChart.this.getBounds();
                if (pt.x >= b.width || pt.x < 0 || pt.y >= b.height || pt.y < 0) {
                    if (!BarLineChart.this.matrix.isZoomedColumnScrollBar() && BarLineChart.this.matrix.getColumnScrollBar() != null) {
                        BarLineChart.this.matrix.getColumnScrollBar().setVisible(false);
                    }
                    if (!BarLineChart.this.matrix.isZoomedRowScrollBar() && BarLineChart.this.matrix.getRowScrollBar() != null) {
                        BarLineChart.this.matrix.getRowScrollBar().setVisible(false);
                    }
                }
            }
        };
        this.addMouseListener(this.scrollBarListener);
    }

    @SASScope
    private static class DataModelMomento {
        private static final long dataOptions = GraphConstants.CUSTOM_OPTION_NULL_MODEL_MESSAGE_ENABLED | GraphConstants.CUSTOM_OPTION_ZERO_DATA_VALUES_MESSAGE_ENABLED;
        private int missingPolicy;
        private boolean missingResponseEnabled;
        private int uniformPolicy;
        private int outsideBarLabelContent;
        private int insideBarLabelContent;
        private int outsideMarkerLabelContent;
        private long customOptions;

        public DataModelMomento() {
        }

        public DataModelMomento(BarLineChartModel barLineChartModel) {
            this.apply(barLineChartModel);
        }

        public void apply(BarLineChartModel barLineChartModel) {
            this.customOptions = barLineChartModel.getCustomOptions() & dataOptions;
            this.missingResponseEnabled = barLineChartModel.isMissingResponseEnabled();
            this.uniformPolicy = barLineChartModel.getUniformPolicy();
            this.missingPolicy = barLineChartModel.getMissingPolicy();
            this.outsideBarLabelContent = barLineChartModel.getOutsideBarLabelContent();
            this.insideBarLabelContent = barLineChartModel.getInsideBarLabelContent();
            this.outsideMarkerLabelContent = barLineChartModel.getOutsideMarkerLabelContent();
        }

        public boolean isApplyDataModel(BarLineChartModel barLineChartModel, DataSource dataSource) {
            if (dataSource != null) {
                return this.missingPolicy != barLineChartModel.getMissingPolicy() || this.uniformPolicy != barLineChartModel.getUniformPolicy() || this.missingResponseEnabled != barLineChartModel.isMissingResponseEnabled() || this.outsideBarLabelContent != barLineChartModel.getOutsideBarLabelContent() || this.insideBarLabelContent != barLineChartModel.getInsideBarLabelContent() || this.outsideMarkerLabelContent != barLineChartModel.getOutsideMarkerLabelContent();
            }
            return this.customOptions != (barLineChartModel.getCustomOptions() & dataOptions);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            DataModelMomento arg = (DataModelMomento)obj;
            return Util.Evaluate.isEqual(this.customOptions, arg.customOptions) && Util.Evaluate.isEqual(this.missingResponseEnabled, arg.missingResponseEnabled) && Util.Evaluate.isEqual(this.uniformPolicy, arg.uniformPolicy) && Util.Evaluate.isEqual(this.missingPolicy, arg.missingPolicy) && Util.Evaluate.isEqual(this.outsideBarLabelContent, arg.outsideBarLabelContent) && Util.Evaluate.isEqual(this.insideBarLabelContent, arg.insideBarLabelContent) && Util.Evaluate.isEqual(this.outsideMarkerLabelContent, arg.outsideMarkerLabelContent) && super.equals(arg);
        }
    }
}

