/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.areabarchart;

import com.sas.graphics.components.AnalysisVariable;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.Variable;
import com.sas.graphics.components.areabarchart.AreaBarChartDataModel;
import com.sas.graphics.components.util.Util;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableModel;

public class AreaBarChartTableDataModel
extends AreaBarChartDataModel {
    private TableModel model;
    private ListSelectionModel selectionModel = new DefaultListSelectionModel();
    private ClassificationVariable columnVariable = null;
    private ClassificationVariable rowVariable = null;
    private ClassificationVariable categoryVariable = null;
    private ClassificationVariable subgroupVariable = null;
    private AnalysisVariable heightVariable = null;
    private AnalysisVariable widthVariable = null;
    private Variable[] auxiliaryVariables;
    private Variable[] dataTipVariables;

    public AreaBarChartTableDataModel() {
    }

    public AreaBarChartTableDataModel(TableModel newModel) {
        this();
        this.model = newModel;
    }

    public void apply(AreaBarChartTableDataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            super.apply(theOtherModel);
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(AreaBarChartTableDataModel theOtherModel) {
        this.model = theOtherModel.model;
        this.selectionModel = theOtherModel.selectionModel;
        this.columnVariable = theOtherModel.columnVariable;
        this.rowVariable = theOtherModel.rowVariable;
        this.categoryVariable = theOtherModel.categoryVariable;
        this.subgroupVariable = theOtherModel.subgroupVariable;
        this.heightVariable = theOtherModel.heightVariable;
        this.widthVariable = theOtherModel.widthVariable;
        this.auxiliaryVariables = theOtherModel.auxiliaryVariables;
        this.dataTipVariables = theOtherModel.dataTipVariables;
    }

    public void setModel(TableModel newModel) {
        TableModel oldModel = this.model;
        this.model = newModel;
        this.firePropertyChange("model", oldModel, newModel);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setColumnVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.columnVariable;
        this.columnVariable = newVariable;
        this.firePropertyChange("columnVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getColumnVariable() {
        return this.columnVariable;
    }

    public void setRowVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.rowVariable;
        this.rowVariable = newVariable;
        this.firePropertyChange("rowVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getRowVariable() {
        return this.rowVariable;
    }

    public void setCategoryVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.categoryVariable;
        this.categoryVariable = newVariable;
        this.firePropertyChange("categoryVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getCategoryVariable() {
        return this.categoryVariable;
    }

    public void setSubgroupVariable(ClassificationVariable newVariable) {
        ClassificationVariable oldVariable = this.subgroupVariable;
        this.subgroupVariable = newVariable;
        this.firePropertyChange("subgroupVariable", oldVariable, newVariable);
    }

    public ClassificationVariable getSubgroupVariable() {
        return this.subgroupVariable;
    }

    public void setHeightVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.heightVariable;
        this.heightVariable = newVariable;
        this.firePropertyChange("heightVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getHeightVariable() {
        return this.heightVariable;
    }

    public void setWidthVariable(AnalysisVariable newVariable) {
        AnalysisVariable oldVariable = this.widthVariable;
        this.widthVariable = newVariable;
        this.firePropertyChange("widthVariable", oldVariable, newVariable);
    }

    public AnalysisVariable getWidthVariable() {
        return this.widthVariable;
    }

    public void setDataTipVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.dataTipVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.dataTipVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.dataTipVariables != null) {
            System.arraycopy(newVariables, 0, this.dataTipVariables, 0, this.dataTipVariables.length);
        }
        this.firePropertyChange("dataTipVariable", oldVariables, newVariables);
    }

    public Variable[] getDataTipVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.dataTipVariables == null ? null : new Variable[this.dataTipVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.dataTipVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setAuxiliaryVariable(Variable[] newVariables) {
        Variable[] oldVariables = this.auxiliaryVariables;
        if (newVariables != null && newVariables.length < 1) {
            throw new IllegalArgumentException();
        }
        Variable[] variableArray = this.auxiliaryVariables = newVariables == null ? null : new Variable[newVariables.length];
        if (this.auxiliaryVariables != null) {
            System.arraycopy(newVariables, 0, this.auxiliaryVariables, 0, this.auxiliaryVariables.length);
        }
        this.firePropertyChange("auxiliaryVariable", oldVariables, newVariables);
    }

    public Variable[] getAuxiliaryVariable() {
        Variable[] copyOfVariables;
        Variable[] variableArray = copyOfVariables = this.auxiliaryVariables == null ? null : new Variable[this.auxiliaryVariables.length];
        if (copyOfVariables != null) {
            System.arraycopy(this.auxiliaryVariables, 0, copyOfVariables, 0, copyOfVariables.length);
        }
        return copyOfVariables;
    }

    public void setSelectionModel(ListSelectionModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        ListSelectionModel oldModel = this.selectionModel;
        this.selectionModel = newModel;
        this.firePropertyChange("selectionModel", oldModel, newModel);
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        AreaBarChartTableDataModel arg = (AreaBarChartTableDataModel)obj;
        return Util.Evaluate.isEqual(this.model, arg.model) && Util.Evaluate.isEqual(this.selectionModel, arg.selectionModel) && Util.Evaluate.isEqual(this.columnVariable, arg.columnVariable) && Util.Evaluate.isEqual(this.rowVariable, arg.rowVariable) && Util.Evaluate.isEqual(this.categoryVariable, arg.categoryVariable) && Util.Evaluate.isEqual(this.subgroupVariable, arg.subgroupVariable) && Util.Evaluate.isEqual(this.heightVariable, arg.heightVariable) && Util.Evaluate.isEqual(this.widthVariable, arg.widthVariable) && Util.Evaluate.isEqual(this.dataTipVariables, arg.dataTipVariables) && Util.Evaluate.isEqual(this.auxiliaryVariables, arg.auxiliaryVariables) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

