/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.animation;

import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.util.cell.GTKUtil;
import com.sas.graphics.util.cell.TableModelVariableFactory;
import com.sas.graphics.util.cell.VariableDefinition;
import com.sas.graphics.util.gtk.Variable;
import com.sas.storage.jdbc.JDBCAdapter;
import com.sas.table.FormattedInterface;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class AnimationTableModel
extends AnimationDirector
implements TableModel,
FormattedInterface {
    private AnimationTableModelDataState dataState = new AnimationTableModelDataState();
    private final Set animationTableModelListeners = Collections.synchronizedSet(new HashSet());
    private TableModel tableModel;
    private final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            TableModelEvent tme = new TableModelEvent(AnimationTableModel.this, e.getFirstRow(), e.getLastRow(), e.getColumn(), e.getType());
            AnimationTableModel.this.fireTableChangedEvent(tme);
        }
    };

    public AnimationTableModel(TableModel tableModel, ClassificationVariable keyFrameVariable) throws IllegalArgumentException, IllegalStateException {
        this._setModel(tableModel, keyFrameVariable, null);
    }

    public AnimationTableModel(TableModel tableModel, ClassificationVariable keyFrameVariable, ClassificationVariable identificationVariable) throws IllegalArgumentException, IllegalStateException {
        this._setModel(tableModel, keyFrameVariable, identificationVariable);
    }

    public void setModel(TableModel tableModel, ClassificationVariable keyFrameVariable) throws IllegalArgumentException, IllegalStateException {
        this._setModel(tableModel, keyFrameVariable, null);
    }

    public void setModel(TableModel tableModel, ClassificationVariable keyFrameVariable, ClassificationVariable identificationVariable) throws IllegalArgumentException, IllegalStateException {
        this._setModel(tableModel, keyFrameVariable, identificationVariable);
    }

    private void _setModel(TableModel tableModel, ClassificationVariable keyFrameVariable, ClassificationVariable identificationVariable) throws IllegalArgumentException, IllegalStateException {
        if (tableModel == null || keyFrameVariable == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (this.tableModel != tableModel || keyFrameVariable != this.getKeyFrameVariable() || identificationVariable != this.getIdentificationVariable()) {
            this.dataState = this._syncModel(tableModel, keyFrameVariable, identificationVariable);
            if (this.tableModel != null) {
                this.tableModel.removeTableModelListener(this.tableModelListener);
            }
            this.tableModel = tableModel;
            this.tableModel.addTableModelListener(this.tableModelListener);
            this.disablePropertyChange();
            super.setKeyFrameVariable(keyFrameVariable);
            super.setIdentificationVariable(identificationVariable);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
            this.fireTableChangedEvent(new TableModelEvent(this, 0));
            this.fireAnimationEvent();
        }
    }

    private AnimationTableModelDataState _syncModel(TableModel tableModel, ClassificationVariable keyFrameVariable, ClassificationVariable identificationVariable) throws IllegalStateException {
        AnimationTableModelDataState newState = new AnimationTableModelDataState();
        if (tableModel != this.tableModel) {
            newState.tableModelDelegate = tableModel;
            if (tableModel instanceof JDBCAdapter) {
                newState.tableModelDelegate = new JDBCTableModelDelegate(tableModel);
            }
            newState.variableFactory = new TableModelVariableFactory(newState.tableModelDelegate);
        } else {
            newState.tableModelDelegate = this.dataState.tableModelDelegate;
            newState.variableFactory = this.dataState.variableFactory;
        }
        Variable gtkKeyFrameVariable = newState.variableFactory.newVariable(VariableDefinition.Factory.newVariableDefinition(keyFrameVariable));
        Variable gtkIdentificationVariable = identificationVariable != null ? newState.variableFactory.newVariable(VariableDefinition.Factory.newVariableDefinition(identificationVariable)) : null;
        newState.uniqueKeyFrameValues = AnimationTableModelDataState.unigueValuesAsObjectArray(gtkKeyFrameVariable);
        newState.formattedUniqueKeyFrameValues = AnimationTableModelDataState.formattedUnigueValuesAsStringArray(gtkKeyFrameVariable);
        newState.keyFrameLabel = gtkKeyFrameVariable.getLabel();
        gtkKeyFrameVariable.disconnect();
        if (gtkIdentificationVariable != null) {
            gtkIdentificationVariable.disconnect();
        }
        return newState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireTableChangedEvent(TableModelEvent tableModelEvent) {
        Set set = this.animationTableModelListeners;
        synchronized (set) {
            TableModelListener[] listeners = this.animationTableModelListeners.toArray(new TableModelListener[0]);
            for (int ii = 0; ii < listeners.length; ++ii) {
                listeners[ii].tableChanged(tableModelEvent);
            }
        }
    }

    @Override
    public void setKeyFrameVariable(ClassificationVariable keyFrameVariable) throws IllegalArgumentException {
        if (keyFrameVariable == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.dataState = this._syncModel(this.getModel(), keyFrameVariable, this.getIdentificationVariable());
        ClassificationVariable oldKeyFrameVariable = this.getKeyFrameVariable();
        this.disablePropertyChange();
        super.setKeyFrameVariable(keyFrameVariable);
        this.enablePropertyChange();
        this.firePropertyChange("keyFrameVariable", oldKeyFrameVariable, this.getKeyFrameVariable());
    }

    @Override
    public void setIdentificationVariable(ClassificationVariable identificationVariable) {
        this.dataState = this._syncModel(this.getModel(), this.getKeyFrameVariable(), identificationVariable);
        ClassificationVariable oldIdentificationVariable = this.getIdentificationVariable();
        this.disablePropertyChange();
        super.setIdentificationVariable(identificationVariable);
        this.enablePropertyChange();
        this.firePropertyChange("identificationVariable", oldIdentificationVariable, this.getIdentificationVariable());
    }

    public void setModel(TableModel tableModel) throws IllegalArgumentException {
        if (tableModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TableModel oldTableModel = this.tableModel;
        this.dataState = this._syncModel(tableModel, this.getKeyFrameVariable(), this.getIdentificationVariable());
        if (this.tableModel != null) {
            this.tableModel.removeTableModelListener(this.tableModelListener);
        }
        this.tableModel = tableModel;
        this.tableModel.addTableModelListener(this.tableModelListener);
        this.firePropertyChange("tableModel", oldTableModel, tableModel);
        this.fireTableChangedEvent(new TableModelEvent(this, 0));
        this.fireAnimationEvent();
    }

    public TableModel getModel() {
        return this.tableModel;
    }

    private String[] clone(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] cloneStringArray = new String[stringArray.length];
        System.arraycopy(stringArray, 0, cloneStringArray, 0, stringArray.length);
        return cloneStringArray;
    }

    private Object[] clone(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] cloneObjectArray = new Object[objectArray.length];
        System.arraycopy(objectArray, 0, cloneObjectArray, 0, objectArray.length);
        return cloneObjectArray;
    }

    @Override
    public String[] getFormattedUniqueKeyFrameValues() {
        return this.clone(this.dataState.formattedUniqueKeyFrameValues);
    }

    @Override
    public String getKeyFrameLabel() {
        return this.dataState.keyFrameLabel;
    }

    @Override
    public Object[] getUniqueKeyFrameValues() {
        return this.clone(this.dataState.uniqueKeyFrameValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTableModelListener(TableModelListener l) {
        Set set = this.animationTableModelListeners;
        synchronized (set) {
            this.animationTableModelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTableModelListener(TableModelListener l) {
        Set set = this.animationTableModelListeners;
        synchronized (set) {
            this.animationTableModelListeners.remove(l);
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.dataState.tableModelDelegate.getColumnClass(columnIndex);
    }

    @Override
    public int getColumnCount() {
        return this.dataState.tableModelDelegate.getColumnCount();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.dataState.tableModelDelegate.getColumnName(columnIndex);
    }

    @Override
    public int getRowCount() {
        return this.dataState.tableModelDelegate.getRowCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.dataState.tableModelDelegate.getValueAt(rowIndex, columnIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.dataState.tableModelDelegate.isCellEditable(rowIndex, columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        this.dataState.tableModelDelegate.setValueAt(aValue, rowIndex, columnIndex);
    }

    public String getFormat(int columnIndex) {
        if (this.tableModel instanceof FormattedInterface) {
            return ((FormattedInterface)this.dataState.tableModelDelegate).getFormat(columnIndex);
        }
        return null;
    }

    public String getFormattedValueAt(int rowIndex, int columnIndex) {
        if (this.tableModel instanceof FormattedInterface) {
            return ((FormattedInterface)this.dataState.tableModelDelegate).getFormattedValueAt(rowIndex, columnIndex);
        }
        Object value = this.dataState.tableModelDelegate.getValueAt(rowIndex, columnIndex);
        return value == null ? null : value.toString();
    }

    public Class getUnformattedColumnClass(int columnIndex) {
        if (this.tableModel instanceof FormattedInterface) {
            return ((FormattedInterface)this.dataState.tableModelDelegate).getUnformattedColumnClass(columnIndex);
        }
        return this.dataState.tableModelDelegate.getColumnClass(columnIndex);
    }

    public Object getUnformattedValueAt(int rowIndex, int columnIndex) {
        if (this.tableModel instanceof FormattedInterface) {
            return ((FormattedInterface)this.dataState.tableModelDelegate).getUnformattedValueAt(rowIndex, columnIndex);
        }
        return this.dataState.tableModelDelegate.getValueAt(rowIndex, columnIndex);
    }

    public boolean isFormattedDataUsed() {
        if (this.tableModel instanceof FormattedInterface) {
            return ((FormattedInterface)this.dataState.tableModelDelegate).isFormattedDataUsed();
        }
        return false;
    }

    public void setFormattedDataUsed(boolean useFormattedData) {
        if (this.tableModel instanceof FormattedInterface) {
            ((FormattedInterface)this.dataState.tableModelDelegate).setFormattedDataUsed(useFormattedData);
        }
    }

    private static final class JDBCTableModelDelegate
    implements TableModel,
    FormattedInterface {
        final TableModel tableModel;
        private final int rowCount;
        private final int columnCount;
        private final Class[] columnClasses;
        private final Object[][] dataValues;
        private final String[] columnNames;
        private final Class[] _FI_unformattedColumnClasses;
        private final String[][] _FI_formattedDataValues;
        private final String[] _FI_columnFormats;
        private final boolean _FI_formattedDataUsed;
        final FormattedInterface _FI_tableModel;

        public JDBCTableModelDelegate(TableModel model) {
            if (model instanceof JDBCAdapter) {
                this.tableModel = model;
                this.rowCount = this.tableModel.getRowCount();
                this.columnCount = this.tableModel.getColumnCount();
                this.dataValues = new Object[this.rowCount][this.columnCount];
                this.columnClasses = new Class[this.columnCount];
                this.columnNames = new String[this.columnCount];
                if (this.tableModel instanceof FormattedInterface) {
                    this._FI_tableModel = (FormattedInterface)this.tableModel;
                    this._FI_formattedDataUsed = this._FI_tableModel.isFormattedDataUsed();
                    this._FI_formattedDataValues = new String[this.rowCount][this.columnCount];
                    this._FI_columnFormats = new String[this.columnCount];
                    this._FI_unformattedColumnClasses = new Class[this.columnCount];
                } else {
                    this._FI_tableModel = null;
                    this._FI_formattedDataUsed = false;
                    this._FI_formattedDataValues = null;
                    this._FI_columnFormats = null;
                    this._FI_unformattedColumnClasses = null;
                }
                for (int column = 0; column < this.columnCount; ++column) {
                    this.columnClasses[column] = this.tableModel.getColumnClass(column);
                    this.columnNames[column] = this.tableModel.getColumnName(column);
                    if (this._FI_tableModel == null) continue;
                    this._FI_columnFormats[column] = this._FI_tableModel.getFormat(column);
                    this._FI_unformattedColumnClasses[column] = this._FI_tableModel.getUnformattedColumnClass(column);
                }
                for (int row = 0; row < this.rowCount; ++row) {
                    for (int column = 0; column < this.columnCount; ++column) {
                        if (this._FI_tableModel != null) {
                            this.dataValues[row][column] = this._FI_tableModel.getUnformattedValueAt(row, column);
                            try {
                                this._FI_formattedDataValues[row][column] = this._FI_tableModel.getFormattedValueAt(row, column);
                            }
                            catch (IllegalStateException e) {
                                String value = this.dataValues[row][column].toString();
                                this._FI_formattedDataValues[row][column] = value == null ? null : value.toString();
                            }
                            continue;
                        }
                        this.dataValues[row][column] = this.tableModel.getValueAt(row, column);
                    }
                }
            } else {
                throw new IllegalArgumentException();
            }
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        public Class getColumnClass(int column) {
            return this.columnClasses[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnCount;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this._FI_tableModel != null && this._FI_formattedDataUsed) {
                return this._FI_formattedDataValues[rowIndex][columnIndex];
            }
            return this.dataValues[rowIndex][columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }

        public String getFormat(int columnIndex) {
            if (this._FI_tableModel != null && this._FI_columnFormats != null && columnIndex > 0 && columnIndex < this._FI_columnFormats.length) {
                return this._FI_columnFormats[columnIndex];
            }
            return null;
        }

        public String getFormattedValueAt(int rowIndex, int columnIndex) {
            if (this._FI_tableModel != null) {
                return this._FI_formattedDataValues[rowIndex][columnIndex];
            }
            Object value = this.dataValues[rowIndex][columnIndex];
            return value == null ? null : value.toString();
        }

        public Class getUnformattedColumnClass(int columnIndex) {
            if (this._FI_tableModel != null) {
                return this._FI_unformattedColumnClasses[columnIndex];
            }
            return this.columnClasses[columnIndex];
        }

        public Object getUnformattedValueAt(int rowIndex, int columnIndex) {
            return this.dataValues[rowIndex][columnIndex];
        }

        public boolean isFormattedDataUsed() {
            if (this._FI_tableModel != null) {
                return this._FI_formattedDataUsed;
            }
            return false;
        }

        public void setFormattedDataUsed(boolean useFormattedData) {
        }
    }

    private static class AnimationTableModelDataState {
        public TableModel tableModelDelegate;
        public TableModelVariableFactory variableFactory;
        public Object[] uniqueKeyFrameValues;
        public String[] formattedUniqueKeyFrameValues;
        public String keyFrameLabel;

        private AnimationTableModelDataState() {
        }

        private static Object[] unigueValuesAsObjectArray(Variable v) {
            Object[] oa = new Object[v.getUniqueValueCount()];
            for (int ii = 0; ii < oa.length; ++ii) {
                oa[ii] = GTKUtil.VariableAccess.getUniqueValue(v, ii);
            }
            return oa;
        }

        private static String[] formattedUnigueValuesAsStringArray(Variable sv) {
            String[] sa = new String[sv.getUniqueValueCount()];
            for (int ii = 0; ii < sa.length; ++ii) {
                sa[ii] = GTKUtil.VariableAccess.getFormattedUniqueValue(sv, ii);
            }
            return sa;
        }
    }
}

