/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.animation;

import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.animation.AnimationEvent;
import com.sas.graphics.components.animation.AnimationListener;
import com.sas.graphics.components.animation.AnimationPosition;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class AnimationDirector {
    private static final int DEFAULT_FRAMES_PER_SECOND = 20;
    private ClassificationVariable keyFrameVariable;
    private ClassificationVariable identificationVariable;
    private boolean playDirectionForward = true;
    private boolean repeatEnabled = false;
    private double speed = 1.0;
    private int frameRate = 20;
    private boolean isValidState = false;
    private Object[] uniqueKeyFrameValues = null;
    private int frameId = -1;
    private int frameIdOfLastKeyFrame = -1;
    private int pauseAtFrameId = -1;
    private int frameIntervalCount = -1;
    private int totalFrameCount = -1;
    private double frameIntervalInSeconds = 1.0 / (double)this.frameRate;
    private int frameIntervalInMilliseconds = (int)(this.frameIntervalInSeconds * 1000.0);
    private AnimationPosition animationPosition = null;
    private final Hashtable uniqueKeyFrameValuesHashtable = new Hashtable();
    private final Set animationListeners = Collections.synchronizedSet(new HashSet());
    private final ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AnimationDirector.this.nextFrame();
        }
    };
    private final Timer playTimer = new Timer(this.frameIntervalInMilliseconds, this.actionListener);
    private static final AnimationListener[] EmptyAnimationListenerArray = new AnimationListener[0];
    private final PropertyChangeSupport propertyChangeSupport;
    private final ContainedModelSupport containedModelSupport;
    private int eventGate;

    public AnimationDirector() {
        this.playTimer.setInitialDelay(0);
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.containedModelSupport = new ContainedModelSupport();
        this.eventGate = 0;
    }

    public abstract String getKeyFrameLabel();

    public abstract Object[] getUniqueKeyFrameValues();

    public abstract String[] getFormattedUniqueKeyFrameValues();

    private void reviseFrameState() {
        if (this.isValidState) {
            this.frameIntervalCount = Math.max((int)((double)this.frameRate / this.speed + 0.5) - 1, 1);
            this.totalFrameCount = this.frameIntervalCount * this.uniqueKeyFrameValues.length;
            this.frameIdOfLastKeyFrame = this.toFrameID(new AnimationPosition(this.uniqueKeyFrameValues[this.uniqueKeyFrameValues.length - 1]));
        } else {
            this.frameIntervalCount = -1;
            this.totalFrameCount = -1;
            this.frameIdOfLastKeyFrame = -1;
        }
    }

    private void stateChanged() {
        this.pause();
        this.uniqueKeyFrameValuesHashtable.clear();
        this.uniqueKeyFrameValues = this.getUniqueKeyFrameValues();
        boolean bl = this.isValidState = this.uniqueKeyFrameValues != null && this.uniqueKeyFrameValues.length > 1;
        if (this.isValidState) {
            this.frameId = 0;
            this.pauseAtFrameId = -1;
            for (int ii = 0; ii < this.uniqueKeyFrameValues.length; ++ii) {
                this.uniqueKeyFrameValuesHashtable.put(this.uniqueKeyFrameValues[ii], new Integer(ii));
            }
        } else {
            this.frameId = -1;
            this.animationPosition = null;
        }
        this.reviseFrameState();
    }

    public int getKeyFrameIndex(Object keyFrame) {
        if (this.isValidState) {
            Integer index = (Integer)this.uniqueKeyFrameValuesHashtable.get(keyFrame);
            return index != null ? index : -1;
        }
        return -1;
    }

    public void setFrameRate(int framesPerSecond) {
        if (framesPerSecond < 1) {
            throw new IllegalArgumentException(RB.getStringResource("lessThanOneInvalid.ex.txt"));
        }
        if (framesPerSecond > 30) {
            throw new IllegalArgumentException(RB.getStringResource("greaterThan30Invalid.ex.txt"));
        }
        double oldFrameRate = this.frameRate;
        boolean isPlayingEnabled = this.isPlaying();
        if (isPlayingEnabled) {
            this.pause();
        }
        AnimationPosition oldFrameIdPosition = this.newAnimationPosition(this.frameId);
        AnimationPosition oldPauseAtFrameIdPosition = this.pauseAtFrameId >= 0 ? this.newAnimationPosition(this.pauseAtFrameId) : null;
        this.frameRate = framesPerSecond;
        this.frameIntervalInSeconds = 1.0 / (double)this.frameRate;
        this.frameIntervalInMilliseconds = (int)(this.frameIntervalInSeconds * 1000.0);
        this.playTimer.setDelay(this.frameIntervalInMilliseconds);
        this.reviseFrameState();
        this.frameId = this.toFrameID(oldFrameIdPosition);
        int n = this.pauseAtFrameId = oldPauseAtFrameIdPosition != null ? this.toFrameID(oldPauseAtFrameIdPosition) : -1;
        if (isPlayingEnabled) {
            this.play();
        }
        this.firePropertyChange("frameRate", oldFrameRate, (double)this.frameRate);
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setKeyFrameVariable(ClassificationVariable keyFrameVariable) throws IllegalArgumentException {
        if (keyFrameVariable == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        ClassificationVariable oldKeyFrameVariable = this.keyFrameVariable;
        this.keyFrameVariable = keyFrameVariable;
        this.firePropertyChange("keyFrameVariable", oldKeyFrameVariable, this.keyFrameVariable);
    }

    public ClassificationVariable getKeyFrameVariable() {
        return this.keyFrameVariable;
    }

    public void setIdentificationVariable(ClassificationVariable identificationVariable) {
        ClassificationVariable oldIdentificationVariable = this.identificationVariable;
        this.identificationVariable = identificationVariable;
        this.firePropertyChange("identificationVariable", oldIdentificationVariable, this.identificationVariable);
    }

    public ClassificationVariable getIdentificationVariable() {
        return this.identificationVariable;
    }

    public void setSpeed(double keyframePerSecond) {
        if (keyframePerSecond < 0.0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        double oldSpeed = this.speed;
        double newSpeed = Math.min(Math.max(keyframePerSecond, 0.1), 24.0);
        if (newSpeed != this.speed) {
            boolean isPlayingEnabled = this.isPlaying();
            if (isPlayingEnabled) {
                this.pause();
            }
            AnimationPosition oldFrameIdPosition = this.newAnimationPosition(this.frameId);
            AnimationPosition oldPauseAtFrameIdPosition = this.pauseAtFrameId >= 0 ? this.newAnimationPosition(this.pauseAtFrameId) : null;
            this.speed = newSpeed;
            this.reviseFrameState();
            this.frameId = this.toFrameID(oldFrameIdPosition);
            int n = this.pauseAtFrameId = oldPauseAtFrameIdPosition != null ? this.toFrameID(oldPauseAtFrameIdPosition) : -1;
            if (isPlayingEnabled) {
                this.play();
            }
            this.firePropertyChange("speed", oldSpeed, this.speed);
        }
    }

    public double getSpeed() {
        return this.speed;
    }

    public void setPlayDirectionForward(boolean playDirectionForward) {
        boolean oldPlayDirectionForward = this.playDirectionForward;
        this.playDirectionForward = playDirectionForward;
        this.firePropertyChange("playDirectionForward", oldPlayDirectionForward, playDirectionForward);
    }

    public boolean isPlayDirectionForward() {
        return this.playDirectionForward;
    }

    public void play() {
        if (this.isValidState && !this.isPlaying()) {
            this.playTimer.start();
        }
    }

    public void pause() {
        if (this.isPlaying()) {
            this.playTimer.stop();
            this.pauseAtFrameId = -1;
        }
    }

    private void nextFrame() {
        if (this.isValidState) {
            this.fireAnimationEvent(this.newAnimationEvent(this.newAnimationPosition_FrameIdIncluded(this.frameId + (this.isPlayDirectionForward() ? 1 : -1))));
        }
    }

    public void playTo(AnimationPosition position) throws IllegalArgumentException {
        if (this.isValidState) {
            this.pauseAt(position);
            this.play();
        }
    }

    public void pauseAt(AnimationPosition position) throws IllegalArgumentException {
        if (this.isValidState) {
            int frameIdOfPosition = this.toFrameID(position);
            if (frameIdOfPosition >= 0) {
                this.pauseAtFrameId = frameIdOfPosition;
            } else {
                throw new IllegalArgumentException("Unable to decipher the specified position.");
            }
        }
    }

    public void skipTo(AnimationPosition position) throws IllegalArgumentException {
        if (this.isValidState) {
            int frameIdOfPosition = this.toFrameID(position);
            if (frameIdOfPosition >= 0) {
                this.fireAnimationEvent(this.newAnimationEvent(this.newAnimationPosition_FrameIdIncluded(frameIdOfPosition)));
            } else {
                throw new IllegalArgumentException("Unable to decipher the specified position.");
            }
        }
    }

    public boolean isPlaying() {
        return this.playTimer.isRunning();
    }

    public AnimationPosition getAnimationPosition() {
        return this.animationPosition;
    }

    public void setRepeatEnabled(boolean repeatEnabled) {
        boolean oldRepeatEnabled = repeatEnabled;
        this.repeatEnabled = repeatEnabled;
        this.firePropertyChange("repeatEnabled", oldRepeatEnabled, this.repeatEnabled);
    }

    public boolean isRepeatEnabled() {
        return this.repeatEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAnimationListener(AnimationListener animationListener) {
        Set set = this.animationListeners;
        synchronized (set) {
            this.animationListeners.add(animationListener);
        }
        if (this.isValidState) {
            this.fireAnimationEvent(animationListener, new AnimationEvent(this, this.animationPosition, this.animationPosition.getKeyFrame1().toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAnimationListener(AnimationListener animationListener) {
        Set set = this.animationListeners;
        synchronized (set) {
            this.animationListeners.remove(animationListener);
        }
    }

    public void fireAnimationEvent() {
        this.fireAnimationEvent(this.newAnimationEvent(this.newAnimationPosition_FrameIdIncluded(this.frameId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAnimationEvent(AnimationEvent animationEvent) {
        if (this.isValidState) {
            this.animationPosition = animationEvent.getAnimationPosition();
            this.frameId = this.toFrameID(this.animationPosition);
            if (this.frameId == this.pauseAtFrameId && this.isPlaying() || !this.repeatEnabled && this.frameId == this.frameIdOfLastKeyFrame) {
                this.pause();
            }
            Set set = this.animationListeners;
            synchronized (set) {
                AnimationListener[] animationListenersArray = this.animationListeners.toArray(EmptyAnimationListenerArray);
                for (int ii = 0; ii < animationListenersArray.length; ++ii) {
                    AnimationListener animationListener = animationListenersArray[ii];
                    this.fireAnimationEvent(animationListener, animationEvent);
                }
            }
        }
    }

    private void fireAnimationEvent(final AnimationListener animationListener, final AnimationEvent animationEvent) {
        if (this.isValidState && animationListener != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    animationListener.animationChanged(animationEvent);
                }
            });
        }
    }

    private AnimationPosition newAnimationPosition_FrameIdIncluded(int frameId) {
        return this._newAnimationPosition_(frameId, true);
    }

    private AnimationPosition newAnimationPosition(int frameId) {
        return this._newAnimationPosition_(frameId, false);
    }

    private AnimationPosition _newAnimationPosition_(int frameId, boolean includeFrameId) {
        if (this.isValidState) {
            while (frameId < 0) {
                frameId += this.totalFrameCount;
            }
            int keyFrame1Index = (frameId %= this.totalFrameCount) / this.frameIntervalCount;
            int keyFrame2Index = (keyFrame1Index + 1) % this.uniqueKeyFrameValues.length;
            int inbetweenId = frameId % this.frameIntervalCount;
            double interpolationPercent = (double)inbetweenId / (double)this.frameIntervalCount;
            Object keyFrame1 = this.uniqueKeyFrameValues[keyFrame1Index];
            Object keyFrame2 = this.uniqueKeyFrameValues[keyFrame2Index];
            AnimationPosition animationPosition = includeFrameId ? new SpecialAnimationPosition(keyFrame1, keyFrame2, interpolationPercent, frameId) : new AnimationPosition(keyFrame1, keyFrame2, interpolationPercent);
            return animationPosition;
        }
        return null;
    }

    private AnimationEvent newAnimationEvent(AnimationPosition animationPosition) {
        if (animationPosition == null) {
            return null;
        }
        return new AnimationEvent(this, animationPosition, animationPosition.getKeyFrame1().toString());
    }

    private AnimationPosition absolutePosition(AnimationPosition position) {
        if (AnimationPosition.NEXT_KEY_FRAME == position) {
            position = this.nextKeyFramePosition();
        } else if (AnimationPosition.PREVIOUS_KEY_FRAME == position) {
            position = this.previousKeyFramePosition();
        } else if (AnimationPosition.NEXT_FRAME == position) {
            position = this.nextFramePosition();
        } else if (AnimationPosition.PREVIOUS_FRAME == position) {
            position = this.previousFramePosition();
        }
        return position;
    }

    private AnimationPosition previousFramePosition() {
        if (this.isValidState) {
            int frameIdOfPreviousFrame = (this.frameId == 0 ? this.totalFrameCount : this.frameId) - 1;
            return this.newAnimationPosition_FrameIdIncluded(frameIdOfPreviousFrame);
        }
        return null;
    }

    private AnimationPosition nextFramePosition() {
        if (this.isValidState) {
            int frameIdOfNextFrame = (this.frameId + 1) % this.totalFrameCount;
            return this.newAnimationPosition_FrameIdIncluded(frameIdOfNextFrame);
        }
        return null;
    }

    private AnimationPosition previousKeyFramePosition() {
        if (this.isValidState) {
            int currentKeyFrameIndex = this.frameId / this.frameIntervalCount;
            int previousKeyFrameIndex = (currentKeyFrameIndex == 0 ? this.uniqueKeyFrameValues.length : currentKeyFrameIndex) - 1;
            int frameIdOfNextKeyFrame = previousKeyFrameIndex * this.frameIntervalCount;
            return this.newAnimationPosition_FrameIdIncluded(frameIdOfNextKeyFrame);
        }
        return null;
    }

    private AnimationPosition nextKeyFramePosition() {
        if (this.isValidState) {
            int currentKeyFrameIndex = this.frameId / this.frameIntervalCount;
            int nextKeyFrameIndex = (currentKeyFrameIndex + 1) % this.uniqueKeyFrameValues.length;
            int frameIdOfNextKeyFrame = nextKeyFrameIndex * this.frameIntervalCount;
            return this.newAnimationPosition_FrameIdIncluded(frameIdOfNextKeyFrame);
        }
        return null;
    }

    private int toFrameID(AnimationPosition position) {
        if (position instanceof SpecialAnimationPosition) {
            return ((SpecialAnimationPosition)position).getFrameId();
        }
        if (this.isValidState && position != null) {
            int keyFrame1Index;
            position = this.absolutePosition(position);
            Object keyFrame1 = position.getKeyFrame1();
            Object keyFrame2 = position.getKeyFrame2();
            double interpolationPercent = position.getInterpolationPercent();
            if (interpolationPercent == 1.0) {
                keyFrame1 = keyFrame2;
                interpolationPercent = 0.0;
            }
            if ((keyFrame1Index = this.getKeyFrameIndex(keyFrame1)) >= 0) {
                if (interpolationPercent == 0.0) {
                    int frameIdOfPosition = keyFrame1Index * this.frameIntervalCount;
                    return frameIdOfPosition;
                }
                int keyFrame2Index = (keyFrame1Index + 1) % this.uniqueKeyFrameValues.length;
                if (keyFrame2.equals(this.uniqueKeyFrameValues[keyFrame2Index])) {
                    int frameIdOfPosition = keyFrame1Index * this.frameIntervalCount + (int)(interpolationPercent * (double)this.frameIntervalCount + 0.5);
                    return frameIdOfPosition;
                }
            }
        }
        return -1;
    }

    protected final void setContainedModel(String property, ModelBase containedModel) {
        this.containedModelSupport.put(property, containedModel);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void enablePropertyChange() {
        this.eventGate = Math.max(0, this.eventGate - 1);
    }

    public void disablePropertyChange() {
        ++this.eventGate;
    }

    private void firePropertyChange(PropertyChangeEvent e) {
        if (this.eventGate == 0) {
            String pn;
            String string = pn = e == null ? "n/a" : e.getPropertyName();
            if (pn.equals("") || pn.equals("tableModel") || pn.equals("keyFrameVariable")) {
                this.stateChanged();
            }
            this.propertyChangeSupport.firePropertyChange(e);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldProperty, newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, ModelBase oldProperty, ModelBase newProperty) {
        if (propertyName != null) {
            if (!"".equals(propertyName)) {
                this.containedModelSupport.put(propertyName, newProperty);
            }
            this.firePropertyChange(propertyName, (Object)oldProperty, (Object)newProperty);
        }
    }

    protected void firePropertyChange(String propertyName, double oldProperty, double newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Double(oldProperty), new Double(newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldProperty, boolean newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Boolean(oldProperty), new Boolean(newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, int oldProperty, int newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Integer(oldProperty), new Integer(newProperty));
        }
    }

    private class ContainedModelSupport {
        private final Hashtable containedModels = new Hashtable();
        private final PropertyChangeListener containedModelPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Enumeration keys = ContainedModelSupport.this.containedModels.keys();
                while (keys.hasMoreElements()) {
                    String property = (String)keys.nextElement();
                    ModelBase model = (ModelBase)ContainedModelSupport.this.containedModels.get(property);
                    if (e.getSource() != model) continue;
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(AnimationDirector.this, property, null, e.getSource());
                    propertyChangeEvent.setPropagationId(e);
                    AnimationDirector.this.firePropertyChange(propertyChangeEvent);
                }
            }
        };

        private ContainedModelSupport() {
        }

        public void put(String property, ModelBase containedModel) {
            if (property != null) {
                ModelBase oldContainedModel = (ModelBase)(containedModel == null ? this.containedModels.remove(property) : this.containedModels.put(property, containedModel));
                if (oldContainedModel != null) {
                    oldContainedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
                }
                if (containedModel != null) {
                    containedModel.addPropertyChangeListener(this.containedModelPropertyChangeListener);
                }
            }
        }

        public void remove(String property) {
            ModelBase containedModel;
            if (property != null && (containedModel = (ModelBase)this.containedModels.remove(property)) != null) {
                containedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
            }
        }
    }

    private static class SpecialAnimationPosition
    extends AnimationPosition {
        private final int frameId;

        public SpecialAnimationPosition(Object keyFrame1, Object keyFrame2, double interpolationPercent, int frameId) throws IllegalArgumentException {
            super(keyFrame1, keyFrame2, interpolationPercent);
            this.frameId = frameId;
        }

        public int getFrameId() {
            return this.frameId;
        }
    }
}

