/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components.animation;

import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.animation.AnimationDirector;
import com.sas.graphics.components.animation.AnimationEvent;
import com.sas.graphics.components.animation.AnimationListener;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import com.sas.visuals.GraphResources;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalButtonUI;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalSliderUI;
import javax.swing.table.TableModel;

public class AnimationControlPanel
extends JPanel {
    private JSlider animationSlider;
    private JSlider speedSlider;
    private ToggleButton playButton;
    private ToggleButton loopButton;
    private SliderButton nextButton;
    private SliderButton previousButton;
    private LabelComponent animationLabel;
    private LabelComponent animationValue;
    private LabelComponent speedLabel;
    private JPanel animationSliderPanel;
    private JPanel animationValuePanel;
    private JPanel speedSliderPanel;
    private InsideBorder ppnPanelBorder;
    private InsideBorder loopPanelBorder;
    private TextStyle dataTipTextStyle;
    private TextStyle labelTextStyle;
    private TextStyle valueTextStyle;
    private AnimationDirector animationDirector;
    private AnimationListener animationListener;
    private TableModelListener tableModelListener;
    private PropertyChangeListener modelPropertyChangeListener;
    private Object[] keyframeValues;
    private boolean flashy;
    private boolean showAnimationValue;
    private boolean snapToTickMarks;
    private boolean animating;
    private boolean sendChangesToAnimationDirector;
    private final Object updateLock = new Object();
    private static final ImageIcon nextIcon = AnimationControlPanel._newImageIcon("res/VCRNext.png");
    private static final ImageIcon nextIconD = AnimationControlPanel._newImageIcon("res/VCRNext_disabled.png");
    private static final ImageIcon prevIcon = AnimationControlPanel._newImageIcon("res/VCRPrevious.png");
    private static final ImageIcon prevIconD = AnimationControlPanel._newImageIcon("res/VCRPrevious_disabled.png");
    private static final ImageIcon playIcon = AnimationControlPanel._newImageIcon("res/VCRPlay.png");
    private static final ImageIcon stopIcon = AnimationControlPanel._newImageIcon("res/VCRPause.png");
    private static final ImageIcon loopIcon = AnimationControlPanel._newImageIcon("res/VCRLoop.png");
    private static final ImageIcon noloopIcon = AnimationControlPanel._newImageIcon("res/VCRNoLoop.png");
    private static final ImageIcon thumbIcon = AnimationControlPanel._newImageIcon("res/VCRSliderKnob.png");
    private static final String PLAY_COMMAND = RB.getStringResource("Animation.play.txt");
    private static final String STOP_COMMAND = RB.getStringResource("Animation.stopPlaying.txt");
    private static final String NEXT_COMMAND = RB.getStringResource("Animation.next.txt");
    private static final String PREV_COMMAND = RB.getStringResource("Animation.previous.txt");
    private static final String LOOP_COMMAND = RB.getStringResource("Animation.loop.txt");
    private static final String NOLOOP_COMMAND = RB.getStringResource("Animation.stopLooping.txt");
    private static final int speedSliderMin = 1;
    private static final int speedSliderDefault = 10;
    private static final int speedSliderMax = 100;
    private static final int speedSliderRange = 99;
    private static final double speedMin = 0.1;
    private static final double speedMax = 7.5;
    private static final double speedRange = 7.4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnimationControlPanel(AnimationDirector animationDirector) {
        this._initListeners();
        this.setEnabled(false);
        Object object = this.updateLock;
        synchronized (object) {
            this.sendChangesToAnimationDirector = false;
            this.setAnimationDirector(animationDirector);
            this.setSnappingToTickMarks(true);
            this._initGui();
            this.sendChangesToAnimationDirector = true;
        }
        this.setEnabled(true);
        this._resetGuiState();
    }

    public AnimationDirector getAnimationDirector() {
        return this.animationDirector;
    }

    public void setAnimationDirector(AnimationDirector animationDirector) {
        if (this.animationDirector != null) {
            this.animationDirector.removeAnimationListener(this.animationListener);
            this.animationDirector.removePropertyChangeListener(this.modelPropertyChangeListener);
            if (this.animationDirector instanceof TableModel) {
                ((TableModel)((Object)this.animationDirector)).removeTableModelListener(this.tableModelListener);
            }
        }
        this.animationDirector = animationDirector;
        if (this.animationDirector != null) {
            this.animationDirector.addAnimationListener(this.animationListener);
            this.animationDirector.addPropertyChangeListener(this.modelPropertyChangeListener);
            if (this.animationDirector instanceof TableModel) {
                ((TableModel)((Object)this.animationDirector)).addTableModelListener(this.tableModelListener);
            }
        }
        this._refreshGuiFromAnimationDirector();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _refreshGuiFromAnimationDirector() {
        if (this.animationSlider == null) {
            return;
        }
        Object object = this.updateLock;
        synchronized (object) {
            boolean send = this.sendChangesToAnimationDirector;
            this.sendChangesToAnimationDirector = false;
            if (this.animationDirector != null) {
                this.keyframeValues = this.animationDirector.getUniqueKeyFrameValues();
                if (this.keyframeValues == null) {
                    this.keyframeValues = new String[]{""};
                }
                this.speedSlider.setValue(this._speedToSliderPosition(this.animationDirector.getSpeed()));
                if (this.animationValue == null) {
                    this.animationValue = new LabelComponent("", this.valueTextStyle);
                    if (this.animationValuePanel != null) {
                        this.animationValuePanel.add((Component)this.animationValue, "Center");
                    }
                }
                if (this.animationLabel == null) {
                    this.animationLabel = new LabelComponent("", this.labelTextStyle);
                    this.animationLabel.setMargin(new Insets(0, 20, 0, 0));
                    if (this.animationSliderPanel != null) {
                        this.animationSliderPanel.add((Component)this.animationLabel, "West");
                    }
                }
                if (this.speedLabel == null) {
                    String speelLabelString = RB.getStringResource("Animation.speed.txt") + ":";
                    this.speedLabel = new LabelComponent(speelLabelString, this.labelTextStyle);
                    this.speedLabel.setMargin(new Insets(0, 20, 0, 0));
                    if (this.speedSliderPanel != null) {
                        this.speedSliderPanel.add((Component)this.speedLabel, "West");
                    }
                }
                this.animationSlider.setMaximum(this.keyframeValues.length - 1);
                int kfi = this._findSliderPosition(this.animationDirector.getAnimationPosition());
                this.animationSlider.setValue(kfi);
                this._setAnimationValueFromKeyframeObject(this.keyframeValues[kfi]);
                ClassificationVariable kfv = this.animationDirector.getKeyFrameVariable();
                String animationLabelString = kfv.getLabel();
                if (animationLabelString == null) {
                    animationLabelString = kfv.getColumnName();
                }
                if (animationLabelString != null) {
                    animationLabelString = animationLabelString.trim();
                }
                animationLabelString = animationLabelString != null && animationLabelString.length() > 0 ? animationLabelString + ":" : "";
                this.animationLabel.setLabel(animationLabelString);
            } else {
                this.keyframeValues = null;
                this.speedSlider.setValue(10);
                this.animationSlider.setMaximum(1);
                this.animationSlider.setValue(0);
                this._setAnimationValueFromKeyframeObject("");
                if (this.animationLabel != null) {
                    this.animationLabel.setLabel("");
                }
                if (this.animationValue != null) {
                    this.animationValue.setLabel("");
                }
            }
            this.sendChangesToAnimationDirector = send;
        }
        this._setAnimationValuePreferredSize();
        this._resetGuiState();
    }

    public TextStyle getLabelTextStyle() {
        return this.labelTextStyle;
    }

    public void setLabelTextStyle(TextStyle labelTextStyle) {
        if (labelTextStyle == null) {
            throw new IllegalArgumentException();
        }
        if (this.labelTextStyle != null) {
            this.labelTextStyle.removePropertyChangeListener(this.modelPropertyChangeListener);
        }
        if (labelTextStyle != this.labelTextStyle) {
            this.labelTextStyle = labelTextStyle;
            if (this.animationLabel != null) {
                this.animationLabel.setTextStyle(labelTextStyle);
            }
            if (this.speedLabel != null) {
                this.speedLabel.setTextStyle(labelTextStyle);
            }
            labelTextStyle.addPropertyChangeListener(this.modelPropertyChangeListener);
        }
    }

    public TextStyle getValueTextStyle() {
        return this.valueTextStyle;
    }

    public void setValueTextStyle(TextStyle valueTextStyle) {
        if (valueTextStyle == null) {
            throw new IllegalArgumentException();
        }
        if (this.valueTextStyle != null) {
            this.valueTextStyle.removePropertyChangeListener(this.modelPropertyChangeListener);
        }
        if (valueTextStyle != this.valueTextStyle) {
            this.valueTextStyle = valueTextStyle;
            if (this.animationValue != null) {
                this.animationValue.setTextStyle(valueTextStyle);
            }
            valueTextStyle.addPropertyChangeListener(this.modelPropertyChangeListener);
        }
    }

    public TextStyle getDataTipTextStyle() {
        return this.dataTipTextStyle;
    }

    public void setDataTipTextStyle(TextStyle dataTipTextStyle) {
        if (dataTipTextStyle == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataTipTextStyle != null) {
            this.dataTipTextStyle.removePropertyChangeListener(this.modelPropertyChangeListener);
        }
        if (dataTipTextStyle != this.dataTipTextStyle) {
            this.dataTipTextStyle = dataTipTextStyle;
            dataTipTextStyle.addPropertyChangeListener(this.modelPropertyChangeListener);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        this.setOpaque(c != null && c.getAlpha() == 255);
    }

    @Override
    public void paint(Graphics g) {
        Object antialiasingHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        super.paint(g);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialiasingHint);
    }

    private boolean isSnappingToTickMarks() {
        return this.snapToTickMarks;
    }

    private void setSnappingToTickMarks(boolean snap) {
        if (this.animationSlider != null) {
            this.animationSlider.setSnapToTicks(snap);
        }
        this.snapToTickMarks = snap;
    }

    private void _setShowingAnimationValue(boolean show) {
        if (show != this.showAnimationValue) {
            this.showAnimationValue = show;
            if (this.animationValuePanel != null) {
                if (show) {
                    this.animationSliderPanel.add((Component)this.animationValuePanel, "East");
                    this._setAnimationValuePreferredSize();
                } else {
                    this.animationSliderPanel.remove(this.animationValuePanel);
                }
                this.animationSliderPanel.repaint();
            }
        }
    }

    private void setSkin(int skin) {
        this.flashy = skin == 12302;
    }

    private void _initListeners() {
        this.modelPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getSource() == AnimationControlPanel.this.animationDirector) {
                    AnimationControlPanel.this._refreshGuiFromAnimationDirector();
                } else if (e.getSource() == AnimationControlPanel.this.valueTextStyle) {
                    AnimationControlPanel.this._setShowingAnimationValue(AnimationControlPanel.this.valueTextStyle.isVisible());
                    if (AnimationControlPanel.this.animationValue != null) {
                        AnimationControlPanel.this.animationValue.repaint();
                    }
                } else if (e.getSource() == AnimationControlPanel.this.labelTextStyle) {
                    if (AnimationControlPanel.this.animationLabel != null) {
                        AnimationControlPanel.this.animationLabel.repaint();
                    }
                    if (AnimationControlPanel.this.speedLabel != null) {
                        AnimationControlPanel.this.speedLabel.repaint();
                    }
                }
            }
        };
        this.animationListener = new AnimationListener(){

            @Override
            public void animationChanged(AnimationEvent e) {
                AnimationControlPanel.this.animationChanged(e);
            }
        };
        this.tableModelListener = new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AnimationControlPanel.this._refreshGuiFromAnimationDirector();
            }
        };
    }

    private void _initGui() {
        this.removeAll();
        this.setSkin(12302);
        GridBagLayout gb = new GridBagLayout();
        GridBagConstraints gbConstraints = new GridBagConstraints();
        this.previousButton = new SliderButton(prevIcon, PREV_COMMAND);
        this.previousButton.setDisabledIcon(prevIconD);
        this.previousButton.setUI(new AnimationButtonUI());
        if (this.flashy) {
            this.previousButton.setRadius(-1);
        }
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnimationControlPanel.this.animationDirector != null) {
                    AnimationControlPanel.this.animationDirector.skipTo(AnimationPosition.PREVIOUS_KEY_FRAME);
                }
            }
        });
        this.playButton = new ToggleButton(playIcon, PLAY_COMMAND, stopIcon, STOP_COMMAND);
        this.playButton.setUI(new AnimationButtonUI());
        if (this.flashy) {
            this.playButton.setRadius(-1);
        }
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnimationControlPanel.this.animationDirector != null) {
                    if (!AnimationControlPanel.this.animating) {
                        AnimationControlPanel.this.animationDirector.play();
                    } else {
                        AnimationControlPanel.this.animationDirector.pause();
                    }
                }
                AnimationControlPanel.this._resetGuiState();
            }
        });
        this.nextButton = new SliderButton(nextIcon, NEXT_COMMAND);
        this.nextButton.setDisabledIcon(nextIconD);
        this.nextButton.setUI(new AnimationButtonUI());
        if (this.flashy) {
            this.nextButton.setRadius(-1);
        }
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnimationControlPanel.this.animationDirector != null) {
                    AnimationControlPanel.this.animationDirector.skipTo(AnimationPosition.NEXT_KEY_FRAME);
                }
            }
        });
        this.loopButton = new ToggleButton(loopIcon, LOOP_COMMAND, noloopIcon, NOLOOP_COMMAND);
        this.loopButton.setUI(new AnimationButtonUI());
        if (this.flashy) {
            this.loopButton.setRadius(-1);
        }
        this.loopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AnimationControlPanel.this.animationDirector != null) {
                    AnimationControlPanel.this.animationDirector.setRepeatEnabled(!AnimationControlPanel.this.animationDirector.isRepeatEnabled());
                }
                AnimationControlPanel.this._resetGuiState();
            }
        });
        Color internalBorderColor = new Color(90, 139, 228);
        JPanel ppnPanel = new JPanel();
        ppnPanel.setOpaque(false);
        this.ppnPanelBorder = new InsideBorder(internalBorderColor, this.flashy ? -1 : 3);
        ppnPanel.setBorder(new CompoundBorder(this.ppnPanelBorder, new EmptyBorder(1, 2, 1, 2)));
        ppnPanel.setLayout(new FlowLayout(0, 0, 0));
        ppnPanel.add(this.previousButton);
        ppnPanel.add(this.playButton);
        ppnPanel.add(this.nextButton);
        JPanel loopPanel = new JPanel();
        loopPanel.setOpaque(false);
        this.loopPanelBorder = new InsideBorder(internalBorderColor, this.flashy ? -1 : 3);
        loopPanel.setBorder(new CompoundBorder(this.loopPanelBorder, new EmptyBorder(1, 1, 1, 1)));
        loopPanel.setLayout(new BorderLayout());
        loopPanel.add((Component)this.loopButton, "West");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setOpaque(false);
        buttonPanel.add(ppnPanel);
        buttonPanel.add(loopPanel);
        FlowLayout fl = new FlowLayout();
        fl.setHgap(0);
        buttonPanel.setLayout(fl);
        buttonPanel.setBorder(new EmptyBorder(1, 5, 0, 0));
        gbConstraints.anchor = 21;
        gbConstraints.weightx = 3.0;
        gb.setConstraints(buttonPanel, gbConstraints);
        this.animationSliderPanel = new JPanel();
        this.animationSliderPanel.setOpaque(false);
        this.animationSliderPanel.setLayout(new BorderLayout());
        if (this.animationLabel != null) {
            this.animationSliderPanel.add((Component)this.animationLabel, "West");
        }
        this.animationSlider = new JSlider(0, 1, 0);
        this.animationSlider.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                if (AnimationControlPanel.this.keyframeValues != null) {
                    Object currentValue = AnimationControlPanel.this.keyframeValues[AnimationControlPanel.this.animationSlider.getValue()];
                    AnimationControlPanel.this._setAnimationValueFromKeyframeObject(currentValue);
                    Object object = AnimationControlPanel.this.updateLock;
                    synchronized (object) {
                        if (AnimationControlPanel.this.sendChangesToAnimationDirector && AnimationControlPanel.this.animationDirector != null) {
                            AnimationControlPanel.this.animationDirector.skipTo(new AnimationPosition(currentValue));
                        }
                    }
                }
            }
        });
        this.animationSlider.setUI(new AnimationSliderUI());
        this.animationSlider.setOpaque(false);
        this.animationSlider.setSnapToTicks(this.snapToTickMarks);
        this.animationSliderPanel.add((Component)this.animationSlider, "Center");
        this.setValueTextStyle(new TextStyle());
        this.setLabelTextStyle(new TextStyle());
        this.setDataTipTextStyle(new TextStyle());
        this.valueTextStyle.setJustification(2);
        this.valueTextStyle.setVisible(false);
        this.animationValuePanel = new JPanel(new BorderLayout());
        this.animationValuePanel.setOpaque(false);
        if (this.animationValue != null) {
            this.animationValuePanel.add((Component)this.animationValue, "Center");
            this._setAnimationValuePreferredSize();
        }
        gbConstraints.weightx = 20.0;
        gbConstraints.fill = 2;
        gb.setConstraints(this.animationSliderPanel, gbConstraints);
        this.speedSliderPanel = new JPanel();
        this.speedSliderPanel.setOpaque(false);
        this.speedSliderPanel.setLayout(new BorderLayout());
        if (this.speedLabel != null) {
            this.speedSliderPanel.add((Component)this.speedLabel, "West");
        }
        this.speedSlider = new JSlider(1, 100, 1);
        this.speedSlider.setUI(new AnimationSliderUI());
        this.speedSlider.setOpaque(false);
        this.speedSlider.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent e) {
                Object object = AnimationControlPanel.this.updateLock;
                synchronized (object) {
                    if (AnimationControlPanel.this.sendChangesToAnimationDirector && AnimationControlPanel.this.animationDirector != null) {
                        double sv = AnimationControlPanel.this._sliderPositionToSpeed(AnimationControlPanel.this.speedSlider.getValue());
                        if (sv > 6.5625) {
                            sv = AnimationControlPanel.this.animationDirector.getFrameRate();
                        }
                        if (sv != AnimationControlPanel.this.animationDirector.getSpeed()) {
                            AnimationControlPanel.this.animationDirector.setSpeed(sv);
                        }
                    }
                }
            }
        });
        this.speedSliderPanel.add((Component)this.speedSlider, "Center");
        gbConstraints.anchor = 22;
        gbConstraints.weightx = 15.0;
        gbConstraints.fill = 2;
        gb.setConstraints(this.speedSliderPanel, gbConstraints);
        this.setLayout(gb);
        this.add(buttonPanel);
        this.add(this.animationSliderPanel);
        this.add(this.speedSliderPanel);
        this.setBackground(this.getBackground());
        this._refreshGuiFromAnimationDirector();
    }

    private int _speedToSliderPosition(double speed) {
        return (int)this._linearInterpolation(speed, 0.1, 7.4, 1.0, 99.0, 100.0);
    }

    private double _sliderPositionToSpeed(int sliderPosition) {
        return this._linearInterpolation(sliderPosition, 1.0, 99.0, 0.1, 7.4, 7.5);
    }

    private double _linearInterpolation(double x, double xMin, double xRange, double yMin, double yRange, double yMax) {
        double y = (x - xMin) / xRange * yRange + yMin;
        if (y < yMin) {
            y = yMin;
        }
        if (y > yMax) {
            y = yMax;
        }
        return y;
    }

    private void _resetGuiState() {
        boolean en = this.animationDirector != null && this.isEnabled();
        boolean repeating = this.animationDirector != null && this.animationDirector.isRepeatEnabled();
        this.animating = this.animationDirector != null && this.animationDirector.isPlaying();
        this.playButton.setEnabled(en);
        this.nextButton.setEnabled(en && !this.animating);
        this.previousButton.setEnabled(en && !this.animating);
        this.loopButton.setEnabled(en);
        this.playButton.setState(en && this.animating);
        this.loopButton.setState(en && repeating);
        this.speedSlider.setEnabled(en);
        this.animationSlider.setEnabled(en);
        if (this.speedLabel != null) {
            this.speedLabel.setEnabled(en);
        }
        if (this.animationLabel != null) {
            this.animationLabel.setEnabled(en);
        }
    }

    private void _setAnimationValueFromKeyframeObject(Object keyframe) {
        String fName;
        if (keyframe == null) {
            return;
        }
        String text = keyframe.toString().trim();
        if (this.animationDirector != null && this.animationDirector.getKeyFrameVariable() != null && (fName = this.animationDirector.getKeyFrameVariable().getFormat()) != null && fName.length() > 0) {
            SASFormat f = SASFormat.getInstance((String)fName);
            if (f instanceof SASNumericFormat) {
                if (keyframe instanceof Number) {
                    text = f.format(keyframe);
                }
            } else if (f instanceof SASDateTimeFormat) {
                if (keyframe instanceof Number || keyframe instanceof Date) {
                    text = f.format(keyframe);
                }
            } else {
                text = f.format((Object)keyframe.toString());
            }
        }
        this._setAnimationValueText(text);
    }

    private void _setAnimationValueText(String text) {
        if (this.animationValue != null) {
            this.animationValue.setLabel(text);
            if (this.valueTextStyle != null && this.valueTextStyle.isVisible() && this.showAnimationValue) {
                this.animationValue.repaint();
            }
        }
        if (this.animationSlider != null) {
            this.animationSlider.setToolTipText(text);
        }
    }

    private void _setAnimationValuePreferredSize() {
        if (this.animationValuePanel != null) {
            int maxw = 0;
            int maxh = 0;
            if (this.animationValue != null && this.keyframeValues != null && this.showAnimationValue) {
                String oldLabel = this.animationValue.getLabel();
                for (int i = 0; i < this.keyframeValues.length; ++i) {
                    this._setAnimationValueFromKeyframeObject(this.keyframeValues[i]);
                    Dimension ps = this.animationValue.getPreferredSize();
                    maxw = Math.max(maxw, ps.width);
                    maxh = Math.max(maxh, ps.height);
                }
                this.animationValue.setLabel(oldLabel);
            }
            this.animationValuePanel.setPreferredSize(new Dimension(maxw, maxh));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void animationChanged(AnimationEvent e) {
        boolean playingNow;
        if (e == null || this.animationDirector == null || this.animationDirector != e.getSource() || !this.isEnabled()) {
            return;
        }
        AnimationPosition ap = e.getAnimationPosition();
        Object kf = ap.getInterpolationPercent() <= 100.0 ? ap.getKeyFrame1() : ap.getKeyFrame2();
        int i = this._findKeyframeIndex(kf);
        Object object = this.updateLock;
        synchronized (object) {
            boolean send = this.sendChangesToAnimationDirector;
            this.sendChangesToAnimationDirector = false;
            this.animationSlider.setValue(i);
            this.sendChangesToAnimationDirector = send;
        }
        this._setAnimationValueText(e.getAnimationPositionDisplayText());
        boolean bl = playingNow = this.animationDirector != null && this.animationDirector.isPlaying();
        if (playingNow != this.animating) {
            this._resetGuiState();
        }
    }

    private int _findKeyframeIndex(Object keyframe) {
        if (this.animationDirector != null) {
            int kfi = this.animationDirector.getKeyFrameIndex(keyframe);
            return kfi >= 0 ? kfi : 0;
        }
        return 0;
    }

    private int _findSliderPosition(AnimationPosition p) {
        if (p == null) {
            return 0;
        }
        Object keyframe = p.getInterpolationPercent() <= 0.5 ? p.getKeyFrame1() : p.getKeyFrame2();
        return this._findKeyframeIndex(keyframe);
    }

    private static ImageIcon _newImageIcon(String fileName) {
        return AnimationControlPanel._newImageIcon(fileName, false, false);
    }

    private static ImageIcon _newImageIcon(String fileName, boolean flipHorizontal, boolean flipVertical) {
        ImageIcon imageIcon = null;
        try {
            Image image = GraphResources.getImage((String)fileName);
            imageIcon = new ImageIcon(image, fileName);
            if (image != null && (flipHorizontal || flipVertical)) {
                int iw = imageIcon.getIconWidth();
                int ih = imageIcon.getIconHeight();
                BufferedImage bufferedImage = new BufferedImage(iw, ih, 2);
                Graphics2D ig = bufferedImage.createGraphics();
                imageIcon.paintIcon(null, ig, 0, 0);
                AffineTransform tx = AffineTransform.getScaleInstance(flipHorizontal ? -1.0 : 1.0, flipVertical ? -1.0 : 1.0);
                tx.translate(flipHorizontal ? (double)(-image.getWidth(null)) : 0.0, flipVertical ? (double)(-image.getHeight(null)) : 0.0);
                AffineTransformOp op = new AffineTransformOp(tx, 1);
                bufferedImage = op.filter(bufferedImage, null);
                imageIcon.setImage(bufferedImage);
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            System.err.println(RB.getStringResource("imageLoadFailed.ex.txt") + " " + fileName);
        }
        return imageIcon;
    }

    private class AnimationSliderUI
    extends MetalSliderUI {
        @Override
        public void installUI(JComponent c) {
            if (UIManager.get("Slider.trackWidth") == null) {
                UIManager.put("Slider.trackWidth", new Integer(3));
            }
            if (UIManager.get("Slider.majorTickLength") == null) {
                UIManager.put("Slider.majorTickLength", new Integer(3));
            }
            super.installUI(c);
            trackWidth = 3;
            horizThumbIcon = thumbIcon;
            vertThumbIcon = thumbIcon;
        }

        @Override
        public int getTrackWidth() {
            return trackWidth;
        }

        @Override
        protected Dimension getThumbSize() {
            return new Dimension(thumbIcon.getIconWidth(), thumbIcon.getIconHeight());
        }

        @Override
        public void paintThumb(Graphics g) {
            thumbIcon.paintIcon(this.slider, g, this.thumbRect.x, this.thumbRect.y);
        }

        @Override
        public void paintTrack(Graphics g) {
            int top = (int)((double)this.trackRect.y + (double)this.trackRect.height / 2.0 - (double)this.getTrackWidth() / 2.0);
            int left = this.trackRect.x;
            if (this.slider.isEnabled()) {
                g.setColor(new Color(162, 162, 162));
            } else {
                g.setColor(MetalLookAndFeel.getControlShadow());
            }
            g.fill3DRect(left, top + 1, this.trackRect.width, this.getTrackWidth() - 1, false);
        }

        @Override
        public void paintFocus(Graphics g) {
            g.setColor(this.getFocusColor());
            BasicGraphicsUtils.drawDashedRect(g, this.focusRect.x, this.focusRect.y, this.focusRect.width, this.focusRect.height);
        }

        protected void scrollDueToClickInTrack(MouseEvent e) {
        }

        @Override
        protected BasicSliderUI.TrackListener createTrackListener(JSlider slider) {
            return new TrackListener();
        }

        public class TrackListener
        extends BasicSliderUI.TrackListener {
            int thumbOffsetX;
            int thumbOffsetY;

            public TrackListener() {
                super(AnimationSliderUI.this);
                this.thumbOffsetX = 0;
                this.thumbOffsetY = 0;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!AnimationControlPanel.this.isSnappingToTickMarks()) {
                    super.mousePressed(e);
                    return;
                }
                if (!AnimationSliderUI.this.slider.isEnabled()) {
                    return;
                }
                if (AnimationSliderUI.this.thumbRect.contains(e.getX(), e.getY())) {
                    this.thumbOffsetX = e.getX() - (((AnimationSliderUI)AnimationSliderUI.this).thumbRect.x + ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.width / 2);
                    this.thumbOffsetY = e.getY() - (((AnimationSliderUI)AnimationSliderUI.this).thumbRect.y + ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.height / 2);
                    super.mousePressed(e);
                    return;
                }
                if (AnimationSliderUI.this.slider.isRequestFocusEnabled()) {
                    AnimationSliderUI.this.slider.requestFocus();
                }
                MouseEvent fakePressEvent = new MouseEvent((Component)e.getSource(), 501, e.getWhen(), e.getModifiers(), ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.x + ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.width / 2, ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.y + ((AnimationSliderUI)AnimationSliderUI.this).thumbRect.height / 2, 1, false);
                this.thumbOffsetY = 0;
                this.thumbOffsetX = 0;
                super.mousePressed(fakePressEvent);
                this.mouseDragged(e);
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (AnimationControlPanel.this.isSnappingToTickMarks()) {
                    switch (AnimationSliderUI.this.slider.getOrientation()) {
                        case 0: {
                            int oldX = e.getX();
                            int newX = AnimationSliderUI.this.xPositionForValue(AnimationSliderUI.this.valueForXPosition(oldX)) + this.thumbOffsetX;
                            e.translatePoint(newX - oldX, 0);
                            break;
                        }
                        default: {
                            int oldY = e.getY();
                            int newY = AnimationSliderUI.this.yPositionForValue(AnimationSliderUI.this.valueForYPosition(oldY)) + this.thumbOffsetY;
                            e.translatePoint(0, newY - oldY);
                        }
                    }
                }
                super.mouseDragged(e);
            }
        }
    }

    private class AnimationButtonUI
    extends MetalButtonUI {
        @Override
        protected void paintFocus(Graphics g, AbstractButton b, Rectangle view, Rectangle text, Rectangle icon) {
            Color buttonFocusColor = UIManager.getColor("Button.focus");
            g.setColor(buttonFocusColor);
            int p = 1;
            int q = p + p;
            BasicGraphicsUtils.drawDashedRect(g, icon.x - p, icon.y - p, icon.width + q, icon.height + q);
        }
    }

    private static class InsideBorder
    implements Border {
        private Color bc;
        private int r = 0;

        public InsideBorder(Color borderColor) {
            this(borderColor, 0);
        }

        public InsideBorder(Color borderColor, int radius) {
            this.setColor(borderColor);
            this.setRadius(radius);
        }

        public void setColor(Color borderColor) {
            this.bc = borderColor;
        }

        public Color getColor() {
            return this.bc;
        }

        public void setRadius(int radius) {
            this.r = radius;
        }

        public int getRadius() {
            return this.r;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return new Insets(1, 1, 1, 1);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Color c0;
            Color c1;
            Color c2;
            if (this.bc != null) {
                c1 = c2 = this.bc;
                c0 = c2;
            } else {
                c0 = c.getBackground().darker().darker();
                c1 = c.getBackground().darker();
                c2 = c.getBackground().brighter().brighter();
            }
            int x0 = x;
            int x1 = x + width - 1;
            int y0 = y;
            int y1 = y + height - 1;
            int maxr = Math.min(width, height) / 2;
            int er = this.r == -1 ? maxr : Math.min(this.r, maxr);
            int aw = er + er;
            int ah = er + er;
            if (this.bc != null && width == height && aw >= width) {
                g.setColor(c0);
                g.drawOval(x0, y0, width - 1, height - 1);
            } else if (this.bc != null && width < height && aw >= width) {
                g.setColor(c0);
                g.drawArc(x0, y0, aw, ah, 0, 180);
                g.drawArc(x0, y1 - ah, aw, ah, 180, 180);
                g.drawLine(x1, y0 + er, x1, y1 - er);
                g.drawLine(x0, y1 - er, x0, y0 + er);
            } else if (this.bc != null && height < width && ah >= height) {
                g.setColor(c0);
                g.drawArc(x0, y0, aw, ah, 90, 180);
                g.drawArc(x1 - aw, y0, aw, ah, 270, 180);
                g.drawLine(x0 + er, y0, x1 - er, y0);
                g.drawLine(x0 + er, y1, x1 - er, y1);
            } else {
                g.setColor(c0);
                g.drawLine(x0, y1 - er, x0, y0 + er);
                g.drawArc(x0, y0, aw, ah, 90, 90);
                g.drawLine(x0 + er, y0, x1 - er, y0);
                g.drawArc(x1 - aw, y0, aw, ah, 60, 30);
                g.setColor(c1);
                g.drawArc(x1 - aw, y0, aw, ah, 30, 30);
                g.setColor(c2);
                g.drawArc(x1 - aw, y0, aw, ah, 0, 30);
                g.drawLine(x1, y0 + er, x1, y1 - er);
                g.drawArc(x1 - aw, y1 - ah, aw, ah, 270, 90);
                g.drawLine(x1 - er, y1, x0 + er, y1);
                g.drawArc(x0, y1 - ah, aw, ah, 240, 30);
                g.setColor(c1);
                g.drawArc(x0, y1 - ah, aw, ah, 210, 30);
                g.setColor(c0);
                g.drawArc(x0, y1 - ah, aw, ah, 180, 30);
            }
        }
    }

    private static class ToggleButton
    extends SliderButton {
        boolean remainDepressedWhileOn = false;
        boolean state;
        ImageIcon onIcon;
        ImageIcon offIcon;
        String onActionCommand;
        String offActionCommand;

        protected ToggleButton(ImageIcon onIcon, String onActionCommand, ImageIcon offIcon, String offActionCommand) {
            this.setToolTipText(onActionCommand);
            this.onActionCommand = onActionCommand;
            this.offActionCommand = offActionCommand;
            this.onIcon = onIcon;
            this.offIcon = offIcon;
            this.init();
            this.setState(false);
        }

        @Override
        public void releaseButton() {
            if (!this.remainDepressedWhileOn) {
                super.releaseButton();
            }
        }

        public void setState(boolean newState) {
            this.state = newState;
            if (this.remainDepressedWhileOn) {
                this.loweredBorder.setColor(this.state ? this.loweredColor : this.raisedColor);
            }
            if (this.state) {
                if (this.offIcon != null) {
                    this.setIcon(this.offIcon);
                }
                this.setToolTipText(this.offActionCommand);
                this.setActionCommand(this.offActionCommand);
            } else {
                this.setIcon(this.onIcon);
                this.setToolTipText(this.onActionCommand);
                this.setActionCommand(this.onActionCommand);
            }
            this.repaint();
        }

        public String getOnActionCommand() {
            return this.onActionCommand;
        }

        public String getOffActionCommand() {
            return this.offActionCommand;
        }

        @Override
        protected Dimension getIconPreferredSize() {
            int w = 0;
            int h = 0;
            if (this.onIcon != null) {
                w = this.onIcon.getIconWidth();
                h = this.onIcon.getIconHeight();
            }
            if (this.offIcon != null) {
                w = Math.max(w, this.offIcon.getIconWidth());
                h = Math.max(h, this.offIcon.getIconHeight());
            }
            return new Dimension(w, h);
        }
    }

    private static class SliderButton
    extends JButton {
        Dimension prefSize;
        final Color highlightColor = new Color(208, 208, 191);
        final Color invisibleColor = new Color(0, 0, 0, 0);
        final Color loweredColor = null;
        final Color raisedColor = this.invisibleColor;
        InsideBorder mouseoverBorder;
        InsideBorder loweredBorder;

        protected SliderButton() {
        }

        protected SliderButton(ImageIcon icon, String actionCommand) {
            this.setIcon(icon);
            this.setToolTipText(actionCommand);
            this.setActionCommand(actionCommand);
            this.init();
        }

        protected void init() {
            this.setContentAreaFilled(false);
            this.setFocusable(true);
            this.mouseoverBorder = new InsideBorder(this.invisibleColor, 3);
            this.loweredBorder = new InsideBorder(this.raisedColor, 2);
            this.setBorder(new CompoundBorder(this.mouseoverBorder, this.loweredBorder));
            Dimension d = this.getIconPreferredSize();
            this.prefSize = new Dimension(4 + d.width, 4 + d.height);
        }

        @Override
        public void processMouseEvent(MouseEvent e) {
            switch (e.getID()) {
                case 504: {
                    this.showMouseoverBorder();
                    break;
                }
                case 505: {
                    this.hideMouseoverBorder();
                    break;
                }
                case 501: {
                    this.depressButton();
                    break;
                }
                case 502: {
                    this.releaseButton();
                    break;
                }
            }
            super.processMouseEvent(e);
        }

        protected void showMouseoverBorder() {
            if (this.isEnabled()) {
                this.mouseoverBorder.setColor(this.highlightColor);
                this.repaint();
            }
        }

        public void hideMouseoverBorder() {
            this.mouseoverBorder.setColor(this.invisibleColor);
            this.repaint();
        }

        protected void depressButton() {
            if (this.isEnabled()) {
                this.loweredBorder.setColor(this.loweredColor);
                this.repaint();
            }
        }

        protected void releaseButton() {
            this.loweredBorder.setColor(this.raisedColor);
            this.repaint();
        }

        protected void hitButton() {
        }

        protected Dimension getIconPreferredSize() {
            ImageIcon ii = (ImageIcon)this.getIcon();
            if (ii != null) {
                return new Dimension(ii.getIconWidth(), ii.getIconHeight());
            }
            return new Dimension(0, 0);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }

        public void setRadius(int radius) {
            this.mouseoverBorder.setRadius(radius);
            this.loweredBorder.setRadius(radius == -1 ? -1 : radius - 1);
        }

        public int getRadius() {
            return this.mouseoverBorder.getRadius();
        }
    }
}

