/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;

@SASScope(value="ALL")
public class TimeLength {
    public static final String RB_KEY = "TimeLength.";
    private int unit = 10820;
    private int magnitude = 1;
    private double[] values = null;

    public TimeLength(int aMagnitude, int aUnit) {
        if (!GraphConstants.TIME_INTERVAL.isValid(aUnit)) {
            throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
        }
        if (aMagnitude <= 0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        this.unit = aUnit;
        this.magnitude = aMagnitude;
        this.values = null;
    }

    public TimeLength(double[] newValues) {
        if (newValues != null) {
            this.unit = 10895;
            this.values = new double[newValues.length];
            System.arraycopy(newValues, 0, this.values, 0, this.values.length);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TimeLength arg = (TimeLength)obj;
        return Util.Evaluate.isEqual(this.unit, arg.unit) && Util.Evaluate.isEqual(this.magnitude, arg.magnitude) && Util.Evaluate.isEqual(this.values, arg.values) && super.equals(arg);
    }

    public int getMagnitude() {
        return this.magnitude;
    }

    public int getUnit() {
        return this.unit;
    }

    public double[] getValues() {
        double[] copyOfValues;
        double[] dArray = copyOfValues = this.values == null ? null : new double[this.values.length];
        if (copyOfValues != null) {
            System.arraycopy(this.values, 0, copyOfValues, 0, this.values.length);
        }
        return copyOfValues;
    }
}

