/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CellStyle;
import com.sas.graphics.components.HierarchyModel;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TableAxisColumn;
import com.sas.graphics.components.TableAxisZone;
import com.sas.graphics.components.TextStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;
import com.sas.swing.visuals.treetable.CellAction;
import java.awt.Color;
import java.awt.Font;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.Icon;

@SASScope(value="ALL")
public class TableAxisModel
extends ModelBase {
    private Font headerFont = FontManager.getFont((String)RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
    private Font cellFont = FontManager.getFont((String)RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
    private Font rowSelcellFont = FontManager.getFont((String)RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)12);
    private Color headerTextColor = Color.black;
    private Color cellTextColor = Color.black;
    private Color tableGridColor = Color.black;
    private Color tableHeaderGridColor = Color.black;
    private CellStyle labelCellStyle = new CellStyle();
    private CellStyle valueCellStyle = new CellStyle();
    private CellStyle rowSelectionCellStyle = new CellStyle();
    private TextStyle labelTextStyle = new TextStyle(this.headerFont, Color.black, 0, true);
    private TextStyle valueTextStyle = new TextStyle(this.cellFont, Color.black, 0, true);
    private TextStyle valueRowSelectionFontStyle = new TextStyle(this.rowSelcellFont, Color.black, 0, true);
    private StrokeLineStyle gridLineStyle = new StrokeLineStyle();
    private boolean gridInFront = false;
    private Color headerBackgroundColor = Color.white;
    private Color cellBackgroundColor = Color.white;
    private TableAxisColumn[] columns = null;
    private TableAxisZone[] zones = null;
    private BaseLength cellPadding = new BaseLength(10.0, "py");
    private boolean rootVisible = true;
    private HashMap treeValueIcon = null;
    private HashMap treeValueOpenIcon = null;
    private HashMap treeValueClosedIcon = null;
    private HashMap treeValueLeafIcon = null;
    private Icon treeOpenIcon = null;
    private Icon treeCloseIcon = null;
    private Icon treeLeafIcon = null;
    private HierarchyModel treeHierarchyModel = new HierarchyModel();
    private Vector tableCellPopupMenuItems = new Vector();
    private boolean tableCellPopupMenuEnabled = false;
    private boolean tableEditable = false;
    private boolean tableEditableSet = false;
    private HashMap tableRowsEditable = new HashMap();
    private HashMap tableColumnsEditable = new HashMap();
    private HashMap taskLinks = new HashMap();
    private int treeExpansionDepth = Integer.MAX_VALUE;

    public TableAxisModel() {
        this.setContainedModel("gridLineStyle", this.gridLineStyle);
        this.setContainedModel("treeHierarchyModel", this.treeHierarchyModel);
        this.setContainedModel("labelTextStyle", this.labelTextStyle);
        this.setContainedModel("valueTextStyle", this.valueTextStyle);
        this.setContainedModel("labelCellStyle", this.labelCellStyle);
        this.setContainedModel("valueCellStyle", this.valueCellStyle);
        this.setContainedModel("rowSelCellStyle", this.rowSelectionCellStyle);
        this.setContainedModel("valueRowSelectionFont", this.valueRowSelectionFontStyle);
        Enumeration e = CellAction.getAllPredefinedCellActions();
        while (e.hasMoreElements()) {
            this.tableCellPopupMenuItems.add(e.nextElement());
        }
    }

    public void apply(TableAxisModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.gridLineStyle.apply(theOtherObject.gridLineStyle);
        this.gridInFront = theOtherObject.gridInFront;
        this.headerFont = theOtherObject.headerFont;
        this.cellFont = theOtherObject.cellFont;
        this.rowSelcellFont = theOtherObject.rowSelcellFont;
        this.headerTextColor = theOtherObject.headerTextColor;
        this.cellTextColor = theOtherObject.cellTextColor;
        this.tableGridColor = theOtherObject.tableGridColor;
        this.tableHeaderGridColor = theOtherObject.tableHeaderGridColor;
        this.cellPadding = theOtherObject.cellPadding;
        this.headerBackgroundColor = theOtherObject.headerBackgroundColor;
        this.cellBackgroundColor = theOtherObject.cellBackgroundColor;
        this.rootVisible = theOtherObject.rootVisible;
        this.columns = this.apply("columns", theOtherObject.columns, this.columns);
        this.zones = this.apply("zones", theOtherObject.zones, this.zones);
        this.treeValueIcon = theOtherObject.treeValueIcon;
        this.treeValueOpenIcon = theOtherObject.treeValueOpenIcon;
        this.treeValueClosedIcon = theOtherObject.treeValueClosedIcon;
        this.treeValueLeafIcon = theOtherObject.treeValueLeafIcon;
        this.treeOpenIcon = theOtherObject.treeOpenIcon;
        this.treeCloseIcon = theOtherObject.treeCloseIcon;
        this.treeLeafIcon = theOtherObject.treeLeafIcon;
        this.treeHierarchyModel = theOtherObject.treeHierarchyModel;
        this.labelTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.labelTextStyle, this.labelTextStyle);
        this.valueTextStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.valueTextStyle, this.valueTextStyle);
        this.valueRowSelectionFontStyle = Util.Conveyer.applyTextStyle_ReplaceAsNeeded(theOtherObject.valueRowSelectionFontStyle, this.valueRowSelectionFontStyle);
        this.labelCellStyle.apply(theOtherObject.labelCellStyle);
        this.valueCellStyle.apply(theOtherObject.valueCellStyle);
        this.rowSelectionCellStyle.apply(theOtherObject.rowSelectionCellStyle);
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    private TableAxisColumn[] apply(String id, TableAxisColumn[] from, TableAxisColumn[] to) {
        int ii;
        if (to != null) {
            for (ii = to.length; ii < to.length; ++ii) {
                this.setContainedModel(id + ii, null);
            }
        }
        if (from != null) {
            to = new TableAxisColumn[from.length];
            for (ii = 0; ii < to.length; ++ii) {
                to[ii] = new TableAxisColumn(from[ii].getVariable());
                to[ii].apply(from[ii]);
                this.setContainedModel(id + ii, to[ii]);
            }
        }
        return to;
    }

    private TableAxisZone[] apply(String id, TableAxisZone[] from, TableAxisZone[] to) {
        int ii;
        if (to != null) {
            for (ii = to.length; ii < to.length; ++ii) {
                this.setContainedModel(id + ii, null);
            }
        }
        if (from != null) {
            to = new TableAxisZone[from.length];
            for (ii = 0; ii < to.length; ++ii) {
                to[ii] = from[ii] != null ? (from[ii].getVariable() != null ? new TableAxisZone(from[ii].getVariable()) : new TableAxisZone(from[ii].getTreeLevel())) : null;
                this.setContainedModel(id + ii, to[ii]);
            }
        }
        return to;
    }

    public void setLabelTextStyle(TextStyle labelTextStyle) throws IllegalArgumentException {
        if (labelTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.labelTextStyle;
        this.labelTextStyle = labelTextStyle;
        this.firePropertyChange("labelTextStyle", oldValue, labelTextStyle);
    }

    public TextStyle getLabelTextStyle() {
        return this.labelTextStyle;
    }

    public void setValueTextStyle(TextStyle valueTextStyle) throws IllegalArgumentException {
        if (valueTextStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.valueTextStyle;
        this.valueTextStyle = valueTextStyle;
        this.firePropertyChange("valueTextStyle", oldValue, valueTextStyle);
    }

    public void setRowSelectionFontStyle(TextStyle valueRowSelFontStyle) throws IllegalArgumentException {
        if (valueRowSelFontStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TextStyle oldValue = this.valueRowSelectionFontStyle;
        this.valueRowSelectionFontStyle = valueRowSelFontStyle;
        this.firePropertyChange("valueRowSelectionFontStyle", oldValue, this.valueRowSelectionFontStyle);
    }

    public TextStyle getRowSelectionFontStyle() {
        return this.valueRowSelectionFontStyle;
    }

    public TextStyle getValueTextStyle() {
        return this.valueTextStyle;
    }

    public void setLabelCellStyle(CellStyle newCellStyle) {
        if (newCellStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        CellStyle oldCellStyle = this.labelCellStyle;
        this.labelCellStyle = newCellStyle;
        this.firePropertyChange("LabelCellStyle", oldCellStyle, this.labelCellStyle);
    }

    public CellStyle getLabelCellStyle() {
        return this.labelCellStyle;
    }

    public void setValueCellStyle(CellStyle newCellStyle) {
        if (newCellStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        CellStyle oldCellStyle = this.valueCellStyle;
        this.valueCellStyle = newCellStyle;
        this.firePropertyChange("valueCellStyle", oldCellStyle, this.valueCellStyle);
    }

    public CellStyle getValueCellStyle() {
        return this.valueCellStyle;
    }

    public void setGridLineStyle(StrokeLineStyle newLineStyle) throws IllegalArgumentException {
        if (newLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        StrokeLineStyle oldValue = this.gridLineStyle;
        this.gridLineStyle = newLineStyle;
        this.firePropertyChange("gridLineStyle", oldValue, newLineStyle);
    }

    public StrokeLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    public boolean isGridInFront() {
        return this.gridInFront;
    }

    public void setGridInFront(boolean inFront) {
        boolean oldValue = this.gridInFront;
        this.gridInFront = inFront;
        this.firePropertyChange("gridInFront", oldValue, inFront);
    }

    public void setHierarchyModel(HierarchyModel newModel) {
        if (newModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        HierarchyModel old = this.treeHierarchyModel;
        this.treeHierarchyModel = newModel;
        this.firePropertyChange("treeHierarchyModel", old, this.treeHierarchyModel);
    }

    public HierarchyModel getHierarchyModel() {
        return this.treeHierarchyModel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        TableAxisModel arg = (TableAxisModel)obj;
        return Util.Evaluate.isEqual(this.gridLineStyle, arg.gridLineStyle) && Util.Evaluate.isEqual(this.gridInFront, arg.gridInFront) && Util.Evaluate.isEqual((BaseDistance)this.cellPadding, (BaseDistance)arg.cellPadding) && Util.Evaluate.isEqual(this.headerFont, arg.headerFont) && Util.Evaluate.isEqual(this.cellFont, arg.cellFont) && Util.Evaluate.isEqual(this.headerTextColor, arg.headerTextColor) && Util.Evaluate.isEqual(this.cellTextColor, arg.cellTextColor) && Util.Evaluate.isEqual(this.headerBackgroundColor, arg.headerBackgroundColor) && Util.Evaluate.isEqual(this.cellBackgroundColor, arg.cellBackgroundColor) && Util.Evaluate.isEqual(this.rowSelcellFont, arg.rowSelcellFont) && Util.Evaluate.isEqual(this.tableGridColor, arg.tableGridColor) && Util.Evaluate.isEqual(this.tableHeaderGridColor, arg.tableHeaderGridColor) && Util.Evaluate.isEqual(this.columns, arg.columns) && Util.Evaluate.isEqual(this.treeHierarchyModel, arg.treeHierarchyModel) && Util.Evaluate.isEqual(this.rootVisible, arg.rootVisible) && super.equals(arg);
    }

    public void setRootVisible(boolean newRootVisible) {
        boolean oldRootVisible = this.rootVisible;
        this.rootVisible = newRootVisible;
        this.firePropertyChange("rootVisible", oldRootVisible, newRootVisible);
    }

    public boolean isRootVisible() {
        return this.rootVisible;
    }

    public void setCellPadding(BaseLength newPadding) throws IllegalArgumentException {
        if (newPadding == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldPadding = this.cellPadding;
        this.cellPadding = newPadding;
        this.firePropertyChange("cellPadding", oldPadding, newPadding);
    }

    public BaseLength getCellPadding() {
        return this.cellPadding;
    }

    public void addTableCellPopupMenuItem(CellAction itemToBeAdded) {
        for (int i = this.tableCellPopupMenuItems.size() - 1; i >= 0; --i) {
            CellAction a = (CellAction)this.tableCellPopupMenuItems.elementAt(i);
            if (!a.getName().equals(itemToBeAdded.getName())) continue;
            this.tableCellPopupMenuItems.removeElementAt(i);
        }
        this.tableCellPopupMenuItems.add(itemToBeAdded);
        this.firePropertyChange("TableCellPopupMenu", null, itemToBeAdded.getName());
    }

    public void removeTableCellPopupMenuItem(CellAction itemToBeRemoved) {
        this.tableCellPopupMenuItems.remove(itemToBeRemoved);
        this.firePropertyChange("TableCellPopupMenu", itemToBeRemoved.getName(), null);
    }

    public void removeAllTableCellPopupMenuItems() {
        this.tableCellPopupMenuItems = new Vector();
        this.firePropertyChange("TableCellPopupMenu", null, null);
    }

    public int getTableCellPopupMenuItemCount() {
        return this.tableCellPopupMenuItems.size();
    }

    public CellAction getTableCellPopupMenuItem(int index) throws IndexOutOfBoundsException {
        return (CellAction)this.tableCellPopupMenuItems.elementAt(index);
    }

    public void setTableCellPopupMenuEnabled(boolean newEnabled) {
        boolean oldEnabled = this.tableCellPopupMenuEnabled;
        this.tableCellPopupMenuEnabled = newEnabled;
        this.firePropertyChange("TableCellPopupMenuEnabled", oldEnabled, newEnabled);
    }

    public boolean isTableCellPopupMenuEnabled() {
        return this.tableCellPopupMenuEnabled;
    }

    public void setTaskLink(String taskName, String newLink) {
        String oldLink = (String)this.taskLinks.get(taskName);
        if (newLink != null) {
            this.taskLinks.put(taskName, newLink);
        } else {
            this.taskLinks.remove(taskName);
        }
        this.firePropertyChange("taskLinks." + taskName, oldLink, newLink);
    }

    public String getTaskLink(String taskName) {
        return (String)this.taskLinks.get(taskName);
    }

    public void removeAllTaskLinks() {
        this.taskLinks.clear();
        this.firePropertyChange("taskLinks.*", "*", null);
    }

    public Iterator getAllLinkedTasks() {
        return this.taskLinks.keySet().iterator();
    }

    public void setTableEditable(boolean newEditable) {
        int oldInt = this._getEditableInt();
        this.tableEditable = newEditable;
        this.tableEditableSet = true;
        int newInt = this._getEditableInt();
        this.firePropertyChange("TableEditable", oldInt, newInt);
    }

    public void unsetTableEditable() {
        int oldInt = this._getEditableInt();
        this.tableEditableSet = false;
        int newInt = this._getEditableInt();
        this.firePropertyChange("TableEditable", oldInt, newInt);
    }

    private int _getEditableInt() {
        return !this.tableEditableSet ? 0 : (this.tableEditable ? 1 : -1);
    }

    public boolean isTableEditable() {
        return this.tableEditable;
    }

    public boolean isTableEditableSet() {
        return this.tableEditableSet;
    }

    public void putTableRowEditable(String taskName, boolean editable) {
        boolean oldEditable = this.getTableRowEditable(taskName);
        if (editable != oldEditable) {
            this.tableRowsEditable.remove(taskName);
            this.tableRowsEditable.put(taskName, new Boolean(editable));
            this.firePropertyChange("TableRowsEditable", null, taskName);
        }
    }

    public boolean getTableRowEditable(String taskName) {
        boolean editable = true;
        if (this.tableRowsEditable.containsKey(taskName)) {
            Boolean b = (Boolean)this.tableRowsEditable.get(taskName);
            editable = b;
        }
        return editable;
    }

    public void removeTableRowEditable(String taskName) {
        this.tableRowsEditable.remove(taskName);
        this.firePropertyChange("TableRowsEditable", taskName, null);
    }

    public void clearTableRowEditable() {
        this.tableRowsEditable.clear();
        this.firePropertyChange("TableRowsEditable", null, null);
    }

    public Set keySetTableRowEditable() {
        return this.tableRowsEditable.keySet();
    }

    public void putTableColumnEditable(String colName, boolean editable) {
        boolean oldEditable = this.getTableColumnEditable(colName);
        if (editable != oldEditable) {
            this.tableColumnsEditable.remove(colName);
            this.tableColumnsEditable.put(colName, new Boolean(editable));
            this.firePropertyChange("TableColumnsEditable", null, colName);
        }
    }

    public boolean getTableColumnEditable(String colName) {
        boolean editable = true;
        if (this.tableColumnsEditable.containsKey(colName)) {
            Boolean b = (Boolean)this.tableColumnsEditable.get(colName);
            editable = b;
        }
        return editable;
    }

    public void removeTableColumnEditable(String colName) {
        this.tableColumnsEditable.remove(colName);
        this.firePropertyChange("TableColumnsEditable", colName, null);
    }

    public void clearTableColumnEditable() {
        this.tableColumnsEditable.clear();
        this.firePropertyChange("TableColumnsEditable", null, null);
    }

    public Set keySetTableColumnEditable() {
        return this.tableColumnsEditable.keySet();
    }

    public void setPreferredExpansionDepth(int newDepth) {
        int oldDepth = this.treeExpansionDepth;
        this.treeExpansionDepth = newDepth;
        if (oldDepth == newDepth) {
            oldDepth = -1;
        }
        this.firePropertyChange("TreeExpansionDepth", oldDepth, newDepth);
    }

    public int getPreferredExpansionDepth() {
        return this.treeExpansionDepth;
    }

    public void setColumns(TableAxisColumn[] newColumns) throws IllegalArgumentException {
        int ii;
        TableAxisColumn[] oldColumns = this.columns;
        if (newColumns != null) {
            if (newColumns.length == 0) {
                throw new IllegalArgumentException("newColumns.length == 0");
            }
            for (ii = 0; ii < newColumns.length; ++ii) {
                if (newColumns[ii] == null) {
                    throw new IllegalArgumentException("newColumns[" + ii + "]==null");
                }
                for (int jj = 0; jj < ii; ++jj) {
                    if (newColumns[jj] == newColumns[ii]) {
                        throw new IllegalArgumentException("newColumns[" + jj + "]==newColumns[" + ii + "]");
                    }
                    if (newColumns[jj].getVariable() != newColumns[ii].getVariable()) continue;
                    throw new IllegalArgumentException("newColumns[" + jj + "].getVariable()==newColumns[" + ii + "].getVariable()");
                }
            }
        }
        if (this.columns != null) {
            for (ii = 0; ii < this.columns.length; ++ii) {
                this.setContainedModel("columns" + ii, null);
            }
        }
        TableAxisColumn[] tableAxisColumnArray = this.columns = newColumns == null ? null : new TableAxisColumn[newColumns.length];
        if (this.columns != null) {
            System.arraycopy(newColumns, 0, this.columns, 0, this.columns.length);
            for (ii = 0; ii < this.columns.length; ++ii) {
                this.setContainedModel("columns" + ii, this.columns[ii]);
            }
        }
        this.firePropertyChange("columns", oldColumns, this.columns);
    }

    public TableAxisColumn[] getColumns() {
        TableAxisColumn[] copyOfColumns;
        TableAxisColumn[] tableAxisColumnArray = copyOfColumns = this.columns == null ? null : new TableAxisColumn[this.columns.length];
        if (copyOfColumns != null) {
            System.arraycopy(this.columns, 0, copyOfColumns, 0, copyOfColumns.length);
        }
        return copyOfColumns;
    }

    public void setZones(TableAxisZone[] newZones) throws IllegalArgumentException {
        int ii;
        TableAxisZone[] oldZones = this.zones;
        if (newZones != null) {
            if (newZones.length == 0) {
                throw new IllegalArgumentException("newZones.length == 0");
            }
            for (ii = 0; ii < newZones.length; ++ii) {
                if (newZones[ii] != null) continue;
                throw new IllegalArgumentException("newZones[" + ii + "] == null");
            }
        }
        if (this.zones != null) {
            for (ii = 0; ii < this.zones.length; ++ii) {
                this.setContainedModel("zones" + ii, null);
            }
        }
        TableAxisZone[] tableAxisZoneArray = this.zones = newZones == null ? null : new TableAxisZone[newZones.length];
        if (this.zones != null) {
            System.arraycopy(newZones, 0, this.zones, 0, this.zones.length);
            for (ii = 0; ii < this.zones.length; ++ii) {
                this.setContainedModel("zones" + ii, this.zones[ii]);
            }
        }
        this.firePropertyChange("zones", oldZones, this.zones);
    }

    public TableAxisZone[] getZones() {
        TableAxisZone[] copyOfZones;
        TableAxisZone[] tableAxisZoneArray = copyOfZones = this.zones == null ? null : new TableAxisZone[this.zones.length];
        if (copyOfZones != null) {
            System.arraycopy(this.zones, 0, copyOfZones, 0, copyOfZones.length);
        }
        return copyOfZones;
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

