/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;
import java.awt.Color;

@SASScope(value="ALL")
public class ShadowStyle
extends ModelBase {
    private static final BaseLength DEFAULT_X_OFFSET = new BaseLength(2.0, "px");
    private static final BaseLength DEFAULT_Y_OFFSET = new BaseLength(4.0, "px");
    private static final Color DEFAULT_SHADOW_COLOR = new Color(0, 0, 0);
    private boolean visible = false;
    private Color color = DEFAULT_SHADOW_COLOR;
    private BaseLength offsetX = DEFAULT_X_OFFSET;
    private BaseLength offsetY = DEFAULT_Y_OFFSET;
    private double softness = 1.0;

    public ShadowStyle() {
    }

    public ShadowStyle(Color colorIn) {
        if (colorIn != null) {
            this.color = colorIn;
        }
    }

    public ShadowStyle(Color color, BaseLength offsetX, BaseLength offsetY, double softness) {
        if (color != null) {
            this.color = color;
        }
        if (offsetX != null) {
            this.offsetX = offsetX;
        }
        if (offsetY != null) {
            this.offsetY = offsetY;
        }
        this.setSoftness(softness);
    }

    public void apply(ShadowStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.visible = theOtherObject.visible;
        this.color = theOtherObject.color;
        this.softness = theOtherObject.softness;
        this.offsetX = theOtherObject.offsetX;
        this.offsetY = theOtherObject.offsetY;
        this.firePropertyChange("", null, this);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        this.firePropertyChange("visible", oldVisible, newVisible);
    }

    public void setColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.color;
        this.color = newColor;
        this.firePropertyChange("color", oldColor, newColor);
    }

    public Color getColor() {
        return this.color;
    }

    public void setSoftness(double newSoftness) {
        newSoftness = Math.min(1.0, newSoftness);
        newSoftness = Math.max(0.0, newSoftness);
        double oldSoftness = this.softness;
        this.softness = newSoftness;
        this.firePropertyChange("softness", oldSoftness, newSoftness);
    }

    public double getSoftness() {
        return this.softness;
    }

    public void setOffsetX(BaseLength newOffsetX) throws IllegalArgumentException {
        if (newOffsetX == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldOffsetX = this.offsetX;
        this.offsetX = newOffsetX;
        this.firePropertyChange("offsetX", oldOffsetX, newOffsetX);
    }

    public BaseLength getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetY(BaseLength newOffsetY) throws IllegalArgumentException {
        if (newOffsetY == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldOffsetY = this.offsetY;
        this.offsetY = newOffsetY;
        this.firePropertyChange("offsetY", oldOffsetY, newOffsetY);
    }

    public BaseLength getOffsetY() {
        return this.offsetY;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ShadowStyle arg = (ShadowStyle)obj;
        return Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.softness, arg.softness) && Util.Evaluate.isEqual(this.color, arg.color) && Util.Evaluate.isEqual((BaseDistance)this.offsetX, (BaseDistance)arg.offsetX) && Util.Evaluate.isEqual((BaseDistance)this.offsetY, (BaseDistance)arg.offsetY) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

