/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.AdvancedTextStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.ZxAxis;
import com.sas.graphics.util.ZxAxisExt;
import com.sas.text.Message;
import java.util.Vector;

@SASScope(value="ALL")
public class ReferenceLineModel
extends ModelBase {
    private AdvancedTextStyle textStyle = null;
    private StrokeLineStyle lineStyle = null;
    private String label = null;
    private boolean inFront = true;
    private int labelPlacement = 10200;
    private boolean visible = true;
    private double position = Double.NaN;
    private Object positionAsObject = null;

    public ReferenceLineModel() {
        this.setContainedModel("lineStyle", this.lineStyle);
    }

    public ReferenceLineModel(double newPosition) {
        this();
        this.position = newPosition;
    }

    public ReferenceLineModel(Object newPositionAsObject) {
        this();
        this.positionAsObject = newPositionAsObject;
    }

    public ReferenceLineModel(String newLabel, double newPosition) {
        this(newPosition);
        this.label = newLabel;
    }

    public void apply(ReferenceLineModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        if (theOtherObject.lineStyle == null) {
            this.setLineStyle(null);
        } else {
            if (this.lineStyle == null) {
                this.setLineStyle(new StrokeLineStyle());
            }
            this.lineStyle.apply(theOtherObject.lineStyle);
        }
        if (theOtherObject.textStyle == null) {
            this.setTextStyle(null);
        } else {
            if (this.textStyle == null) {
                this.setTextStyle(new AdvancedTextStyle());
            }
            this.textStyle.apply(theOtherObject.textStyle);
        }
        this.position = theOtherObject.position;
        this.inFront = theOtherObject.inFront;
        this.label = theOtherObject.label;
        this.labelPlacement = theOtherObject.labelPlacement;
        this.visible = theOtherObject.visible;
        try {
            this.positionAsObject = theOtherObject.clone();
        }
        catch (CloneNotSupportedException e) {
            this.positionAsObject = theOtherObject.positionAsObject;
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setLineStyle(StrokeLineStyle newLineStyle) {
        StrokeLineStyle oldValue = this.lineStyle;
        this.lineStyle = newLineStyle;
        this.firePropertyChange("lineStyle", oldValue, newLineStyle);
    }

    public StrokeLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setTextStyle(AdvancedTextStyle newTextStyle) {
        AdvancedTextStyle oldValue = this.textStyle;
        this.textStyle = newTextStyle;
        this.firePropertyChange("textStyle", oldValue, newTextStyle);
    }

    public AdvancedTextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setLabel(String newLabel) {
        String oldValue = this.label;
        this.label = newLabel;
        this.firePropertyChange("label", oldValue, newLabel);
    }

    public String getLabel() {
        return this.label;
    }

    public void setPosition(double newPosition) {
        double oldValue = this.position;
        this.position = newPosition;
        this.firePropertyChange("position", oldValue, newPosition);
    }

    public Object getPositionAsObject() {
        return this.positionAsObject;
    }

    public void setPositionAsObject(Object newPositionAsObject) {
        Object oldValue = this.positionAsObject;
        this.positionAsObject = newPositionAsObject;
        this.firePropertyChange("positionAsObject", oldValue, newPositionAsObject);
    }

    public double getPosition() {
        return this.position;
    }

    public void setInFront(boolean newInFront) {
        boolean oldInFront = this.inFront;
        this.inFront = newInFront;
        this.firePropertyChange("inFront", oldInFront, newInFront);
    }

    public boolean isInFront() {
        return this.inFront;
    }

    public void setLabelPlacement(int newPlacement) throws IllegalArgumentException {
        switch (newPlacement) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10200: 
            case 11301: 
            case 11302: 
            case 11320: 
            case 11321: 
        }
        int oldPlacement = this.labelPlacement;
        this.labelPlacement = newPlacement;
        this.firePropertyChange("labelPlacement", oldPlacement, newPlacement);
    }

    public int getLabelPlacement() {
        return this.labelPlacement;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ReferenceLineModel arg = (ReferenceLineModel)obj;
        return Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.labelPlacement, arg.labelPlacement) && Util.Evaluate.isEqual(this.inFront, arg.inFront) && Util.Evaluate.isEqual(this.position, arg.position) && Util.Evaluate.isEqual(this.label, arg.label) && Util.Evaluate.isEqual(this.lineStyle, arg.lineStyle) && Util.Evaluate.isEqual(this.textStyle, arg.textStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public static ReferenceLineModel[] rangeToArray(double minPosition, double maxPosition, int interval) throws IllegalArgumentException {
        ReferenceLineModel[] refArray = null;
        Vector<ReferenceLineModel> refVec = new Vector<ReferenceLineModel>();
        if (minPosition <= 0.0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (minPosition == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (maxPosition == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (Double.isNaN(minPosition) || Double.isNaN(maxPosition)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (minPosition >= maxPosition) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(minPosition).toString(), (Object)new Double(maxPosition).toString());
            throw new IllegalArgumentException(message);
        }
        if (interval <= 0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        while (minPosition <= maxPosition) {
            ReferenceLineModel ref = new ReferenceLineModel(minPosition);
            refVec.add(ref);
            minPosition += (double)interval;
        }
        refArray = refVec.toArray(new ReferenceLineModel[0]);
        return refArray;
    }

    public static ReferenceLineModel[] rangeToArrayByTime(double minPosition, double maxPosition, int timeInterval, int multiplier) throws IllegalArgumentException {
        ReferenceLineModel[] refArray = null;
        ZxAxis.Interval intvl = null;
        switch (timeInterval) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10830: 
            case 10835: 
            case 10840: 
        }
        intvl = ReferenceLineModel.computeInterval(timeInterval, false);
        if (intvl != null) {
            refArray = ReferenceLineModel._createArray(intvl, minPosition, maxPosition, multiplier);
        }
        return refArray;
    }

    public static ReferenceLineModel[] rangeToArrayByDate(double minPosition, double maxPosition, int timeInterval, int multiplier) throws IllegalArgumentException {
        ReferenceLineModel[] refArray = null;
        ZxAxis.Interval intvl = null;
        switch (timeInterval) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10855: 
            case 10860: 
            case 10865: 
            case 10875: 
            case 10880: 
            case 10890: 
        }
        intvl = ReferenceLineModel.computeInterval(timeInterval, true);
        if (intvl != null) {
            refArray = ReferenceLineModel._createArray(intvl, minPosition, maxPosition, multiplier);
        }
        return refArray;
    }

    private static ReferenceLineModel[] _createArray(ZxAxis.Interval intvl, double minPosition, double maxPosition, int multiplier) {
        ReferenceLineModel[] refArray = null;
        Vector<ReferenceLineModel> refVec = new Vector<ReferenceLineModel>();
        if (minPosition <= 0.0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (minPosition == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (maxPosition == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (Double.isNaN(minPosition) || Double.isNaN(maxPosition)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (multiplier <= 0) {
            throw new IllegalArgumentException(RB.getStringResource("zeroOrNegativeInvalid.ex.txt"));
        }
        if (minPosition > maxPosition) {
            throw new IllegalArgumentException(RB.getStringResource("invalidMinimum.ex.txt"));
        }
        intvl.intper = 1;
        intvl.shiftper = 0;
        byte align = 3;
        ZxAxis.Interval sub_intrvl = null;
        ReferenceLineModel ref = null;
        double current = minPosition;
        while (current < maxPosition) {
            ref = new ReferenceLineModel(current);
            refVec.add(ref);
            current = ZxAxisExt.zintnx3((ZxAxis.Interval)intvl, (double)current, (double)multiplier, (byte)align, sub_intrvl);
        }
        refArray = refVec.toArray(new ReferenceLineModel[0]);
        return refArray;
    }

    private static ZxAxis.Interval computeInterval(int timeIntervalValue, boolean day) {
        ZxAxis.Interval intvl = new ZxAxis.Interval();
        intvl.units = (char)(day ? 100 : 115);
        switch (timeIntervalValue) {
            case 10830: {
                intvl.intcode = 10;
                break;
            }
            case 10835: {
                intvl.intcode = 15;
                break;
            }
            case 10840: {
                intvl.intcode = 20;
                break;
            }
            case 10855: {
                intvl.intcode = 25;
                break;
            }
            case 10865: {
                intvl.intcode = 35;
                break;
            }
            case 10860: {
                intvl.intcode = 30;
                break;
            }
            case 10875: {
                intvl.intcode = 45;
                break;
            }
            case 10880: {
                intvl.intcode = 50;
                break;
            }
            case 10890: {
                intvl.intcode = 60;
            }
        }
        return intvl;
    }
}

