/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CategorizationModel;
import com.sas.graphics.components.SegmentedRangeStyle;
import com.sas.graphics.components.Variable;

@SASScope(value="ALL")
public abstract class RangeVariable
extends Variable {
    private final String highColumnName;
    private final int highColumnIndex;
    private final String highLabel;
    private final String lowColumnName;
    private final int lowColumnIndex;
    private final String lowLabel;
    private final String targetColumnName;
    private final int targetColumnIndex;
    private final String targetLabel;

    private RangeVariable(String columnName, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, String highColumnName, String highLabel, String lowColumnName, String lowLabel, String targetColumnName, String targetLabel) {
        super(columnName, format, informat, label, categorizationModel, segmentedRangeStyle);
        this.targetColumnName = targetColumnName;
        this.targetColumnIndex = -1;
        this.targetLabel = targetLabel;
        this.highColumnName = highColumnName;
        this.highColumnIndex = -1;
        this.highLabel = highLabel;
        this.lowColumnName = lowColumnName;
        this.lowColumnIndex = -1;
        this.lowLabel = lowLabel;
    }

    private RangeVariable(int columnIndex, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel, int targetColumnIndex, String targetLabel) {
        super(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle);
        this.targetColumnName = null;
        this.targetColumnIndex = targetColumnIndex;
        this.targetLabel = targetLabel;
        this.highColumnName = null;
        this.highColumnIndex = highColumnIndex;
        this.highLabel = highLabel;
        this.lowColumnName = null;
        this.lowColumnIndex = lowColumnIndex;
        this.lowLabel = lowLabel;
    }

    public RangeVariable(String columnName) {
        this(columnName, null, null, null, null, null, null, null, null, null, null, null);
    }

    public RangeVariable(String columnName, String format) {
        this(columnName, format, null, null, null, null, null, null, null, null, null, null);
    }

    public RangeVariable(String columnName, String format, String informat, String label) {
        this(columnName, format, informat, label, null, null, null, null, null, null, null, null);
    }

    public RangeVariable(String columnName, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this(columnName, format, informat, label, categorizationModel, segmentedRangeStyle, null, null, null, null, null, null);
    }

    public RangeVariable(int columnIndex) {
        this(columnIndex, null, null, null, null, null, -1, null, -1, null, -1, null);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label) {
        this(columnIndex, format, informat, label, null, null, -1, null, -1, null, -1, null);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle) {
        this(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle, -1, null, -1, null, -1, null);
    }

    public RangeVariable(String columnName, String format, String informat, String label, String highColumnName, String highLabel, String lowColumnName, String lowLabel) {
        this(columnName, format, informat, label, null, null, highColumnName, highLabel, lowColumnName, lowLabel, null, null);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel) {
        this(columnIndex, format, informat, label, null, null, highColumnIndex, highLabel, lowColumnIndex, lowLabel, -1, null);
    }

    public RangeVariable(String columnName, String format, String informat, String label, String targetColumnName, String targetLabel) {
        this(columnName, format, informat, label, null, null, null, null, null, null, targetColumnName, targetLabel);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label, int targetColumnIndex, String targetLabel) {
        this(columnIndex, format, informat, label, null, null, -1, null, -1, null, targetColumnIndex, targetLabel);
    }

    public RangeVariable(String columnName, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, String highColumnName, String highLabel, String lowColumnName, String lowLabel) {
        this(columnName, format, informat, label, categorizationModel, segmentedRangeStyle, highColumnName, highLabel, lowColumnName, lowLabel, null, null);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, int highColumnIndex, String highLabel, int lowColumnIndex, String lowLabel) {
        this(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle, highColumnIndex, highLabel, lowColumnIndex, lowLabel, -1, null);
    }

    public RangeVariable(String columnName, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, String targetColumnName, String targetLabel) {
        this(columnName, format, informat, label, categorizationModel, segmentedRangeStyle, null, null, null, null, targetColumnName, targetLabel);
    }

    public RangeVariable(int columnIndex, String format, String informat, String label, CategorizationModel categorizationModel, SegmentedRangeStyle segmentedRangeStyle, int targetColumnIndex, String targetLabel) {
        this(columnIndex, format, informat, label, categorizationModel, segmentedRangeStyle, -1, null, -1, null, targetColumnIndex, targetLabel);
    }

    public RangeVariable(RangeVariable rv) {
        super(rv);
        if (rv == null) {
            this.targetColumnName = null;
            this.targetColumnIndex = -1;
            this.targetLabel = null;
            this.highColumnName = null;
            this.highColumnIndex = -1;
            this.highLabel = null;
            this.lowColumnName = null;
            this.lowColumnIndex = -1;
            this.lowLabel = null;
        } else {
            this.targetColumnName = rv.getTargetColumnName();
            this.targetColumnIndex = rv.getTargetColumnIndex();
            this.targetLabel = rv.getTargetLabel();
            this.highColumnName = rv.getHighColumnName();
            this.highColumnIndex = rv.getHighColumnIndex();
            this.highLabel = rv.getHighLabel();
            this.lowColumnName = rv.getLowColumnName();
            this.lowColumnIndex = rv.getLowColumnIndex();
            this.lowLabel = rv.getLowLabel();
        }
    }

    public String getTargetColumnName() {
        return this.targetColumnName;
    }

    public int getTargetColumnIndex() {
        return this.targetColumnIndex;
    }

    public String getTargetLabel() {
        return this.targetLabel;
    }

    public String getHighColumnName() {
        return this.highColumnName;
    }

    public int getHighColumnIndex() {
        return this.highColumnIndex;
    }

    public String getHighLabel() {
        return this.highLabel;
    }

    public String getLowColumnName() {
        return this.lowColumnName;
    }

    public int getLowColumnIndex() {
        return this.lowColumnIndex;
    }

    public String getLowLabel() {
        return this.lowLabel;
    }
}

