/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;

@SASScope(value="ALL")
public abstract class ModelBase {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private final ContainedModelSupport containedModelSupport = new ContainedModelSupport();
    private int eventGate = 0;

    protected final void setContainedModel(String property, ModelBase containedModel) {
        this.containedModelSupport.put(property, containedModel);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    @SASScope
    public void enablePropertyChange() {
        this.eventGate = Math.max(0, this.eventGate - 1);
    }

    @SASScope
    public void disablePropertyChange() {
        ++this.eventGate;
    }

    private void firePropertyChange(PropertyChangeEvent e) {
        if (this.eventGate == 0) {
            this.propertyChangeSupport.firePropertyChange(e);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldProperty, newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, ModelBase oldProperty, ModelBase newProperty) {
        if (propertyName != null) {
            if (!"".equals(propertyName)) {
                this.containedModelSupport.put(propertyName, newProperty);
            }
            this.firePropertyChange(propertyName, (Object)oldProperty, (Object)newProperty);
        }
    }

    protected void firePropertyChange(String propertyName, double oldProperty, double newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Double(oldProperty), new Double(newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, boolean oldProperty, boolean newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Boolean(oldProperty), new Boolean(newProperty));
        }
    }

    protected void firePropertyChange(String propertyName, int oldProperty, int newProperty) {
        if (oldProperty != newProperty) {
            this.firePropertyChange(propertyName, new Integer(oldProperty), new Integer(newProperty));
        }
    }

    public boolean equals(Object obj) {
        return this.getClass().equals(obj.getClass());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @SASScope
    private class ContainedModelSupport {
        private final Hashtable containedModels = new Hashtable();
        private final PropertyChangeListener containedModelPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Enumeration keys = ContainedModelSupport.this.containedModels.keys();
                while (keys.hasMoreElements()) {
                    String property = (String)keys.nextElement();
                    ModelBase model = (ModelBase)ContainedModelSupport.this.containedModels.get(property);
                    if (e.getSource() != model) continue;
                    PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(ModelBase.this, property, null, e.getSource());
                    propertyChangeEvent.setPropagationId(e);
                    ModelBase.this.firePropertyChange(propertyChangeEvent);
                }
            }
        };

        private ContainedModelSupport() {
        }

        public void put(String property, ModelBase containedModel) {
            if (property != null && ModelBase.this != containedModel) {
                ModelBase oldContainedModel = (ModelBase)(containedModel == null ? this.containedModels.remove(property) : this.containedModels.put(property, containedModel));
                if (oldContainedModel != null) {
                    oldContainedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
                }
                if (containedModel != null) {
                    containedModel.addPropertyChangeListener(this.containedModelPropertyChangeListener);
                }
            }
        }

        public void remove(String property) {
            ModelBase containedModel;
            if (property != null && (containedModel = (ModelBase)this.containedModels.remove(property)) != null) {
                containedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
            }
        }
    }
}

