/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import java.awt.Color;
import java.awt.Font;
import javax.swing.UIManager;

@SASScope
public class MessageModel
extends ModelBase {
    public static final int MESSAGE_TYPE_ERROR = 0;
    public static final int MESSAGE_TYPE_WARNING = 2;
    public static final int MESSAGE_TYPE_INFORMATION = 1;
    public static final int MESSAGE_TYPE_PLAIN = -1;
    public static final int MESSAGE_TYPE_QUESTION = 3;
    public static final ConstantCollection MESSAGE_TYPE;
    private transient String title = null;
    private transient String[] message = null;
    private transient int messageType = -1;

    public void apply(MessageModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.title = theOtherObject.title;
        this.message = Util.Copier.copyOf(theOtherObject.message);
        this.messageType = theOtherObject.messageType;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public MessageModel() {
        this(null, null, 1);
    }

    public MessageModel(String newTitle, int messageType) {
        this(newTitle, null, messageType);
    }

    public MessageModel(String newTitle, String[] newMessage, int newMessageType) {
        this.title = newTitle;
        this.message = Util.Copier.copyOf(newMessage);
        if (MESSAGE_TYPE.isValid(newMessageType)) {
            this.messageType = newMessageType;
        }
    }

    public void setMessageType(int newMessageType) throws IllegalArgumentException {
        MESSAGE_TYPE.validate(newMessageType);
        int oldMessageType = this.messageType;
        this.messageType = newMessageType;
        this.firePropertyChange("messageType", oldMessageType, this.messageType);
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setTitle(String newTitle) {
        String oldTitle = this.title;
        this.title = newTitle;
        this.firePropertyChange("title", oldTitle, newTitle);
    }

    public String getTitle() {
        return this.title;
    }

    public void setMessage(String[] newMessage) {
        String[] oldMessage = this.message;
        this.message = Util.Copier.copyOf(newMessage);
        this.firePropertyChange("message", oldMessage, this.message);
    }

    public String[] getMessage() {
        return this.message;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        MessageModel arg = (MessageModel)obj;
        return Util.Evaluate.isEqual(this.messageType, arg.messageType) && Util.Evaluate.isEqual(this.title, arg.title) && Util.Evaluate.isEqual(this.message, arg.message) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    static {
        try {
            Color warningMessageForeground;
            String messageModelPrefix = "com.sas.graphics.components.MessageModel.";
            Color errorMessageForeground = warningMessageForeground = new Color(178, 25, 25);
            Color messageBackground = new Color(255, 252, 234, 235);
            Color messageShadow = new Color(124, 124, 124, 156);
            String fontFamily = RB.getStringResource("fontTimesNewRoman.lcl");
            Font titleFont = FontManager.getFont((String)fontFamily, (int)1, (int)12);
            Font messageFont = FontManager.getFont((String)fontFamily, (int)0, (int)12);
            UIManager.put(messageModelPrefix + "titleFont", titleFont);
            UIManager.put(messageModelPrefix + "messageFont", messageFont);
            UIManager.put(messageModelPrefix + "warningMessageForeground", warningMessageForeground);
            UIManager.put(messageModelPrefix + "errorMessageForeground", errorMessageForeground);
            UIManager.put(messageModelPrefix + "messageBackground", messageBackground);
            UIManager.put(messageModelPrefix + "messageShadow", messageShadow);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        MESSAGE_TYPE = new ConstantCollection(RB.class, new ConstantCollection.Element[]{new ConstantCollection.Element(0, "MESSAGE_TYPE_ERROR", "errorMessage"), new ConstantCollection.Element(2, "MESSAGE_TYPE_WARNING", "warningMessage"), new ConstantCollection.Element(1, "MESSAGE_TYPE_INFORMATION", "informationMessage"), new ConstantCollection.Element(-1, "MESSAGE_TYPE_PLAIN", "plainMessage"), new ConstantCollection.Element(3, "MESSAGE_TYPE_QUESTION", "questionMessage")});
    }
}

