/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.measures.BaseDistance;
import com.sas.measures.BaseLength;
import java.awt.Color;

@SASScope(value="ALL")
public class LineStyle
extends ModelBase {
    private static final BaseLength DEFAULT_THICKNESS = new BaseLength(1.0, "px");
    private Color color = Color.black;
    private BaseLength thickness = DEFAULT_THICKNESS;
    private int visibilityPolicy = 10200;

    public LineStyle() {
    }

    public LineStyle(Color newColor) {
        if (newColor != null) {
            this.color = newColor;
        }
    }

    public LineStyle(Color newColor, BaseLength newThickness, int newVisibilityPolicy) {
        if (newColor != null) {
            this.color = newColor;
        }
        if (newThickness != null) {
            this.thickness = newThickness;
        }
        if (GraphConstants.TRI.isValid(newVisibilityPolicy)) {
            this.visibilityPolicy = newVisibilityPolicy;
        }
    }

    public void apply(LineStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.color = theOtherObject.color;
        this.thickness = theOtherObject.thickness;
        this.visibilityPolicy = theOtherObject.visibilityPolicy;
        this.firePropertyChange("", null, this);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color newColor) throws IllegalArgumentException {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldColor = this.color;
        this.color = newColor;
        this.firePropertyChange("color", oldColor, newColor);
    }

    public void setThickness(BaseLength newThickness) throws IllegalArgumentException {
        if (newThickness == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        BaseLength oldThickness = this.thickness;
        this.thickness = newThickness;
        this.firePropertyChange("thickness", oldThickness, newThickness);
    }

    public BaseLength getThickness() {
        return this.thickness;
    }

    public void setVisibilityPolicy(int newVisibilityPolicy) throws IllegalArgumentException {
        GraphConstants.TRI.validate(newVisibilityPolicy);
        int oldVisibilityPolicy = this.visibilityPolicy;
        this.visibilityPolicy = newVisibilityPolicy;
        this.firePropertyChange("visibilityPolicy", oldVisibilityPolicy, this.visibilityPolicy);
    }

    public int getVisibilityPolicy() {
        return this.visibilityPolicy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        LineStyle arg = (LineStyle)obj;
        return Util.Evaluate.isEqual(this.visibilityPolicy, arg.visibilityPolicy) && Util.Evaluate.isEqual(this.color, arg.color) && Util.Evaluate.isEqual((BaseDistance)this.thickness, (BaseDistance)arg.thickness) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

