/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.actionprovider.SwingActionProvider;
import com.sas.beans.Util;
import com.sas.codepolicy.SASScope;
import com.sas.collection.ContentsChangedEvent;
import com.sas.collection.ContentsChangedListener;
import com.sas.collection.ContentsChangedSource;
import com.sas.graphics.components.ColorScheme;
import com.sas.graphics.components.DataTipModel;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.GraphActionEvent;
import com.sas.graphics.components.GraphActionListener;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.GraphModel;
import com.sas.graphics.components.GraphStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.MessageModel;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.NoteModel;
import com.sas.graphics.components.PickInfo;
import com.sas.graphics.components.ProbeEvent;
import com.sas.graphics.components.ProbeListener;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.animation.AnimationPosition;
import com.sas.graphics.components.util.Util;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.cell.ChartContainer;
import com.sas.graphics.util.cell.EventMulticaster;
import com.sas.graphics.util.cell.LabelComponent;
import com.sas.graphics.util.cell.Matrix;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.Probe;
import com.sas.measures.BaseLength;
import com.sas.text.Message;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.RepaintManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

@SASScope(value="ALL")
public abstract class Graph
extends JComponent {
    public static final String RB_KEY = "Graph.";
    private final transient GraphUI graphUI = new GraphUI();
    private transient boolean keepRubberBandOnSelection = false;
    private final transient ContainedModelSupport containedModelSupport = new ContainedModelSupport();
    private transient int eventGate = 0;
    @SASScope
    protected transient ChartContainer chartContainer;
    private transient JComponent graph;
    private transient JComponent header;
    private transient JComponent footer;
    private final transient NoteModel[] titles = new NoteModel[4];
    private final transient NoteModel[] footnotes = new NoteModel[2];
    private final transient NoteLabel[] titleComponents = new NoteLabel[this.titles.length];
    private final transient NoteLabel[] footnoteComponents = new NoteLabel[this.footnotes.length + 1];
    private transient MessageModel messageModel = new MessageModel();
    protected transient JComponent titleContainer;
    protected transient JComponent footnoteContainer;
    private transient NoteModel internalFootnote;
    private transient int displayPolicy = 10200;
    private transient Object currentModel = null;
    private transient Object currentSelectionModel = null;
    @SASScope
    protected final transient boolean designTime = Util.isDesignTime();
    private static int DEFAULT_WIDTH = 320;
    private static int DEFAULT_HEIGHT = 240;
    private transient GraphModel graphModel;
    @SASScope
    private static transient GraphStyle defaultGraphStyle;
    private static final BaseLength DEFAULT_LINE_THICKNESS;
    private SwingActionProvider actionProvider;
    private final Channel channel;
    private final ContentsChangedListener contentsChangedListener = new ContentsChangedListener(){

        public void contentsChanged(ContentsChangedEvent e) {
            Graph.this.doApplyDataModel();
        }
    };
    private final TableModelListener tableModelListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            Graph.this.doApplyDataModel();
        }
    };
    private final ListSelectionListener listSelectionListener = new ListSelectionListener(){
        private boolean wasAdjusting = false;

        @Override
        public void valueChanged(ListSelectionEvent e) {
            boolean isAdjusting = e.getValueIsAdjusting();
            if (!Graph.this.keepRubberBandOnSelection && !Graph.this.graphUI.isMouseFocusOwner() && !this.wasAdjusting && Graph.this.graphUI.removeBrush()) {
                Graph.this.revalidate();
                Graph.this.repaint();
            }
            if (isAdjusting || !this.wasAdjusting) {
                Graph.this.selectionChanged();
            }
            this.wasAdjusting = isAdjusting;
        }
    };
    private transient int appliedGraphStyleName;
    private transient int appliedGraphStyleModified;
    private transient int appliedColorSchemeName;
    private boolean redoSelectionOnPaintEnabled = false;
    private boolean eraseDataTipOnPaintEnabled = false;
    private boolean redoDataTipOnPaintEnabled = false;
    private AnimationPosition animationPosition = null;
    @SASScope
    protected ProbeListener probeListeners = null;
    private MouseListener probeMouseListener = null;
    private MouseMotionListener probeMouseMotionListener = null;
    private boolean isProbeClearNeeded = false;
    private GraphActionListener actionListeners = null;
    private GraphActionMouseListener graphActionMouseListener = null;

    protected ListSelectionListener getListSelectionListener() {
        return this.listSelectionListener;
    }

    protected TableModelListener getTableModelListener() {
        return this.tableModelListener;
    }

    protected ContentsChangedListener getContentsChangedListener() {
        return this.contentsChangedListener;
    }

    private void addToListenerList(Object model) {
        if (model instanceof ContentsChangedSource) {
            ContentsChangedSource ccs = (ContentsChangedSource)model;
            ccs.addContentsChangedListener(this.contentsChangedListener);
        } else if (model instanceof TableModel) {
            TableModel tm = (TableModel)model;
            tm.addTableModelListener(this.tableModelListener);
        } else if (model instanceof ListSelectionModel) {
            ListSelectionModel lsm = (ListSelectionModel)model;
            lsm.addListSelectionListener(this.listSelectionListener);
        }
    }

    private void removeFromListenerList(Object model) {
        if (model instanceof ContentsChangedSource) {
            ContentsChangedSource ccs = (ContentsChangedSource)model;
            ccs.removeContentsChangedListener(this.contentsChangedListener);
        } else if (model instanceof TableModel) {
            TableModel tm = (TableModel)model;
            tm.removeTableModelListener(this.tableModelListener);
        } else if (model instanceof ListSelectionModel) {
            ListSelectionModel lsm = (ListSelectionModel)model;
            lsm.removeListSelectionListener(this.listSelectionListener);
        }
    }

    public void setActionProvider(SwingActionProvider actionProvider) {
        this.actionProvider = actionProvider;
    }

    public SwingActionProvider getActionProvider() {
        return this.actionProvider;
    }

    protected final GraphStyle getDefaultGraphStyle() {
        return defaultGraphStyle;
    }

    @SASScope
    protected void enablePropertyChange() {
        this.eventGate = Math.max(0, this.eventGate - 1);
    }

    @SASScope
    protected void disablePropertyChange() {
        ++this.eventGate;
    }

    protected void firePropertyChange(String propertyName, ModelBase oldValue, ModelBase newValue) {
        if (oldValue == newValue) {
            return;
        }
        if (propertyName != null) {
            if (!"".equals(propertyName)) {
                this.containedModelSupport.put(propertyName, newValue);
            }
            this.firePropertyChange(propertyName, (Object)oldValue, (Object)newValue);
        }
    }

    private void firePropertyChange(PropertyChangeEvent e) {
        if (this.eventGate == 0) {
            this.doPropertyChange(e.getPropertyName(), e.getOldValue(), e.getNewValue());
            PropertyChangeListener[] listeners = this.getPropertyChangeListeners();
            if (listeners != null) {
                for (int ii = 0; ii < listeners.length; ++ii) {
                    if (listeners[ii] == null) continue;
                    listeners[ii].propertyChange(e);
                }
            }
        }
    }

    @Override
    @SASScope
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (oldValue == newValue) {
            return;
        }
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        this.firePropertyChange(propertyChangeEvent);
    }

    @SASScope
    protected void doPropertyChange(String propertyName, Object oldValue, Object newValue) {
        block6: {
            block9: {
                block8: {
                    block7: {
                        if (propertyName == null) break block6;
                        if (!"".equals(propertyName)) break block7;
                        ++this.appliedGraphStyleModified;
                        this.doApplyGraphModel();
                        this._updateNoteLabels();
                        break block6;
                    }
                    if (!"graphModel".equals(propertyName)) break block8;
                    this.doApplyGraphModel();
                    break block6;
                }
                if (!"dataModel".equals(propertyName) && !"locale".equals(propertyName)) break block9;
                if (this.designTime) break block6;
                if (this.graphModel == null || !this.graphModel.isCustomOptionEnabled(GraphConstants.CUSTOM_OPTION_DATA_UPDATE_EVENTS_DISABLED)) {
                    this.updateDataModelListeners();
                }
                this.doApplyDataModel();
                break block6;
            }
            if (propertyName.startsWith("title")) {
                for (int ii = 1; ii <= this.titles.length; ++ii) {
                    if (!("title" + ii).equals(propertyName)) continue;
                    this._setNote(this.titleContainer, this.titleComponents, this.getTitle(ii), ii);
                }
            } else if (propertyName.startsWith("footnote")) {
                for (int ii = 1; ii <= this.footnotes.length; ++ii) {
                    if (!("footnote" + ii).equals(propertyName)) continue;
                    this._setNote(this.footnoteContainer, this.footnoteComponents, this.getFootnote(ii), ii);
                }
            }
        }
    }

    public Graph() {
        int ii;
        RepaintManager repaintManager;
        if (com.sas.graphics.util.cell.Util.isHeadless() && (repaintManager = RepaintManager.currentManager(this)) != null) {
            repaintManager.setDoubleBufferingEnabled(false);
        }
        this.channel = new Channel((Component)this, 2);
        com.sas.graphics.util.cell.Util.updateChannel(this.channel, 1, 1);
        this.setOpaque(false);
        this.chartContainer = new ChartContainer();
        this.titleContainer = new JPanel();
        this.titleContainer.setOpaque(false);
        this.titleContainer.setLayout(new GridBagLayout());
        this.chartContainer.setTitle(this.titleContainer);
        this.footnoteContainer = new JPanel();
        this.footnoteContainer.setOpaque(false);
        this.footnoteContainer.setLayout(new GridBagLayout());
        this.chartContainer.setFootnote(this.footnoteContainer);
        this.chartContainer.setDataTip(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.chartContainer, "Center");
        for (ii = 0; ii < this.titles.length; ++ii) {
            this.titles[ii] = new NoteModel();
            this.containedModelSupport.put("title" + (ii + 1), this.titles[ii]);
        }
        for (ii = 0; ii < this.footnotes.length; ++ii) {
            this.footnotes[ii] = new NoteModel();
            this.containedModelSupport.put("footnote" + (ii + 1), this.footnotes[ii]);
        }
        this.containedModelSupport.put("messageModel", this.messageModel);
        if (this.designTime) {
            this.internalFootnote = new NoteModel(RB.getStringResource(RB_KEY, "sampleData.txt"));
            this.internalFootnote.getTextStyle().setFont(FontManager.getFont((String)RB.getStringResource("fontHelvetica.lcl"), (int)0, (int)10));
            this.internalFootnote.getTextStyle().setColor(Color.black);
            this.internalFootnote.getTextStyle().setJustification(4);
            this._setNote(this.footnoteContainer, this.footnoteComponents, this.internalFootnote, this.footnotes.length);
        }
    }

    public static int getDefaultWidth() {
        return DEFAULT_WIDTH;
    }

    public static int getDefaultHeight() {
        return DEFAULT_HEIGHT;
    }

    protected void setPaintContext(boolean redoSelectionOnPaintEnabled, AnimationPosition animationPosition) {
        this.redoSelectionOnPaintEnabled = redoSelectionOnPaintEnabled;
        this.animationPosition = animationPosition;
        if (!com.sas.graphics.util.cell.Util.isHeadless() && this.isDisplayable()) {
            double interpolationPercentage = animationPosition != null ? animationPosition.getInterpolationPercent() : 0.0;
            this.redoDataTipOnPaintEnabled = interpolationPercentage == 0.0;
            this.eraseDataTipOnPaintEnabled = interpolationPercentage != 0.0;
        } else {
            this.redoDataTipOnPaintEnabled = false;
            this.eraseDataTipOnPaintEnabled = false;
        }
    }

    @Override
    public Dimension getMinimumSize() {
        this.prepareToPaint();
        return super.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        this.prepareToPaint();
        return super.getPreferredSize();
    }

    @Override
    public void update(Graphics g) {
        this.prepareToPaint();
        super.update(g);
    }

    @Override
    protected void validateTree() {
        this.prepareToPaint();
        super.validateTree();
    }

    @Override
    public void paintAll(Graphics g) {
        this.prepareToPaint();
        super.paintAll(g);
    }

    @Override
    public void paint(Graphics g) {
        this.prepareToPaint();
        if (this.redoSelectionOnPaintEnabled) {
            this.graphUI.refreshBrushSelection();
            this.redoSelectionOnPaintEnabled = false;
        }
        if (this.eraseDataTipOnPaintEnabled) {
            this.graphUI.eraseDataTip();
            this.eraseDataTipOnPaintEnabled = false;
        } else if (this.redoDataTipOnPaintEnabled) {
            this.graphUI.refreshDataTip();
            this.redoDataTipOnPaintEnabled = false;
        }
        super.paint(g);
    }

    public abstract void prepareToPaint();

    public abstract void setAutoRepaintEnabled(boolean var1);

    public abstract boolean isAutoRepaintEnabled();

    @Override
    public void setBounds(int x, int y, int w, int h) {
        Rectangle b = this.getBounds();
        super.setBounds(x, y, w, h);
        if (!b.equals(this.getBounds())) {
            this.graphUI.removeBrush();
        }
    }

    @Override
    public void setBackground(Color c) {
        if (this.graphModel != null && c != null) {
            this.graphModel.getBackgroundFillStyle().setFillType(20000);
            this.graphModel.getBackgroundFillStyle().setSolidFillColor(c);
        }
        super.setBackground(c);
    }

    @Override
    public Color getBackground() {
        return this.graphModel != null ? this.graphModel.getBackgroundFillStyle().getSolidFillColor() : super.getBackground();
    }

    public void setMessageModel(MessageModel newMessageModel) throws IllegalArgumentException {
        if (newMessageModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        MessageModel oldMessageModel = this.messageModel;
        this.messageModel = newMessageModel;
        if (this.graph instanceof Matrix) {
            ((Matrix)this.graph).setMessageModel(this.messageModel);
        }
        this.firePropertyChange("messageModel", oldMessageModel, this.messageModel);
    }

    public MessageModel getMessageModel() {
        return this.messageModel;
    }

    @SASScope
    protected void setGraphModel(GraphModel newGraphModel) throws IllegalArgumentException {
        if (newGraphModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.graphModel = newGraphModel;
        if (this.graph instanceof Matrix) {
            ((Matrix)this.graph).setGraphModel(this.graphModel);
        }
    }

    protected void applyGraphModel() {
        if (!(this.chartContainer.getGraphBackground() instanceof MyBackground)) {
            this.chartContainer.setGraphBackground(new MyBackground());
        }
        MyBackground myBackground = (MyBackground)this.chartContainer.getGraphBackground();
        myBackground.setFillStyle(this.graphModel.getBackgroundFillStyle());
        myBackground.setLogo(this.graphModel.getLogo());
        myBackground.setLogoJustification(this.graphModel.getLogoJustification());
        this.updateGraphUI();
        this._applyAntialiasedTextOnNoteLabels();
        if (this.isShowing()) {
            this.repaint();
        }
    }

    private void doApplyGraphModel() {
        this.modelChanged();
        this.applyGraphModel();
    }

    protected abstract void applyDataModel();

    @Override
    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException e) {
            return Locale.getDefault();
        }
    }

    private void doApplyDataModel() {
        this.modelChanged();
        this.applyDataModel();
    }

    private void modelChanged() {
        if (this.graphUI != null) {
            this.graphUI.eraseDataTip();
            this.graphUI.removeBrush();
        }
    }

    private void updateGraphUI() {
        if (this.graphModel.getDataTipModel().isVisible() && this.graphModel.getDataTipModel().getTextStyle().isVisible()) {
            this.graphUI.enableDataTips();
        } else {
            this.graphUI.disableDataTips();
        }
        if (this.graphModel.getBrushModel().isSelectionAllowed() && this.currentSelectionModel != null && this.currentModel != null) {
            this.graphUI.enableBrushSelection();
            this.graphUI.enableLMBClickSelection();
        } else {
            this.graphUI.disableBrushSelection();
            this.graphUI.disableLMBClickSelection();
        }
    }

    protected abstract void selectionChanged();

    protected abstract void updateDataModelListeners();

    protected void updateDataModelListeners(Object newModel, Object newSelectionModel) {
        if (this.currentModel != newModel) {
            this.removeFromListenerList(this.currentModel);
            this.addToListenerList(newModel);
            this.currentModel = newModel;
        }
        if (this.currentSelectionModel != newSelectionModel) {
            this.removeFromListenerList(this.currentSelectionModel);
            this.addToListenerList(newSelectionModel);
            this.currentSelectionModel = newSelectionModel;
            this.updateGraphUI();
        }
    }

    private void _setNote(JComponent container, NoteLabel[] components, NoteModel noteModel, int position) {
        String text;
        if (container == null || components == null || noteModel == null || position < 1 || position > components.length) {
            return;
        }
        int index = position - 1;
        NoteLabel noteLabel = components[index];
        if (noteLabel == null) {
            components[index] = noteLabel = new NoteLabel(noteModel, this.getChannel());
            noteLabel.setTextAntiAliasingEnabled(this.graphModel != null ? this.graphModel.isAntialiasedText() : true);
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 1;
            constraints.gridy = position;
            constraints.gridwidth = 1;
            constraints.gridheight = 1;
            constraints.weightx = 1.0;
            constraints.weighty = 0.0;
            constraints.fill = 2;
            constraints.anchor = 10;
            container.add((Component)noteLabel, constraints);
            this.revalidate();
        } else {
            noteLabel.setNoteModel(noteModel);
        }
        if (!this.designTime && container == this.titleContainer && position == 1 && (text = noteModel.getText()) != null && "showBuildDate".equalsIgnoreCase(text.trim())) {
            this._buildDatehack();
        }
    }

    private void _updateNoteLabels() {
        int ii;
        for (ii = 0; ii < this.titleComponents.length; ++ii) {
            if (this.titleComponents[ii] == null) continue;
            this.titleComponents[ii]._update();
        }
        for (ii = 0; ii < this.footnoteComponents.length; ++ii) {
            if (this.footnoteComponents[ii] == null) continue;
            this.footnoteComponents[ii]._update();
        }
    }

    private void _applyAntialiasedTextOnNoteLabels() {
        int ii;
        boolean isAntialiasedText = this.graphModel.isAntialiasedText();
        for (ii = 0; ii < this.titleComponents.length; ++ii) {
            if (this.titleComponents[ii] == null || isAntialiasedText == this.titleComponents[ii].isTextAntiAliasingEnabled()) continue;
            this.titleComponents[ii].setTextAntiAliasingEnabled(isAntialiasedText);
            this.titleComponents[ii].invalidate();
            this.titleComponents[ii].revalidate();
            this.titleComponents[ii].repaint();
        }
        for (ii = 0; ii < this.footnoteComponents.length; ++ii) {
            if (this.footnoteComponents[ii] == null || isAntialiasedText == this.footnoteComponents[ii].isTextAntiAliasingEnabled()) continue;
            this.footnoteComponents[ii].setTextAntiAliasingEnabled(isAntialiasedText);
            this.footnoteComponents[ii].invalidate();
            this.footnoteComponents[ii].revalidate();
            this.footnoteComponents[ii].repaint();
        }
    }

    protected void paintBackground(Graphics g, Rectangle bounds, Insets insets) {
        JComponent bg = this.chartContainer.getGraphBackground();
        if (bg instanceof MyBackground) {
            MyBackground mybg = (MyBackground)bg;
            mybg.paintBackground(g, bounds, insets);
        }
    }

    public void setDisplayPolicy(int newDisplayPolicy) throws IllegalArgumentException {
        switch (newDisplayPolicy) {
            default: {
                throw new IllegalArgumentException(RB.getStringResource("unRecognized.ex.txt"));
            }
            case 10000: 
            case 10001: 
            case 10002: 
            case 10200: 
        }
        if (newDisplayPolicy != this.displayPolicy) {
            int oldDisplayPolicy = this.displayPolicy;
            this.displayPolicy = newDisplayPolicy;
            if (this.graph instanceof Matrix) {
                ((Matrix)this.graph).setFitToScreen(this.displayPolicy == 10000 || this.displayPolicy == 10200);
                ((Matrix)this.graph).reconstruct();
                this.revalidate();
                this.repaint();
            }
            this.firePropertyChange("displayPolicy", oldDisplayPolicy, newDisplayPolicy);
        }
    }

    public int getDisplayPolicy() {
        return this.displayPolicy;
    }

    @SASScope
    protected void setGraph(JComponent newGraph) {
        if (newGraph != this.graph) {
            Matrix matrix;
            if (this.graph instanceof Matrix) {
                matrix = (Matrix)this.graph;
                matrix.setGraphModel(null);
                matrix.setMessageModel(null);
            }
            this.graph = newGraph;
            this.chartContainer.setChart(this.graph);
            if (this.graph instanceof Matrix) {
                matrix = (Matrix)this.graph;
                matrix.setGraphModel(this.graphModel);
                matrix.setMessageModel(this.messageModel);
            }
        }
    }

    @SASScope
    protected JComponent getGraph() {
        return this.graph;
    }

    public void setHeader(JComponent newHeader) {
        if (newHeader != this.header) {
            JComponent oldHeader = this.header;
            this.header = newHeader;
            this.chartContainer.setTitle(this.header != null ? this.header : this.titleContainer);
            this.firePropertyChange("header", oldHeader, newHeader);
        }
    }

    public JComponent getHeader() {
        return this.header;
    }

    public void setFooter(JComponent newFooter) {
        if (newFooter != this.footer) {
            JComponent oldFooter = this.footer;
            this.footer = newFooter;
            this.chartContainer.setFootnote(this.footer != null ? this.footer : this.footnoteContainer);
            this.firePropertyChange("footer", oldFooter, newFooter);
        }
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public PickInfo pick(int x, int y) {
        Point p;
        if (this.graph instanceof Matrix && (p = com.sas.graphics.util.cell.Util.toDescendent(x, y, this, this.graph)) != null) {
            return ((Matrix)this.graph).pick(p.x, p.y);
        }
        return null;
    }

    public PickInfo[] pick(int x, int y, int w, int h) {
        Rectangle2D i;
        Rectangle r;
        if (this.graph instanceof Matrix && (r = com.sas.graphics.util.cell.Util.toDescendent(x, y, w, h, this, this.graph)) != null && (i = r.createIntersection(this.graph.getBounds())).getWidth() > 0.0 && i.getHeight() > 0.0) {
            return ((Matrix)this.graph).pick(r.x, r.y, r.width, r.height);
        }
        return null;
    }

    public PickInfo select(int x, int y) {
        return this.select(x, y, false);
    }

    public PickInfo[] select(int x, int y, int w, int h) {
        return this.select(x, y, w, h, false);
    }

    public PickInfo select(int x, int y, boolean isControlDown) {
        Point p;
        if (this.graph instanceof Matrix && (p = com.sas.graphics.util.cell.Util.toDescendent(x, y, this, this.graph)) != null) {
            return ((Matrix)this.graph).select(p.x, p.y, isControlDown);
        }
        return null;
    }

    public PickInfo[] select(int x, int y, int w, int h, boolean isControlDown) {
        if (this.graph instanceof Matrix) {
            Rectangle2D i;
            Rectangle ar;
            if (w == 0 && h == 0) {
                return null;
            }
            if (w < 0) {
                x += w;
                w = -w;
            }
            if (h < 0) {
                y += h;
                h = -h;
            }
            if ((ar = com.sas.graphics.util.cell.Util.toDescendent(x, y, w, h, this, this.graph)) != null && (i = ar.createIntersection(this.graph.getBounds())).getWidth() > 0.0 && i.getHeight() > 0.0) {
                return ((Matrix)this.graph).select(ar.x, ar.y, ar.width, ar.height, isControlDown);
            }
        }
        return null;
    }

    public void clearSelection() {
        if (this.graph instanceof Matrix) {
            ((Matrix)this.graph).clearSelection();
        }
    }

    public PickInfo[] pickSelected() {
        if (this.graph instanceof Matrix) {
            return ((Matrix)this.graph).pickSelected();
        }
        return null;
    }

    public Rectangle getBrushBounds() {
        if (this.graph instanceof Matrix) {
            Component c = ((Matrix)this.graph).getBrushableComponent();
            if (c == null) {
                return null;
            }
            Rectangle r = c.getBounds();
            for (c = c.getParent(); c != null && c != this; c = c.getParent()) {
                Rectangle a = c.getBounds();
                if (a == null) continue;
                r.x += a.x;
                r.y += a.y;
            }
            return r;
        }
        return null;
    }

    @SASScope
    public void addProbeListener(ProbeListener l) {
        if (!com.sas.graphics.util.cell.Util.isHeadless()) {
            if (l != null) {
                this.probeListeners = EventMulticaster.addProbeListener(this.probeListeners, l);
            }
            if (this.probeListeners != null && this.probeMouseMotionListener == null) {
                this.probeMouseListener = new ProbeMouseListener();
                this.addMouseListener(this.probeMouseListener);
                this.probeMouseMotionListener = new ProbeMouseMotionListener();
                this.addMouseMotionListener(this.probeMouseMotionListener);
            }
        }
    }

    @SASScope
    public void removeProbeListener(ProbeListener l) {
        if (l != null) {
            this.probeListeners = EventMulticaster.removeProbeListener(this.probeListeners, l);
        }
        if (this.probeListeners == null && this.probeMouseMotionListener != null) {
            this.removeMouseListener(this.probeMouseListener);
            this.probeMouseListener = null;
            this.removeMouseMotionListener(this.probeMouseMotionListener);
            this.probeMouseMotionListener = null;
        }
    }

    private void fireProbeEvent(ProbeEvent probeEvent) {
        if (this.animationPosition == null || this.animationPosition.getInterpolationPercent() == 0.0) {
            this.probeListeners.probeUpdate(probeEvent);
            this.isProbeClearNeeded = probeEvent != null && probeEvent.getPickInfo() != null;
        }
    }

    @Override
    public synchronized void addMouseListener(MouseListener l) {
        if (!com.sas.graphics.util.cell.Util.isHeadless()) {
            try {
                super.addMouseListener(l);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener l) {
        if (!com.sas.graphics.util.cell.Util.isHeadless()) {
            try {
                super.addMouseMotionListener(l);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public synchronized void addMouseMotionListener(MouseWheelListener l) {
        if (!com.sas.graphics.util.cell.Util.isHeadless()) {
            try {
                super.addMouseWheelListener(l);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void addActionListener(GraphActionListener l) {
        if (!com.sas.graphics.util.cell.Util.isHeadless()) {
            if (l != null) {
                this.actionListeners = EventMulticaster.addActionListener(this.actionListeners, l);
            }
            if (this.actionListeners != null && this.graphActionMouseListener == null) {
                this.graphActionMouseListener = new GraphActionMouseListener();
                this.addMouseListener(this.graphActionMouseListener);
            }
        }
    }

    public void removeActionListener(GraphActionListener l) {
        if (l != null) {
            this.actionListeners = EventMulticaster.removeActionListener(this.actionListeners, l);
        }
        if (this.actionListeners == null && this.graphActionMouseListener != null) {
            this.removeMouseListener(this.graphActionMouseListener);
            this.graphActionMouseListener = null;
        }
    }

    public void setTitle(NoteModel newNoteModel, int position) throws IllegalArgumentException {
        if (newNoteModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (position < 1 || position > this.titles.length) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(this.titles.length).toString());
            throw new IllegalArgumentException(message);
        }
        int index = position - 1;
        NoteModel oldValue = this.titles[index];
        this.titles[index] = newNoteModel;
        this._setNote(this.titleContainer, this.titleComponents, newNoteModel, position);
        this.firePropertyChange("title" + position, oldValue, newNoteModel);
    }

    public NoteModel getTitle(int position) throws IllegalArgumentException {
        if (position < 1 || position > this.titles.length) {
            throw new IllegalArgumentException();
        }
        return this.titles[position - 1];
    }

    public void setTitle1(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setTitle(newNoteModel, 1);
    }

    public NoteModel getTitle1() {
        return this.getTitle(1);
    }

    public void setTitle2(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setTitle(newNoteModel, 2);
    }

    public NoteModel getTitle2() {
        return this.getTitle(2);
    }

    public void setTitle3(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setTitle(newNoteModel, 3);
    }

    public NoteModel getTitle3() {
        return this.getTitle(3);
    }

    public void setTitle4(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setTitle(newNoteModel, 4);
    }

    public NoteModel getTitle4() {
        return this.getTitle(4);
    }

    public void setFootnote(NoteModel newNoteModel, int position) throws IllegalArgumentException {
        if (newNoteModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        if (position < 1 || position > this.footnotes.length) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Integer(1).toString(), (Object)new Integer(this.footnotes.length).toString());
            throw new IllegalArgumentException(message);
        }
        int index = position - 1;
        NoteModel oldValue = this.footnotes[index];
        this.footnotes[index] = newNoteModel;
        this._setNote(this.footnoteContainer, this.footnoteComponents, newNoteModel, position);
        this.firePropertyChange("footnote" + position, oldValue, newNoteModel);
    }

    public NoteModel getFootnote(int position) throws IllegalArgumentException {
        if (position < 1 || position > this.footnotes.length) {
            throw new IllegalArgumentException();
        }
        return this.footnotes[position - 1];
    }

    public void setFootnote1(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setFootnote(newNoteModel, 1);
    }

    public NoteModel getFootnote1() {
        return this.getFootnote(1);
    }

    public void setFootnote2(NoteModel newNoteModel) throws IllegalArgumentException {
        this.setFootnote(newNoteModel, 2);
    }

    public NoteModel getFootnote2() {
        return this.getFootnote(2);
    }

    public int getAppliedGraphStyleName() {
        return this.appliedGraphStyleName;
    }

    public boolean isAppliedGraphStyleModified() {
        return this.appliedGraphStyleModified > 0;
    }

    public int getAppliedColorSchemeName() {
        return this.appliedColorSchemeName;
    }

    public void applyGraphStyle(GraphStyle graphStyle) {
        Color selectionAccentColor;
        if (graphStyle == null) {
            return;
        }
        this.disablePropertyChange();
        this.appliedGraphStyleName = graphStyle.getName();
        this.appliedGraphStyleModified = graphStyle.isModified() ? 1 : -1;
        this.appliedColorSchemeName = graphStyle.getAppliedColorSchemeName();
        this.titles[0].disablePropertyChange();
        this.titles[1].disablePropertyChange();
        this.titles[2].disablePropertyChange();
        this.titles[3].disablePropertyChange();
        this.footnotes[0].disablePropertyChange();
        this.footnotes[1].disablePropertyChange();
        Util.Conveyer.applyTextStyle(graphStyle.getTitle1TextStyle(), this.titles[0]);
        Util.Conveyer.applyTextStyle(graphStyle.getTitle2TextStyle(), this.titles[1]);
        Util.Conveyer.applyTextStyle(graphStyle.getTitle3TextStyle(), this.titles[2]);
        Util.Conveyer.applyTextStyle(graphStyle.getTitle4TextStyle(), this.titles[3]);
        Util.Conveyer.applyTextStyle(graphStyle.getFootnote1TextStyle(), this.footnotes[0]);
        Util.Conveyer.applyTextStyle(graphStyle.getFootnote2TextStyle(), this.footnotes[1]);
        this.titles[0].enablePropertyChange();
        this.titles[1].enablePropertyChange();
        this.titles[2].enablePropertyChange();
        this.titles[3].enablePropertyChange();
        this.footnotes[0].enablePropertyChange();
        this.footnotes[1].enablePropertyChange();
        this.graphModel.getDataElementStyles().apply(graphStyle.getDataElementStyles());
        this.graphModel.getBackgroundFillStyle().apply(graphStyle.getBackgroundFillStyle());
        this.graphModel.getFrameLineStyle().apply(graphStyle.getFrameLineStyle());
        this.graphModel.getDataTipModel().setBackgroundColor(graphStyle.getDataTipBackgroundColor());
        Util.Conveyer.applyTextStyle(graphStyle.getDataTipTextStyle(), this.graphModel.getDataTipModel());
        Color selectionColor = graphStyle.getSelectionColor();
        if (selectionColor != null) {
            this.graphModel.getBrushModel().setSelectionColor(selectionColor);
        }
        if ((selectionAccentColor = graphStyle.getSelectionAccentColor()) != null) {
            this.graphModel.getBrushModel().setSelectionAccentColor(selectionAccentColor);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void applyColorScheme(ColorScheme scheme) {
        Color selectionAccentColor;
        if (scheme == null) {
            return;
        }
        this.disablePropertyChange();
        this.appliedColorSchemeName = scheme.getName();
        this.appliedGraphStyleModified = 1;
        Color tfc = scheme.getTitleFootnoteColor();
        Color fc = scheme.getFrameColor();
        Color sc = scheme.getShadowColor();
        this.titles[0].disablePropertyChange();
        this.titles[1].disablePropertyChange();
        this.titles[2].disablePropertyChange();
        this.titles[3].disablePropertyChange();
        this.footnotes[0].disablePropertyChange();
        this.footnotes[1].disablePropertyChange();
        if (tfc != null) {
            this.titles[0].getTextStyle().setColor(tfc);
            this.titles[1].getTextStyle().setColor(tfc);
            this.titles[2].getTextStyle().setColor(tfc);
            this.titles[3].getTextStyle().setColor(tfc);
            this.footnotes[0].getTextStyle().setColor(tfc);
            this.footnotes[1].getTextStyle().setColor(tfc);
            if (this.designTime && this.internalFootnote != null) {
                this.internalFootnote.getTextStyle().setColor(tfc);
            }
        }
        if (fc != null) {
            // empty if block
        }
        if (sc != null) {
            this.titles[0].getTextStyle().getShadowStyle().setColor(sc);
            this.titles[1].getTextStyle().getShadowStyle().setColor(sc);
            this.titles[2].getTextStyle().getShadowStyle().setColor(sc);
            this.titles[3].getTextStyle().getShadowStyle().setColor(sc);
            this.footnotes[0].getTextStyle().getShadowStyle().setColor(sc);
            this.footnotes[1].getTextStyle().getShadowStyle().setColor(sc);
            if (this.designTime && this.internalFootnote != null) {
                this.internalFootnote.getTextStyle().getShadowStyle().setColor(sc);
            }
        }
        if (scheme.getDataElementColors() != null) {
            this.graphModel.getDataElementStyles().applyDataElementColors(scheme.getDataElementColors());
        }
        if (scheme.getBackgroundColor() != null) {
            this.graphModel.getBackgroundFillStyle().setSolidFillColor(scheme.getBackgroundColor());
        }
        if (fc != null) {
            this.graphModel.getFrameLineStyle().setColor(fc);
        }
        this.titles[0].enablePropertyChange();
        this.titles[1].enablePropertyChange();
        this.titles[2].enablePropertyChange();
        this.titles[3].enablePropertyChange();
        this.footnotes[0].enablePropertyChange();
        this.footnotes[1].enablePropertyChange();
        Color selectionColor = scheme.getSelectionColor();
        if (selectionColor != null) {
            this.graphModel.getBrushModel().setSelectionColor(selectionColor);
        }
        if ((selectionAccentColor = scheme.getSelectionAccentColor()) != null) {
            this.graphModel.getBrushModel().setSelectionAccentColor(selectionAccentColor);
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    protected Channel getChannel() {
        return this.channel;
    }

    private void _buildDatehack() {
        String buildDate;
        Package p = this.getClass().getPackage();
        String string = buildDate = p != null ? p.getImplementationVersion() : null;
        if (buildDate != null) {
            this.internalFootnote = new NoteModel(buildDate);
            this.internalFootnote.getTextStyle().setJustification(2);
            this._setNote(this.footnoteContainer, this.footnoteComponents, this.internalFootnote, this.footnotes.length + 1);
        }
    }

    static {
        DEFAULT_LINE_THICKNESS = new BaseLength(1.0, "px");
        defaultGraphStyle = new GraphStyle(100004);
        MarkerStyle[] ms = defaultGraphStyle.getDataElementStyles().getMarkerStyles();
        for (int ii = 0; ii < ms.length; ++ii) {
            ms[ii].setInterpolation(40002);
        }
        StrokeLineStyle[] sls = defaultGraphStyle.getDataElementStyles().getLineStyles();
        for (int ii = 0; ii < sls.length; ++ii) {
            sls[ii].setSASGraphLineStyle(30001);
            sls[ii].setThickness(DEFAULT_LINE_THICKNESS);
        }
    }

    @SASScope
    private final class DataTipPanel
    extends JComponent {
        public final DataTipProbeListener probeListener = new DataTipProbeListener();
        final Probe cachedprobe = new Probe();
        Probe activeProbe;
        int adjProbeX;
        int adjProbeY;

        public DataTipPanel() {
            this.setOpaque(false);
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            this.cachedprobe.setViewport(x, y, w, h);
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.activeProbe != null) {
                this.activeProbe.draw(g, 0, 0, 0);
            }
        }

        @Override
        public void printComponent(Graphics g) {
        }

        @Override
        public void print(Graphics g) {
        }

        private boolean detach() {
            if (Graph.this.chartContainer.getDataTip() != null) {
                this.probeListener.resetCache();
                Graph.this.chartContainer.setDataTip(null);
                this.activeProbe = null;
                return true;
            }
            return false;
        }

        @SASScope
        class DataTipProbeListener
        implements ProbeListener {
            private PickInfo lastPickInfo = null;

            DataTipProbeListener() {
            }

            public void resetCache() {
                this.lastPickInfo = null;
            }

            @Override
            public void probeUpdate(ProbeEvent e) {
                if (DataTipPanel.this.isVisible()) {
                    DataTipModel dataTipModel = Graph.this.graphModel.getDataTipModel();
                    PickInfo pickInfo = e.getPickInfo();
                    if (this.lastPickInfo != null && pickInfo != null && this.lastPickInfo.getObservationIndex() == pickInfo.getObservationIndex()) {
                        return;
                    }
                    this.lastPickInfo = pickInfo;
                    if (e.getID() == 0 && pickInfo != null) {
                        DataTipPanel.this.activeProbe = DataTipPanel.this.cachedprobe;
                        Graph.this.chartContainer.setDataTip(DataTipPanel.this);
                        DataTipPanel.this.activeProbe.setFont(dataTipModel.getTextStyle().getFont());
                        DataTipPanel.this.activeProbe.setForegroundColor(dataTipModel.getTextStyle().getColor());
                        DataTipPanel.this.activeProbe.setBackgroundColor(dataTipModel.getBackgroundColor());
                        DataTipPanel.this.setOpaque(DataTipPanel.this.activeProbe.getBackgroundColor().getAlpha() == 255);
                        int visibleEntries = 0;
                        Vector[] labelValueCollection = pickInfo.getLabelValueCollection();
                        if (labelValueCollection != null) {
                            DataTipPanel.this.activeProbe.removeAll();
                            for (int ii = 0; ii < labelValueCollection.length; ++ii) {
                                Vector labelValues = labelValueCollection[ii];
                                if (labelValues == null) continue;
                                int size = labelValues.size();
                                for (int jj = 0; jj < size; ++jj) {
                                    Boolean visible;
                                    Hashtable labelValue = (Hashtable)labelValues.elementAt(jj);
                                    if (labelValue == null || (visible = (Boolean)labelValue.get(PickInfo.VISIBLE)) != null && !visible.booleanValue()) continue;
                                    String label = (String)labelValue.get(PickInfo.LABEL);
                                    String formattedValue = (String)labelValue.get(PickInfo.FORMATTED_VALUE);
                                    if (label == null || formattedValue == null) continue;
                                    DataTipPanel.this.activeProbe.addString(label, formattedValue);
                                    ++visibleEntries;
                                }
                            }
                            if (visibleEntries == 0) {
                                return;
                            }
                            int probeX = pickInfo.getX();
                            int probeY = pickInfo.getY();
                            Dimension d = DataTipPanel.this.activeProbe.getPreferredSize(DataTipPanel.this.getGraphics(), 0);
                            switch (dataTipModel.getHorizontalJustification()) {
                                default: {
                                    probeX -= d.width / 2;
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                                case 4: {
                                    probeX -= d.width;
                                }
                            }
                            probeY = (int)((double)probeY - ((double)d.height + dataTipModel.getVerticalOffset().getMagnitude((Object)"px")));
                            probeX = (int)((double)probeX - dataTipModel.getHorizontalOffset().getMagnitude((Object)"px"));
                            Rectangle b = DataTipPanel.this.getParent().getBounds();
                            if (probeY < 0) {
                                probeY = 0;
                            }
                            if (probeX + d.width > b.width) {
                                probeX = b.width - d.width;
                            }
                            if (probeX < 0) {
                                probeX = 0;
                            }
                            DataTipPanel.this.setBounds(probeX, probeY, d.width, d.height);
                        }
                        DataTipPanel.this.repaint();
                    } else {
                        Rectangle b = DataTipPanel.this.getBounds();
                        DataTipPanel.this.detach();
                        Graph.this.chartContainer.repaint(b.x, b.y, b.width, b.height);
                    }
                }
            }
        }
    }

    @SASScope
    private final class BrushPanel
    extends JComponent {
        public BrushPanel() {
            this.setOpaque(false);
            this.setBorder(new LineBorder(Color.black, 1));
        }

        @Override
        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, y, w, h);
            if (w > 0 && h > 0) {
                if (Graph.this.chartContainer.getBrush() == null) {
                    Graph.this.chartContainer.setBrush(this);
                }
            } else if (this.detach()) {
                this.revalidate();
                this.repaint();
            }
        }

        private boolean detach() {
            if (Graph.this.chartContainer.getBrush() != null) {
                Graph.this.chartContainer.setBrush(null);
                return true;
            }
            return false;
        }
    }

    @SASScope
    private class GraphUI {
        private final DataTipPanel myDataTipPanel;
        private final BrushPanel myBrushPanel;
        private Point pickPoint;
        private Point rubberBandPickPoint;
        private Rectangle rubberBand;
        private static final int PICK_MODE_DATA_TIP = 0;
        private static final int PICK_MODE_BRUSH_GROW = 1;
        private static final int PICK_MODE_BRUSH_MOVE = 2;
        private int pickMode;
        private boolean isMouseExitPending;
        private boolean isMouseFocusOwner;
        private boolean isMultipleSelectionkModeEnabled;
        private final MouseListener myLMBClickSelectionMouseListener;
        private final MouseListener myBrushSelectionMouseListener;
        private final MouseMotionListener myBrushSelectionMouseMotionListener;
        private boolean isLMBClickSelectionEnabled;
        private boolean isBrushSelectionEnabled;
        private boolean isDataTipsEnabled;

        private GraphUI() {
            this.myDataTipPanel = new DataTipPanel();
            this.myBrushPanel = new BrushPanel();
            this.pickPoint = null;
            this.rubberBandPickPoint = null;
            this.rubberBand = null;
            this.pickMode = 0;
            this.isMouseExitPending = false;
            this.isMouseFocusOwner = false;
            this.isMultipleSelectionkModeEnabled = true;
            this.myLMBClickSelectionMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (GraphUI.this.isTakeActionClick(e)) {
                        Graph.this.select(e.getX(), e.getY(), e.isControlDown());
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    GraphUI.this.isMouseFocusOwner = false;
                    if (GraphUI.this.rubberBand != null && GraphUI.this.pickMode != 0) {
                        GraphUI.this.isMouseExitPending = true;
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    GraphUI.this.isMouseFocusOwner = true;
                    if (GraphUI.this.rubberBand != null && GraphUI.this.pickMode != 0) {
                        GraphUI.this.isMouseExitPending = false;
                    }
                }
            };
            this.myBrushSelectionMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (GraphUI.this.isTakeActionClick(e)) {
                        GraphUI.this.pickMode = 0;
                        GraphUI.this.rubberBand = null;
                        if (!GraphUI.this.isLMBClickSelectionEnabled) {
                            GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                        }
                        GraphUI.this._repaintBrush();
                    }
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    GraphUI.this.eraseDataTip();
                    Graph.this.chartContainer.repaint();
                    if (GraphUI.this.isTakeActionClick(e)) {
                        if (Graph.this.currentSelectionModel instanceof ListSelectionModel) {
                            GraphUI.this.isMultipleSelectionkModeEnabled = ((ListSelectionModel)Graph.this.currentSelectionModel).getSelectionMode() == 2;
                        } else {
                            GraphUI.this.isMultipleSelectionkModeEnabled = true;
                        }
                        GraphUI.this.pickPoint = new Point(e.getX(), e.getY());
                        GraphUI.this.pickMode = GraphUI.this.rubberBand != null && GraphUI.this.rubberBand.contains(((GraphUI)GraphUI.this).pickPoint.x, ((GraphUI)GraphUI.this).pickPoint.y) ? 2 : 1;
                        if (GraphUI.this.pickMode == 1) {
                            GraphUI.this.rubberBand = GraphUI.this._createRubberBand(((GraphUI)GraphUI.this).pickPoint.x, ((GraphUI)GraphUI.this).pickPoint.y, 0, 0, e.isShiftDown());
                            if (Graph.this.graphModel.getBrushModel().isSelectOnGrow()) {
                                ListSelectionModel lsm;
                                if (Graph.this.currentSelectionModel instanceof ListSelectionModel && !(lsm = (ListSelectionModel)Graph.this.currentSelectionModel).getValueIsAdjusting()) {
                                    lsm.setValueIsAdjusting(true);
                                }
                                GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                            }
                            GraphUI.this._repaintBrush();
                        } else if (GraphUI.this.pickMode == 2) {
                            ListSelectionModel lsm;
                            GraphUI.this.rubberBandPickPoint = new Point(((GraphUI)GraphUI.this).rubberBand.x, ((GraphUI)GraphUI.this).rubberBand.y);
                            if (Graph.this.graphModel.getBrushModel().isSelectOnMove() && Graph.this.currentSelectionModel instanceof ListSelectionModel && !(lsm = (ListSelectionModel)Graph.this.currentSelectionModel).getValueIsAdjusting()) {
                                lsm.setValueIsAdjusting(true);
                            }
                        }
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (GraphUI.this.isTakeActionClick(e) && GraphUI.this.rubberBand != null) {
                        if (GraphUI.this.isMouseExitPending) {
                            GraphUI.this.isMouseExitPending = false;
                            GraphUI.this.removeBrush();
                        } else {
                            int mx = e.getX();
                            int my = e.getY();
                            if (GraphUI.this.pickMode == 1) {
                                int x = ((GraphUI)GraphUI.this).pickPoint.x;
                                int y = ((GraphUI)GraphUI.this).pickPoint.y;
                                int w = mx - ((GraphUI)GraphUI.this).pickPoint.x;
                                int h = my - ((GraphUI)GraphUI.this).pickPoint.y;
                                if (w == 0 && h == 0) {
                                    GraphUI.this.rubberBand = null;
                                    GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                                    GraphUI.this._repaintBrush();
                                } else {
                                    GraphUI.this.rubberBand = GraphUI.this._createRubberBand(x, y, w, h, e.isShiftDown());
                                    GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                                    GraphUI.this._repaintBrush();
                                }
                            } else if (GraphUI.this.pickMode == 2 && GraphUI.this.rubberBandPickPoint != null) {
                                int xo = mx - ((GraphUI)GraphUI.this).pickPoint.x;
                                int yo = my - ((GraphUI)GraphUI.this).pickPoint.y;
                                int x = ((GraphUI)GraphUI.this).rubberBandPickPoint.x;
                                int y = ((GraphUI)GraphUI.this).rubberBandPickPoint.y;
                                int w = (int)GraphUI.this.rubberBand.getWidth();
                                int h = (int)GraphUI.this.rubberBand.getHeight();
                                GraphUI.this.rubberBand = GraphUI.this._moveRubberBand(xo, yo, x, y, w, h, e.isShiftDown());
                                GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                                GraphUI.this._repaintBrush();
                            }
                        }
                        if (GraphUI.this.pickMode == 1) {
                            if (Graph.this.graphModel.getBrushModel().isSelectOnGrow() && Graph.this.currentSelectionModel instanceof ListSelectionModel) {
                                ListSelectionModel lsm = (ListSelectionModel)Graph.this.currentSelectionModel;
                                lsm.setValueIsAdjusting(false);
                            }
                        } else if (GraphUI.this.pickMode == 2 && Graph.this.graphModel.getBrushModel().isSelectOnMove() && Graph.this.currentSelectionModel instanceof ListSelectionModel) {
                            ListSelectionModel lsm = (ListSelectionModel)Graph.this.currentSelectionModel;
                            lsm.setValueIsAdjusting(false);
                        }
                        GraphUI.this.pickPoint = null;
                        GraphUI.this.rubberBandPickPoint = null;
                    }
                    GraphUI.this.pickMode = 0;
                }
            };
            this.myBrushSelectionMouseMotionListener = new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    if (GraphUI.this.isTakeActionClick(e) && GraphUI.this.rubberBand != null) {
                        int mx = e.getX();
                        int my = e.getY();
                        if (GraphUI.this.pickMode == 1) {
                            int x = ((GraphUI)GraphUI.this).pickPoint.x;
                            int y = ((GraphUI)GraphUI.this).pickPoint.y;
                            int w = mx - x;
                            int h = my - y;
                            GraphUI.this.rubberBand = GraphUI.this._createRubberBand(x, y, w, h, e.isShiftDown());
                            if (Graph.this.graphModel.getBrushModel().isSelectOnGrow()) {
                                GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                            }
                            GraphUI.this._repaintBrush();
                        } else if (GraphUI.this.pickMode == 2 && GraphUI.this.rubberBandPickPoint != null) {
                            int xo = mx - ((GraphUI)GraphUI.this).pickPoint.x;
                            int yo = my - ((GraphUI)GraphUI.this).pickPoint.y;
                            int x = ((GraphUI)GraphUI.this).rubberBandPickPoint.x;
                            int y = ((GraphUI)GraphUI.this).rubberBandPickPoint.y;
                            int w = (int)GraphUI.this.rubberBand.getWidth();
                            int h = (int)GraphUI.this.rubberBand.getHeight();
                            GraphUI.this.rubberBand = GraphUI.this._moveRubberBand(xo, yo, x, y, w, h, e.isShiftDown());
                            if (Graph.this.graphModel.getBrushModel().isSelectOnMove()) {
                                GraphUI.this._select(GraphUI.this.rubberBand, e.isControlDown());
                            }
                            GraphUI.this._repaintBrush();
                        }
                    }
                }
            };
            this.isLMBClickSelectionEnabled = false;
            this.isBrushSelectionEnabled = false;
            this.isDataTipsEnabled = false;
        }

        private boolean isTakeActionClick(MouseEvent e) {
            return e != null && !e.isPopupTrigger() && (e.getModifiers() & 0x10) != 0;
        }

        private Rectangle _newRectangle(int x, int y, int w, int h) {
            if (w < 0) {
                x += w;
                w = -w;
            }
            if (h < 0) {
                y += h;
                h = -h;
            }
            return new Rectangle(x, y, w, h);
        }

        private Rectangle _createRubberBand(int x, int y, int w, int h, boolean isConstrained) {
            if (!this.isMultipleSelectionkModeEnabled) {
                isConstrained = false;
                x += w;
                y += h;
                w = 1;
                h = 1;
            }
            Rectangle rb = this._newRectangle(x, y, w, h);
            Rectangle brushBounds = Graph.this.getBrushBounds();
            if (brushBounds != null) {
                rb = brushBounds.intersection(rb);
                if (rb.width < 0 || rb.height < 0) {
                    return null;
                }
                if (rb.width < 0) {
                    rb.width = 0;
                }
                if (rb.height < 0) {
                    rb.height = 0;
                }
            }
            if (isConstrained) {
                if (rb.width > rb.height) {
                    int l = rb.height;
                    rb = this._newRectangle(x, y, w < 0 ? -l : l, h < 0 ? -l : l);
                } else {
                    int l = rb.width;
                    rb = this._newRectangle(x, y, w < 0 ? -l : l, h < 0 ? -l : l);
                }
            }
            return rb;
        }

        private Rectangle _moveRubberBand(int xo, int yo, int x, int y, int w, int h, boolean isConstrained) {
            if (isConstrained) {
                if (Math.abs(xo) > Math.abs(yo)) {
                    yo = 0;
                } else {
                    xo = 0;
                }
            }
            Rectangle rb = this._newRectangle(x += xo, y += yo, w, h);
            Rectangle brushBounds = Graph.this.getBrushBounds();
            if (brushBounds != null) {
                if (rb.x + rb.width > brushBounds.x + brushBounds.width) {
                    rb.x = brushBounds.x + brushBounds.width - rb.width;
                }
                if (rb.x < brushBounds.x) {
                    rb.x = brushBounds.x;
                }
                if (rb.y + rb.height > brushBounds.y + brushBounds.height) {
                    rb.y = brushBounds.y + brushBounds.height - rb.height;
                }
                if (rb.y < brushBounds.y) {
                    rb.y = brushBounds.y;
                }
            }
            return rb;
        }

        private void _select(Rectangle rb, boolean isControlDown) {
            if (rb == null) {
                if (!isControlDown) {
                    Graph.this.clearSelection();
                }
            } else {
                int x = (int)rb.getX();
                int y = (int)rb.getY();
                int w = (int)rb.getWidth();
                int h = (int)rb.getHeight();
                if (w == 0 && h == 0 && !isControlDown) {
                    Graph.this.clearSelection();
                }
                Graph.this.select(x, y, w, h, isControlDown);
            }
        }

        private void _repaintBrush() {
            if (this.rubberBand == null) {
                if (this.myBrushPanel.detach()) {
                    Graph.this.revalidate();
                    Graph.this.repaint();
                }
            } else {
                int w = (int)this.rubberBand.getWidth();
                int h = (int)this.rubberBand.getHeight();
                if (w <= 1 && h <= 1) {
                    if (this.myBrushPanel.detach()) {
                        Graph.this.revalidate();
                        Graph.this.repaint();
                    }
                } else {
                    Insets i = Graph.this.getInsets();
                    int x = (int)this.rubberBand.getX() - i.left;
                    int y = (int)this.rubberBand.getY() - i.top;
                    this.myBrushPanel.setBounds(x, y, w, h);
                }
            }
        }

        public boolean removeBrush() {
            if (this.rubberBand != null) {
                this.rubberBand = null;
                this._repaintBrush();
                return true;
            }
            return false;
        }

        public void enableLMBClickSelection() {
            if (!com.sas.graphics.util.cell.Util.isHeadless() && !this.isLMBClickSelectionEnabled) {
                this.isLMBClickSelectionEnabled = true;
                Graph.this.addMouseListener(this.myLMBClickSelectionMouseListener);
            }
        }

        public void disableLMBClickSelection() {
            if (this.isLMBClickSelectionEnabled) {
                Graph.this.removeMouseListener(this.myLMBClickSelectionMouseListener);
                this.isLMBClickSelectionEnabled = false;
            }
        }

        public void enableBrushSelection() {
            if (!com.sas.graphics.util.cell.Util.isHeadless() && !this.isBrushSelectionEnabled) {
                this.isBrushSelectionEnabled = true;
                Graph.this.addMouseListener(this.myBrushSelectionMouseListener);
                Graph.this.addMouseMotionListener(this.myBrushSelectionMouseMotionListener);
            }
        }

        public void refreshDataTip() {
            Point mousePosition;
            if (!com.sas.graphics.util.cell.Util.isHeadless() && Graph.this.isDisplayable() && (mousePosition = Graph.this.getMousePosition()) != null) {
                PickInfo pickInfo = Graph.this.pick((int)mousePosition.getX(), (int)mousePosition.getY());
                if (pickInfo != null) {
                    Graph.this.fireProbeEvent(new ProbeEvent((Object)Graph.this, pickInfo));
                } else if (Graph.this.isProbeClearNeeded) {
                    Graph.this.fireProbeEvent(new ProbeEvent((Object)Graph.this, null));
                }
            }
        }

        public void refreshBrushSelection() {
            if (this.rubberBand != null) {
                int x = (int)this.rubberBand.getX();
                int y = (int)this.rubberBand.getY();
                int w = (int)this.rubberBand.getWidth();
                int h = (int)this.rubberBand.getHeight();
                if (w != 0 && h != 0) {
                    Graph.this.keepRubberBandOnSelection = true;
                    Graph.this.select(x, y, w, h, false);
                    Graph.this.keepRubberBandOnSelection = false;
                }
                this._repaintBrush();
            }
        }

        public void disableBrushSelection() {
            if (this.isBrushSelectionEnabled) {
                Graph.this.removeMouseListener(this.myBrushSelectionMouseListener);
                Graph.this.removeMouseMotionListener(this.myBrushSelectionMouseMotionListener);
                this.removeBrush();
                this.isBrushSelectionEnabled = false;
            }
        }

        public void enableDataTips() {
            if (!com.sas.graphics.util.cell.Util.isHeadless() && !this.isDataTipsEnabled) {
                this.isDataTipsEnabled = true;
                Graph.this.addProbeListener(this.myDataTipPanel.probeListener);
            }
        }

        public void disableDataTips() {
            if (this.isDataTipsEnabled) {
                Graph.this.removeProbeListener(this.myDataTipPanel.probeListener);
                this.isDataTipsEnabled = false;
            }
        }

        public void eraseDataTip() {
            if (this.myDataTipPanel.detach()) {
                Graph.this.revalidate();
                Graph.this.repaint();
            }
        }

        public boolean isMouseFocusOwner() {
            return this.isMouseFocusOwner;
        }
    }

    @SASScope
    private class GraphActionMouseListener
    extends MouseAdapter {
        private GraphActionMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event != null && Graph.this.actionListeners != null) {
                PickInfo pickInfo = Graph.this.pick(event.getX(), event.getY());
                if (pickInfo != null) {
                    pickInfo.setMouseEvent(event);
                    Graph.this.actionListeners.actionPerformed(new GraphActionEvent((Object)Graph.this, pickInfo));
                } else {
                    Graph.this.actionListeners.actionPerformed(new GraphActionEvent((Object)Graph.this, null));
                }
            }
        }
    }

    @SASScope
    private class ProbeMouseListener
    extends MouseAdapter {
        private ProbeMouseListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (Graph.this.isProbeClearNeeded) {
                Graph.this.fireProbeEvent(new ProbeEvent((Object)Graph.this, null));
            }
        }
    }

    @SASScope
    private class ProbeMouseMotionListener
    extends MouseMotionAdapter {
        private ProbeMouseMotionListener() {
        }

        @Override
        public void mouseMoved(MouseEvent event) {
            if (event != null && Graph.this.probeListeners != null) {
                PickInfo pickInfo = Graph.this.pick(event.getX(), event.getY());
                if (pickInfo != null) {
                    pickInfo.setMouseEvent(event);
                    Graph.this.fireProbeEvent(new ProbeEvent((Object)Graph.this, pickInfo));
                } else if (Graph.this.isProbeClearNeeded) {
                    Graph.this.fireProbeEvent(new ProbeEvent((Object)Graph.this, null));
                }
            }
        }
    }

    @SASScope
    private final class MyBackground
    extends JComponent {
        private final ImageIcon imageIcon = new ImageIcon();
        private FillStyle fillStyle;
        private ImageIcon logo;
        private int logoJustification;

        public MyBackground() {
            this.setOpaque(false);
        }

        public void setFillStyle(FillStyle newFillStyle) {
            this.fillStyle = newFillStyle;
        }

        public FillStyle getFillStyle() {
            return this.fillStyle;
        }

        public void setLogo(ImageIcon newLogo) {
            this.logo = newLogo;
        }

        public ImageIcon getLogo() {
            return this.logo;
        }

        public void setLogoJustification(int justification) {
            this.logoJustification = justification;
        }

        public int getLogoJustification() {
            return this.logoJustification;
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (g != null) {
                super.paintComponent(g);
                Rectangle r = this.getBounds();
                Insets insets = this.getInsets();
                if (r != null && insets != null) {
                    this.paintBackground(g, r, insets);
                }
            }
        }

        public void paintBackground(Graphics g, Rectangle r, Insets insets) {
            int y;
            int x;
            int ys;
            int xs;
            int ih;
            if (g == null || r == null || insets == null) {
                return;
            }
            if (this.fillStyle != null && this.fillStyle.isVisible()) {
                if (this.fillStyle.getFillType() == 20002 || this.fillStyle.getFillType() == 20003 || this.fillStyle.getFillType() == 20004) {
                    if (this.fillStyle.getImageIcon() != null) {
                        this.imageIcon.setImage(this.fillStyle.getImageIcon().getImage());
                        int iw = this.imageIcon.getIconWidth();
                        ih = this.imageIcon.getIconHeight();
                        xs = r.width - (insets.left + insets.right);
                        ys = r.height - (insets.top + insets.bottom);
                        if (this.fillStyle.getImageFill() == 20201) {
                            int xc = xs / iw + 1;
                            int yc = ys / ih + 1;
                            for (int ii = 0; ii < yc; ++ii) {
                                for (int jj = 0; jj < xc; ++jj) {
                                    this.imageIcon.paintIcon(this, g, insets.left + iw * jj, insets.top + ih * ii);
                                }
                            }
                        } else if (this.fillStyle.getImageFill() == 20200) {
                            g.drawImage(this.imageIcon.getImage(), 0, 0, xs, ys, this);
                        } else {
                            x = 0;
                            y = 0;
                            switch (this.fillStyle.getImageFill()) {
                                case 20203: {
                                    x = (int)((double)(xs - iw) / 2.0 + 0.5);
                                    y = (int)((double)(ys - ih) / 2.0 + 0.5);
                                    break;
                                }
                                case 20204: {
                                    x = (int)((double)(xs - iw) / 2.0 + 0.5);
                                    break;
                                }
                                case 20205: {
                                    break;
                                }
                                case 20206: {
                                    x = xs - iw;
                                    break;
                                }
                                case 20207: {
                                    x = (int)((double)(xs - iw) / 2.0 + 0.5);
                                    y = ys - ih;
                                    break;
                                }
                                case 20208: {
                                    y = ys - ih;
                                    break;
                                }
                                case 20209: {
                                    x = xs - iw;
                                    y = ys - ih;
                                    break;
                                }
                                case 20202: {
                                    x = this.fillStyle.getX();
                                    y = this.fillStyle.getY();
                                }
                            }
                            g.setColor(this.fillStyle.getImageFillColor());
                            g.fillRect(0, 0, r.width + 1, r.height + 1);
                            g.drawImage(this.imageIcon.getImage(), x, y, iw, ih, this);
                        }
                    }
                    if (this.fillStyle.getFillType() == 20003) {
                        Color c = this.fillStyle.getSolidBlendColor();
                        if (c.getAlpha() == 255) {
                            c = new Color(c.getRed(), c.getGreen(), c.getBlue(), 100);
                        }
                        g.setColor(c);
                        g.fillRect(0, 0, r.width + 1, r.height + 1);
                    } else if (this.fillStyle.getFillType() == 20004) {
                        ((Graphics2D)g).setPaint(this._newGradientPaint(this.fillStyle, r, true));
                        g.fillRect(0, 0, r.width + 1, r.height + 1);
                    }
                } else if (this.fillStyle.getFillType() == 20000) {
                    g.setColor(this.fillStyle.getSolidFillColor());
                    g.fillRect(0, 0, r.width + 1, r.height + 1);
                } else if (this.fillStyle.getFillType() == 20001) {
                    ((Graphics2D)g).setPaint(this._newGradientPaint(this.fillStyle, r, false));
                    g.fillRect(0, 0, r.width + 1, r.height + 1);
                }
            }
            if (this.logo != null) {
                int iw = this.logo.getIconWidth();
                ih = this.logo.getIconHeight();
                xs = r.width - (insets.left + insets.right);
                ys = r.height - (insets.top + insets.bottom);
                x = 0;
                y = 0;
                switch (this.logoJustification) {
                    case 8: 
                    case 20205: {
                        break;
                    }
                    case 2: 
                    case 20206: {
                        x = xs - iw;
                        break;
                    }
                    case 6: 
                    case 20208: {
                        y = ys - ih;
                        break;
                    }
                    case 4: 
                    case 20209: {
                        x = xs - iw;
                        y = ys - ih;
                    }
                }
                g.drawImage(this.logo.getImage(), x, y, iw, ih, this);
            }
        }

        private Paint _newGradientPaint(FillStyle fs, Rectangle r, boolean blend) {
            boolean x1 = false;
            int y1 = 0;
            int x2 = 0;
            int y2 = 0;
            Color color1 = null;
            Color color2 = null;
            if (blend) {
                color1 = fs.getGradientBlendBeginColor();
                color2 = fs.getGradientBlendEndColor();
                if (color1.getAlpha() == 255 && color2.getAlpha() == 255) {
                    color1 = new Color(color1.getRed(), color1.getGreen(), color1.getBlue(), 100);
                    color2 = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), 100);
                }
            } else {
                color1 = fs.getGradientFillBeginColor();
                color2 = fs.getGradientFillEndColor();
            }
            switch (fs.getGradientFill()) {
                default: {
                    y1 = r.height;
                    break;
                }
                case 20103: {
                    y1 = r.height;
                    x2 = r.width;
                    break;
                }
                case 20104: {
                    y2 = r.height;
                    x2 = r.width;
                    break;
                }
                case 20100: {
                    x2 = r.width;
                }
            }
            return new GradientPaint((float)x1, y1, color1, x2, y2, color2);
        }
    }

    @SASScope
    private final class ContainedModelSupport {
        private final Hashtable containedModels = new Hashtable();
        private final PropertyChangeListener containedModelPropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (Graph.this.eventGate == 0) {
                    Enumeration keys = ContainedModelSupport.this.containedModels.keys();
                    while (keys.hasMoreElements()) {
                        String propertyName = (String)keys.nextElement();
                        ModelBase model = (ModelBase)ContainedModelSupport.this.containedModels.get(propertyName);
                        if (e.getSource() != model) continue;
                        if ("graphModel".equals(propertyName)) {
                            if (!("antialiasedGraphics".equals(e.getPropertyName()) || "antialiasedText".equals(e.getPropertyName()) || "displayMissing".equals(e.getPropertyName()))) {
                                Graph.this.appliedGraphStyleModified++;
                            }
                        } else if ((propertyName.startsWith("title") || propertyName.startsWith("footnote")) && !"text".equals(e.getPropertyName())) {
                            Graph.this.appliedGraphStyleModified++;
                        }
                        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(Graph.this, propertyName, null, e.getSource());
                        propertyChangeEvent.setPropagationId(e);
                        Graph.this.firePropertyChange(propertyChangeEvent);
                    }
                }
            }
        };

        private ContainedModelSupport() {
        }

        public void put(String property, ModelBase containedModel) {
            if (property != null) {
                ModelBase oldContainedModel = (ModelBase)(containedModel == null ? this.containedModels.remove(property) : this.containedModels.put(property, containedModel));
                if (oldContainedModel != null) {
                    oldContainedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
                }
                if (containedModel != null) {
                    containedModel.addPropertyChangeListener(this.containedModelPropertyChangeListener);
                }
            }
        }

        public void remove(String property) {
            ModelBase containedModel;
            if (property != null && (containedModel = (ModelBase)this.containedModels.remove(property)) != null) {
                containedModel.removePropertyChangeListener(this.containedModelPropertyChangeListener);
            }
        }
    }

    @SASScope
    private static final class NoteLabel
    extends LabelComponent {
        private NoteModel noteModel;
        private final PropertyChangeListener noteModelListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this._refresh();
            }
        };

        public NoteLabel(NoteModel newNoteModel, Channel channel) {
            super(newNoteModel != null ? newNoteModel.getText() : null, newNoteModel != null ? newNoteModel.getTextStyle() : null, channel);
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.noteModel = newNoteModel;
            if (this.noteModel == null) {
                this.noteModel = new NoteModel();
                this._update();
            }
            this.noteModel.addPropertyChangeListener(this.noteModelListener);
        }

        public void setNoteModel(NoteModel newNoteModel) {
            if (newNoteModel != null && newNoteModel != this.noteModel) {
                this.noteModel.removePropertyChangeListener(this.noteModelListener);
                this.noteModel = newNoteModel;
                this.noteModel.addPropertyChangeListener(this.noteModelListener);
                this._refresh();
            }
        }

        public NoteModel getNoteModel() {
            return this.noteModel;
        }

        private void _update() {
            this.setLabel(this.noteModel.getText());
            this.setTextStyle(this.noteModel.getTextStyle());
            this.invalidateNetwork();
            this.invalidate();
        }

        private void _refresh() {
            this._update();
            this.revalidate();
            this.repaint();
        }
    }
}

