/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.MarkerStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.util.Util;

@SASScope
public class DiscreteStyle
extends ModelBase {
    private FillStyle fillStyle;
    private StrokeLineStyle lineStyle;
    private MarkerStyle markerStyle;

    public DiscreteStyle(FillStyle fillStyle) {
        this(fillStyle, null, null);
    }

    public DiscreteStyle(StrokeLineStyle lineStyle) {
        this(null, lineStyle, null);
    }

    public DiscreteStyle(MarkerStyle markerStyle) {
        this(null, null, markerStyle);
    }

    public DiscreteStyle(FillStyle fillStyle, StrokeLineStyle lineStyle, MarkerStyle markerStyle) {
        this.fillStyle = fillStyle;
        this.lineStyle = lineStyle;
        this.markerStyle = markerStyle;
        this.setContainedModel("fillStyle", this.fillStyle);
        this.setContainedModel("lineStyle", this.lineStyle);
        this.setContainedModel("markerStyle", this.markerStyle);
    }

    public void setFillStyle(FillStyle fillStyle) {
        FillStyle oldFillStyle = this.fillStyle;
        this.fillStyle = fillStyle;
        this.firePropertyChange("fillStyle", oldFillStyle, this.fillStyle);
    }

    public FillStyle getFillStyle() {
        return this.fillStyle;
    }

    public void setLineStyle(StrokeLineStyle lineStyle) {
        StrokeLineStyle oldLineStyle = this.lineStyle;
        this.lineStyle = lineStyle;
        this.firePropertyChange("lineStyle", oldLineStyle, this.lineStyle);
    }

    public StrokeLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public void setMarkerStyle(MarkerStyle markerStyle) {
        MarkerStyle oldMarkerStyle = this.markerStyle;
        this.markerStyle = markerStyle;
        this.firePropertyChange("markerStyle", oldMarkerStyle, this.markerStyle);
    }

    public MarkerStyle getMarkerStyle() {
        return this.markerStyle;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DiscreteStyle arg = (DiscreteStyle)obj;
        return Util.Evaluate.isEqual(this.fillStyle, arg.fillStyle) && Util.Evaluate.isEqual(this.lineStyle, arg.lineStyle) && Util.Evaluate.isEqual(this.markerStyle, arg.markerStyle) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        int hash = 0;
        if (this.fillStyle != null) {
            hash = this.fillStyle.getSolidFillColor().hashCode();
        }
        if (this.lineStyle != null) {
            hash = hash * 31 + this.lineStyle.getColor().hashCode();
        }
        if (this.markerStyle != null) {
            hash = hash * 31 + this.markerStyle.getColor().hashCode();
        }
        return hash;
    }
}

