/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.util.Util;
import com.sas.rpf.Context;
import java.util.Locale;

@SASScope(value="ALL")
public abstract class DataModel
extends ModelBase {
    Context rulesContext;
    Locale locale;
    int sortStrategy = 10475;

    public Context getRulesContext() {
        return this.rulesContext;
    }

    public void setRulesContext(Context newRulesContext) {
        Context oldRulesContext = this.rulesContext;
        this.rulesContext = newRulesContext;
        this.firePropertyChange("rulesContext", oldRulesContext, newRulesContext);
    }

    public void setLocale(Locale newLocale) {
        Locale oldLocale = this.locale;
        this.locale = newLocale;
        this.firePropertyChange("locale", oldLocale, this.locale);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setSortStrategy(int newSortStrategy) {
        GraphConstants.SORT_STRATEGY.validate(newSortStrategy);
        int oldSortStrategy = this.sortStrategy;
        this.sortStrategy = newSortStrategy;
        this.firePropertyChange("sortStrategy", oldSortStrategy, this.sortStrategy);
    }

    public int getSortStrategy() {
        return this.sortStrategy;
    }

    public void apply(DataModel theOtherModel) {
        if (theOtherModel != null) {
            this.disablePropertyChange();
            this._applyLocalFields(theOtherModel);
            this.enablePropertyChange();
            this.firePropertyChange("", null, this);
        }
    }

    private void _applyLocalFields(DataModel theOtherModel) {
        this.rulesContext = theOtherModel.rulesContext;
        this.locale = theOtherModel.locale;
        this.sortStrategy = theOtherModel.sortStrategy;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DataModel arg = (DataModel)obj;
        return Util.Evaluate.isEqual(this.rulesContext, arg.rulesContext) && Util.Evaluate.isEqual(this.locale, arg.locale) && Util.Evaluate.isEqual(this.sortStrategy, arg.sortStrategy) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

