/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CellStyle;
import com.sas.graphics.components.FillStyle;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.ReferenceBandModel;
import com.sas.graphics.components.ReferenceLineModel;
import com.sas.graphics.components.StrokeLineStyle;
import com.sas.graphics.components.TimeLength;
import com.sas.graphics.components.TimePeriodModel;
import com.sas.graphics.components.util.Util;
import java.awt.Color;

@SASScope
public class CompoundTimeAxisModel
extends ModelBase {
    public static final String RB_KEY = "CompoundTimeAxisModel.";
    private TimeLength preferredVisibleTimeLength = null;
    private double zoomFactor = 2.0;
    private boolean visible = true;
    private boolean gridInFront = false;
    private double min = Double.NaN;
    private double max = Double.NaN;
    private boolean reverseDirection = false;
    private FillStyle weekendFillStyle = new FillStyle(this.newColor(Color.LIGHT_GRAY, 0.8));
    private StrokeLineStyle gridLineStyle = new StrokeLineStyle();
    private StrokeLineStyle axisLineStyle = new StrokeLineStyle();
    private TimePeriodModel timePeriodModel1 = new TimePeriodModel();
    private TimePeriodModel timePeriodModel2 = new TimePeriodModel();
    private TimePeriodModel timePeriodModel3 = new TimePeriodModel();
    private ReferenceLineModel[] referenceLineModels = null;
    private ReferenceBandModel[] referenceBandModels = null;
    private CellStyle valueCellStyle = new CellStyle();

    public CompoundTimeAxisModel() {
        this.weekendFillStyle.setVisible(false);
        this.setContainedModel("timePeriodModel1", this.timePeriodModel1);
        this.setContainedModel("timePeriodModel2", this.timePeriodModel2);
        this.setContainedModel("timePeriodModel3", this.timePeriodModel3);
        this.setContainedModel("gridLineStyle", this.gridLineStyle);
        this.setContainedModel("axisLineStyle", this.axisLineStyle);
        this.setContainedModel("weekendFillStyle", this.weekendFillStyle);
        this.setContainedModel("valueCellStyle", this.valueCellStyle);
    }

    public void apply(CompoundTimeAxisModel theOtherObject) {
        int ii;
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.min = theOtherObject.min;
        this.max = theOtherObject.max;
        this.preferredVisibleTimeLength = theOtherObject.preferredVisibleTimeLength;
        this.zoomFactor = theOtherObject.zoomFactor;
        this.visible = theOtherObject.visible;
        this.reverseDirection = theOtherObject.reverseDirection;
        this.gridInFront = theOtherObject.gridInFront;
        this.gridLineStyle = theOtherObject.gridLineStyle;
        this.axisLineStyle = theOtherObject.axisLineStyle;
        this.timePeriodModel1.apply(theOtherObject.timePeriodModel1);
        this.timePeriodModel2.apply(theOtherObject.timePeriodModel2);
        this.timePeriodModel3.apply(theOtherObject.timePeriodModel3);
        this.weekendFillStyle.apply(theOtherObject.weekendFillStyle);
        this.valueCellStyle.apply(theOtherObject.valueCellStyle);
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (this.referenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, null);
            }
        }
        ReferenceLineModel[] referenceLineModelArray = this.referenceLineModels = theOtherObject.referenceLineModels == null ? null : new ReferenceLineModel[theOtherObject.referenceLineModels.length];
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (theOtherObject.referenceLineModels[ii] == null) continue;
                this.referenceLineModels[ii] = new ReferenceLineModel();
                this.referenceLineModels[ii].apply(theOtherObject.referenceLineModels[ii]);
                this.setContainedModel("referenceLineModel" + ii, this.referenceLineModels[ii]);
            }
        }
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setWeekendBandFillStyle(FillStyle newFillStyle) {
        if (newFillStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        FillStyle oldWeekendFillStyle = this.weekendFillStyle;
        this.weekendFillStyle = newFillStyle;
        this.firePropertyChange("weekendBandFillStyle", oldWeekendFillStyle, newFillStyle);
    }

    public FillStyle getWeekendBandFillStyle() {
        return this.weekendFillStyle;
    }

    public void setTimePeriodModel1(TimePeriodModel newTimePeriodModel) throws IllegalArgumentException {
        if (newTimePeriodModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TimePeriodModel oldValue = this.timePeriodModel1;
        this.timePeriodModel1 = newTimePeriodModel;
        this.firePropertyChange("timePeriodModel1", oldValue, newTimePeriodModel);
    }

    public TimePeriodModel getTimePeriodModel1() {
        return this.timePeriodModel1;
    }

    public void setTimePeriodModel2(TimePeriodModel newTimePeriodModel) throws IllegalArgumentException {
        if (newTimePeriodModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TimePeriodModel oldValue = this.timePeriodModel2;
        this.timePeriodModel2 = newTimePeriodModel;
        this.firePropertyChange("timePeriodModel2", oldValue, newTimePeriodModel);
    }

    public TimePeriodModel getTimePeriodModel2() {
        return this.timePeriodModel2;
    }

    public void setTimePeriodModel3(TimePeriodModel newTimePeriodModel) throws IllegalArgumentException {
        if (newTimePeriodModel == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        TimePeriodModel oldValue = this.timePeriodModel3;
        this.timePeriodModel3 = newTimePeriodModel;
        this.firePropertyChange("timePeriodModel3", oldValue, newTimePeriodModel);
    }

    public void setPreferredVisibleTimeLength(TimeLength newLength) {
        TimeLength oldLength = this.preferredVisibleTimeLength;
        this.preferredVisibleTimeLength = newLength;
        this.firePropertyChange("preferredVisibleTimeLength", oldLength, newLength);
    }

    public TimeLength getPreferredVisibleTimeLength() {
        return this.preferredVisibleTimeLength;
    }

    public TimePeriodModel getTimePeriodModel3() {
        return this.timePeriodModel3;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        CompoundTimeAxisModel arg = (CompoundTimeAxisModel)obj;
        return Util.Evaluate.isEqual(this.gridInFront, arg.gridInFront) && Util.Evaluate.isEqual(this.preferredVisibleTimeLength, arg.preferredVisibleTimeLength) && Util.Evaluate.isEqual(this.visible, arg.visible) && Util.Evaluate.isEqual(this.reverseDirection, arg.reverseDirection) && Util.Evaluate.isEqual(this.min, arg.min) && Util.Evaluate.isEqual(this.max, arg.max) && Util.Evaluate.isEqual(this.zoomFactor, arg.zoomFactor) && Util.Evaluate.isEqual(this.gridLineStyle, arg.gridLineStyle) && Util.Evaluate.isEqual(this.axisLineStyle, arg.axisLineStyle) && Util.Evaluate.isEqual(this.referenceLineModels, arg.referenceLineModels) && Util.Evaluate.isEqual(this.weekendFillStyle, arg.weekendFillStyle) && Util.Evaluate.isEqual(this.timePeriodModel1, arg.timePeriodModel1) && Util.Evaluate.isEqual(this.timePeriodModel2, arg.timePeriodModel2) && Util.Evaluate.isEqual(this.timePeriodModel3, arg.timePeriodModel3) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public final void setZoomFactor(double zoomValue) {
    }

    public final double getZoomFactor() {
        return this.zoomFactor;
    }

    public void setVisible(boolean visible) {
        boolean oldValue = this.visible;
        this.visible = visible;
        this.firePropertyChange("visible", oldValue, visible);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setGridLineStyle(StrokeLineStyle newLineStyle) throws IllegalArgumentException {
        if (newLineStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        StrokeLineStyle oldValue = this.gridLineStyle;
        this.gridLineStyle = newLineStyle;
        this.firePropertyChange("gridLineStyle", oldValue, newLineStyle);
    }

    public StrokeLineStyle getGridLineStyle() {
        return this.gridLineStyle;
    }

    public void setValueCellStyle(CellStyle newCellStyle) {
        if (newCellStyle == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        CellStyle oldCellStyle = this.valueCellStyle;
        this.valueCellStyle = newCellStyle;
        this.firePropertyChange("valueCellStyle", oldCellStyle, this.valueCellStyle);
    }

    public CellStyle getValueCellStyle() {
        return this.valueCellStyle;
    }

    public void setGridInFront(boolean inFront) {
        boolean oldValue = this.gridInFront;
        this.gridInFront = inFront;
        this.firePropertyChange("gridInFront", oldValue, inFront);
    }

    public boolean isGridInFront() {
        return this.gridInFront;
    }

    public void setReferenceLineModels(ReferenceLineModel[] newReferenceLineModels) {
        int ii;
        ReferenceLineModel[] oldReferenceLineModels = this.referenceLineModels;
        if (this.referenceLineModels != null) {
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (this.referenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, null);
            }
        }
        ReferenceLineModel[] referenceLineModelArray = this.referenceLineModels = newReferenceLineModels == null ? null : new ReferenceLineModel[newReferenceLineModels.length];
        if (this.referenceLineModels != null) {
            System.arraycopy(newReferenceLineModels, 0, this.referenceLineModels, 0, this.referenceLineModels.length);
            for (ii = 0; ii < this.referenceLineModels.length; ++ii) {
                if (newReferenceLineModels[ii] == null) continue;
                this.setContainedModel("referenceLineModel" + ii, this.referenceLineModels[ii]);
            }
        }
        this.firePropertyChange("referenceLineModels", oldReferenceLineModels, newReferenceLineModels);
    }

    public ReferenceLineModel[] getReferenceLineModels() {
        ReferenceLineModel[] copyOfReferenceLineModels;
        ReferenceLineModel[] referenceLineModelArray = copyOfReferenceLineModels = this.referenceLineModels == null ? null : new ReferenceLineModel[this.referenceLineModels.length];
        if (copyOfReferenceLineModels != null) {
            System.arraycopy(this.referenceLineModels, 0, copyOfReferenceLineModels, 0, this.referenceLineModels.length);
        }
        return copyOfReferenceLineModels;
    }

    public void setReferenceBandModels(ReferenceBandModel[] newReferenceBandModels) {
        int ii;
        ReferenceBandModel[] oldReferenceBandModels = this.referenceBandModels;
        if (this.referenceBandModels != null) {
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (this.referenceBandModels[ii] == null) continue;
                this.setContainedModel("referenceBandModel" + ii, null);
            }
        }
        ReferenceBandModel[] referenceBandModelArray = this.referenceBandModels = newReferenceBandModels == null ? null : new ReferenceBandModel[newReferenceBandModels.length];
        if (this.referenceBandModels != null) {
            System.arraycopy(newReferenceBandModels, 0, this.referenceBandModels, 0, this.referenceBandModels.length);
            for (ii = 0; ii < this.referenceBandModels.length; ++ii) {
                if (newReferenceBandModels[ii] == null) continue;
                this.setContainedModel("referenceBandModel" + ii, this.referenceBandModels[ii]);
            }
        }
        this.firePropertyChange("referenceBandModels", oldReferenceBandModels, newReferenceBandModels);
    }

    public ReferenceBandModel[] getReferenceBandModels() {
        ReferenceBandModel[] copyOfReferenceBandModels;
        ReferenceBandModel[] referenceBandModelArray = copyOfReferenceBandModels = this.referenceBandModels == null ? null : new ReferenceBandModel[this.referenceBandModels.length];
        if (copyOfReferenceBandModels != null) {
            System.arraycopy(this.referenceBandModels, 0, copyOfReferenceBandModels, 0, copyOfReferenceBandModels.length);
        }
        return copyOfReferenceBandModels;
    }

    public void setMinimum(double minValue) {
        if (minValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (minValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldMin = this.min;
        this.min = minValue;
        this.firePropertyChange("minimum", oldMin, minValue);
    }

    public double getMinimum() {
        return this.min;
    }

    public void setMaximum(double maxValue) {
        if (maxValue == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (maxValue == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        double oldMax = this.max;
        this.max = maxValue;
        this.firePropertyChange("maximum", oldMax, maxValue);
    }

    public double getMaximum() {
        return this.max;
    }

    private Color newColor(Color c, double transparancy) {
        int alpha = (int)((double)c.getAlpha() / 255.0 * (1.0 - transparancy) * 255.0);
        c = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
        return c;
    }
}

