/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ColorPosition;
import com.sas.graphics.components.ConstantCollection;
import com.sas.graphics.components.DataElementColors;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.styles.FillStyleElement;
import com.sas.graphics.styles.LineStyleElement;
import com.sas.graphics.styles.MarkerStyleElement;
import com.sas.graphics.styles.PredefinedStyles;
import com.sas.graphics.styles.RampStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.styles.TextStyleElement;
import java.awt.Color;

@SASScope(value="ALL")
public class ColorScheme
extends ModelBase {
    public static final String RB_KEY = "ColorScheme.";
    private static final int _SCHEME_ = 101000;
    public static final int SCHEME_AUTUMN = 101000;
    public static final int SCHEME_BRIGHT = 101001;
    public static final int SCHEME_CARNIVAL = 101002;
    public static final int SCHEME_COMMERCE = 101003;
    public static final int SCHEME_GRAYSCALE = 101004;
    public static final int SCHEME_INDUSTRY = 101005;
    public static final int SCHEME_MAGELLAN = 101006;
    public static final int SCHEME_NEON = 101007;
    public static final int SCHEME_OCEAN = 101008;
    public static final int SCHEME_PASTEL = 101009;
    public static final int SCHEME_PICNIC = 101010;
    public static final int SCHEME_PINE = 101011;
    public static final int SCHEME_TERRA = 101012;
    public static final int SCHEME_WHEAT = 101013;
    public static final int SCHEME_WOODLAND = 101014;
    public static final int SCHEME_GANTTCHART = 101015;
    public static final int SCHEME_DECO = 101016;
    public static final int SCHEME_ZUNI = 101017;
    public static final ConstantCollection SCHEME = new ConstantCollection("ColorScheme.", new ConstantCollection.Element[]{new ConstantCollection.Element(101000, "SCHEME_AUTUMN", "Autumn"), new ConstantCollection.Element(101001, "SCHEME_BRIGHT", "Bright"), new ConstantCollection.Element(101002, "SCHEME_CARNIVAL", "Carnival"), new ConstantCollection.Element(101003, "SCHEME_COMMERCE", "Commerce"), new ConstantCollection.Element(101016, "SCHEME_DECO", "Deco"), new ConstantCollection.Element(101015, "SCHEME_GANTTCHART", "GanttChart"), new ConstantCollection.Element(101004, "SCHEME_GRAYSCALE", "Grayscale"), new ConstantCollection.Element(101005, "SCHEME_INDUSTRY", "Industry"), new ConstantCollection.Element(101006, "SCHEME_MAGELLAN", "Magellan"), new ConstantCollection.Element(101007, "SCHEME_NEON", "Neon"), new ConstantCollection.Element(101008, "SCHEME_OCEAN", "Ocean"), new ConstantCollection.Element(101009, "SCHEME_PASTEL", "Pastel"), new ConstantCollection.Element(101010, "SCHEME_PICNIC", "Picnic"), new ConstantCollection.Element(101011, "SCHEME_PINE", "Pine"), new ConstantCollection.Element(101012, "SCHEME_TERRA", "Terra"), new ConstantCollection.Element(101013, "SCHEME_WHEAT", "Wheat"), new ConstantCollection.Element(101014, "SCHEME_WOODLAND", "Woodland"), new ConstantCollection.Element(101017, "SCHEME_ZUNI", "Zuni")});
    private int name;
    private boolean modified = false;
    private Color backgroundColor;
    private Color wallColor;
    private Color floorColor;
    private Color legendBackgroundColor;
    private Color axisLineColor;
    private Color gridLineColor;
    private Color majorTickColor;
    private Color minorTickColor;
    private Color labelColor;
    private Color valueColor;
    private Color dataLabelColor;
    private Color dataTipColor;
    private DataElementColors dataElementColors;
    private Color columnAxisLabelCellBackgroundColor;
    private Color rowAxisLabelCellBackgroundColor;
    private Color columnAxisValueCellBackgroundColor;
    private Color rowAxisValueCellBackgroundColor;
    private Color columnRowAxisLabelCellFrameColor;
    private Color columnRowAxisValueCellFrameColor;
    private Color shadowColor;
    private Color selectionColor;
    private Color selectionAccentColor;
    private Color textFrameColor;
    private Color frameColor;
    private Color titleFootnoteColor;
    private Color weekendBandColor;
    private static final String NAME = "name";
    private static final String BACKGROUNDCOLOR = "backgroundColor";
    private static final String WALLCOLOR = "wallColor";
    private static final String FLOORCOLOR = "floorColor";
    private static final String LEGENDBACKGROUNDCOLOR = "legendBackgroundColor";
    private static final String AXISLINECOLOR = "axisLineColor";
    private static final String GRIDLINECOLOR = "gridLineColor";
    private static final String MAJORTICKCOLOR = "majorTickColor";
    private static final String MINORTICKCOLOR = "minorTickColor";
    private static final String LABELCOLOR = "labelColor";
    private static final String VALUECOLOR = "valueColor";
    private static final String DATALABELCOLOR = "dataLabelColor";
    private static final String DATATIPCOLOR = "dataTipColor";
    private static final String SHADOWCOLOR = "shadowColor";
    private static final String SELECTIONCOLOR = "selectionColor";
    private static final String SELECTIONACCENTCOLOR = "selectionAccentColor";
    private static final String TEXTFRAMECOLOR = "textFrameColor";
    private static final String FRAMECOLOR = "frameColor";
    private static final String TITLEFOOTNOTECOLOR = "titleFootnoteColor";
    private static final String DATAELEMENTCOLORS = "dataElementColors";
    private static final String ROWAXISLABELCELLBACKGROUNDCOLOR = "rowAxisLabelCellBackgroundColor";
    private static final String ROWAXISVALUECELLBACKGROUNDCOLOR = "rowAxisValueCellBackgroundColor";
    private static final String COLUMNAXISLABELCELLBACKGROUNDCOLOR = "columnAxisLabelCellBackgroundColor";
    private static final String COLUMNAXISVALUECELLBACKGROUNDCOLOR = "columnAxisValueCellBackgroundColor";
    private static final String COLUMNROWAXISLABELCELLFRAMECOLOR = "columnAxisLabelCellFrameColor";
    private static final String COLUMNROWAXISVALUECELLFRAMECOLOR = "columnAxisValueCellFrameColor";
    private static final String WEEKENDBANDCOLOR = "weekendBandColor";

    public ColorScheme() {
        this(101012);
    }

    public ColorScheme(int newName) {
        this.disablePropertyChange();
        switch (newName) {
            case 101000: {
                this.buildAutumnScheme();
                break;
            }
            case 101001: {
                this.buildBrightScheme();
                break;
            }
            case 101002: {
                this.buildCarnivalScheme();
                break;
            }
            case 101003: {
                this.buildCommerceScheme();
                break;
            }
            case 101004: {
                this.buildGrayscaleScheme();
                break;
            }
            case 101005: {
                this.buildIndustryScheme();
                break;
            }
            case 101006: {
                this.buildMagellanScheme();
                break;
            }
            case 101007: {
                this.buildNeonScheme();
                break;
            }
            case 101008: {
                this.buildOceanScheme();
                break;
            }
            case 101009: {
                this.buildPastelScheme();
                break;
            }
            case 101010: {
                this.buildPicnicScheme();
                break;
            }
            case 101011: {
                this.buildPineScheme();
                break;
            }
            case 101012: {
                this.buildTerraScheme();
                break;
            }
            case 101013: {
                this.buildWheatScheme();
                break;
            }
            case 101014: {
                this.buildWoodlandScheme();
                break;
            }
            case 101015: {
                this.buildGanttChartScheme();
                break;
            }
            case 101016: {
                this.buildDecoScheme();
                break;
            }
            case 101017: {
                this.buildZuniScheme();
                break;
            }
            default: {
                this.buildTerraScheme();
            }
        }
        this.modified = false;
        this.setContainedModel(DATAELEMENTCOLORS, this.dataElementColors);
        this.enablePropertyChange();
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldProperty, Object newProperty) {
        this.modified = true;
        super.firePropertyChange(propertyName, oldProperty, newProperty);
    }

    private void setName(int newName) {
        if (SCHEME.isValid(newName)) {
            int oldName = this.name;
            this.name = newName;
            this.firePropertyChange(NAME, oldName, newName);
        }
    }

    public int getName() {
        return this.name;
    }

    public boolean isModified() {
        return this.modified;
    }

    public String toString() {
        return SCHEME.toName(this.name);
    }

    public void setDataElementColors(DataElementColors newdataElementColors) {
        DataElementColors olddataElementColors = this.dataElementColors;
        this.dataElementColors = newdataElementColors;
        this.firePropertyChange(DATAELEMENTCOLORS, (Object)olddataElementColors, (Object)newdataElementColors);
        this.setContainedModel(DATAELEMENTCOLORS, newdataElementColors);
    }

    public DataElementColors getDataElementColors() {
        return this.dataElementColors;
    }

    public void setBackgroundColor(Color newBackgroundColor) {
        Color oldBackgroundColor = this.backgroundColor;
        this.backgroundColor = newBackgroundColor;
        this.firePropertyChange(BACKGROUNDCOLOR, oldBackgroundColor, newBackgroundColor);
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @SASScope
    public void setRowAxisLabelCellBackgroundColor(Color newColor) {
        Color oldColor = this.rowAxisLabelCellBackgroundColor;
        this.rowAxisLabelCellBackgroundColor = newColor;
        this.firePropertyChange(ROWAXISLABELCELLBACKGROUNDCOLOR, oldColor, this.rowAxisLabelCellBackgroundColor);
    }

    @SASScope
    public Color getRowAxisLabelCellBackgroundColor() {
        return this.rowAxisLabelCellBackgroundColor;
    }

    public void setRowAxisValueCellBackgroundColor(Color newColor) {
        Color oldColor = this.rowAxisValueCellBackgroundColor;
        this.rowAxisValueCellBackgroundColor = newColor;
        this.firePropertyChange(ROWAXISVALUECELLBACKGROUNDCOLOR, oldColor, this.rowAxisValueCellBackgroundColor);
    }

    public Color getRowAxisValueCellBackgroundColor() {
        return this.rowAxisValueCellBackgroundColor;
    }

    @SASScope
    public void setColumnRowAxisLabelCellFrameColor(Color newColor) {
        Color oldColor = this.columnRowAxisLabelCellFrameColor;
        this.columnRowAxisLabelCellFrameColor = newColor;
        this.firePropertyChange(COLUMNROWAXISLABELCELLFRAMECOLOR, oldColor, this.columnRowAxisLabelCellFrameColor);
    }

    @SASScope
    public Color getColumnRowAxisLabelCellFrameColor() {
        return this.columnRowAxisLabelCellFrameColor;
    }

    @SASScope
    public void setColumnAxisLabelCellBackgroundColor(Color newColor) {
        Color oldColor = this.columnAxisLabelCellBackgroundColor;
        this.columnAxisLabelCellBackgroundColor = newColor;
        this.firePropertyChange(COLUMNAXISLABELCELLBACKGROUNDCOLOR, oldColor, this.columnAxisLabelCellBackgroundColor);
    }

    @SASScope
    public Color getColumnAxisLabelCellBackgroundColor() {
        return this.columnAxisLabelCellBackgroundColor;
    }

    @SASScope
    public void setColumnRowAxisValueCellFrameColor(Color newColor) {
        Color oldColor = this.columnRowAxisValueCellFrameColor;
        this.columnRowAxisValueCellFrameColor = newColor;
        this.firePropertyChange(COLUMNROWAXISVALUECELLFRAMECOLOR, oldColor, this.columnRowAxisValueCellFrameColor);
    }

    @SASScope
    public Color getColumnRowAxisValueCellFrameColor() {
        return this.columnRowAxisValueCellFrameColor;
    }

    public void setColumnAxisValueCellBackgroundColor(Color newColor) {
        Color oldColor = this.columnAxisValueCellBackgroundColor;
        this.columnAxisValueCellBackgroundColor = newColor;
        this.firePropertyChange(COLUMNAXISVALUECELLBACKGROUNDCOLOR, oldColor, this.columnAxisValueCellBackgroundColor);
    }

    public Color getColumnAxisValueCellBackgroundColor() {
        return this.columnAxisValueCellBackgroundColor;
    }

    public void setRowAxisBackgroundColor(Color newBackgroundColor) {
        this.setRowAxisValueCellBackgroundColor(newBackgroundColor);
    }

    public Color getRowAxisBackgroundColor() {
        return this.getRowAxisValueCellBackgroundColor();
    }

    public void setColumnAxisBackgroundColor(Color newBackgroundColor) {
        this.setColumnAxisValueCellBackgroundColor(newBackgroundColor);
    }

    public Color getColumnAxisBackgroundColor() {
        return this.getColumnAxisValueCellBackgroundColor();
    }

    public void setWallColor(Color newWallColor) {
        Color oldWallColor = this.wallColor;
        this.wallColor = newWallColor;
        this.firePropertyChange(WALLCOLOR, oldWallColor, newWallColor);
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public void setWeekendBandColor(Color newColor) throws IllegalArgumentException {
        if (newColor != null) {
            Color oldValue = this.weekendBandColor;
            this.weekendBandColor = newColor;
            this.firePropertyChange(WEEKENDBANDCOLOR, oldValue, this.weekendBandColor);
        }
    }

    public Color getWeekendBandColor() {
        return this.weekendBandColor;
    }

    public void setFloorColor(Color newFloorColor) {
        Color oldFloorColor = this.floorColor;
        this.floorColor = newFloorColor;
        this.firePropertyChange(FLOORCOLOR, oldFloorColor, newFloorColor);
    }

    public Color getFloorColor() {
        return this.floorColor;
    }

    public void setLegendBackgroundColor(Color newLegendBackgroundColor) {
        Color oldLegendBackgroundColor = this.legendBackgroundColor;
        this.legendBackgroundColor = newLegendBackgroundColor;
        this.firePropertyChange(LEGENDBACKGROUNDCOLOR, oldLegendBackgroundColor, newLegendBackgroundColor);
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public void setTextFrameColor(Color newTextFrameColor) {
        Color oldTextFrameColor = this.textFrameColor;
        this.textFrameColor = newTextFrameColor;
        this.firePropertyChange(TEXTFRAMECOLOR, oldTextFrameColor, newTextFrameColor);
    }

    public Color getTextFrameColor() {
        return this.textFrameColor;
    }

    public void setShadowColor(Color newShadowColor) {
        Color oldShadowColor = this.shadowColor;
        this.shadowColor = newShadowColor;
        this.firePropertyChange(SHADOWCOLOR, oldShadowColor, newShadowColor);
    }

    public Color getShadowColor() {
        return this.shadowColor;
    }

    public void setSelectionColor(Color newSelectionColor) throws IllegalArgumentException {
        Color oldSelectionColor = this.selectionColor;
        this.selectionColor = newSelectionColor;
        this.firePropertyChange(SELECTIONCOLOR, oldSelectionColor, newSelectionColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionAccentColor(Color newSelectionAccentColor) throws IllegalArgumentException {
        Color oldSelectionAccentColor = this.selectionAccentColor;
        this.selectionAccentColor = newSelectionAccentColor;
        this.firePropertyChange(SELECTIONACCENTCOLOR, oldSelectionAccentColor, newSelectionAccentColor);
    }

    public Color getSelectionAccentColor() {
        return this.selectionAccentColor;
    }

    public void setAxisLineColor(Color newAxisLineColor) {
        Color oldAxisLineColor = this.axisLineColor;
        this.axisLineColor = newAxisLineColor;
        this.firePropertyChange(AXISLINECOLOR, oldAxisLineColor, newAxisLineColor);
    }

    public Color getAxisLineColor() {
        return this.axisLineColor;
    }

    public void setGridLineColor(Color newGridLineColor) {
        Color oldGridLineColor = this.gridLineColor;
        this.gridLineColor = newGridLineColor;
        this.firePropertyChange(GRIDLINECOLOR, oldGridLineColor, newGridLineColor);
    }

    public Color getGridLineColor() {
        return this.gridLineColor;
    }

    public void setMajorTickColor(Color newMajorTickColor) {
        Color oldMajorTickColor = this.majorTickColor;
        this.majorTickColor = newMajorTickColor;
        this.firePropertyChange(MAJORTICKCOLOR, oldMajorTickColor, newMajorTickColor);
    }

    public Color getMajorTickColor() {
        return this.majorTickColor;
    }

    public void setMinorTickColor(Color newMinorTickColor) {
        Color oldMinorTickColor = this.minorTickColor;
        this.minorTickColor = newMinorTickColor;
        this.firePropertyChange(MINORTICKCOLOR, oldMinorTickColor, newMinorTickColor);
    }

    public Color getMinorTickColor() {
        return this.minorTickColor;
    }

    public void setFrameColor(Color newFrameColor) {
        Color oldFrameColor = this.frameColor;
        this.frameColor = newFrameColor;
        this.firePropertyChange(FRAMECOLOR, oldFrameColor, newFrameColor);
    }

    public Color getFrameColor() {
        return this.frameColor;
    }

    public void setLabelColor(Color newLabelColor) {
        Color oldLabelColor = this.labelColor;
        this.labelColor = newLabelColor;
        this.firePropertyChange(LABELCOLOR, oldLabelColor, newLabelColor);
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setValueColor(Color newValueColor) {
        Color oldValueColor = this.valueColor;
        this.valueColor = newValueColor;
        this.firePropertyChange(VALUECOLOR, oldValueColor, newValueColor);
    }

    public Color getValueColor() {
        return this.valueColor;
    }

    public void setDataLabelColor(Color newDataLabelColor) {
        Color oldDataLabelColor = this.dataLabelColor;
        this.dataLabelColor = newDataLabelColor;
        this.firePropertyChange(DATALABELCOLOR, oldDataLabelColor, newDataLabelColor);
    }

    public Color getDataLabelColor() {
        return this.dataLabelColor;
    }

    public void setDataTipColor(Color newDataTipColor) {
        Color oldDataTipColor = this.dataTipColor;
        this.dataTipColor = newDataTipColor;
        this.firePropertyChange(DATATIPCOLOR, oldDataTipColor, newDataTipColor);
    }

    public Color getDataTipColor() {
        return this.dataTipColor;
    }

    public void setTitleFootnoteColor(Color newTitleFootnoteColor) {
        Color oldTitleFootnoteColor = this.titleFootnoteColor;
        this.titleFootnoteColor = newTitleFootnoteColor;
        this.firePropertyChange(TITLEFOOTNOTECOLOR, oldTitleFootnoteColor, newTitleFootnoteColor);
    }

    public Color getTitleFootnoteColor() {
        return this.titleFootnoteColor;
    }

    private void _setDefaultMilestoneColor(DataElementColors dec) {
        Color[] dfca;
        if (dec != null && (dfca = dec.getDiscreteFillColors()) != null) {
            Color lastDataElementColor = dfca[dfca.length - 1];
            dec.setMilestoneColor(lastDataElementColor);
        }
    }

    private Color _getFillStyleElementColor(FillStyleElement fse) {
        return fse.applyElementTransparency(fse.getFillColor());
    }

    private Color _getLineStyleElementColor(LineStyleElement lse) {
        return lse.applyElementTransparency(lse.getLineColor());
    }

    private Color _getMarkerStyleElementColor(MarkerStyleElement mse) {
        return mse.applyElementTransparency(mse.getMarkerColor());
    }

    private Color _getTextStyleElementColor(TextStyleElement tse) {
        return tse.applyElementTransparency(tse.getTextColor());
    }

    private void _applyColorStyle(Style s) {
        s.setFallbackEnabled(true);
        DataElementColors dec = new DataElementColors();
        Color[] clr = new Color[]{this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle1")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle2")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle3")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle4")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle5")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle6")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle7")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle8")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle9")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle10")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle11")), this._getFillStyleElementColor(s.getFillStyleElement("GraphDataStyle12"))};
        dec.setDiscreteFillColors(clr);
        clr = new Color[]{this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle1")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle2")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle3")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle4")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle5")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle6")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle7")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle8")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle9")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle10")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle11")), this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphDataStyle12"))};
        dec.setDiscreteContrastColors(clr);
        dec.setMilestoneColor(this._getMarkerStyleElementColor(s.getMarkerStyleElement("GraphMilestone")));
        this._setContinuousColorSpectrum(dec);
        RampStyleElement rse = s.getRampStyleElement("TwoColorRamp");
        dec.setContinuousFillTwoColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        dec.setContinuousFillTwoColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        rse = s.getRampStyleElement("ThreeColorRamp");
        dec.setContinuousFillThreeColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        dec.setContinuousFillThreeColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        dec.setContinuousFillThreeColorNeutralColor(rse.applyElementTransparency(rse.getNeutralColor()));
        rse = s.getRampStyleElement("TwoColorAltRamp");
        dec.setContinuousContrastTwoColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        dec.setContinuousContrastTwoColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        rse = s.getRampStyleElement("ThreeColorAltRamp");
        dec.setContinuousContrastThreeColorStartColor(rse.applyElementTransparency(rse.getStartColor()));
        dec.setContinuousContrastThreeColorEndColor(rse.applyElementTransparency(rse.getEndColor()));
        dec.setContinuousContrastThreeColorNeutralColor(rse.applyElementTransparency(rse.getNeutralColor()));
        this.setBackgroundColor(this._getFillStyleElementColor(s.getFillStyleElement("Backfill")));
        this.setWallColor(this._getFillStyleElementColor(s.getFillStyleElement("WallFill")));
        this.setFloorColor(this._getFillStyleElementColor(s.getFillStyleElement("FloorFill")));
        this.setLegendBackgroundColor(this._getFillStyleElementColor(s.getFillStyleElement("LegendFill")));
        this.setShadowColor(this._getFillStyleElementColor(s.getFillStyleElement("DropShadow")));
        this.setSelectionColor(this._getFillStyleElementColor(s.getFillStyleElement("Selection")));
        this.setTextFrameColor(this._getLineStyleElementColor(s.getLineStyleElement("BorderLines")));
        this.setAxisLineColor(this._getLineStyleElementColor(s.getLineStyleElement("AxisLines")));
        this.setGridLineColor(this._getLineStyleElementColor(s.getLineStyleElement("GridLines")));
        this.setFrameColor(this._getLineStyleElementColor(s.getLineStyleElement("BorderLines")));
        this.setMajorTickColor(this.getAxisLineColor());
        this.setMinorTickColor(this.getAxisLineColor());
        dec.setOutlineColor(this._getLineStyleElementColor(s.getLineStyleElement("Outlines")));
        dec.setConnectingLineColor(this._getLineStyleElementColor(s.getLineStyleElement("Outlines")));
        this.setLabelColor(this._getTextStyleElementColor(s.getTextStyleElement("LabelText")));
        this.setValueColor(this._getTextStyleElementColor(s.getTextStyleElement("ValueText")));
        this.setTitleFootnoteColor(this._getTextStyleElementColor(s.getTextStyleElement("TitleText")));
        this.setDataLabelColor(this._getTextStyleElementColor(s.getTextStyleElement("DataText")));
        this.setDataElementColors(dec);
    }

    private void buildAutumnScheme() {
        this.setName(101000);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Electronics"));
    }

    private void buildBrightScheme() {
        this.setName(101001);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Banker"));
    }

    private void buildCarnivalScheme() {
        this.setName(101002);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"RSVP"));
    }

    private void buildCommerceScheme() {
        this.setName(101003);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Magnify"));
    }

    private void buildGrayscaleScheme() {
        this.setName(101004);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Journal"));
    }

    private void buildIndustryScheme() {
        this.setName(101005);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Astronomy"));
    }

    private void buildMagellanScheme() {
        this.setName(101006);
        DataElementColors dec = new DataElementColors();
        dec.setDiscreteFillColors(new Color[]{new Color(25, 50, 150), new Color(255, 197, 0), new Color(86, 4, 103), new Color(38, 196, 190), new Color(195, 5, 14), new Color(255, 150, 0), new Color(171, 44, 237), new Color(255, 228, 0), new Color(97, 112, 255), new Color(117, 0, 107), new Color(102, 164, 4), new Color(197, 213, 244)});
        dec.setDiscreteContrastColors(new Color[]{new Color(113, 43, 112), new Color(208, 151, 42), new Color(143, 192, 11), new Color(42, 93, 126), new Color(159, 0, 79), new Color(136, 77, 12), new Color(197, 54, 196), new Color(91, 91, 208), new Color(0, 100, 50), new Color(11, 158, 170), new Color(132, 148, 195), new Color(39, 228, 14)});
        this._setDefaultMilestoneColor(dec);
        dec.setContinuousFillTwoColorStartColor(Color.white);
        dec.setContinuousFillTwoColorEndColor(new Color(25, 50, 150));
        dec.setContinuousContrastTwoColorStartColor(Color.white);
        dec.setContinuousContrastTwoColorEndColor(new Color(100, 151, 235));
        dec.setContinuousFillThreeColorStartColor(new Color(253, 180, 98));
        dec.setContinuousFillThreeColorEndColor(new Color(97, 166, 231));
        dec.setContinuousFillThreeColorNeutralColor(new Color(210, 97, 150));
        dec.setContinuousContrastThreeColorStartColor(new Color(100, 151, 235));
        dec.setContinuousContrastThreeColorEndColor(Color.white);
        dec.setContinuousContrastThreeColorNeutralColor(new Color(221, 96, 96));
        this._setContinuousColorSpectrum(dec);
        this.setBackgroundColor(Color.white);
        this.setWallColor(Color.white);
        this.setFloorColor(Color.white);
        this.setLegendBackgroundColor(Color.white);
        this.setTextFrameColor(Color.white);
        this.setShadowColor(new Color(128, 128, 128).darker().darker());
        this.setAxisLineColor(Color.black);
        this.setGridLineColor(new Color(254, 253, 218));
        this.setFrameColor(Color.black);
        this.setMajorTickColor(this.getAxisLineColor());
        this.setMinorTickColor(this.getAxisLineColor());
        dec.setOutlineColor(new Color(34, 49, 197));
        dec.setConnectingLineColor(new Color(34, 49, 197));
        this.setLabelColor(Color.black);
        this.setValueColor(Color.black);
        this.setTitleFootnoteColor(Color.black);
        this.setDataLabelColor(Color.black);
        this.setDataElementColors(dec);
    }

    private void buildNeonScheme() {
        this.setName(101007);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Sketch"));
    }

    private void buildOceanScheme() {
        this.setName(101008);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Science"));
    }

    private void buildPastelScheme() {
        this.setName(101009);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Torn"));
    }

    private void buildPicnicScheme() {
        this.setName(101010);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Education"));
    }

    private void buildPineScheme() {
        this.setName(101011);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Gears"));
    }

    private void buildTerraScheme() {
        this.setName(101012);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Convention"));
    }

    private void buildWheatScheme() {
        this.setName(101013);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Blockprint"));
    }

    private void buildWoodlandScheme() {
        this.setName(101014);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Curve"));
    }

    private void buildDecoScheme() {
        this.setName(101016);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Statistical"));
    }

    private void buildZuniScheme() {
        this.setName(101017);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Analysis"));
    }

    private void buildGanttChartScheme() {
        this.setName(101015);
        this._applyColorStyle(PredefinedStyles.getPredefinedStyle((String)"Gantt"));
    }

    private void _setContinuousColorSpectrum(DataElementColors dec) {
        ColorPosition[] continuousColorSpectrum = new ColorPosition[]{new ColorPosition(dec.getContinuousFillThreeColorStartColor(), 0.0), new ColorPosition(dec.getContinuousFillThreeColorNeutralColor(), 0.5), new ColorPosition(dec.getContinuousFillThreeColorEndColor(), 1.0)};
        dec.setContinuousColorSpectrum(continuousColorSpectrum);
    }

    public boolean equals(ColorScheme that) {
        return this.name == that.name && this.modified == that.modified && this.colorsEqual(this.backgroundColor, that.backgroundColor) && this.colorsEqual(this.wallColor, that.wallColor) && this.colorsEqual(this.floorColor, that.floorColor) && this.colorsEqual(this.legendBackgroundColor, that.legendBackgroundColor) && this.colorsEqual(this.axisLineColor, that.axisLineColor) && this.colorsEqual(this.gridLineColor, that.gridLineColor) && this.colorsEqual(this.majorTickColor, that.majorTickColor) && this.colorsEqual(this.minorTickColor, that.minorTickColor) && this.colorsEqual(this.labelColor, that.labelColor) && this.colorsEqual(this.valueColor, that.valueColor) && this.colorsEqual(this.dataLabelColor, that.dataLabelColor) && this.colorsEqual(this.dataTipColor, that.dataTipColor) && this.colorsEqual(this.shadowColor, that.shadowColor) && this.colorsEqual(this.selectionColor, that.selectionColor) && this.colorsEqual(this.selectionAccentColor, that.selectionAccentColor) && this.colorsEqual(this.textFrameColor, that.textFrameColor) && this.colorsEqual(this.frameColor, that.frameColor) && this.colorsEqual(this.titleFootnoteColor, that.titleFootnoteColor) && this.colorsEqual(this.rowAxisLabelCellBackgroundColor, that.rowAxisLabelCellBackgroundColor) && this.colorsEqual(this.rowAxisValueCellBackgroundColor, that.rowAxisValueCellBackgroundColor) && this.colorsEqual(this.columnAxisLabelCellBackgroundColor, that.columnAxisLabelCellBackgroundColor) && this.colorsEqual(this.columnRowAxisLabelCellFrameColor, that.columnRowAxisLabelCellFrameColor) && this.colorsEqual(this.columnAxisValueCellBackgroundColor, that.columnAxisValueCellBackgroundColor) && this.colorsEqual(this.columnRowAxisValueCellFrameColor, that.columnRowAxisValueCellFrameColor) && this.dataElementColors.equals(that.dataElementColors);
    }

    private boolean colorsEqual(Color c1, Color c2) {
        return c1 == c2 || c1 != null && c2 != null && c1.equals(c2);
    }
}

