/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import com.sas.text.Message;
import java.awt.Color;

@SASScope(value="ALL")
public class ColorPosition {
    public static final String RB_KEY = "ColorPosition.";
    private Color color;
    private double position;

    public static ColorPosition[] newContinuousColorRange(Color[] colors, double[] positions) {
        if (colors == null || positions == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        if (colors.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        if (positions.length < 2) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidArraySizeLessThanTwo.ex.fmt.txt"), (Object)"positions"));
        }
        ColorPosition[] colorPositionArray = new ColorPosition[Math.min(colors.length + 1, positions.length)];
        double previousPosition = Double.NaN;
        for (int index = 0; index < colorPositionArray.length; ++index) {
            int colorIndex = Math.min(index, colors.length - 1);
            if (colors[colorIndex] == null) {
                throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
            }
            Color color = colors[colorIndex];
            double position = positions[index];
            if (Double.isNaN(position) || Double.isInfinite(position)) {
                throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
            }
            if (!Double.isNaN(previousPosition) && position <= previousPosition) {
                throw new IllegalArgumentException(RB.getStringResource("invalidReplicatedRangeValue.ex.txt"));
            }
            colorPositionArray[index] = new ColorPosition(color, position);
            previousPosition = position;
        }
        return colorPositionArray;
    }

    public static ColorPosition[] newContinuousColorRange(double from, double to, double by, Color[] colorArray) {
        if (colorArray == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullEntryInvalid.ex.txt"));
        }
        if (colorArray.length < 1) {
            throw new IllegalArgumentException(RB.getStringResource("zeroLengthInvalid.ex.txt"));
        }
        if (Double.isNaN(from) || Double.isInfinite(from)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (Double.isNaN(to) || Double.isInfinite(to)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (Double.isNaN(by) || Double.isInfinite(by)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        if (from >= to) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidRangeSpec.ex.fmt.txt"), (Object)"to", (Object)"from"));
        }
        if (to - from < by) {
            throw new IllegalArgumentException(Message.format((String)RB.getStringResource("invalidBySpec.ex.fmt.txt"), (Object)"by", (Object)"to", (Object)"from"));
        }
        int size = (int)((to - from) / by) + 1;
        double[] positions = new double[size];
        Color[] colors = new Color[size];
        int ii = 0;
        double position = from;
        while (position <= to) {
            positions[ii] = position;
            colors[ii] = colorArray[ii % colorArray.length];
            position += by;
            ++ii;
        }
        return ColorPosition.newContinuousColorRange(colors, positions);
    }

    public ColorPosition(Color newColor, double newPosition) {
        this(null, newColor, newPosition);
    }

    public ColorPosition(Color newActiveColor, Color newColor, double newPosition) {
        if (newColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        this.color = newColor;
        if (newPosition == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("positiveInfinityInvalid.ex.txt"));
        }
        if (newPosition == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException(RB.getStringResource("negativeInfinityInvalid.ex.txt"));
        }
        if (Double.isNaN(newPosition)) {
            throw new IllegalArgumentException(RB.getStringResource("nanInvalid.ex.txt"));
        }
        this.position = newPosition;
    }

    public Color getColor() {
        return this.color;
    }

    public double getPosition() {
        return this.position;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ColorPosition arg = (ColorPosition)obj;
        return Util.Evaluate.isEqual(this.position, arg.position) && Util.Evaluate.isEqual(this.color, arg.color);
    }

    public String toString() {
        return "" + this.position + " ==> " + this.color;
    }
}

