/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ClassificationVariable;
import com.sas.graphics.components.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

@SASScope(value="ALL")
public class ClassificationVariableList
extends ClassificationVariable {
    private final ClassificationVariableList next;

    public ClassificationVariableList(String columnName, String format, String informat, String label, int sort, ClassificationVariableList next) {
        super(columnName, format, informat, label, sort);
        this.next = next;
    }

    public ClassificationVariableList(int columnIndex, String format, String informat, String label, int sort, ClassificationVariableList next) {
        super(columnIndex, format, informat, label, sort);
        this.next = next;
    }

    public ClassificationVariableList(String[] columnNames) {
        super(columnNames != null && columnNames.length > 0 ? columnNames[0] : null);
        if (columnNames != null && columnNames.length > 1) {
            ClassificationVariableList nextVar = null;
            for (int ii = columnNames.length - 1; ii > 0; --ii) {
                nextVar = new ClassificationVariableList(columnNames[ii], null, null, null, 10400, nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    private ClassificationVariableList(ClassificationVariable variable, ClassificationVariableList nextVar) {
        super(variable);
        this.next = nextVar;
    }

    public ClassificationVariableList(ClassificationVariable[] variableArray) {
        super(variableArray != null && variableArray.length > 0 ? variableArray[0] : null);
        if (variableArray != null && variableArray.length > 1) {
            ClassificationVariableList nextVar = null;
            for (int ii = variableArray.length - 1; ii > 0; --ii) {
                nextVar = new ClassificationVariableList(variableArray[ii], nextVar);
            }
            this.next = nextVar;
        } else {
            this.next = null;
        }
    }

    public ClassificationVariableList getNext() {
        return this.next;
    }

    public ClassificationVariable[] asArray() {
        ClassificationVariableList curr;
        int ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            ++ii;
        }
        ClassificationVariable[] array = new ClassificationVariable[ii];
        ii = 0;
        for (curr = this; curr != null; curr = curr.getNext()) {
            array[ii++] = new ClassificationVariable(curr);
        }
        return array;
    }

    public ArrayList asArrayList() {
        ClassificationVariableList curr = this;
        ArrayList<ClassificationVariableList> list = new ArrayList<ClassificationVariableList>();
        do {
            list.add(curr);
        } while ((curr = curr.getNext()) != null);
        return list;
    }

    public Iterator iterator() {
        return new VariableListIterator(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassificationVariableList arg = (ClassificationVariableList)obj;
        return Util.Evaluate.isEqual(this.next, arg.next) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    @SASScope
    private static class VariableListIterator
    implements Iterator {
        ClassificationVariableList prev = null;
        ClassificationVariableList curr = null;
        ClassificationVariableList next;

        public VariableListIterator(ClassificationVariableList ptr) {
            this.next = ptr;
        }

        public Object next() throws NoSuchElementException {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.prev = this.curr;
            this.curr = this.next;
            this.next = this.curr.getNext();
            return this.curr;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public void remove() {
        }
    }
}

