/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.CellStyle;
import com.sas.graphics.components.GraphConstants;
import com.sas.graphics.components.LineStyle;
import com.sas.graphics.components.RB;
import com.sas.text.Message;
import java.awt.Color;

@SASScope(value="ALL")
public class ClassificationCellStyle
extends CellStyle {
    public static final String RB_KEY = "ClassificationCellStyle.";
    private int shadingPolicy = 10200;
    private Float shadingIntensity = new Float(0.05f);

    public void apply(ClassificationCellStyle theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        super.apply(theOtherObject);
        this.shadingPolicy = theOtherObject.shadingPolicy;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public ClassificationCellStyle() {
    }

    public ClassificationCellStyle(Color[] backgroundColors, LineStyle frameLineStyle) {
        super(backgroundColors, frameLineStyle);
    }

    public ClassificationCellStyle(Color backgroundColor, LineStyle frameLineStyle) {
        super(backgroundColor, frameLineStyle);
    }

    public void setShadingPolicy(int newShadingPolicy) {
        GraphConstants.TRI.validate(newShadingPolicy);
        int oldShadingPolicy = this.shadingPolicy;
        this.shadingPolicy = newShadingPolicy;
        this.firePropertyChange("shadingPolicy", oldShadingPolicy, this.shadingPolicy);
    }

    public int getShadingPolicy() {
        return this.shadingPolicy;
    }

    public void setShadingIntensity(Float intensity) {
        if (intensity == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        float f = intensity.floatValue();
        if (f < -1.0f || f > 1.0f) {
            String message = Message.format((String)RB.getStringResource("invalidRange.ex.fmt.txt"), (Object)new Double(-1.0).toString(), (Object)new Double(1.0).toString());
            throw new IllegalArgumentException(message);
        }
        Float oldShadingIntensity = this.shadingIntensity;
        this.shadingIntensity = intensity;
        this.firePropertyChange("shadingIntensity", oldShadingIntensity, this.shadingIntensity);
    }

    public Float getShadingIntensity() {
        return this.shadingIntensity;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        ClassificationCellStyle arg = (ClassificationCellStyle)obj;
        return this.shadingPolicy == arg.shadingPolicy && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

