/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.components;

import com.sas.codepolicy.SASScope;
import com.sas.graphics.components.ModelBase;
import com.sas.graphics.components.RB;
import com.sas.graphics.components.util.Util;
import java.awt.Color;
import java.awt.SystemColor;

@SASScope(value="ALL")
public class BrushModel
extends ModelBase {
    private boolean selectOnGrow = true;
    private boolean selectOnMove = true;
    private boolean selectionAllowed = true;
    private Color selectionColor = SystemColor.textHighlight;
    private Color selectionAccentColor = SystemColor.textHighlightText;

    public void apply(BrushModel theOtherObject) {
        if (theOtherObject == null) {
            return;
        }
        this.disablePropertyChange();
        this.selectOnGrow = theOtherObject.selectOnGrow;
        this.selectOnMove = theOtherObject.selectOnMove;
        this.selectionAllowed = theOtherObject.selectionAllowed;
        this.selectionColor = theOtherObject.selectionColor;
        this.selectionAccentColor = theOtherObject.selectionAccentColor;
        this.enablePropertyChange();
        this.firePropertyChange("", null, this);
    }

    public void setSelectOnGrow(boolean newSelectOnGrow) {
        boolean oldSelectOnGrow = this.selectOnGrow;
        this.selectOnGrow = newSelectOnGrow;
        this.firePropertyChange("selectOnGrow", oldSelectOnGrow, this.selectOnGrow);
    }

    public boolean isSelectOnGrow() {
        return this.selectOnGrow;
    }

    public void setSelectOnMove(boolean newSelectOnMove) {
        boolean oldSelectOnMove = this.selectOnMove;
        this.selectOnMove = newSelectOnMove;
        this.firePropertyChange("selectOnMove", oldSelectOnMove, this.selectOnMove);
    }

    public boolean isSelectOnMove() {
        return this.selectOnMove;
    }

    public void setSelectionAllowed(boolean newSelectionAllowed) {
        boolean oldSelectOnGrow = this.selectionAllowed;
        this.selectionAllowed = newSelectionAllowed;
        this.firePropertyChange("selectionAllowed", oldSelectOnGrow, this.selectionAllowed);
    }

    public boolean isSelectionAllowed() {
        return this.selectionAllowed;
    }

    public void setSelectionColor(Color newSelectionColor) throws IllegalArgumentException {
        if (newSelectionColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldValue = this.selectionColor;
        this.selectionColor = newSelectionColor;
        this.firePropertyChange("selectionColor", oldValue, this.selectionColor);
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionAccentColor(Color newSelectionAccentColor) throws IllegalArgumentException {
        if (newSelectionAccentColor == null) {
            throw new IllegalArgumentException(RB.getStringResource("nullInvalid.ex.txt"));
        }
        Color oldValue = this.selectionAccentColor;
        this.selectionAccentColor = newSelectionAccentColor;
        this.firePropertyChange("selectionAccentColor", oldValue, this.selectionAccentColor);
    }

    public Color getSelectionAccentColor() {
        return this.selectionAccentColor;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BrushModel arg = (BrushModel)obj;
        return Util.Evaluate.isEqual(this.selectOnGrow, arg.selectOnGrow) && Util.Evaluate.isEqual(this.selectOnMove, arg.selectOnMove) && Util.Evaluate.isEqual(this.selectionAllowed, arg.selectionAllowed) && Util.Evaluate.isEqual(this.selectionColor, arg.selectionColor) && Util.Evaluate.isEqual(this.selectionAccentColor, arg.selectionAccentColor) && super.equals(arg);
    }

    @Override
    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

