/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render.pie;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorCache;
import com.sas.graphics.util.gtk.LineStyle;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericCache;
import com.sas.graphics.util.gtk.NumericVariable;
import com.sas.graphics.util.gtk.NumericVectorVariable;
import com.sas.graphics.util.gtk.OLAPLevelVariable;
import com.sas.graphics.util.gtk.OLAPVariableFactory;
import com.sas.graphics.util.gtk.StringCache;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringVariable;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.ValueMap;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.GTKLogEvent;
import com.sas.graphics.util.gtk.gl.GTKLogEventListener;
import com.sas.graphics.util.gtk.gl.GTKPie;
import com.sas.graphics.util.gtk.gl.Image;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.NetworkRoot;
import com.sas.graphics.util.gtk.render.RendererUtil;
import com.sas.graphics.util.gtk.render.SelectInfo;
import com.sas.graphics.util.gtk.render.pie.GTKPieChartRendererModel;
import com.sas.graphics.util.gtk.resources.GraphResources;
import com.sas.measures.BaseLength;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;

public class GTKPieChartRenderer {
    private GTKPieChartRendererModel model;
    private JComponent component;
    private NetworkRoot nr;
    private Channel channel;
    private Composite composite;
    private int order;
    private GridInCell pieGrid;
    private int preferredX;
    private int preferredY;
    private int titleMarkerID = 0;
    private double preferredRadius = 0.0;
    private Color pieOutlineColor;
    private int numPieElements = 0;
    private Vector<String>[] catVec;
    private Vector<String>[] subVec;
    private Vector<Double>[] respVec;
    private Vector<Double>[] indexVec;
    private Vector<Double>[] selVec;
    private Vector<Double>[] selPctVec;
    private boolean consistantFontSizes = true;
    private boolean consistantRadius = true;
    private String subTitleName;
    private String subTitleLabel;
    private HashMap<String, String> respToFmtHash;
    private GTKPie[] pieComponents;
    private GTKPie curPie;
    private List<GTKLogEventListener> logListeners = new ArrayList<GTKLogEventListener>();
    private List<GTKLogEvent> events = new ArrayList<GTKLogEvent>();
    private static final int PIE_HEIGHT = 25;
    private static final BaseLength MINIMUM_SIZE = new BaseLength(8.0, "pt");

    public GTKPieChartRenderer(GTKPieChartRendererModel rendererModel, JComponent component) {
        this.channel = new Channel((Component)component, 2);
        this.channel.glDisable(4);
        this.channel.glDisable(3);
        this.nr = new NetworkRoot(this.channel);
        this.composite = new Composite();
        this.nr.addElement(this.composite);
        this.init(rendererModel, component, this.nr, this.composite, this.channel);
    }

    private void init(GTKPieChartRendererModel rendererModel, JComponent component, NetworkRoot nr, Composite composite, Channel channel) {
        this.model = rendererModel;
        this.component = component;
        this.nr = nr;
        this.channel = channel;
        this.composite = composite;
        this.titleMarkerID = channel.addCustomMarker(rendererModel.getTitleMarker());
    }

    private void initModelForSectorPie() {
        this.model.setSkin(RendererUtil.Skin.NOMAD);
        this.model.setStartAngle(90.0);
        this.model.setCenterFirstSlice(false);
        this.model.setSliceOrder(RendererUtil.Sort.DESCENDING);
        if (this.model.getSubgroupVariable() != null) {
            this.model.setVisibleOtherSlice(false);
            this.model.setExplodeOtherSlice(false);
            this.model.setSubgroupStacked(true);
        }
        this.model.setReverseDirection(true);
        this.model.setSubgroupLabelPlacement(RendererUtil.DataLabel.NONE);
    }

    public GTKPieChartRendererModel getModel() {
        return this.model;
    }

    public synchronized void construct() {
        if (this.model.isSectorPie()) {
            this.initModelForSectorPie();
        }
        this.events.clear();
        this.order = 0;
        this.pieGrid = null;
        this.preferredX = 0;
        this.preferredY = 0;
        this.preferredRadius = 0.0;
        this.pieOutlineColor = null;
        this.numPieElements = 0;
        this.catVec = null;
        this.subVec = null;
        this.respVec = null;
        this.indexVec = null;
        this.selVec = null;
        this.selPctVec = null;
        this.consistantFontSizes = true;
        this.consistantRadius = true;
        this.subTitleName = null;
        this.subTitleLabel = null;
        this.respToFmtHash = null;
        this.pieComponents = null;
        this.curPie = null;
        this.titleMarkerID = this.channel.addCustomMarker(this.model.getTitleMarker());
        StringPipe subgroupFormattedValue = null;
        this.composite.removeAllElements();
        StringVariable subgroupVariable = null;
        Rectangle b = this.component.getBounds();
        StringPipe categoryFormattedValue = this.model.getCategoryVariable().formattedValue;
        Variable[] responseVariableArray = this.model.getResponseVariableArray();
        Variable[] selectionVariableArray = this.model.getSelectionVariableArray();
        subgroupVariable = this.model.getSubgroupVariable();
        if (subgroupVariable != null) {
            OLAPVariableFactory ovf;
            List al;
            this.subTitleName = subgroupVariable.getName();
            this.subTitleLabel = subgroupVariable.getLabel();
            if (subgroupVariable.getConnection() instanceof OLAPLevelVariable && (al = (ovf = ((OLAPLevelVariable)subgroupVariable.getConnection()).getFactory()).getLevelNamesForHeirarchy(((OLAPLevelVariable)subgroupVariable.getConnection()).getHierachyName())).size() == 1) {
                this.subTitleLabel = this.subTitleName = ovf.getLabel((String)al.get(0));
            }
            subgroupFormattedValue = subgroupVariable.formattedValue;
        }
        if (categoryFormattedValue != null && responseVariableArray != null && responseVariableArray.length > 0) {
            boolean labelEnabled;
            Object colorMapper = null;
            this.pieOutlineColor = this.model.getOutlineLineStyle().getColor();
            this.numPieElements = 0;
            if (this.model.isSubgroupStacked()) {
                this.numPieElements = responseVariableArray.length;
            } else {
                int n = this.numPieElements = subgroupVariable == null ? 1 : subgroupVariable.getUniqueValueCount();
            }
            if (this.pieComponents == null || this.pieComponents.length != this.numPieElements) {
                this.pieComponents = new GTKPie[this.numPieElements];
            }
            this.pieGrid = new GridInCell(this.numPieElements, this.model.getAcross(), this.model.getDown());
            Point2D.Double scale = this.pieGrid.getScale();
            this.preferredX = b.width;
            this.preferredY = b.height;
            int smallerPreferred = (int)((double)Math.min(this.preferredX / this.pieGrid.getCols(), this.preferredY / this.pieGrid.getRows()) / 1.4);
            this.preferredRadius = smallerPreferred;
            Point2D.Double orig = this.pieGrid.getTranslate(this.preferredX, this.preferredY);
            boolean respLabelVis = this.model.isResponseLabelVisible();
            boolean bl = labelEnabled = respLabelVis && this.model.isResponseLabelTextStyleVisible() && responseVariableArray.length > 1;
            if (this.model.isSubgroupStacked()) {
                this.respToFmtHash = null;
                for (int ii = 0; ii < responseVariableArray.length; ++ii) {
                    if (responseVariableArray[ii] == null) continue;
                    if (this.pieComponents[ii] == null) {
                        this.pieComponents[ii] = this.createPieElement();
                    }
                    this.initPieElement(this.pieComponents[ii]);
                    Point2D.Double translate = this.pieGrid.getTranslate(this.preferredX, this.preferredY);
                    Composite c = new Composite();
                    c.transform.translateX.setValue(translate.x);
                    c.transform.translateY.setValue(translate.y);
                    c.transform.scaleX.setValue(scale.x);
                    c.transform.scaleY.setValue(scale.y);
                    this.pieComponents[ii].setResponseTitleAdjustment(new Point2D.Double(translate.x - orig.x, -translate.y + orig.y));
                    this.pieComponents[ii].setGridLayout(new Dimension(this.pieGrid.getCols(), this.pieGrid.getRows()));
                    String theTitle = responseVariableArray[ii].getLabel().trim();
                    if (labelEnabled && theTitle.length() > 0) {
                        this.pieComponents[ii].setResponseLabel(theTitle);
                    }
                    if (selectionVariableArray != null && selectionVariableArray.length > 0 && selectionVariableArray[0] instanceof NumericVariable) {
                        SelectInfo selectInfo;
                        if (this.model.getRuleTargetIdentifier() == null || this.model.getRuleTargetIdentifier().equals(responseVariableArray[ii].getRootVariable().getColumnName())) {
                            if (ii > selectionVariableArray.length - 1) {
                                this.pieComponents[ii].highlightOn.connectFrom(((NumericVariable)selectionVariableArray[0]).value);
                            } else {
                                this.pieComponents[ii].highlightOn.connectFrom(((NumericVariable)selectionVariableArray[ii]).value);
                            }
                            if (this.model.getSelectedPercentageVariable() != null) {
                                this.pieComponents[ii].highlightPercentage.connectFrom(this.model.getSelectedPercentageVariable().value);
                            }
                            this.pieComponents[ii].highlightFillColor.setValue(this.model.getHighlightFillColor());
                            this.pieComponents[ii].highlightEdgeColor.setValue(this.model.getHighlightEdgeColor());
                        }
                        if ((selectInfo = (SelectInfo)this.pieComponents[ii].getUserData()) != null) {
                            selectInfo.userData = responseVariableArray[ii];
                        }
                    }
                    AInitAction initAction = new AInitAction(this.channel);
                    StringCache categoryCache = new StringCache();
                    categoryCache.input.connectFrom(categoryFormattedValue);
                    categoryCache.value.init(initAction);
                    NumericCache responseCache = new NumericCache();
                    responseCache.input.connectFrom(((NumericVariable)responseVariableArray[ii]).value);
                    responseCache.value.init(initAction);
                    if (colorMapper != null) {
                        ColorCache colorCache = new ColorCache();
                        colorCache.input.connectFrom(colorMapper.value);
                        colorCache.value.init(initAction);
                    }
                    this.pieComponents[ii].category.connectFrom(categoryCache.value);
                    this.pieComponents[ii].response.connectFrom(responseCache.value);
                    if (subgroupVariable != null) {
                        StringCache subgroupCache = new StringCache();
                        subgroupCache.input.connectFrom(subgroupFormattedValue);
                        subgroupCache.value.init(initAction);
                        this.pieComponents[ii].subgroup.connectFrom(subgroupCache.value);
                        this.pieComponents[ii].setSubgroupTitle(this.subTitleLabel);
                    }
                    c.addElement(this.pieComponents[ii]);
                    this.composite.addElement(c);
                    this.pieGrid.increment();
                }
            } else {
                int ii;
                int numSubs = this.numPieElements;
                StringVectorVariable[] catVar = new StringVectorVariable[numSubs];
                StringVectorVariable[] subVar = new StringVectorVariable[numSubs];
                NumericVectorVariable[] respVar = new NumericVectorVariable[numSubs];
                NumericVectorVariable[] indexVar = new NumericVectorVariable[numSubs];
                NumericVectorVariable[] selVar = new NumericVectorVariable[numSubs];
                NumericVectorVariable[] selPctVar = new NumericVectorVariable[numSubs];
                this.catVec = new Vector[numSubs];
                this.subVec = new Vector[numSubs];
                this.respVec = new Vector[numSubs];
                this.indexVec = new Vector[numSubs];
                this.selVec = new Vector[numSubs];
                this.selPctVec = new Vector[numSubs];
                String compareSub = "";
                String thisSub = "";
                String thisFormattedSub = "";
                String thisCat = "";
                String[] responseVariableColumnNames = new String[responseVariableArray.length];
                String[] responseVariableLabels = new String[responseVariableArray.length];
                double thisResp = 0.0;
                double thisSel = 0.0;
                double thisSelPct = 0.0;
                for (int kk = 0; kk < responseVariableArray.length; ++kk) {
                    responseVariableLabels[kk] = responseVariableArray[kk].getRootVariable().getLabel();
                    responseVariableColumnNames[kk] = responseVariableArray[kk].getRootVariable().getColumnName();
                }
                boolean sameFormat = true;
                String fmtCompare = responseVariableArray[0].getSASFormatName();
                this.respToFmtHash = new HashMap(responseVariableArray.length);
                this.respToFmtHash.put(responseVariableLabels[0], fmtCompare);
                if (fmtCompare == null) {
                    sameFormat = false;
                } else {
                    for (ii = 1; ii < responseVariableArray.length; ++ii) {
                        String thisFmt = responseVariableArray[ii].getSASFormatName();
                        this.respToFmtHash.put(responseVariableLabels[ii], thisFmt);
                        if (thisFmt != null && fmtCompare.equals(thisFmt)) continue;
                        sameFormat = false;
                    }
                }
                for (ii = 0; ii < numSubs; ++ii) {
                    if (subgroupVariable != null) {
                        try {
                            compareSub = subgroupVariable.formattedUniqueValue.getValue(ii).trim();
                        }
                        catch (MissingValueException e) {
                            compareSub = ".";
                        }
                    }
                    this.catVec[ii] = new Vector();
                    this.subVec[ii] = new Vector();
                    this.respVec[ii] = new Vector();
                    this.indexVec[ii] = new Vector();
                    this.selVec[ii] = new Vector();
                    this.selPctVec[ii] = new Vector();
                    catVar[ii] = new StringVectorVariable();
                    subVar[ii] = new StringVectorVariable();
                    respVar[ii] = new NumericVectorVariable();
                    indexVar[ii] = new NumericVectorVariable();
                    selVar[ii] = new NumericVectorVariable();
                    selPctVar[ii] = new NumericVectorVariable();
                    catVar[ii].connectFrom(this.catVec[ii]);
                    subVar[ii].connectFrom(this.subVec[ii]);
                    respVar[ii].connectFrom(this.respVec[ii]);
                    if (sameFormat) {
                        this.respToFmtHash.clear();
                        respVar[ii].setFormat(responseVariableArray[0].getFormat());
                    }
                    indexVar[ii].connectFrom(this.indexVec[ii]);
                    selVar[ii].connectFrom(this.selVec[ii]);
                    selPctVar[ii].connectFrom(this.selPctVec[ii]);
                    for (int kk = 0; kk < responseVariableArray.length; ++kk) {
                        StringVariable categoryVariable = this.model.getCategoryVariable();
                        for (int jj = 0; jj < categoryVariable.getValueCount(); ++jj) {
                            try {
                                thisCat = categoryVariable.formattedValue.getValue(jj).trim();
                            }
                            catch (MissingValueException e) {
                                thisCat = ValueMap.getDefaultMissingValueLabel(e.getMissingValue());
                            }
                            try {
                                thisResp = ((NumericVariable)responseVariableArray[kk]).value.getValue(jj);
                            }
                            catch (MissingValueException e) {
                                thisResp = 0.0;
                            }
                            try {
                                if (selectionVariableArray != null) {
                                    thisSel = kk > selectionVariableArray.length - 1 ? ((NumericVariable)selectionVariableArray[0]).value.getValue(jj) : ((NumericVariable)selectionVariableArray[kk]).value.getValue(jj);
                                }
                            }
                            catch (MissingValueException e) {
                                thisSel = 0.0;
                            }
                            if (this.model.getSelectedPercentageVariable() != null) {
                                try {
                                    thisSelPct = this.model.getSelectedPercentageVariable().value.getValue(jj);
                                }
                                catch (MissingValueException e) {
                                    thisSelPct = 0.0;
                                }
                            } else {
                                thisSelPct = 0.0;
                            }
                            if (subgroupVariable != null) {
                                try {
                                    thisSub = subgroupVariable.formattedValue.getValue(jj).trim();
                                }
                                catch (MissingValueException e) {
                                    thisSub = ".";
                                }
                            }
                            if (!thisSub.equals(compareSub)) continue;
                            this.catVec[ii].add(thisCat);
                            this.subVec[ii].add(responseVariableLabels[kk]);
                            this.respVec[ii].add(new Double(thisResp));
                            this.indexVec[ii].add(new Double(jj));
                            if (this.model.getRuleTargetIdentifier() != null && responseVariableColumnNames[kk] != null && thisSel > 0.0 && this.model.getRuleTargetIdentifier().equals(responseVariableColumnNames[kk])) {
                                this.selVec[ii].add(new Double(thisSel));
                                this.selPctVec[ii].add(new Double(thisSelPct));
                                continue;
                            }
                            this.selVec[ii].add(new Double(0.0));
                            this.selPctVec[ii].add(new Double(0.0));
                        }
                    }
                    if (this.pieComponents[ii] == null) {
                        this.pieComponents[ii] = this.createPieElement();
                    }
                    this.initPieElement(this.pieComponents[ii]);
                    Point2D.Double translate = this.pieGrid.getTranslate(this.preferredX, this.preferredY);
                    Composite c = new Composite();
                    c.transform.translateX.setValue(translate.x);
                    c.transform.translateY.setValue(translate.y);
                    c.transform.scaleX.setValue(scale.x);
                    c.transform.scaleY.setValue(scale.y);
                    this.pieComponents[ii].setResponseTitleAdjustment(new Point2D.Double(translate.x - orig.x, translate.y - orig.y));
                    this.pieComponents[ii].setGridLayout(new Dimension(this.pieGrid.getCols(), this.pieGrid.getRows()));
                    String theTitle = compareSub;
                    if (labelEnabled && theTitle.length() > 0) {
                        this.pieComponents[ii].setResponseLabel(theTitle);
                    }
                    if (selectionVariableArray != null && selectionVariableArray.length > 0 && selectionVariableArray[0] instanceof NumericVariable) {
                        SelectInfo selectInfo;
                        this.pieComponents[ii].highlightOn.connectFrom(selVar[ii].value);
                        this.pieComponents[ii].highlightFillColor.setValue(this.model.getHighlightFillColor());
                        this.pieComponents[ii].highlightEdgeColor.setValue(this.model.getHighlightEdgeColor());
                        if (this.model.getSelectedPercentageVariable() != null) {
                            this.pieComponents[ii].highlightPercentage.connectFrom(selPctVar[ii].value);
                        }
                        if ((selectInfo = (SelectInfo)this.pieComponents[ii].getUserData()) != null) {
                            selectInfo.userData = respVar[ii];
                        }
                    }
                    if (thisFormattedSub != "") {
                        this.pieComponents[ii].setResponseLabel(thisFormattedSub);
                    }
                    if (!sameFormat) {
                        this.pieComponents[ii].setUniqueSubgroupFormats(this.respToFmtHash);
                    }
                    this.pieComponents[ii].category.connectFrom(catVar[ii].formattedValue);
                    this.pieComponents[ii].response.connectFrom(respVar[ii].value);
                    this.pieComponents[ii].subgroup.connectFrom(subVar[ii].formattedValue);
                    this.pieComponents[ii].setSubgroupTitle("");
                    InitAction initAction = new InitAction(this.channel);
                    this.pieComponents[ii].processedCategory.init(initAction);
                    this.pieComponents[ii].processedSubgroup.init(initAction);
                    this.pieComponents[ii].processedResponse.init(initAction);
                    c.addElement(this.pieComponents[ii]);
                    this.composite.addElement(c);
                    this.pieGrid.increment();
                }
            }
        }
        if (this.consistantFontSizes) {
            this.nr.build();
            int constantResponseLabelSize = this.getMinimumScaledResponseLabelSize();
            int constantSliceLabelSize = this.getMinimumScaledSliceLabelSize();
            int constantSubgroupLabelSize = this.getMinimumScaledSubgroupLabelSize();
            int constantSubgroupTitleSize = this.getMinimumScaledSubgroupTitleSize();
            if (this.model.getFixedResponseLabelFontSize() != null) {
                constantResponseLabelSize = this.model.getFixedResponseLabelFontSize();
            }
            if (this.model.getFixedSliceLabelFontSize() != null) {
                constantSliceLabelSize = this.model.getFixedSliceLabelFontSize();
            }
            if (this.model.getFixedSubgroupLabelFontSize() != null) {
                constantSubgroupLabelSize = this.model.getFixedSubgroupLabelFontSize();
            }
            if (this.model.getFixedSubgroupTitleFontSize() != null) {
                constantSubgroupTitleSize = this.model.getFixedSubgroupTitleFontSize();
            }
            for (int iii = 0; iii < this.pieComponents.length; ++iii) {
                this.pieComponents[iii].setFixedResponseLabelFontSize(constantResponseLabelSize);
                this.pieComponents[iii].setFixedSliceLabelFontSize(constantSliceLabelSize);
                this.pieComponents[iii].setFixedSubgroupLabelFontSize(constantSubgroupLabelSize);
                this.pieComponents[iii].setFixedSubgroupTitleFontSize(constantSubgroupTitleSize);
            }
        }
        if (this.consistantRadius) {
            double constantRadius = this.getMinimumRadius();
            if (this.model.getFixedRadius() != null) {
                constantRadius = this.model.getFixedRadius();
            }
            for (int iii = 0; iii < this.pieComponents.length; ++iii) {
                this.pieComponents[iii].setFixedRadius(constantRadius);
            }
        }
    }

    public NetworkRoot getNetworkRoot() {
        return this.nr;
    }

    private GTKPie createPieElement() {
        GTKPie tmpPie = new GTKPie();
        return tmpPie;
    }

    private void initPieElement(GTKPie tmpPie) {
        tmpPie.setColorMap(this.model.getColorMap());
        SelectInfo.selectEnable(tmpPie, 7);
        if (this.model.isResponseLabelVisible()) {
            tmpPie.setResponseTitleStyle(this.model.getResponseLabelTextStyle());
        }
        LineStyle outline = this.model.getOutlineLineStyle();
        tmpPie.radius.setValue(this.preferredRadius);
        tmpPie.edgeOn.setValue(outline.isVisible());
        tmpPie.edgeColor.setValue(this.pieOutlineColor);
        tmpPie.setEdgeWidth(this.model.getOutlineLineStyle().getWidth());
        tmpPie.fillOn.setValue(this.model.isFillEnabled());
        tmpPie.setShrinkableFonts(true);
        tmpPie.setRingGap(this.model.getRingGap());
        this.channel.glLineStipple(outline.getStippleFactor(), outline.getStipplePattern());
        RendererUtil.Placement outPlacement = this.model.getOutsideSliceLabelPlacement();
        if (RendererUtil.Placement.ARROW == outPlacement) {
            tmpPie.setOutsideLabelPlacement(1);
        } else {
            tmpPie.setOutsideLabelPlacement(0);
        }
        RendererUtil.Placement inPlacement = this.model.getInsideSliceLabelPlacement();
        switch (inPlacement) {
            case BEST: {
                tmpPie.setInsideLabelPlacement(5);
                break;
            }
            case INSIDE_IF_FIT: {
                tmpPie.setInsideLabelPlacement(4);
                break;
            }
            default: {
                tmpPie.setInsideLabelPlacement(0);
            }
        }
        RendererUtil.DataLabel subPlacement = this.model.getSubgroupLabelPlacement();
        if (RendererUtil.DataLabel.NONE == subPlacement) {
            tmpPie.setSubgroupLabelPlacement(6);
        } else if (RendererUtil.DataLabel.EAST == subPlacement) {
            tmpPie.setSubgroupLabelPlacement(3);
        } else {
            tmpPie.setSubgroupLabelPlacement(2);
        }
        if (!this.model.isInsideSliceLabelTextStyleVisible()) {
            tmpPie.setInsideLabelContent(RendererUtil.DataLabel.NONE);
        } else {
            tmpPie.setInsideLabelContent(this.model.getInsideSliceLabelContent());
        }
        tmpPie.setInsideLabelStyle(this.model.getInsideSliceLabelTextStyle());
        tmpPie.setOutsideLabelStyle(this.model.getOutsideSliceLabelTextStyle());
        if (this.model.getSubgroupVariable() != null || !this.model.isOutsideSliceLabelTextStyleVisible()) {
            tmpPie.setOutsideLabelContent(RendererUtil.DataLabel.NONE);
        } else {
            tmpPie.setOutsideLabelContent(this.model.getOutsideSliceLabelContent());
        }
        tmpPie.setDonutLabelStyle(this.model.getDonutHoleLabelTextStyle());
        tmpPie.setSubgroupTitleStyle(this.model.getSubgroupLabelTextStyle());
        tmpPie.setSubgroupLabelStyle(this.model.getSubgroupLabelValueTextStyle());
        if (this.model.isSubgroupLabelDrillIconVisible()) {
            tmpPie.setTitleMarkerVisible(true);
            tmpPie.setTitleMarkerId(this.titleMarkerID);
            tmpPie.setTitleMarkerSize(this.model.getTitleMarkerSize());
        }
        tmpPie.setSize(new Dimension(this.component.getBounds().width, this.component.getBounds().height));
        if (this.model.isImageFillEnabled()) {
            tmpPie.setTextureImage(new BufferedImage[]{Image.convertImageToBufferedImage(this.model.getFillImage())});
        }
        ImageIcon pieEffectsIcon = null;
        switch (this.model.getSkin()) {
            case CRISP: {
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/CrispPie.png");
                break;
            }
            case GLOSS: {
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/GlossPie.png");
                break;
            }
            case MATTE: {
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/MattePie.png");
                break;
            }
            case MODERN: 
            case PRESSED: {
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/PressedPie.png");
                break;
            }
            case SATIN: 
            case SHEEN: {
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/SheenPie.png");
                break;
            }
            case NOMAD: {
                if (this.model.getSubgroupVariable() != null && this.model.isSubgroupStacked()) {
                    pieEffectsIcon = GraphResources.getImageIcon("skin/pie/nomadGroup.png");
                    break;
                }
                pieEffectsIcon = GraphResources.getImageIcon("skin/pie/nomadNoGroup.png");
                break;
            }
        }
        if (pieEffectsIcon != null) {
            tmpPie.setSkinWidth(pieEffectsIcon.getIconWidth());
            tmpPie.setSkinHeight(pieEffectsIcon.getIconHeight());
        }
        tmpPie.setSkin(pieEffectsIcon);
        tmpPie.setStartAngle(this.model.getStartAngle() / 360.0 * 2.0 * Math.PI);
        tmpPie.setSliceDirection(this.model.isReverseDirection() ? 1 : -1);
        tmpPie.setOtherColor(this.model.getOtherColor());
        tmpPie.setOtherLabel(this.model.getOtherSliceLabel());
        RendererUtil.Sort sort = this.model.getSliceOrder();
        if (RendererUtil.Sort.ASCENDING == sort) {
            tmpPie.setSliceOrder(3);
        } else if (RendererUtil.Sort.DESCENDING == sort) {
            tmpPie.setSliceOrder(4);
            if (this.model.isSectorPie()) {
                tmpPie.setSliceOrder(5);
            }
        } else {
            tmpPie.setSliceOrder(0);
        }
        if (((String)this.model.getOtherThreshold().getUnit()).equals("percent")) {
            tmpPie.setOtherThresholdPct(this.model.getOtherThreshold().getMagnitude() / 100.0);
            tmpPie.setOtherThresholdNum(-1);
        } else {
            tmpPie.setOtherThresholdPct(0.0);
            tmpPie.setOtherThresholdNum((int)this.model.getOtherThreshold().getMagnitude());
        }
        tmpPie.setDonutSize(this.model.getDonutHoleSize());
        tmpPie.setDonutLabelStyle(this.model.getDonutHoleLabelTextStyle());
        tmpPie.setDonutLabel(this.model.getDonutHoleLabel());
        tmpPie.setInvisibleArray(this.model.getInvisibleCategories());
        tmpPie.setExplodeArray(this.model.getExplodedCategories());
        tmpPie.setExplodeOtherSice(this.model.isExplodingOtherSlice());
        tmpPie.setTwoD(this.model.is2D());
        tmpPie.setPercentFormat(this.model.getPercentFormat());
        tmpPie.setVisibleOtherSlice(this.model.isOtherSliceVisible());
        tmpPie.setGroupGapDimension(this.model.getGroupGapDimension());
        tmpPie.setRenderer(this);
    }

    public int getMinimumScaledResponseLabelSize() {
        int smallestSize = Integer.MAX_VALUE;
        if (this.pieComponents != null) {
            for (int i = 0; i < this.pieComponents.length; ++i) {
                smallestSize = Math.min(smallestSize, this.pieComponents[i].getScaledResponseLabelFontSize());
            }
        }
        return smallestSize;
    }

    public int getMinimumScaledSliceLabelSize() {
        int smallestSize = Integer.MAX_VALUE;
        if (this.pieComponents != null) {
            for (int i = 0; i < this.pieComponents.length; ++i) {
                smallestSize = Math.min(smallestSize, this.pieComponents[i].getScaledSliceLabelFontSize());
            }
        }
        return smallestSize;
    }

    public int getMinimumScaledSubgroupLabelSize() {
        int smallestSize = Integer.MAX_VALUE;
        if (this.pieComponents != null) {
            for (int i = 0; i < this.pieComponents.length; ++i) {
                smallestSize = Math.min(smallestSize, this.pieComponents[i].getScaledSubgroupLabelFontSize());
            }
        }
        return smallestSize;
    }

    public int getMinimumScaledSubgroupTitleSize() {
        int smallestSize = Integer.MAX_VALUE;
        if (this.pieComponents != null) {
            for (int i = 0; i < this.pieComponents.length; ++i) {
                smallestSize = Math.min(smallestSize, this.pieComponents[i].getScaledSubgroupTitleFontSize());
            }
        }
        return smallestSize;
    }

    public double getMinimumRadius() {
        double smallestSize = Double.MAX_VALUE;
        if (this.pieComponents != null) {
            for (int i = 0; i < this.pieComponents.length; ++i) {
                smallestSize = Math.min(smallestSize, this.pieComponents[i].getScaledRadius());
            }
        }
        return smallestSize;
    }

    public int getCategoryUniqueValueCount() {
        return this.model.getCategoryVariable().getUniqueValueCount();
    }

    public void setBounds(int x, int y, int w, int h) {
        this.channel.glViewport(0, 0, w, h);
        this.channel.glOrtho(0.0, (double)w, 0.0, (double)h, -1.0, 1.0);
        this.channel.gluLookAt(0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0);
    }

    public void updateChannel(Component component) {
        int width = component.getWidth();
        int height = component.getHeight();
        if (this.model.is2D()) {
            if (width <= 0) {
                width = 1;
            }
            if (height <= 0) {
                height = 1;
            }
            this.channel.glDisable(27);
            this.channel.glViewport(0, 0, width, height);
            this.channel.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
            this.channel.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
            this.channel.glDisable(4);
            this.channel.glDisable(3);
        } else {
            this.channel.glEnable(1);
            this.channel.glEnable(4);
            this.channel.setDepthTestAlgorithm(2);
            this.channel.glEnable(3);
            this.channel.glOrtho(0.0, 25.0, (double)this.preferredX, (double)this.order, (double)this.getCategoryUniqueValueCount(), 0.0);
            this.channel.glViewport(0, 0, width, height);
            this.channel.glOrtho(0.0, (double)width, 0.0, (double)height, -1000.0, 1000.0);
            this.channel.gluLookAt(0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0);
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public void paintComponent(Graphics g) {
        Channel c = this.channel;
        if (this.model.isAntialiasedGraphics()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        this.updateChannel(this.component);
        if (this.model.is2D()) {
            if (this.model.isAntialiasedText()) {
                this.getChannel().glEnable(14);
            } else {
                this.getChannel().glDisable(14);
            }
            this.channel.setSingleBufferGraphics(g);
            this.nr.draw();
        } else {
            if (this.isTextAntiAliasingEnabled()) {
                c.glEnable(14);
            }
            c.setSingleBufferGraphics(g);
            this.nr.build();
            c.glCallList(this.nr.getRootListName());
        }
        this.fireLogEvent();
        this.events.clear();
    }

    public Dimension getMinimumSize() {
        int px = (int)MINIMUM_SIZE.getMagnitude((Object)"px");
        if (this.pieGrid != null) {
            return new Dimension(this.pieGrid.getCols() * px, this.pieGrid.getRows() * px);
        }
        return new Dimension(px, px);
    }

    public boolean isStackedResponse() {
        return !this.model.isSubgroupStacked() && this.model.getResponseVariableArray().length > 1;
    }

    public GTKPie[] getPieComponents() {
        return this.pieComponents;
    }

    public GTKPie getCurrentPie() {
        return this.curPie;
    }

    public void setCurrentPie(GTKPie pie) {
        this.curPie = pie;
    }

    public HashMap<String, String> getResponseToFmtHash() {
        return this.respToFmtHash;
    }

    public final boolean isTextAntiAliasingEnabled() {
        if (this.model.isAntialiasedText()) {
            this.getChannel().glEnable(14);
        } else {
            this.getChannel().glDisable(14);
        }
        return this.getChannel().glIsEnabled(14);
    }

    public void addLogEventListener(GTKLogEventListener listener) {
        if (listener != null && !this.logListeners.contains(listener)) {
            this.logListeners.add(listener);
        }
    }

    public void removeLogEventListener(GTKLogEventListener listener) {
        this.logListeners.remove(listener);
    }

    public void removeAllLogEventListener() {
        this.logListeners.clear();
    }

    public void fireLogEvent() {
        for (GTKLogEvent evt : this.events) {
            for (GTKLogEventListener listener : this.logListeners) {
                listener.logEventOccured(evt);
            }
        }
    }

    public void addLogEvent(GTKLogEvent evt) {
        if (evt != null && !this.events.contains(evt)) {
            this.events.add(evt);
        }
    }

    class GridInCell {
        private int piesInGrid;
        private int across = 0;
        private int down = 0;
        private int cols = 0;
        private int rows = 0;
        private int curCol = 0;
        private int curRow = 0;

        public GridInCell() {
            this(1, 0, 0);
        }

        public GridInCell(int total) {
            this(total, 0, 0);
        }

        public GridInCell(int total, int a, int d) {
            this.piesInGrid = total;
            this.across = a;
            this.down = d;
            if (this.across > 0 && this.down > 0) {
                if (this.across * this.down < this.piesInGrid) {
                    if (this.across > this.down) {
                        this.down = 0;
                    } else {
                        this.across = 0;
                    }
                } else {
                    this.cols = this.across;
                    this.rows = this.down;
                    return;
                }
            }
            if (this.across > 0 && this.down == 0) {
                this.cols = this.across;
                this.rows = (int)Math.ceil((double)this.piesInGrid / (double)this.across);
            } else if (this.down > 0 && this.across == 0) {
                this.rows = this.down;
                this.cols = (int)Math.ceil((double)this.piesInGrid / (double)this.down);
            } else {
                this.rows = (int)Math.floor(Math.sqrt(Math.floor(Math.sqrt(this.piesInGrid)) + (double)this.piesInGrid));
                this.cols = (int)Math.ceil((double)this.piesInGrid / (double)this.rows);
            }
        }

        protected Point2D.Double getTranslate(int w, int h) {
            Point2D.Double tx = new Point2D.Double();
            double xExt = w;
            double yExt = h;
            double xPos = (double)this.curCol * xExt / (double)this.cols + xExt / (double)(2 * this.cols);
            double yPos = yExt - ((double)this.curRow * yExt / (double)this.rows + yExt / (double)(2 * this.rows));
            tx.x = xPos;
            tx.y = yPos;
            return tx;
        }

        protected Point2D.Double getScale() {
            Point2D.Double sc = new Point2D.Double();
            sc.x = 1.0 / (double)Math.max(this.cols, this.rows);
            sc.y = 1.0 / (double)Math.max(this.cols, this.rows);
            return sc;
        }

        protected void increment() {
            ++this.curCol;
            if (this.curCol >= this.cols) {
                ++this.curRow;
                this.curCol = 0;
            }
        }

        int getRows() {
            return this.rows;
        }

        int getCols() {
            return this.cols;
        }
    }
}

