/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.render;

import com.sas.text.SASFormat;
import java.util.Locale;

public class RendererUtil {
    public static SASFormat newSASFormat(String formatName, Locale locale) {
        if (formatName == null || formatName.trim().length() == 0) {
            return null;
        }
        try {
            return SASFormat.getInstance((String)formatName.trim(), (Locale)(locale == null ? Locale.getDefault() : locale));
        }
        catch (RuntimeException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public static int getSkinType(Skin skin) {
        switch (skin) {
            case CRISP: {
                return 5;
            }
            case GLOSS: {
                return 6;
            }
            case MATTE: {
                return 7;
            }
            case PRESSED: {
                return 3;
            }
            case SHEEN: {
                return 4;
            }
        }
        return 0;
    }

    public static enum KPIChartType {
        DIAL,
        TRAFFIC_LIGHT,
        BULLET,
        SLIDER,
        SPEEDOMETER_FULL,
        SPEEDOMETER_HALF,
        SPEEDOMETER_QUARTER,
        SPEEDOMETER_FULL_NOLABEL;

    }

    public static enum Sort {
        NONE,
        ASCENDING,
        DESCENDING;

    }

    public static enum Placement {
        ARROW,
        BEST,
        DEFAULT,
        INSIDE_IF_FIT;

    }

    public static enum Skin {
        PRESSED,
        SHEEN,
        CRISP,
        GLOSS,
        MATTE,
        NONE,
        SATIN,
        MODERN,
        CUSTOM,
        NOMAD;

    }

    public static enum GroupGapDimension {
        PIXEL,
        PERCENT;

    }

    public static enum DataLabel {
        NONE,
        ID,
        SIZE,
        COLOR,
        AUTOMATIC,
        CATEGORY,
        CATEGORY_PERCENT,
        CATEGORY_RESPONSE,
        CATEGORY_RESPONSE_PERCENT,
        HEIGHT,
        HEIGHT_PERCENT,
        MEAN,
        PERCENT,
        RESPONSE,
        RESPONSE_PERCENT,
        SUBPERCENT,
        SUM,
        WIDTH,
        WIDTH_PERCENT,
        X,
        Y,
        EAST,
        WEST;

    }

    public static enum TileChartLayout {
        LAYOUT_STANDARD,
        LAYOUT_TOGGLE,
        LAYOUT_GEOGRAPHIC,
        LAYOUT_FLOW;

    }
}

