/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.IntegerProperty;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;

public class VectorSegment
extends Element {
    public final NumericProperty beginX = new NumericProperty(this, true);
    public final NumericProperty beginY = new NumericProperty(this, true);
    public final NumericProperty beginZ = new NumericProperty(this, true);
    public final NumericProperty endX = new NumericProperty(this, true);
    public final NumericProperty endY = new NumericProperty(this, true);
    public final NumericProperty endZ = new NumericProperty(this, true);
    public final ColorProperty color = new ColorProperty(this, true);
    public final NumericProperty lineWidth = new NumericProperty(this, true);
    public final IntegerProperty arrowDirection = new IntegerProperty(this, true);
    public final IntegerProperty arrowShape = new IntegerProperty(this, true);
    public static final int ARROW_DIRECTION_IN = 0;
    public static final int ARROW_DIRECTION_OUT = 1;
    public static final int ARROW_DIRECTION_BOTH = 2;
    public static final int ARROW_DIRECTION_NONE = 3;
    public static final int ARROW_SHAPE_OPEN = 0;
    public static final int ARROW_SHAPE_CLOSED = 1;
    public static final int ARROW_SHAPE_FILLED = 2;
    public static final int ARROW_SHAPE_BARBED = 3;
    public final IntegerProperty linePattern = new IntegerProperty(this, true);
    protected int stipplePattern;
    protected int stippleFactor;
    static final double EPSILON = 1.0E-8;
    static final double[] origin = new double[]{0.0, 0.0, 0.0};
    static final double[] onePixel = new double[]{1.0, 1.0, 1.0};
    static final int arrowXpixels = 8;
    static final int arrowYpixels = 4;
    private static final double arrowAngleSin;
    private double xPixel;
    private double yPixel;
    private static final Vec3d X_AXIS;
    private Vec3d begin = new Vec3d();
    private Vec3d end = new Vec3d();
    private Vec3d diff = new Vec3d();
    private Vec3d axisOfRotation = new Vec3d();
    private VectorParameters vectorParameters = new VectorParameters();
    private double stippleScaleFactor = 1.0;
    private boolean scaleArrow = false;
    private int skinType = 0;

    public VectorSegment() {
        super(new Transform());
        this.lineWidth.setValue(1.0);
        this.linePattern.setValue(-1);
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        int index = bBoxAction.getValueIndex();
        BoundingBox box = bBoxAction.getElementBoundingBox();
        bBoxAction.pt1.set(this.beginX.getValue(index), this.beginY.getValue(index), this.beginZ.getValue(index));
        box.union(bBoxAction.pt1);
        bBoxAction.pt1.set(this.endX.getValue(index), this.endY.getValue(index), this.endZ.getValue(index));
        box.union(bBoxAction.pt1);
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Channel channel = ba.getChannel();
        int direction = this.arrowDirection.getValue();
        int shape = this.arrowShape.getValue();
        float lw = (float)this.lineWidth.getValue(index);
        this.loadBeginEndVectors(direction, index);
        this.diff.set(this.end);
        this.diff.subtract(this.begin);
        double lineAngle = this.diff.angle(X_AXIS) * 57.29577951308232;
        double length = this.diff.length();
        if (this.fuzzyCompare(lineAngle, 180.0)) {
            this.axisOfRotation.set(0.0, 1.0, 0.0);
        } else {
            this.axisOfRotation.set(X_AXIS);
            this.axisOfRotation.cross(this.diff);
        }
        channel.glLineWidth(lw);
        channel.glColor(this.color.getValue(index));
        channel.glSkinType(this.getSkinType());
        channel.glSkinCategory(1);
        channel.glDPIScaleFactor((float)this.stippleScaleFactor);
        channel.glPushMatrix();
        channel.glTranslate(this.begin.x, this.begin.y, this.begin.z);
        channel.glRotate(lineAngle, this.axisOfRotation.x, this.axisOfRotation.y, this.axisOfRotation.z);
        if (this.scaleArrow) {
            this.setupVectorParametersWithScaledArrow(length, direction, lw, shape);
        } else {
            this.setupVectorParameters(length, direction, lw, shape);
        }
        if (this.skinType != 0 && (!this.scaleArrow || length > 0.0)) {
            channel.glSkinRenderMode(2);
            this.drawArrow(channel, length, direction, shape, lw);
            channel.glSkinRenderMode(15);
        }
        if (channel.isSVGSelectionMode()) {
            channel.setSVGSelectionText(this.userDataToString(index), false);
        }
        this.drawLine(channel, length, index, direction);
        if (!this.scaleArrow || length > 0.0) {
            if (this.skinType != 0) {
                channel.glSkinRenderMode(5);
            }
            this.drawArrow(channel, length, direction, shape, lw);
        }
        if (channel.isSVGSelectionMode()) {
            channel.clearSVGSelectionText();
        }
        channel.glPopMatrix();
        channel.glLineWidth(1.0f);
        channel.glSkinType(0);
        channel.glSkinCategory(0);
        channel.glSkinRenderMode(15);
    }

    private boolean fuzzyCompare(double v1, double v2) {
        return Math.abs(v1 - v2) < 1.0E-8;
    }

    private double computeMiterLength(double lw) {
        double miterLength = 0.0;
        if (lw > 1.0) {
            miterLength = this.scaleArrow ? (lw < 2.0 ? 0.0 : 0.67 * lw - 1.0) : lw / 2.0 / arrowAngleSin;
        }
        return miterLength;
    }

    private void loadBeginEndVectors(int direction, int index) throws MissingValueException {
        this.begin.x = this.beginX.getValue(index);
        this.begin.y = this.beginY.getValue(index);
        this.begin.z = this.beginZ.getValue(index);
        this.end.x = this.endX.getValue(index);
        this.end.y = this.endY.getValue(index);
        this.end.z = this.endZ.getValue(index);
    }

    private void drawLine(Channel channel, double length, int index, int direction) throws MissingValueException {
        if (this.scaleArrow) {
            if (length == 0.0) {
                float lw = (float)this.lineWidth.getValue(index);
                int half = (int)((double)(lw - 1.0f) * 0.5);
                int size = lw < 1.0f ? 1 : (int)lw;
                channel.glPolygonMode(3);
                channel.glRect((double)(-half), (double)(-half), (double)(-half + size - 1), (double)(-half + size - 1));
                return;
            }
            if (this.arrowShape.getValue() == 1 && length < this.vectorParameters.arrowXsize) {
                return;
            }
        }
        if (this.linePattern.isConnected()) {
            int patternIndex = this.linePattern.getValue(index);
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        } else if (this.linePattern.getValue() != -1) {
            int patternIndex = this.linePattern.getValue();
            this.stipplePattern = SASLinePatterns.getStipplePattern((int)patternIndex);
            this.stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)SASLinePatterns.getStippleFactor((int)patternIndex));
        }
        if (this.stippleFactor > 0) {
            channel.glEnable(6);
            channel.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
        }
        channel.glBegin(1);
        channel.glVertex(this.vectorParameters.lineInX - this.vectorParameters.lineInAdjustment, 0.0);
        channel.glVertex(this.vectorParameters.lineOutX + this.vectorParameters.lineOutAdjustment, 0.0);
        channel.glEnd();
        if (this.stippleFactor > 0) {
            channel.glDisable(6);
        }
    }

    @Override
    public void init(AInitAction initAction) {
        super.init(initAction);
        Channel ch = (Channel)initAction.getGraphicsContext();
        this.computePixelSizes(ch);
    }

    private void computePixelSizes(Channel channel) {
        double[] worldOrigin = new double[3];
        double[] worldPixel = new double[3];
        channel.gluUnProject(origin, worldOrigin);
        channel.gluUnProject(onePixel, worldPixel);
        this.xPixel = Math.abs(worldPixel[0] - worldOrigin[0]);
        this.yPixel = Math.abs(worldPixel[1] - worldOrigin[1]);
    }

    private void drawArrow(Channel channel, double length, int direction, int shape, double lw) {
        if (direction != 3) {
            channel.glPushAttrib(0);
            channel.glDisable(1);
            switch (shape) {
                case 0: {
                    if (this.scaleArrow) {
                        if (lw >= 2.0) {
                            channel.glLineWidth((float)(0.67 * lw));
                        }
                        this.drawScaledArrowOpen(channel);
                        if (!(lw >= 2.0)) break;
                        channel.glLineWidth((float)lw);
                        break;
                    }
                    this.drawArrowOpen(channel);
                    break;
                }
                case 1: {
                    if (this.scaleArrow && lw >= 2.0) {
                        channel.glLineWidth((float)(0.67 * lw));
                    }
                    this.drawArrowClosed(channel);
                    if (!this.scaleArrow || !(lw >= 2.0)) break;
                    channel.glLineWidth((float)lw);
                    break;
                }
                case 2: {
                    this.drawArrowFilled(channel);
                    break;
                }
                case 3: {
                    if (this.scaleArrow) {
                        this.drawScaledArrowBarbed(channel);
                        break;
                    }
                    this.drawArrowBarbed(channel);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown shape.");
                }
            }
            channel.glPopAttrib();
        }
    }

    private static double getArrowSize(double lw, double DPIScaleFactor, int shape) {
        if ((lw = (double)Math.round(lw / DPIScaleFactor)) < 2.0) {
            lw = 2.0;
        }
        double arrowSize = shape == 0 || shape == 1 ? lw + 2.0 * (0.67 * lw / 1.732 + 2.0) : lw + 2.0 * (lw / 1.732 + 2.0);
        if (shape == 3) {
            arrowSize *= 1.125;
        }
        return arrowSize *= DPIScaleFactor;
    }

    private void setupVectorParametersWithScaledArrow(double length, int direction, double lw, int shape) {
        double arrowXsize;
        double arrowYsize;
        if (lw >= 1.0) {
            double arrowSide = VectorSegment.getArrowSize(lw, this.stippleScaleFactor, shape);
            double adjustedYpixels = Math.floor((arrowSide + 1.0) * 0.5);
            double adjustedXpixels = arrowSide * Math.sin(1.0471975511965976);
            arrowYsize = adjustedYpixels * this.yPixel;
            arrowXsize = adjustedXpixels * this.xPixel;
        } else if (shape == 3) {
            arrowYsize = 6.0 * this.yPixel;
            arrowXsize = 12.0 * this.xPixel;
        } else if (shape == 2) {
            arrowYsize = 4.5 * this.yPixel;
            arrowXsize = 9.0 * this.xPixel;
        } else {
            arrowYsize = 4.0 * this.yPixel;
            arrowXsize = 8.0 * this.xPixel;
        }
        double miterLength = this.computeMiterLength(lw) * this.xPixel;
        this.vectorParameters.arrowInX = 0.0;
        this.vectorParameters.arrowOutX = length;
        this.vectorParameters.lineInX = 0.0;
        this.vectorParameters.lineOutX = length;
        this.vectorParameters.arrowXsize = arrowXsize;
        this.vectorParameters.arrowYsize = arrowYsize;
        this.vectorParameters.direction = direction;
        if (direction != 3) {
            if (this.drawIn()) {
                this.vectorParameters.lineInX = arrowXsize;
                if (this.isArrowDrawnWithLines(shape, direction)) {
                    this.vectorParameters.arrowInX += miterLength;
                    this.vectorParameters.lineInX += miterLength;
                }
            }
            if (this.drawOut()) {
                this.vectorParameters.lineOutX = length - arrowXsize;
                if (this.isArrowDrawnWithLines(shape, direction)) {
                    this.vectorParameters.arrowOutX -= miterLength;
                    this.vectorParameters.lineOutX -= miterLength;
                }
            }
            this.vectorParameters.lineInAdjustment = 0.0;
            this.vectorParameters.lineOutAdjustment = 0.0;
            double adjustment = 0.0;
            switch (shape) {
                case 0: {
                    adjustment = arrowXsize - this.computeMiterLength(lw);
                    break;
                }
                case 1: {
                    adjustment = 0.0;
                    break;
                }
                case 2: {
                    adjustment = lw * 0.5;
                    break;
                }
                case 3: {
                    adjustment = arrowXsize * 0.5;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown shape.");
                }
            }
            if (this.drawIn()) {
                this.vectorParameters.lineInAdjustment = adjustment;
            }
            if (this.drawOut()) {
                this.vectorParameters.lineOutAdjustment = adjustment;
            }
        }
    }

    private void setupVectorParameters(double length, int direction, double lw, int shape) {
        double arrowYsize = 4.0 * this.yPixel * lw;
        double arrowXsize = 8.0 * this.xPixel * lw;
        double miterLength = this.computeMiterLength(lw);
        this.vectorParameters.arrowInX = 0.0;
        this.vectorParameters.arrowOutX = length;
        this.vectorParameters.lineInX = 0.0;
        this.vectorParameters.lineOutX = length;
        this.vectorParameters.arrowXsize = arrowXsize;
        this.vectorParameters.arrowYsize = arrowYsize;
        this.vectorParameters.direction = direction;
        if (direction != 3) {
            if (this.drawIn()) {
                this.vectorParameters.lineInX = arrowXsize;
                if (this.isArrowDrawnWithLines(shape, direction)) {
                    this.vectorParameters.arrowInX += miterLength;
                    this.vectorParameters.lineInX += miterLength;
                }
            }
            if (this.drawOut()) {
                this.vectorParameters.lineOutX = length - arrowXsize;
                if (this.isArrowDrawnWithLines(shape, direction)) {
                    this.vectorParameters.arrowOutX -= miterLength;
                    this.vectorParameters.lineOutX -= miterLength;
                }
            }
            if (!this.isArrowDrawnWithLines(shape, direction) && lw > 1.0) {
                this.vectorParameters.arrowYsize += lw / 2.0;
            }
        }
    }

    private boolean isArrowDrawnWithLines(int shape, int direction) {
        return shape == 0 || shape == 1;
    }

    private boolean drawIn() {
        return this.vectorParameters.direction == 0 || this.vectorParameters.direction == 2;
    }

    private boolean drawOut() {
        return this.vectorParameters.direction == 1 || this.vectorParameters.direction == 2;
    }

    private void drawArrowOpen(Channel channel) {
        VectorParameters a = this.vectorParameters;
        if (this.drawOut()) {
            channel.glBegin(1);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, 0.0);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(1);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glEnd();
            channel.glBegin(1);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, 0.0);
            channel.glEnd();
        }
    }

    private void drawArrowClosed(Channel channel) {
        VectorParameters a = this.vectorParameters;
        if (this.drawOut()) {
            channel.glBegin(1);
            channel.glVertex(a.lineOutX, 0.0);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(1);
            channel.glVertex(a.lineInX, 0.0);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glEnd();
        }
    }

    private void drawArrowFilled(Channel channel) {
        VectorParameters a = this.vectorParameters;
        channel.glPolygonMode(3);
        if (this.drawOut()) {
            channel.glBegin(2);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(2);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glEnd();
        }
    }

    private void drawArrowBarbed(Channel channel) {
        VectorParameters a = this.vectorParameters;
        double barbXlength = 1.5 * a.arrowXsize;
        double barbYlength = 1.5 * a.arrowYsize;
        if (this.drawOut()) {
            channel.glBegin(2);
            channel.glVertex(a.lineOutX, 0.0);
            channel.glVertex(a.arrowOutX - barbXlength, -barbYlength);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glEnd();
            channel.glBegin(2);
            channel.glVertex(a.lineOutX, 0.0);
            channel.glVertex(a.arrowOutX - barbXlength, barbYlength);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glEnd();
            channel.glBegin(2);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(2);
            channel.glVertex(a.lineInX, 0.0);
            channel.glVertex(a.arrowInX + barbXlength, -barbYlength);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glEnd();
            channel.glEnd();
            channel.glBegin(2);
            channel.glVertex(a.lineInX, 0.0);
            channel.glVertex(a.arrowInX + barbXlength, barbYlength);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glEnd();
            channel.glBegin(2);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glEnd();
        }
    }

    private void drawScaledArrowOpen(Channel channel) {
        VectorParameters a = this.vectorParameters;
        if (this.drawOut()) {
            channel.glBegin(1);
            channel.glVertex(a.lineOutX, -a.arrowYsize);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.lineOutX, a.arrowYsize);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(1);
            channel.glVertex(a.lineInX, -a.arrowYsize);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.lineInX, a.arrowYsize);
            channel.glEnd();
        }
    }

    private void drawScaledArrowBarbed(Channel channel) {
        VectorParameters a = this.vectorParameters;
        channel.glPolygonMode(3);
        if (this.drawOut()) {
            channel.glBegin(2);
            channel.glVertex(a.arrowOutX, 0.0);
            channel.glVertex(a.arrowOutX - a.arrowXsize, 0.0 - a.arrowYsize);
            channel.glVertex(a.arrowOutX - a.arrowXsize * 0.66, 0.0);
            channel.glVertex(a.arrowOutX - a.arrowXsize, 0.0 + a.arrowYsize);
            channel.glEnd();
        }
        if (this.drawIn()) {
            channel.glBegin(2);
            channel.glVertex(a.arrowInX, 0.0);
            channel.glVertex(a.arrowInX + a.arrowXsize, 0.0 - a.arrowYsize);
            channel.glVertex(a.arrowInX + a.arrowXsize * 0.66, 0.0);
            channel.glVertex(a.arrowInX + a.arrowXsize, 0.0 + a.arrowYsize);
            channel.glEnd();
        }
    }

    public void setStipple(int pattern, int factor) {
        this.stipplePattern = pattern;
        this.stippleFactor = factor;
    }

    public int getStipplePattern() {
        return this.stipplePattern;
    }

    public int getStippleFactor() {
        return this.stippleFactor;
    }

    public void setStippleScaleFactor(double fac) {
        this.stippleScaleFactor = fac;
    }

    public double getStippleScaleFactor() {
        return this.stippleScaleFactor;
    }

    public void setScaleArrow(boolean b) {
        this.scaleArrow = b;
    }

    public boolean isScaleArrow() {
        return this.scaleArrow;
    }

    public void setSkinType(int t) {
        this.skinType = t;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public static double getArrowYSize(double lw, double DPIScaleFactor, int shape) {
        double arrowYsize;
        if (lw >= 1.0) {
            double arrowSide = VectorSegment.getArrowSize(lw, DPIScaleFactor, shape);
            arrowYsize = Math.floor((arrowSide + 1.0) * 0.5);
            double arrowXsize = arrowSide * Math.sin(1.0471975511965976);
        } else if (shape == 3) {
            arrowYsize = 6.0;
            double arrowXsize = 12.0;
        } else if (shape == 2) {
            arrowYsize = 4.5;
            double arrowXsize = 9.0;
        } else {
            arrowYsize = 4.0;
            double arrowXsize = 8.0;
        }
        return arrowYsize;
    }

    static {
        X_AXIS = Vec3d.getXAxis();
        Vec3d arrowSide = new Vec3d(8.0, 4.0, 0.0);
        double a = arrowSide.angle(X_AXIS);
        arrowAngleSin = Math.abs(Math.sin(a));
    }

    private class VectorParameters {
        double arrowInX;
        double arrowOutX;
        double lineInX;
        double lineOutX;
        double arrowXsize;
        double arrowYsize;
        int direction;
        double lineInAdjustment = 0.0;
        double lineOutAdjustment = 0.0;

        private VectorParameters() {
        }
    }
}

