/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ATukeyBox;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.util.ArrayList;

public class TukeyBox
extends ATukeyBox {
    int nIndices;
    int nValues;

    public TukeyBox() {
        super(new Transform());
    }

    private int getFirst(int index) {
        int i;
        try {
            if (this.outlierCount.getValue(index) >= 0) {
                int idx = 0;
                for (int i2 = 0; i2 < index; ++i2) {
                    idx += 7 + this.outlierCount.getValue(i2);
                }
                return idx;
            }
        }
        catch (MissingValueException idx) {
            // empty catch block
        }
        int j = -1;
        double value0 = Double.NaN;
        double value1 = Double.NaN;
        for (i = 0; i < this.nValues && j < index; ++i) {
            try {
                value1 = this.x.getValue(i);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            if (value0 != value1) {
                ++j;
            }
            value0 = value1;
        }
        return i - 1;
    }

    @Override
    public void init(AInitAction ia) {
        super.init(ia);
        this.nIndices = ia.getValueCount();
        ia.pushValueCount();
        this.x.init(ia);
        this.y.init(ia);
        this.nValues = ia.getValueCount();
        ia.popValueCount();
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction action = BuildAction.castBuildAction(buildAction);
        Channel channel = action.getChannel();
        int index = action.getValueIndex();
        if (channel.isSVGSelectionMode()) {
            channel.setSVGSelectionText(this.userDataToString(index));
        }
        if (this.orientation.getValue(index) == 0) {
            this.renderVerticalBox(channel, index);
        } else {
            this.renderHorizontalBox(channel, index);
        }
        if (channel.isSVGSelectionMode()) {
            channel.clearSVGSelectionText();
        }
    }

    private void renderVerticalBox(Channel channel, int index) throws MissingValueException {
        int cap;
        double adj;
        int v;
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = this.boxWidth.getValue(index);
        double halfX = (maxX - minX) / 2.0;
        boolean graphMin = this.graphed.getValue(i);
        double minY = graphMin ? this.y.getValue(i) : 0.0;
        boolean graphQ1 = this.graphed.getValue(++i);
        double q1 = graphQ1 ? this.y.getValue(i) : 0.0;
        boolean graphMedian = this.graphed.getValue(++i);
        double median = graphMedian || this.notched.getValue(index) ? this.y.getValue(i) : 0.0;
        boolean graphQ3 = this.graphed.getValue(++i);
        double q3 = graphQ3 ? this.y.getValue(i) : 0.0;
        boolean graphMax = this.graphed.getValue(++i);
        double maxY = graphMax ? this.y.getValue(i) : 0.0;
        boolean graphMean = this.graphed.getValue(++i);
        double mean = graphMean ? this.y.getValue(i) : 0.0;
        double n = this.rawY.getValue(++i);
        ++i;
        minX = -halfX;
        maxX = halfX;
        halfX = 0.0;
        boolean ex = this.extreme.getValue(index);
        if (ex) {
            int end = this.nValues;
            if (index + 1 < this.nIndices) {
                end = this.getFirst(index + 1);
            }
            for (int j = i; j < end; ++j) {
                double v2 = this.y.getValue(j);
                if (v2 > maxY) {
                    maxY = v2;
                }
                if (!(v2 < minY)) continue;
                minY = v2;
            }
        }
        boolean notch = this.notched.getValue(index) && n > 0.0;
        double endY = 1.58 * (q3 - q1) / Math.sqrt(n);
        double endX = notch ? 0.25 * (maxX - minX) : 0.0;
        boolean drawOutline = !this.fillOn.getValue(index) || this.getSkinType() == 0;
        boolean drawFillPattern = this.fillPatternOn.getValue(index);
        boolean drawFill = this.fillOn.getValue(index);
        ArrayList<Double> vertexX = new ArrayList<Double>();
        ArrayList<Double> vertexY = new ArrayList<Double>();
        vertexX.add(minX);
        vertexY.add(q1);
        if (notch) {
            vertexX.add(minX);
            vertexY.add(median - endY);
            vertexX.add(minX + endX);
            vertexY.add(median);
            vertexX.add(minX);
            vertexY.add(median + endY);
        }
        vertexX.add(minX);
        vertexY.add(q3);
        vertexX.add(maxX);
        vertexY.add(q3);
        if (notch) {
            vertexX.add(maxX);
            vertexY.add(median + endY);
            vertexX.add(maxX - endX);
            vertexY.add(median);
            vertexX.add(maxX);
            vertexY.add(median - endY);
        }
        vertexX.add(maxX);
        vertexY.add(q1);
        int nPoints = vertexX.size();
        if (drawFill) {
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glPixelBenderImages(this.getPixelBenderImages(1));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            channel.glSkinCategory(1);
            channel.glColor(this.fillColor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glPolygonMode(3);
            if (this.getSkinType() != 0 && drawFillPattern) {
                channel.glSkinRenderMode(3);
                channel.glSkinImage(null);
            }
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
            if (this.getSkinType() != 0 && drawFillPattern) {
                channel.glSkinType(0);
                channel.glPixelBenderImages(null);
            } else {
                channel.glSkinType(0);
                channel.glSkinImage(null);
                channel.glPixelBenderImages(null);
                channel.glSkinCategory(0);
            }
        }
        if (drawFillPattern) {
            channel.glPolygonMode(8);
            channel.glFillPatternColor(this.fillPatternColor.getValue(index));
            channel.glFillPatternType(this.fillPatternType.getValue(index));
            channel.glFillPatternWidth(this.fillPatternWidth.getValue(index));
            channel.glFillPatternScaleFactor(this.fillPatternScaleFactor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
        }
        if (drawFill && this.getSkinType() != 0 && drawFillPattern) {
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glSkinRenderMode(12);
            channel.glPolygonMode(3);
            channel.glColor(this.fillColor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
            channel.glSkinType(0);
            channel.glSkinImage(null);
            channel.glPixelBenderImages(null);
            channel.glSkinCategory(0);
        }
        int o_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.outlineStippleFactor.getValue(index));
        int o_stipplePattern = this.outlineStipplePattern.getValue(index);
        if (drawOutline) {
            channel.glColor(this.outlineColor.getValue(index));
            channel.glLineWidth((float)this.outlineWidth.getValue(index));
            if (o_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(o_stippleFactor, (int)((short)o_stipplePattern));
            }
            channel.glBegin(2);
            channel.glPolygonMode(2);
            for (int v3 = 0; v3 < nPoints; ++v3) {
                channel.glVertex(((Double)vertexX.get(v3)).doubleValue(), ((Double)vertexY.get(v3)).doubleValue());
            }
            channel.glVertex(((Double)vertexX.get(0)).doubleValue(), ((Double)vertexY.get(0)).doubleValue());
            channel.glEnd();
        }
        double d = adj = this.getSkinType() == 0 ? 0.0 : 1.0;
        if (graphMedian) {
            channel.glColor(this.medianColor.getValue(index));
            if (this.medianShape.getValue(index) >= 0) {
                channel.glEdgeColor(this.medianColor.getValue(index));
                channel.setMarkerSize((int)this.medianWidth.getValue(index));
                channel.setMarkerType(this.medianShape.getValue(index));
                if (this.weightedMarkerEnabled.getValue(index)) {
                    channel.glEnable(28);
                } else {
                    channel.glDisable(28);
                }
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glBegin(4);
                channel.glVertex(halfX, median);
                channel.glEnd();
            } else {
                channel.glLineWidth((float)this.medianWidth.getValue(index));
                int m_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.medianStippleFactor.getValue(index));
                int m_stipplePattern = this.medianStipplePattern.getValue(index);
                if (m_stippleFactor > 0) {
                    channel.glEnable(6);
                    channel.glLineStipple(m_stippleFactor, (int)((short)m_stipplePattern));
                }
                channel.glBegin(1);
                if (notch) {
                    channel.glVertex(minX + endX, median);
                    channel.glVertex(maxX - endX - adj, median);
                } else {
                    channel.glVertex(minX, median);
                    channel.glVertex(maxX - adj, median);
                }
                channel.glEnd();
                if (m_stippleFactor > 0) {
                    channel.glDisable(6);
                }
            }
        }
        if (channel.isSVGSelectionMode()) {
            channel.setSVGSelectionText(this.userDataToString(index), false);
        }
        if (graphMean) {
            channel.glSkinType(this.getSkinType());
            channel.glPixelBenderImages(this.getPixelBenderImages(4));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            channel.glColor(this.meanColor.getValue(index));
            if (this.meanShape.getValue(index) >= 0) {
                channel.glEdgeColor(this.meanColor.getValue(index));
                channel.setMarkerSize((int)this.meanWidth.getValue(index));
                channel.setMarkerType(this.meanShape.getValue(index));
                if (this.weightedMarkerEnabled.getValue(index)) {
                    channel.glEnable(28);
                } else {
                    channel.glDisable(28);
                }
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glLineWidth((float)((int)this.meanEdgeWidth.getValue(index)));
                if (this.skinType == 0) {
                    channel.glBegin(4);
                    channel.glVertex(halfX, mean);
                    channel.glEnd();
                } else {
                    channel.glMarker(halfX, mean, 0.0);
                }
                channel.glLineWidth(1.0f);
            } else {
                channel.glLineWidth((float)this.meanWidth.getValue(index));
                channel.glBegin(1);
                if (notch) {
                    double deltaX = 0.0;
                    double dist = Math.abs(median - mean);
                    deltaX = dist >= endY ? 0.0 : (endY - dist) * endX / endY;
                    channel.glVertex(minX + deltaX, mean);
                    channel.glVertex(maxX - deltaX, mean);
                } else {
                    channel.glVertex(minX, mean);
                    channel.glVertex(maxX, mean);
                }
                channel.glEnd();
            }
            channel.glSkinType(0);
            channel.glPixelBenderImages(null);
        }
        if (o_stippleFactor > 0) {
            channel.glDisable(6);
        }
        if (graphMin || graphMax) {
            int w_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.whiskerStippleFactor.getValue(index));
            int w_stipplePattern = this.whiskerStipplePattern.getValue(index);
            channel.glColor(this.whiskerColor.getValue(index));
            channel.glLineWidth((float)this.whiskerWidth.getValue(index));
            if (w_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(w_stippleFactor, (int)((short)w_stipplePattern));
            }
            if (graphMin) {
                channel.glBegin(1);
                channel.glVertex(halfX, q1 + adj);
                channel.glVertex(halfX, minY);
                channel.glEnd();
            }
            if (graphMax) {
                channel.glBegin(1);
                channel.glVertex(halfX, q3);
                channel.glVertex(halfX, maxY);
                channel.glEnd();
            }
            if (w_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if ((cap = this.capShape.getValue(index)) == 1 || cap == 2 || cap == 3 && (graphMin || graphMax)) {
            double halfCapLength = cap == 1 ? (maxX - minX) / 4.0 : (maxX - minX) / 2.0;
            double delta = (maxX - minX) / 2.0 - (halfCapLength *= this.capScale);
            int c_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.capStippleFactor.getValue(index));
            int c_stipplePattern = this.capStipplePattern.getValue(index);
            channel.glColor(this.capColor.getValue(index));
            channel.glLineWidth((float)this.capWidth.getValue(index));
            if (c_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(c_stippleFactor, (int)((short)c_stipplePattern));
            }
            if (cap == 1 || cap == 2) {
                if (graphMin) {
                    channel.glBegin(1);
                    channel.glVertex(minX + delta, minY);
                    channel.glVertex(maxX - delta, minY);
                    channel.glEnd();
                }
                if (graphMax) {
                    channel.glBegin(1);
                    channel.glVertex(minX + delta, maxY);
                    channel.glVertex(maxX - delta, maxY);
                    channel.glEnd();
                }
            } else if (cap == 3) {
                double quarterY = Math.min(q1 - minY, maxY - q3) / 4.0;
                quarterY *= this.capScale;
                if (graphMin) {
                    channel.glBegin(1);
                    channel.glVertex(minX + delta, minY + quarterY);
                    channel.glVertex(minX + delta, minY);
                    channel.glVertex(maxX - delta, minY);
                    channel.glVertex(maxX - delta, minY + quarterY);
                    channel.glEnd();
                }
                if (graphMax) {
                    channel.glBegin(1);
                    channel.glVertex(minX + delta, maxY - quarterY);
                    channel.glVertex(minX + delta, maxY);
                    channel.glVertex(maxX - delta, maxY);
                    channel.glVertex(maxX - delta, maxY - quarterY);
                    channel.glEnd();
                }
            }
            if (c_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if (this.markerOn.getValue(index) && !ex) {
            channel.glColor(this.markerColor.getValue(index));
            channel.glEdgeColor(this.markerColor.getValue(index));
            channel.setMarkerSize((int)this.markerWidth.getValue(index));
            channel.setMarkerType(this.markerShape.getValue(index));
            if (this.weightedMarkerEnabled.getValue(index)) {
                channel.glEnable(28);
            } else {
                channel.glDisable(28);
            }
            channel.setMarkerWeight(this.markerWeight.getValue(index));
            channel.glBegin(4);
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                channel.glVertex(halfX, this.y.getValue(i));
                ++i;
            }
            channel.glEnd();
        }
    }

    private void renderHorizontalBox(Channel channel, int index) throws MissingValueException {
        int cap;
        double adj;
        int v;
        int i = this.getFirst(index);
        double minY = 0.0;
        double maxY = this.boxWidth.getValue(index);
        double halfY = (maxY - minY) / 2.0;
        boolean graphMin = this.graphed.getValue(i);
        double minX = graphMin ? this.y.getValue(i) : 0.0;
        boolean graphQ1 = this.graphed.getValue(++i);
        double q1 = graphQ1 ? this.y.getValue(i) : 0.0;
        boolean graphMedian = this.graphed.getValue(++i);
        double median = graphMedian || this.notched.getValue(index) ? this.y.getValue(i) : 0.0;
        boolean graphQ3 = this.graphed.getValue(++i);
        double q3 = graphQ3 ? this.y.getValue(i) : 0.0;
        boolean graphMax = this.graphed.getValue(++i);
        double maxX = graphMax ? this.y.getValue(i) : 0.0;
        boolean graphMean = this.graphed.getValue(++i);
        double mean = graphMean ? this.y.getValue(i) : 0.0;
        double n = this.rawY.getValue(++i);
        ++i;
        minY = -halfY;
        maxY = halfY;
        halfY = 0.0;
        boolean ex = this.extreme.getValue(index);
        if (ex) {
            int end = this.nValues;
            if (index + 1 < this.nIndices) {
                end = this.getFirst(index + 1);
            }
            for (int j = i; j < end; ++j) {
                double v2 = this.y.getValue(j);
                if (v2 > maxX) {
                    maxX = v2;
                }
                if (!(v2 < minX)) continue;
                minX = v2;
            }
        }
        boolean notch = this.notched.getValue(index) && n > 0.0;
        double endX = 1.58 * (q3 - q1) / Math.sqrt(n);
        double endY = notch ? 0.25 * (maxY - minY) : 0.0;
        boolean drawOutline = !this.fillOn.getValue(index) || this.getSkinType() == 0;
        boolean drawFillPattern = this.fillPatternOn.getValue(index);
        boolean drawFill = this.fillOn.getValue(index);
        ArrayList<Double> vertexX = new ArrayList<Double>();
        ArrayList<Double> vertexY = new ArrayList<Double>();
        vertexX.add(q1);
        vertexY.add(minY);
        if (notch) {
            vertexX.add(median - endX);
            vertexY.add(minY);
            vertexX.add(median);
            vertexY.add(minY + endY);
            vertexX.add(median + endX);
            vertexY.add(minY);
        }
        vertexX.add(q3);
        vertexY.add(minY);
        vertexX.add(q3);
        vertexY.add(maxY);
        if (notch) {
            vertexX.add(median + endX);
            vertexY.add(maxY);
            vertexX.add(median);
            vertexY.add(maxY - endY);
            vertexX.add(median - endX);
            vertexY.add(maxY);
        }
        vertexX.add(q1);
        vertexY.add(maxY);
        int nPoints = vertexX.size();
        if (drawFill) {
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glPixelBenderImages(this.getPixelBenderImages(2));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            channel.glSkinCategory(2);
            channel.glColor(this.fillColor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            channel.glPolygonMode(3);
            if (this.getSkinType() != 0 && drawFillPattern) {
                channel.glSkinRenderMode(3);
                channel.glSkinImage(null);
            }
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
            if (this.getSkinType() != 0 && drawFillPattern) {
                channel.glSkinType(0);
                channel.glPixelBenderImages(null);
            } else {
                channel.glSkinType(0);
                channel.glSkinImage(null);
                channel.glPixelBenderImages(null);
                channel.glSkinCategory(0);
            }
        }
        if (drawFillPattern) {
            channel.glPolygonMode(8);
            channel.glFillPatternColor(this.fillPatternColor.getValue(index));
            channel.glFillPatternType(this.fillPatternType.getValue(index));
            channel.glFillPatternWidth(this.fillPatternWidth.getValue(index));
            channel.glFillPatternScaleFactor(this.fillPatternScaleFactor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
        }
        if (drawFill && this.getSkinType() != 0 && drawFillPattern) {
            channel.glSkinType(this.getSkinType());
            channel.glSkinImage(this.getSkin());
            channel.glSkinRenderMode(12);
            channel.glPolygonMode(3);
            channel.glColor(this.fillColor.getValue(index));
            channel.glBegin(2);
            channel.glNormal(0.0, 0.0, 1.0);
            for (v = 0; v < nPoints; ++v) {
                channel.glVertex(((Double)vertexX.get(v)).doubleValue(), ((Double)vertexY.get(v)).doubleValue());
            }
            channel.glEnd();
            channel.glSkinType(0);
            channel.glSkinImage(null);
            channel.glPixelBenderImages(null);
            channel.glSkinCategory(0);
        }
        int o_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.outlineStippleFactor.getValue(index));
        int o_stipplePattern = this.outlineStipplePattern.getValue(index);
        if (drawOutline) {
            channel.glColor(this.outlineColor.getValue(index));
            channel.glLineWidth((float)this.outlineWidth.getValue(index));
            if (o_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(o_stippleFactor, (int)((short)o_stipplePattern));
            }
            channel.glBegin(2);
            channel.glPolygonMode(2);
            for (int v3 = 0; v3 < nPoints; ++v3) {
                channel.glVertex(((Double)vertexX.get(v3)).doubleValue(), ((Double)vertexY.get(v3)).doubleValue());
            }
            channel.glVertex(((Double)vertexX.get(0)).doubleValue(), ((Double)vertexY.get(0)).doubleValue());
            channel.glEnd();
        }
        double d = adj = this.getSkinType() == 0 ? 0.0 : 1.0;
        if (graphMedian) {
            channel.glColor(this.medianColor.getValue(index));
            if (this.medianShape.getValue(index) >= 0) {
                channel.glEdgeColor(this.medianColor.getValue(index));
                channel.setMarkerSize((int)this.medianWidth.getValue(index));
                channel.setMarkerType(this.medianShape.getValue(index));
                if (this.weightedMarkerEnabled.getValue(index)) {
                    channel.glEnable(28);
                } else {
                    channel.glDisable(28);
                }
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glBegin(4);
                channel.glVertex(median, halfY);
                channel.glEnd();
            } else {
                channel.glLineWidth((float)this.medianWidth.getValue(index));
                int m_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.medianStippleFactor.getValue(index));
                int m_stipplePattern = this.medianStipplePattern.getValue(index);
                if (m_stippleFactor > 0) {
                    channel.glEnable(6);
                    channel.glLineStipple(m_stippleFactor, (int)((short)m_stipplePattern));
                }
                channel.glBegin(1);
                if (notch) {
                    channel.glVertex(median, minY + endY + adj);
                    channel.glVertex(median, maxY - endY);
                } else {
                    channel.glVertex(median, minY + adj);
                    channel.glVertex(median, maxY);
                }
                channel.glEnd();
                if (m_stippleFactor > 0) {
                    channel.glDisable(6);
                }
            }
        }
        if (channel.isSVGSelectionMode()) {
            channel.setSVGSelectionText(this.userDataToString(index), false);
        }
        if (graphMean) {
            channel.glSkinType(this.getSkinType());
            channel.glPixelBenderImages(this.getPixelBenderImages(4));
            channel.glDPIScaleFactor(this.getDPIScaleFactor());
            channel.glColor(this.meanColor.getValue(index));
            if (this.meanShape.getValue(index) >= 0) {
                channel.glEdgeColor(this.meanColor.getValue(index));
                channel.setMarkerSize((int)this.meanWidth.getValue(index));
                channel.setMarkerType(this.meanShape.getValue(index));
                if (this.weightedMarkerEnabled.getValue(index)) {
                    channel.glEnable(28);
                } else {
                    channel.glDisable(28);
                }
                channel.setMarkerWeight(this.markerWeight.getValue(index));
                channel.glLineWidth((float)((int)this.meanEdgeWidth.getValue(index)));
                if (this.getSkinType() == 0) {
                    channel.glBegin(4);
                    channel.glVertex(mean, halfY);
                    channel.glEnd();
                } else {
                    channel.glMarker(mean, halfY, 0.0);
                }
                channel.glLineWidth(1.0f);
            } else {
                channel.glLineWidth((float)this.meanWidth.getValue(index));
                channel.glBegin(1);
                if (notch) {
                    double deltaY = 0.0;
                    double dist = Math.abs(median - mean);
                    deltaY = dist >= endX ? 0.0 : (endX - dist) * endY / endX;
                    channel.glVertex(mean, minY + deltaY);
                    channel.glVertex(mean, maxY - deltaY);
                } else {
                    channel.glVertex(mean, minY);
                    channel.glVertex(mean, maxY);
                }
                channel.glEnd();
            }
            channel.glSkinType(0);
            channel.glPixelBenderImages(null);
        }
        if (o_stippleFactor > 0) {
            channel.glDisable(6);
        }
        if (graphMin || graphMax) {
            int w_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.whiskerStippleFactor.getValue(index));
            int w_stipplePattern = this.whiskerStipplePattern.getValue(index);
            channel.glColor(this.whiskerColor.getValue(index));
            channel.glLineWidth((float)this.whiskerWidth.getValue(index));
            if (w_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(w_stippleFactor, (int)((short)w_stipplePattern));
            }
            if (graphMin) {
                channel.glBegin(1);
                channel.glVertex(q1, halfY);
                channel.glVertex(minX, halfY);
                channel.glEnd();
            }
            if (graphMax) {
                channel.glBegin(1);
                channel.glVertex(q3 - adj, halfY);
                channel.glVertex(maxX, halfY);
                channel.glEnd();
            }
            if (w_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if ((cap = this.capShape.getValue(index)) == 1 || cap == 2 || cap == 3 && (graphMin || graphMax)) {
            double halfCapLength = cap == 1 ? (maxY - minY) / 4.0 : (maxY - minY) / 2.0;
            double delta = (maxY - minY) / 2.0 - (halfCapLength *= this.capScale);
            int c_stippleFactor = (int)(0.5 + this.stippleScaleFactor * (double)this.capStippleFactor.getValue(index));
            int c_stipplePattern = this.capStipplePattern.getValue(index);
            channel.glColor(this.capColor.getValue(index));
            channel.glLineWidth((float)this.capWidth.getValue(index));
            if (c_stippleFactor > 0) {
                channel.glEnable(6);
                channel.glLineStipple(c_stippleFactor, (int)((short)c_stipplePattern));
            }
            if (cap == 1 || cap == 2) {
                if (graphMin) {
                    channel.glBegin(1);
                    channel.glVertex(minX, minY + delta);
                    channel.glVertex(minX, maxY - delta);
                    channel.glEnd();
                }
                if (graphMax) {
                    channel.glBegin(1);
                    channel.glVertex(maxX, minY + delta);
                    channel.glVertex(maxX, maxY - delta);
                    channel.glEnd();
                }
            } else if (cap == 3) {
                double quarterX = Math.min(q1 - minX, maxX - q3) / 4.0;
                quarterX *= this.capScale;
                if (graphMin) {
                    channel.glBegin(1);
                    channel.glVertex(minX + quarterX, minY + delta);
                    channel.glVertex(minX, minY + delta);
                    channel.glVertex(minX, maxY - delta);
                    channel.glVertex(minX + quarterX, maxY - delta);
                    channel.glEnd();
                }
                if (graphMax) {
                    channel.glBegin(1);
                    channel.glVertex(maxX - quarterX, minY + delta);
                    channel.glVertex(maxX, minY + delta);
                    channel.glVertex(maxX, maxY - delta);
                    channel.glVertex(maxX - quarterX, maxY - delta);
                    channel.glEnd();
                }
            }
            if (c_stippleFactor > 0) {
                channel.glDisable(6);
            }
        }
        if (this.markerOn.getValue(index) && !ex) {
            channel.glColor(this.markerColor.getValue(index));
            channel.glEdgeColor(this.markerColor.getValue(index));
            channel.setMarkerSize((int)this.markerWidth.getValue(index));
            channel.setMarkerType(this.markerShape.getValue(index));
            if (this.weightedMarkerEnabled.getValue(index)) {
                channel.glEnable(28);
            } else {
                channel.glDisable(28);
            }
            channel.setMarkerWeight(this.markerWeight.getValue(index));
            channel.glBegin(4);
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                channel.glVertex(this.y.getValue(i), halfY);
                ++i;
            }
            channel.glEnd();
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) {
        Vec3d size;
        Vec3d center;
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        int index = bba.getValueIndex();
        BoundingBox box = bba.getElementBoundingBox();
        int i = this.getFirst(index);
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        try {
            maxX = this.boxWidth.getValue(index);
            minY = this.y.getValue(i);
            maxY = this.y.getValue(i += 4);
            i += 3;
            int j = this.nValues;
            if (index + 1 < this.nIndices) {
                j = this.getFirst(index + 1);
            }
            while (i < j) {
                double outY = this.y.getValue(i);
                if (minY > outY) {
                    minY = outY;
                }
                if (maxY < outY) {
                    maxY = outY;
                }
                ++i;
            }
        }
        catch (MissingValueException j) {
            // empty catch block
        }
        int orient = 0;
        try {
            orient = this.orientation.getValue(index);
        }
        catch (MissingValueException outY) {
            // empty catch block
        }
        if (orient == 0) {
            center = new Vec3d((maxX - minX) / 2.0, (maxY - minY) / 2.0, 0.0);
            size = new Vec3d(maxX - minX, maxY - minY, 0.0);
        } else {
            center = new Vec3d((maxY - minY) / 2.0, (maxX - minX) / 2.0, 0.0);
            size = new Vec3d(maxY - minY, maxX - minX, 0.0);
        }
        box.union(center, size);
    }
}

