/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.Action;
import com.sas.graphics.util.gtk.MissingValueException;

public class Transform
extends ATransform {
    @Override
    public void push(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glPushMatrix();
    }

    @Override
    public void pop(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glPopMatrix();
    }

    @Override
    public void loadIdentity(Action action) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glLoadIdentity();
    }

    @Override
    public void getMatrix(Action action, double[] matrix) {
        Channel channel = (Channel)action.getGraphicsContext();
        channel.glGetMatrix(matrix);
    }

    @Override
    public void apply(Action action) throws MissingValueException {
        boolean isScaleOrientation;
        double tz;
        double ty;
        Channel channel = (Channel)action.getGraphicsContext();
        int i = action.getValueIndex();
        double tx = this.translateX.getValue(i);
        boolean isTranslation = !Transform.isZero(tx, ty = this.translateY.getValue(i), tz = this.translateZ.getValue(i));
        double cx = this.centerX.getValue(i);
        double cy = this.centerY.getValue(i);
        double cz = this.centerZ.getValue(i);
        boolean isCenter = !Transform.isZero(cx, cy, cz);
        double ax = this.rotationAxisX.getValue(i);
        double ay = this.rotationAxisY.getValue(i);
        double az = this.rotationAxisZ.getValue(i);
        double angle = this.rotationAngle.getValue(i);
        boolean isRotation = !Transform.isZero(angle);
        double sx = this.scaleX.getValue(i);
        double sy = this.scaleY.getValue(i);
        double sz = this.scaleZ.getValue(i);
        boolean isScale = !Transform.isZero(sx - 1.0, sy - 1.0, sz - 1.0);
        double sox = this.scaleOrientationAxisX.getValue(i);
        double soy = this.scaleOrientationAxisY.getValue(i);
        double soz = this.scaleOrientationAxisZ.getValue(i);
        double sOAngle = this.scaleOrientationAngle.getValue(i);
        boolean bl = isScaleOrientation = !Transform.isZero(sOAngle);
        if (isTranslation) {
            channel.glTranslate(tx, ty, tz);
        }
        if (isCenter) {
            channel.glTranslate(cx, cy, cz);
        }
        if (isRotation) {
            channel.glRotate(angle * 57.29577951308232, ax, ay, az);
        }
        if (isScaleOrientation) {
            channel.glRotate(sOAngle * 57.29577951308232, sox, soy, soz);
        }
        if (isScale) {
            channel.glScale(sx, sy, sz);
        }
        if (isScaleOrientation) {
            channel.glRotate(-sOAngle * 57.29577951308232, sox, soy, soz);
        }
        if (isCenter) {
            channel.glTranslate(-cx, -cy, -cz);
        }
    }
}

