/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ALineConnector;
import com.sas.graphics.util.gtk.AResetAction;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.FilledLineConnector;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ResetAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.util.Vector;

public class StepConnector
extends ALineConnector {
    private Vec3d v1 = new Vec3d();
    private Vec3d v2 = new Vec3d();
    public static final byte LEFT = 0;
    public static final byte RIGHT = 1;
    public static final byte CENTER = 2;
    protected Color myColor = ColorProperty.getDefaultColor();
    protected Color myFillColor = ColorProperty.getDefaultColor();
    protected float myLineWidth;
    protected boolean myJoin = false;
    protected int myJustification = 0;

    public StepConnector() {
        super(new Transform());
    }

    public int getJustification() {
        return this.myJustification;
    }

    public void setJustification(int justify) {
        this.myJustification = justify;
    }

    public void setJoin(boolean join) {
        this.myJoin = join;
    }

    public boolean getJoin() {
        return this.myJoin;
    }

    @Override
    protected void drawSelectableGeometry(Channel channel, int valueIndex, boolean fill, double lineWidth, Vec3d point2) {
        Vector v = this.getCurrentPolyline();
        if (v != null) {
            Vec3d point1 = this.v2;
            int previousValueIndex = (Integer)v.elementAt(v.size() - 1);
            try {
                point1.x = this.pointX.getValue(previousValueIndex);
                point1.y = this.pointY.getValue(previousValueIndex);
                point1.z = this.pointZ.getValue(previousValueIndex);
                channel.glLineWidth((float)lineWidth);
                switch (this.myJustification) {
                    case 0: {
                        this.replaceObservation(channel, previousValueIndex);
                        channel.glBegin(1);
                        channel.glVertex(point1.x, point1.y, point1.z);
                        channel.glVertex(point2.x, point1.y, point1.z);
                        channel.glEnd();
                        this.replaceObservation(channel, valueIndex);
                        break;
                    }
                    case 1: {
                        channel.glBegin(1);
                        channel.glVertex(point1.x, point2.y, point1.z);
                        channel.glVertex(point2.x, point1.y, point1.z);
                        channel.glEnd();
                        break;
                    }
                    default: {
                        double midx = point1.x + (point2.x - point1.x) / 2.0;
                        double midy = point1.y + (point2.y - point1.y) / 2.0;
                        channel.glBegin(1);
                        channel.glVertex(midx, point2.y, point2.z);
                        channel.glVertex(point2.x, point2.y, point2.z);
                        channel.glEnd();
                        this.replaceObservation(channel, previousValueIndex);
                        channel.glBegin(1);
                        channel.glVertex(point1.x, point1.y, point1.z);
                        channel.glVertex(midx, point1.y, point1.z);
                        channel.glEnd();
                        this.replaceObservation(channel, valueIndex);
                        break;
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
    }

    @Override
    public void reset(AResetAction resetAction) {
        if (this.multipleGroup) {
            return;
        }
        super.reset(resetAction);
        ResetAction ra = (ResetAction)resetAction;
        Channel channel = ra.getChannel();
        int polyLineCount = this.renderIndices.size();
        if (polyLineCount <= 0) {
            return;
        }
        Color c = ColorProperty.getDefaultColor();
        Color fc = ColorProperty.getDefaultColor();
        float w = 1.0f;
        boolean isFill = false;
        int firstIndex = this.getFirstIndex();
        try {
            w = (float)this.lineWidth.getValue(firstIndex);
            c = this.color.getValue(firstIndex);
            fc = this.fillColor.getValue(firstIndex);
            isFill = this.fillOn.getValue(firstIndex);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        channel.glPushAttrib(0);
        channel.glLineWidth(w);
        channel.glColor(c);
        channel.lineCapStyle(0);
        channel.setLineJoinStyle(1);
        if (this.stippleFactor > 0) {
            channel.glEnable(6);
            channel.glLineStipple(this.stippleFactor, (int)((short)this.stipplePattern));
        }
        for (int i = 0; i < polyLineCount; ++i) {
            Vector v = (Vector)this.renderIndices.elementAt(i);
            if (v == null) continue;
            int intersectionCount = v.size();
            if (this.myJoin) {
                channel.glBegin(1);
            }
            block13: for (int j = 1; j < intersectionCount; ++j) {
                double middleY;
                try {
                    int index = (Integer)v.elementAt(j - 1);
                    this.v1.x = this.pointX.getValue(index);
                    this.v1.y = this.pointY.getValue(index);
                    this.v1.z = this.pointZ.getValue(index);
                    index = (Integer)v.elementAt(j);
                    this.v2.x = this.pointX.getValue(index);
                    this.v2.y = this.pointY.getValue(index);
                    this.v2.z = this.pointZ.getValue(index);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                if (this.myJoin) {
                    switch (this.myJustification) {
                        case 0: {
                            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                            channel.glVertex(this.v2.x, this.v1.y, this.v1.z);
                            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                            break;
                        }
                        case 1: {
                            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                            channel.glVertex(this.v1.x, this.v2.y, this.v1.z);
                            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                            break;
                        }
                        default: {
                            double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                            middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                            channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                            channel.glVertex(middleX, this.v1.y, this.v1.z);
                            channel.glVertex(middleX, this.v2.y, this.v1.z);
                            channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                            break;
                        }
                    }
                    continue;
                }
                switch (this.myJustification) {
                    case 0: {
                        channel.glBegin(1);
                        channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                        channel.glVertex(this.v2.x, this.v1.y, this.v1.z);
                        channel.glEnd();
                        continue block13;
                    }
                    case 1: {
                        channel.glBegin(1);
                        channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                        channel.glVertex(this.v1.x, this.v2.y, this.v1.z);
                        channel.glEnd();
                        continue block13;
                    }
                    default: {
                        double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                        middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                        channel.glBegin(1);
                        channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                        channel.glVertex(middleX, this.v1.y, this.v1.z);
                        channel.glEnd();
                        channel.glBegin(1);
                        channel.glVertex(middleX, this.v2.y, this.v1.z);
                        channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                        channel.glEnd();
                        continue block13;
                    }
                }
            }
            if (!this.myJoin) continue;
            channel.glEnd();
        }
        channel.glPopAttrib();
        this.resetRenderIndices();
    }

    @Override
    protected void renderPolylineGroup(ABuildAction buildAction, FilledLineConnector.PolylineGroup group, boolean fillOn) {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        int polyLineCount = group.getPolylineCount();
        if (polyLineCount <= 0) {
            return;
        }
        for (int i = 0; i < polyLineCount; ++i) {
            Vector line = group.getPolyline(i);
            if (line == null) continue;
            if (this.myJoin) {
                this.drawJoinedStep(channel, line, ba.isUseNameStack());
                continue;
            }
            this.drawStep(channel, line, ba.isUseNameStack());
        }
    }

    private void drawJoinedStep(Channel channel, Vector aLine, boolean useNameStack) {
        if (useNameStack) {
            this.drawStep(channel, aLine, useNameStack);
            return;
        }
        int intersectionCount = aLine.size();
        if ((this.startArrow || this.endArrow) && intersectionCount >= 2) {
            this.computeArrowHeadParameters(channel, aLine, intersectionCount);
        }
        channel.glBegin(1);
        block6: for (int j = 1; j < intersectionCount; ++j) {
            try {
                int index = (Integer)aLine.elementAt(j - 1);
                this.v1.x = this.pointX.getValue(index);
                this.v1.y = this.pointY.getValue(index);
                this.v1.z = this.pointZ.getValue(index);
                index = (Integer)aLine.elementAt(j);
                this.v2.x = this.pointX.getValue(index);
                this.v2.y = this.pointY.getValue(index);
                this.v2.z = this.pointZ.getValue(index);
                if (this.startArrow) {
                    if (j - 1 < this.index_s) {
                        this.adjustStartPoint(this.v1);
                    }
                    if (j < this.index_s) {
                        this.adjustStartPoint(this.v2);
                    }
                }
                if (this.endArrow) {
                    if (j - 1 > this.index_e) {
                        this.adjustEndPoint(this.v1);
                    }
                    if (j > this.index_e) {
                        this.adjustEndPoint(this.v2);
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            switch (this.myJustification) {
                case 0: {
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v1.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    continue block6;
                }
                case 1: {
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(this.v1.x, this.v2.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    continue block6;
                }
                default: {
                    double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                    double middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(middleX, this.v1.y, this.v1.z);
                    channel.glVertex(middleX, this.v2.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    continue block6;
                }
            }
        }
        channel.glEnd();
        if (this.startArrow && intersectionCount >= 2) {
            this.drawArrow(channel, this.arrowV1, this.arrowV2);
        }
        if (this.endArrow && intersectionCount >= 2) {
            this.drawArrow(channel, this.arrowV1end, this.arrowV2end);
        }
    }

    private void drawStep(Channel channel, Vector aLine, boolean useNameStack) {
        int index1 = 0;
        int index2 = 0;
        int intersectionCount = aLine.size();
        block6: for (int j = 1; j < intersectionCount; ++j) {
            try {
                index1 = (Integer)aLine.elementAt(j - 1);
                this.v1.x = this.pointX.getValue(index1);
                this.v1.y = this.pointY.getValue(index1);
                this.v1.z = this.pointZ.getValue(index1);
                index2 = (Integer)aLine.elementAt(j);
                this.v2.x = this.pointX.getValue(index2);
                this.v2.y = this.pointY.getValue(index2);
                this.v2.z = this.pointZ.getValue(index2);
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            switch (this.myJustification) {
                case 0: {
                    if (useNameStack) {
                        this.replaceObservation(channel, index1);
                        channel.glLoadName((Object)this.currentGroup);
                    }
                    channel.glBegin(1);
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(this.v2.x - 1.0, this.v1.y, this.v1.z);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(this.v2.x + 1.0, this.v2.y, this.v2.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    channel.glEnd();
                    continue block6;
                }
                case 1: {
                    if (useNameStack) {
                        this.replaceObservation(channel, index2);
                        channel.glLoadName((Object)this.currentGroup);
                    }
                    channel.glBegin(1);
                    channel.glVertex(this.v1.x - 1.0, this.v1.y, this.v1.z);
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glEnd();
                    channel.glBegin(1);
                    channel.glVertex(this.v1.x + 1.0, this.v2.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v1.z);
                    channel.glEnd();
                    continue block6;
                }
                default: {
                    double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                    double middleY = this.v1.y + (this.v2.y - this.v1.y) / 2.0;
                    if (useNameStack) {
                        this.replaceObservation(channel, index1);
                        channel.glLoadName((Object)this.currentGroup);
                    }
                    channel.glBegin(1);
                    channel.glVertex(this.v1.x, this.v1.y, this.v1.z);
                    channel.glVertex(middleX - 1.0, this.v1.y, this.v1.z);
                    channel.glEnd();
                    if (useNameStack) {
                        this.replaceObservation(channel, index2);
                        channel.glLoadName((Object)this.currentGroup);
                    }
                    channel.glBegin(1);
                    channel.glVertex(middleX, this.v2.y, this.v1.z);
                    channel.glVertex(this.v2.x, this.v2.y, this.v2.z);
                    channel.glEnd();
                    continue block6;
                }
            }
        }
    }

    private void computeArrowHeadParameters(Channel channel, Vector aLine, int intersectionCount) {
        double v_dist;
        double h_dist;
        int index;
        int j;
        this.arrowV1 = null;
        this.arrowV2 = null;
        this.index_s = 0;
        if (this.startArrow && intersectionCount >= 2) {
            for (j = 1; j < intersectionCount; ++j) {
                try {
                    index = (Integer)aLine.elementAt(j - 1);
                    this.v1.x = this.pointX.getValue(index);
                    this.v1.y = this.pointY.getValue(index);
                    this.v1.z = this.pointZ.getValue(index);
                    index = (Integer)aLine.elementAt(j);
                    this.v2.x = this.pointX.getValue(index);
                    this.v2.y = this.pointY.getValue(index);
                    this.v2.z = this.pointZ.getValue(index);
                    this.arrowV2 = new Vec3d(this.v1);
                    this.arrowV1 = new Vec3d(this.v2);
                    if (this.arrowV1.equals((Object)this.arrowV2)) {
                        this.arrowV1 = null;
                        continue;
                    }
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                switch (this.myJustification) {
                    case 0: {
                        this.arrowV1 = new Vec3d(this.v2.x, this.v1.y, this.v1.z);
                        if (!this.arrowV1.equals((Object)this.arrowV2)) break;
                        this.arrowV1 = new Vec3d(this.v2.x, this.v2.y, this.v2.z);
                        break;
                    }
                    case 1: {
                        this.arrowV1 = new Vec3d(this.v1.x, this.v2.y, this.v1.z);
                        if (!this.arrowV1.equals((Object)this.arrowV2)) break;
                        this.arrowV1 = new Vec3d(this.v2.x, this.v2.y, this.v2.z);
                        break;
                    }
                    default: {
                        double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                        this.arrowV1 = new Vec3d(middleX, this.v1.y, this.v1.z);
                        if (!this.arrowV1.equals((Object)this.arrowV2)) break;
                        this.arrowV1 = new Vec3d(this.v2.x, this.v2.y, this.v2.z);
                        break;
                    }
                }
                this.index_s = j;
                break;
            }
            this.adjX = 0.0;
            this.adjY = 0.0;
            if (this.arrowV1 != null && this.arrowV2 != null) {
                double sizeAdj = this.getArrowSizeAdjustment(channel, this.currentGroup.getLineWidth(), this.arrowShape, this.arrowScale);
                if (sizeAdj > 0.0) {
                    h_dist = Math.abs(this.arrowV2.x - this.arrowV1.x);
                    if (h_dist > (v_dist = Math.abs(this.arrowV2.y - this.arrowV1.y))) {
                        this.adjX = Math.min(sizeAdj, h_dist);
                    } else {
                        this.adjY = Math.min(sizeAdj, v_dist);
                    }
                }
            } else {
                this.startArrow = false;
            }
        }
        this.arrowV1end = null;
        this.arrowV2end = null;
        this.index_e = 0;
        if (this.endArrow && intersectionCount >= 2) {
            for (j = intersectionCount - 2; j >= 0; --j) {
                try {
                    index = (Integer)aLine.elementAt(j);
                    this.v1.x = this.pointX.getValue(index);
                    this.v1.y = this.pointY.getValue(index);
                    this.v1.z = this.pointZ.getValue(index);
                    index = (Integer)aLine.elementAt(j + 1);
                    this.v2.x = this.pointX.getValue(index);
                    this.v2.y = this.pointY.getValue(index);
                    this.v2.z = this.pointZ.getValue(index);
                    this.arrowV2end = new Vec3d(this.v2);
                    this.arrowV1end = new Vec3d(this.v1);
                    if (this.arrowV1end.equals((Object)this.arrowV2end)) {
                        this.arrowV1end = null;
                        continue;
                    }
                }
                catch (MissingValueException sizeAdj) {
                    // empty catch block
                }
                switch (this.myJustification) {
                    case 0: {
                        this.arrowV1end = new Vec3d(this.v2.x, this.v1.y, this.v1.z);
                        if (!this.arrowV1end.equals((Object)this.arrowV2end)) break;
                        this.arrowV1end = new Vec3d(this.v1.x, this.v1.y, this.v1.z);
                        break;
                    }
                    case 1: {
                        this.arrowV1end = new Vec3d(this.v1.x, this.v2.y, this.v1.z);
                        if (!this.arrowV1end.equals((Object)this.arrowV2end)) break;
                        this.arrowV1end = new Vec3d(this.v1.x, this.v1.y, this.v1.z);
                        break;
                    }
                    default: {
                        double middleX = this.v1.x + (this.v2.x - this.v1.x) / 2.0;
                        this.arrowV1end = new Vec3d(middleX, this.v2.y, this.v1.z);
                        if (!this.arrowV1end.equals((Object)this.arrowV2end)) break;
                        this.arrowV1end = new Vec3d(this.v1.x, this.v1.y, this.v1.z);
                        break;
                    }
                }
                this.index_e = j;
                break;
            }
            this.adjXend = 0.0;
            this.adjYend = 0.0;
            if (this.arrowV1end != null && this.arrowV2end != null) {
                double sizeAdj = this.getArrowSizeAdjustment(channel, this.currentGroup.getLineWidth(), this.arrowShape, this.arrowScale);
                if (sizeAdj > 0.0) {
                    h_dist = Math.abs(this.arrowV2end.x - this.arrowV1end.x);
                    if (h_dist > (v_dist = Math.abs(this.arrowV2end.y - this.arrowV1end.y))) {
                        this.adjXend = Math.min(sizeAdj, h_dist);
                    } else {
                        this.adjYend = Math.min(sizeAdj, v_dist);
                    }
                }
            } else {
                this.endArrow = false;
            }
        }
    }
}

