/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ASphere;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class Sphere
extends ASphere {
    public static void drawSphere(Channel channel, double radius, Color color, Color edgeColor, boolean edgeOn, boolean fillOn, int precision) {
        if (x == null || y == null || z == null || precision != lastPrecision) {
            lastPrecision = precision;
            Sphere.calculatePoints(lastPrecision);
        }
        channel.glPushAttrib(0);
        channel.glColor(color);
        channel.glEdgeColor(edgeColor);
        channel.glPolygonMode(BuildAction.getGLFillStyle(fillOn, edgeOn));
        int nLongitude = precision + 1;
        int nLatitude = nLongitude / 2;
        Vec3d v0 = new Vec3d();
        Vec3d v1 = new Vec3d();
        Vec3d v2 = new Vec3d();
        Vec3d v3 = new Vec3d();
        radius = Math.abs(radius);
        channel.glBegin(2);
        for (int latitude = 0; latitude < nLatitude; ++latitude) {
            for (int longitude = 0; longitude < nLongitude; ++longitude) {
                v0.x = x[latitude][longitude];
                v0.y = y[latitude];
                v0.z = z[latitude][longitude];
                v1.x = x[latitude][longitude + 1];
                v1.y = y[latitude];
                v1.z = z[latitude][longitude + 1];
                v2.x = x[latitude + 1][longitude];
                v2.y = y[latitude + 1];
                v2.z = z[latitude + 1][longitude];
                v3.x = x[latitude + 1][longitude + 1];
                v3.y = y[latitude + 1];
                v3.z = z[latitude + 1][longitude + 1];
                channel.glVertex(v0.x * radius, v0.y * radius, v0.z * radius);
                channel.glVertex(v2.x * radius, v2.y * radius, v2.z * radius);
                channel.glVertex(v3.x * radius, v3.y * radius, v3.z * radius);
                channel.glVertex(v1.x * radius, v1.y * radius, v1.z * radius);
                v3.subtract(v0);
                v2.subtract(v1);
                Vec3d cross = v2.cross(v3);
                channel.glNormal(cross.x, cross.y, cross.z);
                channel.glBound();
            }
        }
        channel.glEnd();
        channel.glPopAttrib();
    }

    public Sphere() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Sphere.drawSphere(ba.getChannel(), this.radius.getValue(index), this.color.getValue(index), this.edgeColor.getValue(index), this.edgeOn.getValue(index), this.fillOn.getValue(index), this.precision.getValue(index));
    }
}

