/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.ReusableDouble;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.ASpatialDataMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.Transform;

public class SpatialDataMap
extends ASpatialDataMap {
    Channel segmentChannel;
    boolean dlHeightOn = false;
    long firstRegionCallingListName;
    long firstRegionListName;
    ReusableDouble key = new ReusableDouble();

    public SpatialDataMap() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        Channel channel = ba.getChannel();
        channel.glCallList(this.firstRegionCallingListName + (long)ba.getValueIndex());
    }

    @Override
    protected void rebuildLists(AInitAction initAction) {
        Channel ch = ((InitAction)initAction).getChannel();
        if (this.segmentChannel == null) {
            this.segmentChannel = ch;
            this.firstRegionCallingListName = ch.glGenLists((long)this.numMultiPolygons);
            this.firstRegionListName = ch.glGenLists((long)this.numMultiPolygons);
        }
        this.buildRegionCallingLists(ch);
        this.buildRegionLists(ch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildRegionCallingLists(Channel ch) {
        this.init(new InitAction(ch));
        int regionCount = 0;
        int highlightRegionCount = 0;
        boolean matrixPushed = false;
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            long callingRegionListName;
            boolean regionHighlighted = this.isRegionHighlighted(i);
            if (regionHighlighted) {
                callingRegionListName = this.firstRegionCallingListName + (long)this.numMultiPolygons - 1L - (long)highlightRegionCount;
                ++highlightRegionCount;
            } else {
                callingRegionListName = this.firstRegionCallingListName + (long)regionCount;
                ++regionCount;
            }
            ch.glNewList(callingRegionListName);
            ch.glPopName();
            ch.glPopName();
            BuildAction.pushName(ch, i, this);
            try {
                matrixPushed = false;
                if (this.heightOn.getValue(i)) {
                    ch.glPushMatrix();
                    matrixPushed = true;
                    ch.glScale(1.0, 1.0, this.height.getValue(i));
                }
                if (regionHighlighted) {
                    ch.glPolygonMode(BuildAction.getGLFillStyle(this.fillOn.getValue(i), true));
                    ch.glEdgeColor(this.highlightColor);
                } else {
                    ch.glPolygonMode(BuildAction.getGLFillStyle(this.fillOn.getValue(i), this.edgeOn.getValue(i)));
                    if (this.edgeOn.getValue(i)) {
                        ch.glEdgeColor(this.edgeColor.getValue(i));
                        if (this.heightOn.getValue(i)) {
                            ch.glLineWidth(0.0f);
                        } else {
                            ch.glLineWidth((float)this.edgeWidth.getValue(i));
                        }
                    }
                }
                ch.glColor(this.color.getValue(i));
                ch.glCallList(this.firstRegionListName + (long)i);
            }
            catch (MissingValueException missingValueException) {
            }
            finally {
                if (matrixPushed) {
                    ch.glPopMatrix();
                }
            }
            ch.glLineWidth(0.0f);
            ch.glEndList();
        }
    }

    private void buildRegionLists(Channel ch) {
        if (ch.glIsList(this.firstRegionListName) && this.dlHeightOn == this.heightOn.getValue()) {
            return;
        }
        this.dlHeightOn = this.heightOn.getValue();
        ch.glNormal(0.0, 0.0, 1.0);
        int vertexCount = 0;
        int culledVertexCount = 0;
        for (int i = 0; i < this.numMultiPolygons; ++i) {
            ch.glNewList(this.firstRegionListName + (long)i);
            try {
                int drawMode;
                if (this.heightOn.getValue(i)) {
                    ch.setExtrusionVector(0.0, 0.0, 1.0);
                    ch.glEnable(0);
                    drawMode = 3;
                } else {
                    ch.glDisable(0);
                    drawMode = 2;
                }
                if (this.multiPolygons[i] != null) {
                    int j = 0;
                    while ((long)j < this.multiPolygons[i].num_wkbPolygons) {
                        ch.glBegin(drawMode);
                        int k = 0;
                        while ((long)k < this.multiPolygons[i].WKBPolygons[j].numRings) {
                            ch.glEdgeFlag(true);
                            Vec3d[] points = this.multiPolygons[i].WKBPolygons[j].rings[k].points;
                            int l = 0;
                            while ((long)l < this.multiPolygons[i].WKBPolygons[j].rings[k].numPoints) {
                                ++vertexCount;
                                if (l == 0 || !this.isVertexCullingEnabled() || Math.abs(points[l].x - points[l - 1].x) > this.worldPixelWidth && Math.abs(points[l].y - points[l - 1].y) > this.worldPixelHeight) {
                                    ch.glVertex(points[l].x, points[l].y, points[l].z);
                                } else {
                                    ++culledVertexCount;
                                }
                                ++l;
                            }
                            ch.glEdgeFlag(false);
                            ch.glVertex(this.multiPolygons[i].WKBPolygons[j].rings[k].points[0].x, this.multiPolygons[i].WKBPolygons[j].rings[k].points[0].y, this.multiPolygons[i].WKBPolygons[j].rings[k].points[0].z);
                            ch.glVertex(this.multiPolygons[i].WKBPolygons[j].rings[0].points[0].x, this.multiPolygons[i].WKBPolygons[j].rings[0].points[0].y, this.multiPolygons[i].WKBPolygons[j].rings[0].points[0].z);
                            ++k;
                        }
                        ch.glEnd();
                        ++j;
                    }
                }
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
            ch.glEdgeFlag(true);
            ch.glEndList();
        }
    }

    public void rebuildRegionGraphicsAttributes(Channel ch) {
        this.buildRegionCallingLists(ch);
    }
}

