/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Bbox;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ALabel;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringPipe;
import com.sas.graphics.util.gtk.StringProperty;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.io.PrintStream;

public class RasterLabel
extends ALabel {
    public PrintStream printStream = null;
    public String plotName = null;
    public double wallWidth = Double.NaN;
    public double wallHeight = Double.NaN;
    public double xD2S = Double.NaN;
    public double yD2S = Double.NaN;
    public final StringProperty outID = new StringProperty(this, true);

    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor) {
        boolean shadowOn = false;
        Color shadowColor = null;
        int shadowOffsetX = 0;
        int shadowOffsetY = 0;
        RasterLabel.drawRasterLabel(channel, label, color, angle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, bgColor, shadowOn, shadowColor, shadowOffsetX, shadowOffsetY);
    }

    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor, boolean shadowOn, Color shadowColor, int shadowOffsetX, int shadowOffsetY) {
        RasterLabel.drawRasterLabel(channel, label, color, angle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, bgColor, null, null, shadowOn, shadowColor, shadowOffsetX, shadowOffsetY, 0.0, 0.0, 0.0, false);
    }

    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor, boolean shadowOn, Color shadowColor, int shadowOffsetX, int shadowOffsetY, double x, double y, double z) {
        RasterLabel.drawRasterLabel(channel, label, color, angle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, bgColor, null, null, shadowOn, shadowColor, shadowOffsetX, shadowOffsetY, x, y, z, false);
    }

    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor, boolean shadowOn, Color shadowColor, int shadowOffsetX, int shadowOffsetY, double x, double y, double z, boolean originalAlignments) {
        RasterLabel.drawRasterLabel(channel, label, color, angle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, bgColor, null, null, shadowOn, shadowColor, shadowOffsetX, shadowOffsetY, x, y, z, originalAlignments);
    }

    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor, Color bgEdgeColor, Insets bgPad, boolean shadowOn, Color shadowColor, int shadowOffsetX, int shadowOffsetY, double x, double y, double z) {
        RasterLabel.drawRasterLabel(channel, label, color, angle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, bgColor, bgEdgeColor, bgPad, shadowOn, shadowColor, shadowOffsetX, shadowOffsetY, x, y, z, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRasterLabel(Channel channel, String label, Color color, double angle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, Color bgColor, Color bgEdgeColor, Insets bgPad, boolean shadowOn, Color shadowColor, int shadowOffsetX, int shadowOffsetY, double x, double y, double z, boolean originalAlignments) {
        try {
            channel.glPushAttrib(0);
            if (shadowOn) {
                channel.glEnable(11);
                channel.setShadowColor(shadowColor);
                channel.setShadowOffset(shadowOffsetX, shadowOffsetY);
            } else {
                channel.glDisable(11);
            }
            channel.glAlignment(horizontalJustification, verticalJustification);
            RasterLabel.executeLabelFittingAndSelectFont(channel, label, font, angle, maxWidth, maxHeight, fit, truncate, null);
            channel.glColor(color);
            Color rasterBackground = channel.getRasterBackgroundColor();
            Color rasterBackgroundEdge = channel.getRasterBackgroundEdgeColor();
            Insets rasterBackgroundPad = channel.getRasterBackgroundPad();
            channel.setKeepOrginalAlignments(originalAlignments);
            channel.setRasterBackgroundColor(bgColor);
            channel.setRasterBackgroundEdgeColor(bgEdgeColor);
            channel.setRasterBackgroundPad(bgPad);
            channel.gl2DText(label, x, y, z, (int)Math.round(angle));
            channel.setRasterBackgroundColor(rasterBackground);
            channel.setRasterBackgroundEdgeColor(rasterBackgroundEdge);
            channel.setRasterBackgroundPad(rasterBackgroundPad);
            channel.setKeepOrginalAlignments(false);
            if (shadowOn) {
                channel.glDisable(11);
            }
        }
        finally {
            channel.glPopAttrib();
        }
    }

    private static void executeLabelFittingAndSelectFont(Channel channel, String label, Font font, double angle, double maxWidth, double maxHeight, boolean fit, boolean truncate, Bbox bounds) {
        channel.glSelect2DFont(font);
        if (fit) {
            double textWidth = channel.glGetTextWidth(label);
            double textHeight = channel.glGetTextHeight(label);
            if (textWidth > maxWidth) {
                int minFontSize = 8;
                double size = font.getSize();
                double newSize = size * (maxWidth / textWidth);
                newSize = Math.max(newSize, (double)minFontSize);
                font = font.deriveFont((float)newSize);
                channel.glSelect2DFont(font);
                textWidth = channel.glGetTextWidth(label);
                textHeight = channel.glGetTextHeight(label);
                while ((textWidth > maxWidth || textHeight > maxHeight) && newSize > (double)minFontSize) {
                    font = font.deriveFont((float)(newSize -= 1.0));
                    channel.glSelect2DFont(font);
                    textWidth = channel.glGetTextWidth(label);
                    textHeight = channel.glGetTextHeight(label);
                }
            }
        }
        if (bounds != null) {
            channel.glGetText2DBbox(label, 0.0, 0.0, 0.0, (int)Math.round(angle), bounds);
        }
    }

    public RasterLabel() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Color background = this.backgroundColorOn.getValue(index) ? this.backgroundColor.getValue(index) : null;
        Color backgroundEdge = this.backgroundEdgeOn.getValue(index) ? this.backgroundEdgeColor.getValue(index) : null;
        String s = this.string.getValue(index);
        if (this.trimOn.getValue(index)) {
            s = s.trim();
        }
        boolean outline = ba.getChannel().isOutlinedRasterLabel();
        double light = ba.getChannel().getRasterLabelBacklight();
        int width = ba.getChannel().getRasterLabelOutlineWidth();
        if (this.outlineOn.getValue(index)) {
            ba.getChannel().setOutlinedRasterLabel(true);
            ba.getChannel().setRasterLabelBacklight(this.backlight.getValue(index));
            ba.getChannel().setRasterLabelOutlineWidth(this.outlineWidth.getValue(index));
        }
        RasterLabel.drawRasterLabel(ba.getChannel(), s, this.color.getValue(index), this.angle.getValue(index), this.horizontalJustification.getValue(index), this.verticalJustification.getValue(index), this.fit.getValue(index), this.truncate.getValue(index), this.maxWidth.getValue(index), this.maxHeight.getValue(index), this.getFont(index), background, backgroundEdge, this.backgroundPad, this.shadowOn.getValue(index), this.shadowColor.getValue(index), this.shadowOffsetX.getValue(index), this.shadowOffsetY.getValue(index), this.coordX.getValue(index), this.coordY.getValue(index), this.coordZ.getValue(index), this.originalAlignments);
        if (this.printStream != null) {
            ba.getChannel().glPushAttrib(0);
            ba.getChannel().glSelect2DFont(this.getFont(index));
            double textWidth = ba.getChannel().glGetTextWidth(s) + (double)this.backgroundPad.left + (double)this.backgroundPad.right;
            double textHeight = ba.getChannel().glGetTextHeight(s) + (double)this.backgroundPad.top + (double)this.backgroundPad.bottom;
            double textDescent = ba.getChannel().glGetTextDescent() + (double)this.backgroundPad.bottom;
            if (this.xD2S == this.xD2S && this.yD2S == this.yD2S) {
                this.printStream.print(this.plotName + ", " + this.outID.getValue(index) + ", " + textWidth + ", " + textHeight + ", " + textDescent + ", " + textWidth / this.wallWidth + ", " + textHeight / this.wallHeight + ", " + textDescent / this.wallHeight + ", " + textWidth * this.xD2S + ", " + textHeight * this.yD2S + ", " + textDescent * this.yD2S + "\n");
            } else {
                this.printStream.print(this.plotName + ", " + this.outID.getValue(index) + ", " + textWidth + ", " + textHeight + ", " + textDescent + ", " + textWidth / this.wallWidth + ", " + textHeight / this.wallHeight + ", " + textDescent / this.wallHeight + ", ., ., .\n");
            }
            ba.getChannel().glPopAttrib();
        }
        if (this.outlineOn.getValue(index)) {
            ba.getChannel().setOutlinedRasterLabel(outline);
            ba.getChannel().setRasterLabelBacklight(light);
            ba.getChannel().setRasterLabelOutlineWidth(width);
        }
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
        ComputeBoundingBoxAction bba = ComputeBoundingBoxAction.castComputeBoundingBoxAction(bBoxAction);
        int index = bba.getValueIndex();
        Font font = this.getFont();
        int hj = this.horizontalJustification.getValue(index);
        int vj = this.verticalJustification.getValue(index);
        RasterLabel.computeBoundingBox(bba.getElementBoundingBox(), bba.getChannel(), this.string.getValue(index), this.angle.getValue(index), hj, vj, this.fit.getValue(index), this.truncate.getValue(index), this.maxWidth.getValue(index), this.maxHeight.getValue(index), font, this.shadowOn.getValue(index), this.shadowOffsetX.getValue(index), this.shadowOffsetY.getValue(index));
    }

    public static void computeBoundingBox(BoundingBox box, Channel channel, String label, double textAngle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font) {
        RasterLabel.computeBoundingBox(box, channel, label, textAngle, horizontalJustification, verticalJustification, fit, truncate, maxWidth, maxHeight, font, false, 0, 0);
    }

    public static void computeBoundingBox(BoundingBox box, Channel channel, String label, double textAngle, int horizontalJustification, int verticalJustification, boolean fit, boolean truncate, double maxWidth, double maxHeight, Font font, boolean shadowOn, int shadowOffsetX, int shadowOffsetY) {
        Vec3d center = new Vec3d();
        center.z = 0.0;
        Vec3d size = new Vec3d();
        channel.glAlignment(horizontalJustification, verticalJustification);
        if (shadowOn) {
            channel.glEnable(11);
            channel.setShadowOffset(shadowOffsetX, shadowOffsetY);
        }
        Bbox b = new Bbox();
        RasterLabel.executeLabelFittingAndSelectFont(channel, label, font, textAngle, maxWidth, maxHeight, fit, truncate, b);
        size.set(Math.abs(b.xmax - b.xmin), Math.abs(b.ymax - b.ymin), Math.abs(b.zmax - b.zmin));
        center.set(b.xmin + size.x / 2.0, b.ymin + size.y / 2.0, b.zmin + size.z / 2.0);
        box.union(center, size);
        if (shadowOn) {
            channel.glDisable(11);
        }
    }

    public static double getMaxLength(Channel channel, Font font, StringPipe pipe) {
        InitAction initAction = new InitAction(channel);
        pipe.init(initAction);
        int n = initAction.getValueCount();
        return RasterLabel.getMaxLength(channel, font, pipe, n);
    }

    public static Point2D getMaxWidthAndHeight(Channel channel, Font font, StringPipe pipe) {
        Point2D.Double result = new Point2D.Double();
        InitAction initAction = new InitAction(channel);
        pipe.init(initAction);
        double maxWidth = Double.NEGATIVE_INFINITY;
        double maxHeight = Double.NEGATIVE_INFINITY;
        channel.glSelect2DFont(font);
        int n = initAction.getValueCount();
        for (int i = 0; i < n; ++i) {
            try {
                maxHeight = Math.max(channel.glGetTextHeight(pipe.getValue(i)), maxHeight);
                maxWidth = Math.max(channel.glGetTextWidth(pipe.getValue(i)), maxWidth);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        ((Point2D)result).setLocation(maxWidth, maxHeight);
        return result;
    }

    public static double getMaxLength(Channel channel, Font font, StringPipe string, int valueCount) {
        double maxLength = Double.NEGATIVE_INFINITY;
        channel.glSelect2DFont(font);
        for (int i = 0; i < valueCount; ++i) {
            try {
                maxLength = Math.max(channel.glGetTextWidth(string.getValue(i)), maxLength);
                continue;
            }
            catch (MissingValueException missingValueException) {
                // empty catch block
            }
        }
        return maxLength;
    }

    public static String wordBreak(Channel channel, Font font, String aLabel, double aspectRatio) {
        String newString = aLabel.replace(' ', '\n');
        return newString;
    }
}

