/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.SASLinePatterns;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.ARangeAttrMap;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;

public class RangeAttrMap
extends ARangeAttrMap {
    public RangeAttrMap() {
        super(new Transform());
    }

    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction(buildAction);
        int index = ba.getValueIndex();
        Channel channel = ba.getChannel();
        boolean lineLowOn = this.lineLowerOn.getValue(index);
        boolean lineUppOn = this.lineUpperOn.getValue(index);
        boolean edgeOn = lineLowOn || lineUppOn;
        boolean fOn = this.fillOn.getValue(index);
        Color ec = null;
        int ew = 0;
        int ep = -1;
        Color c = this.color.getValue(index);
        if (edgeOn) {
            ec = this.lineColor.getValue(index);
            ew = this.lineWidth.getValue(index);
            ep = this.linePattern.getValue(index);
        }
        channel.glPushAttrib(0);
        if (edgeOn) {
            channel.glEdgeColor(ec);
            channel.glLineWidth((float)ew);
            if (ep >= 0) {
                channel.glEnable(6);
                channel.glLineStipple(SASLinePatterns.getStippleFactor((int)ep), SASLinePatterns.getStipplePattern((int)ep));
            }
        }
        channel.glPolygonMode(3);
        if (this.direction == ARangeAttrMap.Direction.BOTH) {
            double vuy;
            double vux;
            double vly;
            double vlx;
            double huy;
            double hux;
            double hly;
            double hlx;
            if (fOn) {
                double tmp;
                hlx = this.horizontalLowerX.getValue(index);
                hly = this.horizontalLowerY.getValue(index);
                hux = this.horizontalUpperX.getValue(index);
                huy = this.horizontalUpperY.getValue(index);
                vlx = this.verticalLowerX.getValue(index);
                vly = this.verticalLowerY.getValue(index);
                vux = this.verticalUpperX.getValue(index);
                vuy = this.verticalUpperY.getValue(index);
                if (huy < hly) {
                    tmp = hly;
                    hly = huy;
                    huy = tmp;
                }
                if (vux < vlx) {
                    tmp = vlx;
                    vlx = vux;
                    vux = tmp;
                }
                channel.glColor(c);
                channel.glBegin(2);
                channel.glVertex(hux, huy);
                channel.glVertex(vux, huy);
                channel.glVertex(vux, vuy);
                channel.glVertex(vlx, vly);
                channel.glVertex(vlx, hly);
                channel.glVertex(hlx, hly);
                channel.glEnd();
            }
            if (edgeOn) {
                hlx = this.horizontalLowerX.getValue(index);
                hly = this.horizontalLowerY.getValue(index);
                hux = this.horizontalUpperX.getValue(index);
                huy = this.horizontalUpperY.getValue(index);
                vlx = this.verticalLowerX.getValue(index);
                vly = this.verticalLowerY.getValue(index);
                vux = this.verticalUpperX.getValue(index);
                vuy = this.verticalUpperY.getValue(index);
                if (this.lineLowerOn.getValue(index)) {
                    this.drawHVLine(channel, ec, hlx, hly, vlx, vly);
                }
                if (this.lineUpperOn.getValue(index)) {
                    this.drawHVLine(channel, ec, hux, huy, vux, vuy);
                }
            }
        } else {
            double uY;
            double uX;
            double lY;
            double lX;
            if (this.direction == ARangeAttrMap.Direction.HORIZONTAL) {
                lX = this.horizontalLowerX.getValue(index);
                lY = this.horizontalLowerY.getValue(index);
                uX = this.horizontalUpperX.getValue(index);
                uY = this.horizontalUpperY.getValue(index);
            } else {
                lX = this.verticalLowerX.getValue(index);
                lY = this.verticalLowerY.getValue(index);
                uX = this.verticalUpperX.getValue(index);
                uY = this.verticalUpperY.getValue(index);
            }
            double length = this.depth.getValue(index);
            if (fOn) {
                channel.glColor(c);
                channel.glBegin(2);
                if (this.direction == ARangeAttrMap.Direction.HORIZONTAL) {
                    channel.glVertex(uX, uY);
                    channel.glVertex(uX + length, uY);
                    channel.glVertex(uX + length, lY);
                    channel.glVertex(lX, lY);
                } else {
                    channel.glVertex(lX, lY);
                    channel.glVertex(lX, lY + length);
                    channel.glVertex(uX, uY + length);
                    channel.glVertex(uX, uY);
                }
                channel.glEnd();
            }
            if (edgeOn) {
                if (lineLowOn) {
                    this.drawLine(channel, ec, lX, lY, length);
                }
                if (lineUppOn) {
                    this.drawLine(channel, ec, uX, uY, length);
                }
            }
        }
        channel.glLineWidth(1.0f);
        channel.glDisable(6);
        channel.glPopAttrib();
    }

    private void drawHVLine(Channel channel, Color ec, double hX, double hY, double vX, double vY) {
        channel.glColor(ec);
        channel.glBegin(1);
        channel.glVertex(hX, hY);
        channel.glVertex(vX, hY);
        channel.glVertex(vX, vY);
        channel.glEnd();
    }

    private void drawLine(Channel channel, Color ec, double x, double y, double length) {
        channel.glColor(ec);
        channel.glBegin(1);
        channel.glVertex(x, y);
        if (this.direction == ARangeAttrMap.Direction.HORIZONTAL) {
            channel.glVertex(x + length, y);
        } else {
            channel.glVertex(x, y + length);
        }
        channel.glEnd();
    }
}

