/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.gl.LineSegment;
import java.awt.Color;

public class PolylineSegment
extends LineSegment {
    public static void drawPolylineSegment(Channel channel, double[] xps, double[] yps, int nPoints, Color color, double lineWidth, int stipplePat, int stippleFac) {
        PolylineSegment.drawPolylineSegment(channel, xps, yps, nPoints, color, lineWidth, stipplePat, stippleFac, false);
    }

    public static void drawPolylineSegment(Channel channel, double[] xps, double[] yps, int nPoints, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical) {
        PolylineSegment.drawPolylineSegment(channel, xps, yps, nPoints, color, lineWidth, stipplePat, stippleFac, disableAntialiasForHorizontalOrVertical, 1);
    }

    public static void drawPolylineSegment(Channel channel, double[] xps, double[] yps, int nPoints, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            for (int ii = 0; ii < nPoints; ++ii) {
                channel.glVertex(xps[ii], yps[ii], 0.0);
            }
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
    }

    public static void drawPolylineSegment(Channel channel, double[] xps, double[] yps, int nPoints, Color color, double lineWidth, int stipplePat, int stippleFac, boolean disableAntialiasForHorizontalOrVertical, int drawCount, int skinType, float dpiFactor) {
        boolean stippleNeeded;
        boolean bl = stippleNeeded = stippleFac > 0 && (stipplePat & 0xFFFF) != 65535;
        if (stippleNeeded) {
            channel.glEnable(6);
            channel.glLineStipple(stippleFac, (int)((short)stipplePat));
        }
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glEnable(17);
        }
        channel.glLineWidth((float)lineWidth);
        channel.glColor(color);
        channel.glSkinType(skinType);
        channel.glDPIScaleFactor(dpiFactor);
        for (int i = 0; i < drawCount; ++i) {
            channel.glBegin(1);
            for (int ii = 0; ii < nPoints; ++ii) {
                channel.glVertex(xps[ii], yps[ii], 0.0);
            }
            channel.glEnd();
        }
        channel.glLineWidth(1.0f);
        if (disableAntialiasForHorizontalOrVertical) {
            channel.glDisable(17);
        }
        if (stippleNeeded) {
            channel.glDisable(6);
        }
        channel.glSkinType(0);
    }

    public static void drawPolylineBand(Channel channel, double[] xpsU, double[] ypsU, int nPointsU, double[] xpsL, double[] ypsL, int nPointsL, Color color) {
        int ii;
        channel.glColor(color);
        channel.glPolygonMode(3);
        channel.glBegin(2);
        for (ii = 0; ii < nPointsU; ++ii) {
            channel.glVertex(xpsU[ii], ypsU[ii], 0.0);
        }
        for (ii = nPointsL - 1; ii >= 0; --ii) {
            channel.glVertex(xpsL[ii], ypsL[ii], 0.0);
        }
        channel.glEnd();
    }
}

