/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.BoundingBox;
import com.sas.graphics.util.Debug;
import com.sas.graphics.util.Vec3d;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ANetworkRoot;
import com.sas.graphics.util.gtk.Element;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.Bar;
import com.sas.graphics.util.gtk.gl.Box;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Composite;
import com.sas.graphics.util.gtk.gl.ComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.gl.InitAction;
import com.sas.graphics.util.gtk.gl.SelectResult;
import com.sas.graphics.util.gtk.gl.SelectableShape;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import java.util.Vector;

public class NetworkRoot
extends ANetworkRoot {
    private Channel channel;
    private long rootListName;
    private long bboxListName;
    private Stack nameStack = new Stack();
    private InitAction initAction;
    private BuildAction buildAction;
    private ComputeBoundingBoxAction bboxAction;
    private boolean showBoundingBox = false;
    private Vector selectResultVector = new Vector();
    private NameStackIterator nameStackIterator = new NameStackIterator();

    public NetworkRoot() {
    }

    public NetworkRoot(Channel aChannel) {
        this.channel = aChannel;
        this.rootListName = this.channel.glGenLists(1L);
        this.bboxListName = this.channel.glGenLists(1L);
        this.initAction = new InitAction(this.channel);
        this.buildAction = new BuildAction(this.channel);
        this.bboxAction = new ComputeBoundingBoxAction(this.channel);
        this.buildAction.setDisplayListName(this.rootListName);
    }

    public long getRootListName() {
        return this.rootListName;
    }

    public void setRootListName(long rootListName) {
        this.rootListName = rootListName;
    }

    public boolean getBoundingBoxVisible() {
        return this.showBoundingBox;
    }

    public void setBoundingBoxVisible(boolean trueOrFalse) {
        this.showBoundingBox = trueOrFalse;
    }

    @Override
    public void build() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.build(): No associated channel.");
            return;
        }
        this.build(this.channel, this.rootListName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void build(Channel ch, long listName, Element anElement) {
        InitAction ia = new InitAction(ch);
        BuildAction ba = new BuildAction(ch);
        ba.setDisplayListName(listName);
        ba.setUseNameStack(true);
        ia.apply(anElement);
        try {
            ch.glNewList(listName);
            ba.apply(anElement);
        }
        finally {
            ch.glEndList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void build(Channel ch, long listName) {
        Element e;
        int i;
        BuildAction ba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            ba = new BuildAction(ch);
            ba.setDisplayListName(listName);
        } else {
            ia = this.initAction;
            ba = this.buildAction;
        }
        NetworkRoot.setChannelDefaults(ba.getChannel());
        int n = this.getElementCount();
        for (i = 0; i < n; ++i) {
            e = this.getElement(i);
            ia.apply(e);
        }
        if (this.showBoundingBox) {
            this.addBoundingBox();
        }
        ch.glNewList(listName);
        try {
            for (i = 0; i < n; ++i) {
                e = this.getElement(i);
                ba.apply(e);
            }
            if (this.showBoundingBox) {
                ch.glCallList(this.bboxListName);
            }
        }
        finally {
            ch.glEndList();
        }
    }

    public Vector computeSelectableShapes() {
        Vector feedback = new Vector();
        this.channel.glFeedbackBuffer(3, feedback);
        this.channel.glRenderMode(2);
        this.draw(this.channel, true);
        this.channel.glRenderMode(0);
        Vector selectableShapes = new Vector();
        NetworkRoot.addFeedbackToSelectableShape(feedback, selectableShapes);
        NetworkRoot.consolidateSelectableShapes(selectableShapes);
        return selectableShapes;
    }

    private static void consolidateSelectableShapes(Vector selectableShapes) {
        int n = selectableShapes.size();
        Vector<Integer> removeList = new Vector<Integer>();
        for (int i = 0; i < n; ++i) {
            int j;
            Area area = null;
            SelectableShape ss = (SelectableShape)selectableShapes.get(i);
            SelectResult sr = ss.getSelectResult();
            if (!(sr.getElement() instanceof Bar)) continue;
            Shape combinedShape = ss.getShape();
            for (j = i + 1; j < n; ++j) {
                SelectableShape ss2 = (SelectableShape)selectableShapes.get(j);
                SelectResult sr2 = ss2.getSelectResult();
                if (!sr.equals(sr2)) continue;
                if (area == null) {
                    area = new Area(combinedShape);
                }
                area.add(new Area(ss2.getShape()));
                combinedShape = area;
                removeList.add(new Integer(j));
            }
            for (j = removeList.size() - 1; j >= 0; --j) {
                selectableShapes.removeElementAt((Integer)removeList.elementAt(j));
            }
            removeList.removeAllElements();
            n = selectableShapes.size();
            if (area != null && area.isPolygonal()) {
                combinedShape = NetworkRoot.areaToPolygon(area);
            }
            ss.setShape(combinedShape);
        }
    }

    private static Polygon areaToPolygon(Area area) {
        PathIterator pi = area.getPathIterator(null);
        double[] coord = new double[6];
        Vector<Point2D.Double> polygonVertices = new Vector<Point2D.Double>();
        while (!pi.isDone()) {
            int type = pi.currentSegment(coord);
            switch (type) {
                default: {
                    System.out.println("Unhandled PathIterator type.");
                    break;
                }
                case 0: 
                case 1: {
                    polygonVertices.add(new Point2D.Double(coord[0], coord[1]));
                    break;
                }
                case 4: {
                    polygonVertices.add((Point2D.Double)polygonVertices.elementAt(0));
                }
            }
            pi.next();
        }
        int n = polygonVertices.size();
        int[] x = new int[n];
        int[] y = new int[n];
        for (int i = 0; i < n; ++i) {
            Point2D.Double p = (Point2D.Double)polygonVertices.elementAt(i);
            x[i] = (int)p.x;
            y[i] = (int)p.y;
        }
        return new Polygon(x, y, n);
    }

    public static void addFeedbackToSelectableShape(Vector feedback, Vector selectableShapes) {
        NameStackIterator nameStackIterator = new NameStackIterator();
        int n = feedback.size();
        for (int i = 0; i < n; i += 2) {
            Stack nameStack = (Stack)feedback.elementAt(i);
            Polygon polygon = (Polygon)feedback.elementAt(i + 1);
            nameStackIterator.setNameStack(nameStack);
            SelectResult sr = nameStackIterator.next();
            if (sr == null) continue;
            selectableShapes.addElement(new SelectableShape(sr, polygon));
        }
    }

    public void draw() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.draw(): No associated channel.");
            return;
        }
        this.draw(this.channel, false);
    }

    public void draw(Channel ch) {
        this.draw(ch, true);
    }

    public void draw(Channel ch, boolean doSelectProcessing) {
        BuildAction ba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            ba = new BuildAction(ch);
        } else {
            ia = this.initAction;
            ba = this.buildAction;
        }
        NetworkRoot.setChannelDefaults(ba.getChannel());
        if (doSelectProcessing) {
            ba.getChannel().glInitNames();
        }
        int n = this.getElementCount();
        ba.setUseNameStack(doSelectProcessing);
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            ia.apply(e);
            ba.apply(e);
        }
        if (this.showBoundingBox) {
            this.drawBoundingBox();
        }
    }

    private static void setChannelDefaults(Channel ch) {
        ch.glDisable(6);
    }

    private void addBoundingBox() {
        this.channel.glNewList(this.bboxListName);
        this.drawBoundingBox();
        this.channel.glEndList();
    }

    public static Rectangle2D projectBoundingBox(BoundingBox box, Channel ch) {
        Vec3d s = box.getSize();
        Vec3d c = box.getCenter();
        Vec3d[] corners = new Vec3d[8];
        double halfX = s.x / 2.0;
        double halfY = s.y / 2.0;
        double halfZ = s.z / 2.0;
        corners[6] = new Vec3d(c.x - halfX, c.y - halfY, c.z + halfZ);
        corners[0] = new Vec3d(c.x - halfX, c.y - halfY, c.z - halfZ);
        corners[5] = new Vec3d(c.x - halfX, c.y + halfY, c.z + halfZ);
        corners[4] = new Vec3d(c.x - halfX, c.y + halfY, c.z - halfZ);
        corners[7] = new Vec3d(c.x + halfX, c.y - halfY, c.z + halfZ);
        corners[1] = new Vec3d(c.x + halfX, c.y - halfY, c.z - halfZ);
        corners[3] = new Vec3d(c.x + halfX, c.y + halfY, c.z + halfZ);
        corners[2] = new Vec3d(c.x + halfX, c.y + halfY, c.z - halfZ);
        Rectangle2D r = null;
        double[] world = new double[3];
        double[] pixel = new double[3];
        for (int i = 0; i < corners.length; ++i) {
            Vec3d v = corners[i];
            world[0] = v.x;
            world[1] = v.y;
            world[2] = v.z;
            ch.gluProject(world, pixel);
            if (r == null) {
                r = new Rectangle2D.Double(pixel[0], pixel[1], 1.0, 1.0);
                continue;
            }
            r.add(pixel[0], pixel[1]);
        }
        return r;
    }

    public static void drawBoundingBox(BoundingBox bb, Channel channel, Color c) {
        Vec3d center = bb.getCenter();
        Vec3d size = bb.getSize();
        channel.glTranslate(center.x, center.y, center.z);
        Box.drawBox(channel, size.x, size.y, size.z, c, c, 0, true, false);
        channel.glTranslate(-center.x, -center.y, -center.z);
    }

    public static void drawBoundingBoxProjection(BoundingBox bb, Channel channel, Graphics2D graphics) {
        Rectangle2D r = NetworkRoot.projectBoundingBox(bb, channel);
        graphics.setColor(Color.BLUE);
        graphics.draw(r);
    }

    private void drawBoundingBox() {
        BoundingBox bb = this.computeBoundingBox(this.channel);
        NetworkRoot.drawBoundingBox(bb, this.getChannel(), new Color(1.0f, 1.0f, 0.0f, 0.5f));
    }

    @Override
    public ANetworkRoot.BoundsInfo computeBounds() {
        this.bboxAction.clearProjection();
        this.computeBoundingBox(this.channel);
        ANetworkRoot.BoundsInfo boundsInfo = new ANetworkRoot.BoundsInfo(this.bboxAction.getProjectedBounds(), this.bboxAction.getNetworkBoundingBox());
        return boundsInfo;
    }

    @Override
    public BoundingBox computeBoundingBox() {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.computeBoundingBox(): No associated channel.");
            return null;
        }
        return this.computeBoundingBox(this.channel);
    }

    public BoundingBox computeBoundingBox(Channel ch) {
        ComputeBoundingBoxAction bba;
        InitAction ia;
        if (this.channel == null) {
            ia = new InitAction(ch);
            bba = new ComputeBoundingBoxAction(ch);
        } else {
            ia = this.initAction;
            bba = this.bboxAction;
        }
        BoundingBox box = bba.getElementBoundingBox();
        box.makeEmpty();
        box = bba.getNetworkBoundingBox();
        box.makeEmpty();
        int n = this.getElementCount();
        for (int i = 0; i < n; ++i) {
            Element e = this.getElement(i);
            ia.apply(e);
            bba.apply(e);
        }
        return bba.getNetworkBoundingBox();
    }

    public synchronized void refresh() {
        this.channel.clearBGC();
        this.channel.glCallList(this.rootListName);
        this.channel.glRefresh();
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, this.channel, -1L, false, true);
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight, boolean doTransformations) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, this.channel, this.rootListName, doTransformations, false);
    }

    public synchronized SelectResult selectClosest(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations) {
        return this.doSelectClosest(x, y, apertureWidth, apertureHeight, ch, listName, doTransformations, false);
    }

    private SelectResult doSelectClosest(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations, boolean immediateMode) {
        SelectResult selectResult = null;
        this.doSelect(x, y, apertureWidth, apertureHeight, ch, listName, doTransformations, immediateMode);
        int size = this.selectResultVector.size();
        if (size > 0) {
            selectResult = (SelectResult)this.selectResultVector.elementAt(size - 1);
        }
        return selectResult;
    }

    public synchronized Vector select(int x, int y, int apertureWidth, int apertureHeight, boolean doTransformations) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelect(x, y, apertureWidth, apertureHeight, this.channel, this.rootListName, doTransformations, false);
    }

    public synchronized Vector select(int x, int y, int apertureWidth, int apertureHeight, boolean doTransformations, boolean immediateMode) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.select(): No associated channel.");
            return null;
        }
        return this.doSelect(x, y, apertureWidth, apertureHeight, this.channel, this.rootListName, doTransformations, immediateMode);
    }

    public synchronized Vector select(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long rootListName, boolean doTransformations) {
        return this.doSelect(x, y, apertureWidth, apertureHeight, ch, rootListName, doTransformations, false);
    }

    private Vector doSelect(int x, int y, int apertureWidth, int apertureHeight, Channel ch, long listName, boolean doTransformations, boolean immediateMode) {
        ch.glRenderMode(1);
        ch.gluPickMatrix(x, y, apertureWidth, apertureHeight);
        this.nameStack.removeAllElements();
        ch.glSelectBuffer(this.nameStack);
        if (immediateMode) {
            this.draw(ch, true);
        } else {
            ch.glCallList(listName, doTransformations);
        }
        this.selectResultVector.removeAllElements();
        if (ch.glRenderMode(0)) {
            this.nameStackIterator.setNameStack(this.nameStack);
            while (this.nameStackIterator.hasNext()) {
                SelectResult sr = this.nameStackIterator.next();
                if (sr == null) continue;
                this.selectResultVector.addElement(sr);
            }
        }
        return this.selectResultVector;
    }

    private static boolean isSelectable(SelectEntry se) {
        Element element = se.getElement();
        int i = se.getValueIndex();
        boolean rc = false;
        try {
            rc = element.selectEnabled.getValue(i);
        }
        catch (MissingValueException missingValueException) {
            // empty catch block
        }
        return rc;
    }

    public static NetworkRoot castNetworkRoot(ANetworkRoot anANetworkRoot) {
        return (NetworkRoot)anANetworkRoot;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public double setObliqueView(BoundingBox bbox, double fieldOfView, double azimuth, double incline) {
        return this.setObliqueView(bbox, 0.8, fieldOfView, azimuth, incline, new Vec3d(0.0, 0.0, 0.0), true);
    }

    @Override
    public double setObliqueView(BoundingBox bbox, double obliqueFactor, double obliqueAngle, double azimuth, double incline, Vec3d focal, boolean fit) {
        obliqueFactor = Math.sin(obliqueAngle * Math.PI / 180.0) * obliqueFactor;
        double distance = 1.0;
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.setglObliqueView(): No associated channel.");
            return distance;
        }
        double[] viewport = this.channel.glGetDoublev(0);
        double aspectRatio = viewport[3] / viewport[2];
        Vec3d boxSize = bbox.getSize();
        Vec3d center = bbox.getCenter();
        distance = boxSize.z * 0.5;
        double skew = boxSize.z * obliqueFactor * 0.5;
        double width = boxSize.x * 0.5 + skew;
        double height = boxSize.y * 0.5 + skew;
        if (fit) {
            this.channel.glOblique(center.x - width, center.x + width, center.y - height, center.y + height, -1000.0, 1000.0, obliqueFactor, obliqueAngle);
        } else if (height / width < aspectRatio) {
            this.channel.glOblique(center.x - width, center.x + width, center.y - width * aspectRatio, center.y + width * aspectRatio, -1000.0, 1000.0, obliqueFactor, obliqueAngle);
        } else {
            this.channel.glOblique(center.x - height / aspectRatio, center.x + height / aspectRatio, center.y - height, center.y + height, -1000.0, 1000.0, obliqueFactor, obliqueAngle);
        }
        this.channel.gluLookAt(focal.x, focal.y, focal.z, distance, azimuth, incline, 0.0);
        return distance;
    }

    @Override
    public double setPerspectiveView(BoundingBox bbox, double fieldOfView, double azimuth, double incline) {
        if (this.channel == null) {
            Debug.println((String)"NetworkRoot.setPerspectiveView(): No associated channel.");
            return 3.0;
        }
        double degrees2radians = Math.PI / 180;
        double[] viewport = this.channel.glGetDoublev(0);
        double aspectRatio = viewport[2] / viewport[3];
        double fov = fieldOfView * 0.5 * degrees2radians;
        Vec3d boxSize = bbox.getSize();
        Vec3d center = bbox.getCenter();
        double distance = boxSize.x / boxSize.y >= aspectRatio ? boxSize.z / 2.0 + boxSize.x / 1.4 / Math.tan(aspectRatio * fov) : boxSize.z / 2.0 + boxSize.y / 1.4 / Math.tan(fov);
        if (aspectRatio > 1.0) {
            aspectRatio = 1.0 / aspectRatio;
        }
        this.channel.gluPerspective(fieldOfView, 1.0 / aspectRatio, 0.1, 2.0 * distance);
        this.channel.gluLookAt(center.x, center.y, center.z, distance, azimuth, incline, 0.0);
        return distance;
    }

    public void printElementHierarchy() {
        System.out.println("NetworkRoot:");
        for (int i = 0; i < this.getElementCount(); ++i) {
            this.printElement(this.getElement(i), 1);
        }
    }

    private void printElement(Element e, int tabLevel) {
        System.out.println(this.getTabs(tabLevel) + e);
        if (e instanceof Composite) {
            Composite c = (Composite)e;
            for (int i = 0; i < c.getElementCount(); ++i) {
                this.printElement(c.getElement(i), tabLevel + 1);
            }
        }
    }

    private String getTabs(int tabLevel) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (i = 0; i < tabLevel; ++i) {
            sb.append("\t");
        }
        return sb.toString();
    }

    public static class NameStackIterator {
        private Stack nameStack;
        private int entryCurrent;
        private int nameStackSize = -1;

        public void setNameStack(Stack nameStack) {
            this.nameStack = nameStack;
            this.entryCurrent = 0;
            if (nameStack != null) {
                this.nameStackSize = nameStack.size();
            }
        }

        public boolean hasNext() {
            boolean result = false;
            while (this.nameStack != null && this.entryCurrent < this.nameStackSize && !result) {
                int entryLength = (Integer)this.nameStack.elementAt(this.entryCurrent);
                if (entryLength <= 1) {
                    this.entryCurrent += entryLength;
                    continue;
                }
                if (!(this.nameStack.elementAt(this.entryCurrent + 1) instanceof SelectEntry)) continue;
                result = true;
            }
            return result;
        }

        public SelectResult next() {
            SelectEntry se;
            int e = 0;
            SelectResult selectResult = null;
            e = this.entryCurrent;
            int entryLength = (Integer)this.nameStack.elementAt(this.entryCurrent);
            if (entryLength <= 1) {
                return null;
            }
            boolean compositeSelectable = true;
            boolean isComposite = true;
            do {
                Object o;
                if (!((o = this.nameStack.elementAt(++e)) instanceof SelectEntry)) {
                    return null;
                }
                se = (SelectEntry)this.nameStack.elementAt(e);
                if (se.getElement() instanceof Composite) {
                    compositeSelectable &= NetworkRoot.isSelectable(se);
                    continue;
                }
                isComposite = false;
            } while (isComposite);
            if (compositeSelectable && NetworkRoot.isSelectable(se)) {
                selectResult = new SelectResult(this.nameStack, this.entryCurrent);
            }
            this.entryCurrent += entryLength;
            return selectResult;
        }
    }
}

