/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gtk.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.AInitAction;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.MultiResponseStackedBarDetail;
import com.sas.graphics.util.gtk.NumericPipe;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.SelectDetail;
import com.sas.graphics.util.gtk.SelectEntry;
import com.sas.graphics.util.gtk.gl.BaseBar;
import com.sas.graphics.util.gtk.gl.BuildAction;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Stack;

public class MultiResponseStackedBar
extends BaseBar {
    private static final int MISSING_SHAPE_INFORMATION = -2;
    private List lengths = new ArrayList();
    private List responses = new ArrayList();
    private List names = new ArrayList();
    private List highlightOns = new ArrayList();
    private double negativeDataCoordinateExtent;
    private double positiveDataCoordinateExtent;
    public final NumericProperty baseline = new NumericProperty(this, true);

    public MultiResponseStackedBar() {
        this.edgeOn.setInitByContainer(false);
        this.fillOn.setInitByContainer(false);
        this.edgeWidth.setInitByContainer(false);
        this.edgeColor.setInitByContainer(false);
        this.color1.setInitByContainer(false);
        this.color2.setInitByContainer(false);
        this.gradientOn.setInitByContainer(false);
        this.gradientDirection.setInitByContainer(false);
        this.textureOn.setInitByContainer(false);
        this.textureMode.setInitByContainer(false);
        this.textureStyle.setInitByContainer(false);
        this.textureIndex.setInitByContainer(false);
        this.thresholdOn.setInitByContainer(false);
        this.thresholdValue.setInitByContainer(false);
        this.thresholdColor.setInitByContainer(false);
        this.marker3DShape.setInitByContainer(false);
    }

    public void removeAllResponses() {
        this.responses.clear();
        this.lengths.clear();
    }

    public void addResponse(NumericPipe length, NumericPipe response) {
        this.addResponse(length, response, null, null);
    }

    public void addResponse(NumericPipe length, NumericPipe response, String name, NumericPipe ho) {
        this.responses.add(response);
        this.lengths.add(length);
        this.names.add(name);
        this.highlightOns.add(ho);
    }

    public String getNameAt(int responseIndex) {
        String result = null;
        if (responseIndex >= 0 && responseIndex < this.names.size()) {
            result = (String)this.names.get(responseIndex);
        }
        return result;
    }

    @Override
    public void init(AInitAction initAction) {
        boolean beenInitialized = true;
        initAction.pushValueCount();
        super.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        int responseCount = this.responses.size();
        for (int i = 0; i < responseCount; ++i) {
            NumericPipe np = (NumericPipe)this.responses.get(i);
            np.init(initAction);
            beenInitialized &= initAction.beenInitialized(this);
            np = (NumericPipe)this.lengths.get(i);
            np.init(initAction);
            beenInitialized &= initAction.beenInitialized(this);
        }
        this.setMyValueCount(initAction.getValueCount());
        initAction.popValueCount();
        initAction.pushValueCount();
        initAction.setValueCount(responseCount);
        this.edgeOn.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.fillOn.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.edgeWidth.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.edgeColor.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.color1.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.color2.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.textureOn.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.textureIndex.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.textureMode.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.textureStyle.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.gradientDirection.init(initAction);
        beenInitialized &= initAction.beenInitialized(this);
        this.gradientOn.init(initAction);
        initAction.popValueCount();
        this.setValueCount(1);
        initAction.setValueCount(1);
        if (!(beenInitialized &= initAction.beenInitialized(this))) {
            List drawOrder = this.getDrawOrderList();
            drawOrder.clear();
            this.negativeDataCoordinateExtent = 0.0;
            this.positiveDataCoordinateExtent = 0.0;
            for (int valueIndex = 0; valueIndex < this.getMyValueCount(); ++valueIndex) {
                double b = 0.0;
                try {
                    b = this.baseline.getValue(0);
                }
                catch (MissingValueException missingValueException) {
                    // empty catch block
                }
                double pExt = 0.0;
                double nExt = 0.0;
                double pl = b;
                double nl = b;
                double pos = 0.0;
                double sv = 0.0;
                for (int responseIndex = 0; responseIndex < responseCount; ++responseIndex) {
                    BaseBar.BarInfo bi;
                    try {
                        double ev;
                        double r = ((NumericPipe)this.responses.get(responseIndex)).getValue(valueIndex);
                        double l = Math.abs(((NumericPipe)this.lengths.get(responseIndex)).getValue(valueIndex) - b);
                        pos = this.position.getValue(valueIndex);
                        if (r < 0.0) {
                            sv = nl;
                            ev = nl - l;
                        } else {
                            sv = pl;
                            ev = pl + l;
                        }
                        bi = new BaseBar.BarInfo(pos, sv, ev, valueIndex, responseIndex);
                        if (r < 0.0) {
                            nExt += r;
                            nl -= l;
                        } else {
                            pExt += r;
                            pl += l;
                        }
                    }
                    catch (MissingValueException e) {
                        bi = new BaseBar.BarInfo(0.0, 0.0, 0.0, -2, -2);
                    }
                    drawOrder.add(bi);
                }
                if (nExt < this.negativeDataCoordinateExtent) {
                    this.negativeDataCoordinateExtent = nExt;
                }
                if (!(pExt > this.positiveDataCoordinateExtent)) continue;
                this.positiveDataCoordinateExtent = pExt;
            }
            if (!this.isTwoD() && this.isDrawOrderSortEnabled()) {
                Collections.sort(drawOrder, this.getPositionComparator());
                Collections.sort(drawOrder, this.getStackComparator());
            }
        }
    }

    public double getNegativeExtent() {
        this.init(new AInitAction());
        return this.negativeDataCoordinateExtent;
    }

    public double getPositiveExtent() {
        this.init(new AInitAction());
        return this.positiveDataCoordinateExtent;
    }

    @Override
    public void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(ABuildAction buildAction) throws MissingValueException {
        Channel ch = (Channel)buildAction.getGraphicsContext();
        if (!this.transform.isIdentity()) {
            ch.glPopMatrix();
        }
        BaseBar.BarInfo bi = null;
        List drawOrderList = this.getDrawOrderList();
        BaseBar.PropertyValueBlock pBlock = this.getPropertyValueBlock();
        for (int i = 0; i < drawOrderList.size(); ++i) {
            bi = (BaseBar.BarInfo)this.getDrawOrderList().get(i);
            int valueIndex = bi.valueIndex;
            int responseIndex = bi.responseIndex;
            if (valueIndex == -2) continue;
            boolean isIdentity = this.transform.isIdentity();
            try {
                boolean textureNeeded;
                if (!isIdentity) {
                    buildAction.setValueIndex(valueIndex);
                    this.transform.push(buildAction);
                    this.transform.apply(buildAction);
                }
                this.loadPropertyValueBlock(bi, valueIndex);
                this.loadPropertyValueBlockPerResponse(bi, valueIndex, responseIndex);
                if (pBlock.eo) {
                    ch.glPolygonMode(BuildAction.getGLFillStyle(pBlock.fo, pBlock.eo));
                    ch.glEdgeColor(pBlock.ec);
                }
                BufferedImage[] texImage = this.getTextureImage();
                boolean bl = textureNeeded = pBlock.texOn && pBlock.fo && texImage != null && texImage.length > 0;
                if (textureNeeded) {
                    if (pBlock.ti < 0 || pBlock.ti > texImage.length - 1) {
                        pBlock.ti = 0;
                    }
                    ch.glTexImage2D((Image)texImage[pBlock.ti]);
                    ch.glTexEnv(10, 1, pBlock.tm);
                    ch.glTexEnv(10, 2, pBlock.ts);
                }
                if (buildAction.isUseNameStack()) {
                    ch.glPopName();
                    ch.glLoadName((Object)new SelectEntry(this, valueIndex));
                    ch.glPushName(null);
                    ch.glLoadName((Object)new Integer(responseIndex));
                }
                if (this.isTwoD()) {
                    this.drawTwoDBar(ch, pBlock);
                    continue;
                }
                this.drawThreeDBar(ch, pBlock);
                continue;
            }
            catch (MissingValueException missingValueException) {
                continue;
            }
            finally {
                if (!isIdentity) {
                    this.transform.pop(buildAction);
                }
            }
        }
        if (!this.transform.isIdentity()) {
            ch.glPushMatrix();
        }
    }

    private void loadPropertyValueBlock(BaseBar.BarInfo bi, int index) throws MissingValueException {
        BaseBar.PropertyValueBlock pBlock = this.getPropertyValueBlock();
        pBlock.ew = this.edgeWidth.getValue(index);
        pBlock.vertical = this.verticalOn.getValue(index);
        pBlock.pos = bi.categoryPosition;
        pBlock.thick = this.thickness.getValue(index);
        pBlock.b = this.baseline.getValue(index);
        pBlock.hc = this.highlightFillColor.getValue(index);
        pBlock.hec = this.highlightEdgeColor.getValue(index);
        pBlock.ho = this.highlightOn.getValue(index);
        pBlock.hp = this.highlightPercentage.getValue(index);
        pBlock.d = this.depth.getValue(index);
    }

    private void loadPropertyValueBlockPerResponse(BaseBar.BarInfo bi, int valueIndex, int responseIndex) throws MissingValueException {
        BaseBar.PropertyValueBlock pBlock = this.getPropertyValueBlock();
        pBlock.sv = bi.sv;
        pBlock.ev = bi.ev;
        pBlock.c1 = this.color1.getValue(responseIndex);
        pBlock.c2 = this.color2.getValue(responseIndex);
        pBlock.ec = this.edgeColor.getValue(responseIndex);
        pBlock.fo = this.fillOn.getValue(responseIndex);
        pBlock.eo = this.edgeOn.getValue(responseIndex);
        pBlock.texOn = this.textureOn.getValue(responseIndex);
        pBlock.ti = this.textureIndex.getValue(responseIndex);
        pBlock.tm = this.textureMode.getValue(responseIndex);
        pBlock.ts = this.textureStyle.getValue(responseIndex);
        pBlock.go = this.gradientOn.getValue(responseIndex);
        pBlock.gd = this.gradientDirection.getValue(responseIndex);
        pBlock.tc = this.thresholdColor.getValue(responseIndex);
        pBlock.m3dshape = this.marker3DShape.getValue(responseIndex);
        pBlock.thresh = this.thresholdValue.getValue(responseIndex);
        pBlock.threshOn = this.thresholdOn.getValue(responseIndex);
        pBlock.hgOn = false;
        pBlock.lOn = false;
        pBlock.hgv = this.highValue.getValue(responseIndex);
        pBlock.hgc = this.highColor.getValue(responseIndex);
        pBlock.hglThick = this.highLowThickness.getValue(responseIndex);
        pBlock.lv = this.lowValue.getValue(responseIndex);
        pBlock.lc = this.lowColor.getValue(responseIndex);
        pBlock.tgOn = this.targetOn.getValue(responseIndex);
        pBlock.tgv = this.targetValue.getValue(responseIndex);
        pBlock.tgc = this.targetColor.getValue(responseIndex);
        pBlock.tgThick = this.targetThickness.getValue(responseIndex);
        pBlock.tgGran = this.targetGran.getValue(responseIndex);
        pBlock.hglIsBar = this.highLowIsBar.getValue(responseIndex);
        pBlock.hglFillOn = this.highLowFillOn.getValue(responseIndex);
        NumericPipe hons = (NumericPipe)this.highlightOns.get(responseIndex);
        if (hons != null) {
            boolean bl = pBlock.ho = hons.getValue(valueIndex) != 0.0;
        }
        if (pBlock.eo) {
            pBlock.ew = this.edgeWidth.getValue(responseIndex);
            pBlock.ec = this.edgeColor.getValue(responseIndex);
        }
    }

    @Override
    protected SelectDetail getSelectDetail(Object rawDetail, int startIndex) {
        Stack nameStack = (Stack)rawDetail;
        int entryLength = (Integer)nameStack.elementAt(startIndex);
        int detailIndex = startIndex + entryLength - 1;
        Integer responseIndex = (Integer)nameStack.elementAt(detailIndex);
        MultiResponseStackedBarDetail detail = null;
        if (responseIndex != null) {
            detail = new MultiResponseStackedBarDetail(responseIndex);
        }
        return detail;
    }
}

